/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy;

import com.aelitis.azureus.core.proxy.impl.AEPluginProxyHandler;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginViewInterface;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ipc.IPCException;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddyPluginBeta {
    public static final String BETA_CHAT_KEY = "test:beta:chat";
    public static final int PRIVATE_CHAT_DISABLED = 1;
    public static final int PRIVATE_CHAT_PINNED_ONLY = 2;
    public static final int PRIVATE_CHAT_ENABLED = 3;
    private static final int MSG_STATUS_CHAT_NONE = 0;
    private static final int MSG_STATUS_CHAT_QUIT = 1;
    private BuddyPlugin plugin;
    private PluginInterface plugin_interface;
    private BooleanParameter enabled;
    private AsyncDispatcher dispatcher = new AsyncDispatcher("BuddyPluginBeta");
    private Map<String, ChatInstance> chat_instances_map = new HashMap<String, ChatInstance>();
    private CopyOnWriteList<ChatInstance> chat_instances_list = new CopyOnWriteList();
    private PluginInterface azmsgsync_pi;
    private TimerEventPeriodic timer;
    private String shared_public_nickname;
    private String shared_anon_nickname;
    private int private_chat_state;
    private boolean shared_anon_endpoint;
    private boolean sound_enabled;
    private String sound_file;
    private Map<String, Long> favourite_map;
    private CopyOnWriteList<FTUXStateChangeListener> ftux_listeners = new CopyOnWriteList();
    private boolean ftux_accepted = false;

    protected BuddyPluginBeta(PluginInterface _pi, BuddyPlugin _plugin, BooleanParameter _enabled) {
        this.plugin_interface = _pi;
        this.plugin = _plugin;
        this.enabled = _enabled;
        this.ftux_accepted = COConfigurationManager.getBooleanParameter("azbuddy.dchat.ftux.accepted", false);
        this.shared_public_nickname = COConfigurationManager.getStringParameter("azbuddy.chat.shared_nick", "");
        this.shared_anon_nickname = COConfigurationManager.getStringParameter("azbuddy.chat.shared_anon_nick", "");
        this.private_chat_state = COConfigurationManager.getIntParameter("azbuddy.chat.private_chat_state", 3);
        this.shared_anon_endpoint = COConfigurationManager.getBooleanParameter("azbuddy.chat.share_i2p_endpoint", true);
        this.sound_enabled = COConfigurationManager.getBooleanParameter("azbuddy.chat.notif.sound.enable", true);
        this.sound_file = COConfigurationManager.getStringParameter("azbuddy.chat.notif.sound.file", "");
        this.favourite_map = COConfigurationManager.getMapParameter("azbuddy.dchat.favemap", new HashMap());
    }

    public boolean isAvailable() {
        return this.plugin_interface.getPluginManager().getPluginInterfaceByID("azmsgsync", true) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFavourite(String net, String key) {
        Map<String, Long> map = this.favourite_map;
        synchronized (map) {
            Long l = this.favourite_map.get(net + ":" + key);
            if (l == null) {
                return false;
            }
            return l == 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFavourite(String net, String key, boolean b) {
        Map<String, Long> map = this.favourite_map;
        synchronized (map) {
            String net_key = net + ":" + key;
            Long existing = this.favourite_map.get(net_key);
            if (existing == null && !b) {
                return;
            }
            if (existing != null && b == (existing == 1L)) {
                return;
            }
            if (b) {
                this.favourite_map.put(net_key, 1L);
            } else {
                this.favourite_map.remove(net_key);
            }
            COConfigurationManager.setParameter("azbuddy.dchat.favemap", this.favourite_map);
        }
        COConfigurationManager.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String[]> getFavourites() {
        Map<String, Long> map = this.favourite_map;
        synchronized (map) {
            ArrayList<String[]> result = new ArrayList<String[]>();
            for (Map.Entry<String, Long> entry : this.favourite_map.entrySet()) {
                String net_key = entry.getKey();
                Long value = entry.getValue();
                if (value != 1L) continue;
                String[] bits = net_key.split(":", 2);
                String network = AENetworkClassifier.internalise(bits[0]);
                String key = bits[1];
                result.add(new String[]{network, key});
            }
            return result;
        }
    }

    public String getSharedPublicNickname() {
        return this.shared_public_nickname;
    }

    public void setSharedPublicNickname(String _nick) {
        if (!_nick.equals(this.shared_public_nickname)) {
            this.shared_public_nickname = _nick;
            COConfigurationManager.setParameter("azbuddy.chat.shared_nick", _nick);
            this.allUpdated();
        }
    }

    public String getSharedAnonNickname() {
        return this.shared_anon_nickname;
    }

    public void setSharedAnonNickname(String _nick) {
        if (!_nick.equals(this.shared_anon_nickname)) {
            this.shared_anon_nickname = _nick;
            COConfigurationManager.setParameter("azbuddy.chat.shared_anon_nick", _nick);
            this.allUpdated();
        }
    }

    public int getPrivateChatState() {
        return this.private_chat_state;
    }

    public void setPrivateChatState(int state) {
        if (state != this.private_chat_state) {
            this.private_chat_state = state;
            COConfigurationManager.setParameter("azbuddy.chat.private_chat_state", state);
            this.plugin.fireUpdated();
        }
    }

    public boolean getSharedAnonEndpoint() {
        return this.shared_anon_endpoint;
    }

    public void setSharedAnonEndpoint(boolean b) {
        if (b != this.shared_anon_endpoint) {
            this.shared_anon_endpoint = b;
            COConfigurationManager.setParameter("azbuddy.chat.share_i2p_endpoint", b);
            this.plugin.fireUpdated();
        }
    }

    public void setSoundEnabled(boolean b) {
        if (b != this.sound_enabled) {
            this.sound_enabled = b;
            COConfigurationManager.setParameter("azbuddy.chat.notif.sound.enable", b);
            this.plugin.fireUpdated();
        }
    }

    public boolean getSoundEnabled() {
        return this.sound_enabled;
    }

    public String getSoundFile() {
        return this.sound_file;
    }

    public void setSoundFile(String _file) {
        if (!_file.equals(this.sound_file)) {
            this.sound_file = _file;
            COConfigurationManager.setParameter("azbuddy.chat.notif.sound.file", _file);
            this.plugin.fireUpdated();
        }
    }

    private void allUpdated() {
        for (ChatInstance chat : this.chat_instances_list) {
            chat.updated();
        }
        this.plugin.fireUpdated();
    }

    protected void startup() {
        PluginInterface[] plugins;
        this.plugin_interface.addEventListener(new PluginEventListener(){

            public void handleEvent(PluginEvent ev) {
                int type = ev.getType();
                if (type == 8) {
                    BuddyPluginBeta.this.pluginAdded((PluginInterface)ev.getValue());
                }
                if (type == 9) {
                    BuddyPluginBeta.this.pluginRemoved((PluginInterface)ev.getValue());
                }
            }
        });
        for (PluginInterface pi : plugins = this.plugin_interface.getPluginManager().getPlugins(true)) {
            if (!pi.getPluginState().isOperational()) continue;
            this.pluginAdded(pi);
        }
    }

    protected void closedown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pluginAdded(PluginInterface pi) {
        if (pi.getPluginID().equals("azmsgsync")) {
            Map<String, ChatInstance> map = this.chat_instances_map;
            synchronized (map) {
                this.azmsgsync_pi = pi;
                Iterator<ChatInstance> it = this.chat_instances_map.values().iterator();
                while (it.hasNext()) {
                    ChatInstance inst = it.next();
                    try {
                        inst.bind(this.azmsgsync_pi, null);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        it.remove();
                    }
                }
            }
            this.dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    try {
                        if (Constants.isCVSVersion() && BuddyPluginBeta.this.enabled.getValue()) {
                            ChatInstance chat = BuddyPluginBeta.this.getChat("Public", BuddyPluginBeta.BETA_CHAT_KEY);
                            chat.setPersistent();
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pluginRemoved(PluginInterface pi) {
        if (pi.getPluginID().equals("azmsgsync")) {
            Map<String, ChatInstance> map = this.chat_instances_map;
            synchronized (map) {
                this.azmsgsync_pi = null;
                Iterator<ChatInstance> it = this.chat_instances_map.values().iterator();
                while (it.hasNext()) {
                    ChatInstance inst = it.next();
                    inst.unbind();
                    if (!inst.isPrivateChat()) continue;
                    it.remove();
                }
            }
        }
    }

    public boolean isI2PAvailable() {
        return AEPluginProxyHandler.hasPluginProxyForNetwork("I2P", false);
    }

    public void handleURI(String url_str) throws Exception {
        String network;
        BuddyPluginViewInterface ui = this.plugin.getSWTUI();
        if (ui == null) {
            throw new Exception("UI unavailable");
        }
        int pos = url_str.indexOf(63);
        String key = "";
        if (pos != -1) {
            key = UrlUtils.decode(url_str.substring(pos + 1));
        }
        if (url_str.toLowerCase(Locale.US).startsWith("chat:anon")) {
            if (!this.isI2PAvailable()) {
                throw new Exception("I2P unavailable");
            }
            network = "I2P";
        } else {
            network = "Public";
        }
        ChatInstance chat = this.getChat(network, key);
        ui.openChat(chat);
    }

    public boolean getFTUXAccepted() {
        return this.ftux_accepted;
    }

    public void setFTUXAccepted(boolean accepted) {
        this.ftux_accepted = accepted;
        COConfigurationManager.setParameter("azbuddy.dchat.ftux.accepted", true);
        COConfigurationManager.save();
        for (FTUXStateChangeListener l : this.ftux_listeners) {
            l.stateChanged(accepted);
        }
    }

    public void addFTUXStateChangeListener(FTUXStateChangeListener listener) {
        this.ftux_listeners.add(listener);
        listener.stateChanged(this.ftux_accepted);
    }

    public void removeFTUXStateChangeListener(FTUXStateChangeListener listener) {
        this.ftux_listeners.remove(listener);
    }

    public void getAndShowChat(String network, String key) throws Exception {
        BuddyPluginViewInterface ui = this.plugin.getSWTUI();
        if (ui == null) {
            throw new Exception("UI unavailable");
        }
        ChatInstance chat = this.getChat(network, key);
        ui.openChat(chat);
    }

    public void showChat(ChatInstance inst) throws Exception {
        BuddyPluginViewInterface ui = this.plugin.getSWTUI();
        if (ui == null) {
            throw new Exception("UI unavailable");
        }
        ui.openChat(inst);
    }

    private String pkToString(byte[] pk) {
        byte[] temp = new byte[3];
        if (pk != null) {
            System.arraycopy(pk, 8, temp, 0, 3);
        }
        return ByteFormatter.encodeString(temp);
    }

    public ChatInstance importChat(String import_data) throws Exception {
        if (this.azmsgsync_pi == null) {
            throw new Exception("Plugin unavailable ");
        }
        HashMap<String, byte[]> options = new HashMap<String, byte[]>();
        options.put("import_data", import_data.getBytes("UTF-8"));
        Map reply = (Map)this.azmsgsync_pi.getIPC().invoke("importMessageHandler", new Object[]{options});
        String key = new String((byte[])reply.get("key"), "UTF-8");
        String network = (String)reply.get("network");
        Object handler = reply.get("handler");
        return this.getChat(network, key, null, handler, false);
    }

    public ChatInstance getChat(String network, String key) throws Exception {
        return this.getChat(network, key, null, null, false);
    }

    public ChatInstance getChat(ChatParticipant participant) throws Exception {
        String key = participant.getChat().getKey() + " - " + participant.getName() + " (outgoing)";
        return this.getChat(participant.getChat().getNetwork(), key, participant, null, true);
    }

    public ChatInstance getChat(ChatParticipant parent_participant, Object handler) throws Exception {
        String key = parent_participant.getChat().getKey() + " - " + parent_participant.getName() + " (incoming)";
        return this.getChat(parent_participant.getChat().getNetwork(), key, null, handler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatInstance getChat(String network, String key, ChatParticipant private_target, Object handler, boolean is_private_chat) throws Exception {
        if (!this.enabled.getValue()) {
            throw new Exception("Plugin not enabled");
        }
        String meta_key = network + ":" + key;
        Map<String, ChatInstance> map = this.chat_instances_map;
        synchronized (map) {
            ChatInstance inst = this.chat_instances_map.get(meta_key);
            if (inst == null) {
                inst = new ChatInstance(network, key, private_target, is_private_chat);
                this.chat_instances_map.put(meta_key, inst);
                this.chat_instances_list.add(inst);
                if (this.azmsgsync_pi != null) {
                    try {
                        inst.bind(this.azmsgsync_pi, handler);
                    }
                    catch (Throwable e) {
                        this.chat_instances_map.remove(meta_key);
                        this.chat_instances_list.remove(inst);
                        inst.destroy();
                        if (e instanceof Exception) {
                            throw (Exception)e;
                        }
                        throw new Exception(e);
                    }
                }
            } else {
                inst.addReference();
            }
            if (this.timer == null) {
                this.timer = SimpleTimer.addPeriodicEvent("BPB:timer", 2500L, new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        for (ChatInstance inst : BuddyPluginBeta.this.chat_instances_list) {
                            inst.update();
                        }
                    }
                });
            }
            return inst;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChatInstance {
        private static final int MSG_HISTORY_MAX = 512;
        private final String network;
        private final String key;
        private boolean is_private_chat;
        private final ChatParticipant private_target;
        private volatile PluginInterface msgsync_pi;
        private volatile Object handler;
        private byte[] my_public_key;
        private byte[] managing_public_key;
        private boolean read_only;
        private Object chat_lock = this;
        private AtomicInteger message_uid_next = new AtomicInteger();
        private List<ChatMessage> messages = new ArrayList<ChatMessage>();
        private ByteArrayHashMap<ChatParticipant> participants = new ByteArrayHashMap();
        private Map<String, List<ChatParticipant>> nick_clash_map = new HashMap<String, List<ChatParticipant>>();
        private CopyOnWriteList<ChatListener> listeners = new CopyOnWriteList();
        private boolean persistent = false;
        private Map<String, Object> status;
        private boolean is_shared_nick;
        private String instance_nick;
        private int reference_count;
        private boolean is_favourite;
        private boolean destroyed;
        private TimerEvent sort_event;
        private boolean sort_force_changed;
        AsyncDispatcher dispatcher = new AsyncDispatcher("sendAsync");

        private ChatInstance(String _network, String _key, ChatParticipant _private_target, boolean _is_private_chat) {
            this.network = _network;
            this.key = _key;
            this.private_target = _private_target;
            this.is_private_chat = _is_private_chat;
            String chat_key_base = "azbuddy.chat." + this.getNetAndKey();
            String shared_key = chat_key_base + ".shared";
            String nick_key = chat_key_base + ".nick";
            this.is_shared_nick = COConfigurationManager.getBooleanParameter(shared_key, true);
            this.instance_nick = COConfigurationManager.getStringParameter(nick_key, "");
            if (!this.is_private_chat) {
                this.is_favourite = BuddyPluginBeta.this.getFavourite(this.network, this.key);
            }
            this.addReference();
        }

        public ChatInstance getClone() throws Exception {
            if (this.is_private_chat) {
                this.addReference();
                return this;
            }
            return BuddyPluginBeta.this.getChat(this.network, this.key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addReference() {
            Object object = this.chat_lock;
            synchronized (object) {
                ++this.reference_count;
            }
        }

        public String getName() {
            String str = this.key;
            int pos = str.indexOf(91);
            if (pos != -1) {
                str = str.substring(0, pos);
            }
            return MessageText.getString(this.network == "Public" ? "label.public" : "label.anon") + " - '" + str + "'";
        }

        public String getShortName() {
            String short_name = this.getName();
            if (short_name.length() > 60) {
                short_name = short_name.substring(0, 60) + "...";
            }
            return short_name;
        }

        public String getNetwork() {
            return this.network;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isFavourite() {
            return this.is_favourite;
        }

        public void setFavourite(boolean b) {
            if (!this.is_private_chat && b != this.is_favourite) {
                this.is_favourite = b;
                BuddyPluginBeta.this.setFavourite(this.network, this.key, b);
            }
        }

        public boolean isManaged() {
            return this.managing_public_key != null;
        }

        public boolean amManager() {
            return this.managing_public_key != null && Arrays.equals(this.my_public_key, this.managing_public_key);
        }

        public boolean isReadOnly() {
            return this.read_only && !this.amManager();
        }

        public String getURL() {
            if (this.network == "Public") {
                return "chat:?" + UrlUtils.encode(this.key);
            }
            return "chat:anon:?" + UrlUtils.encode(this.key);
        }

        public byte[] getPublicKey() {
            return this.my_public_key;
        }

        public boolean isPrivateChat() {
            return this.is_private_chat;
        }

        public String getNetAndKey() {
            return this.network + ": " + this.key;
        }

        public void setPersistent() {
            this.persistent = true;
        }

        public boolean isSharedNickname() {
            return this.is_shared_nick;
        }

        public void setSharedNickname(boolean _shared) {
            if (_shared != this.is_shared_nick) {
                this.is_shared_nick = _shared;
                String chat_key_base = "azbuddy.chat." + this.getNetAndKey();
                String shared_key = chat_key_base + ".shared";
                COConfigurationManager.setParameter(shared_key, _shared);
                this.updated();
            }
        }

        public String getInstanceNickname() {
            return this.instance_nick;
        }

        public void setInstanceNickname(String _nick) {
            if (!_nick.equals(this.instance_nick)) {
                this.instance_nick = _nick;
                String chat_key_base = "azbuddy.chat." + this.getNetAndKey();
                String nick_key = chat_key_base + ".nick";
                COConfigurationManager.setParameter(nick_key, _nick);
                this.updated();
            }
        }

        public String getNickname() {
            if (this.is_shared_nick) {
                return this.network == "Public" ? BuddyPluginBeta.this.shared_public_nickname : BuddyPluginBeta.this.shared_anon_nickname;
            }
            return this.instance_nick;
        }

        private Object getHandler() {
            return this.handler;
        }

        private void bind(PluginInterface _msgsync_pi, Object _handler) throws Exception {
            this.msgsync_pi = _msgsync_pi;
            if (_handler != null) {
                this.handler = _handler;
                try {
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("handler", _handler);
                    options.put("addlistener", this);
                    Map reply = (Map)this.msgsync_pi.getIPC().invoke("updateMessageHandler", new Object[]{options});
                    this.my_public_key = (byte[])reply.get("pk");
                    this.managing_public_key = (byte[])reply.get("mpk");
                    Boolean ro = (Boolean)reply.get("ro");
                    this.read_only = ro != null && ro != false;
                    for (ChatListener l : this.listeners) {
                        try {
                            l.stateChanged(true);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
                catch (Throwable e) {
                    throw new Exception(e);
                }
            }
            try {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("network", this.network);
                options.put("key", this.key.getBytes("UTF-8"));
                if (this.private_target != null) {
                    options.put("parent_handler", this.private_target.getChat().getHandler());
                    options.put("target_pk", this.private_target.getPublicKey());
                    options.put("target_contact", this.private_target.getContact());
                }
                if (this.network != "Public") {
                    options.put("server_id", BuddyPluginBeta.this.getSharedAnonEndpoint() ? "dchat_shared" : "dchat");
                }
                options.put("listener", this);
                Map reply = (Map)this.msgsync_pi.getIPC().invoke("getMessageHandler", new Object[]{options});
                this.handler = reply.get("handler");
                this.my_public_key = (byte[])reply.get("pk");
                this.managing_public_key = (byte[])reply.get("mpk");
                Boolean ro = (Boolean)reply.get("ro");
                this.read_only = ro != null && ro != false;
                for (ChatListener l : this.listeners) {
                    try {
                        l.stateChanged(true);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
            catch (Throwable e) {
                throw new Exception(e);
            }
        }

        private void unbind() {
            for (ChatListener l : this.listeners) {
                try {
                    l.stateChanged(false);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            this.handler = null;
            this.msgsync_pi = null;
        }

        public boolean isAvailable() {
            return this.handler != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChatMessage[] getHistory() {
            Object object = this.chat_lock;
            synchronized (object) {
                return this.messages.toArray(new ChatMessage[this.messages.size()]);
            }
        }

        private void update() {
            PluginInterface current_pi = this.msgsync_pi;
            Object current_handler = this.handler;
            if (current_handler != null && current_pi != null) {
                try {
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("handler", current_handler);
                    this.status = (Map)current_pi.getIPC().invoke("getStatus", new Object[]{options});
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            this.updated();
        }

        private void updated() {
            for (ChatListener l : this.listeners) {
                try {
                    l.updated();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }

        public int getEstimatedNodes() {
            Map<String, Object> map = this.status;
            if (this.status == null) {
                return -1;
            }
            return ((Number)map.get("node_est")).intValue();
        }

        public String getStatus() {
            PluginInterface current_pi = this.msgsync_pi;
            Object current_handler = this.handler;
            if (current_pi == null) {
                return MessageText.getString("azbuddy.dchat.status.noplugin");
            }
            if (current_handler == null) {
                return MessageText.getString("azbuddy.dchat.status.nohandler");
            }
            Map<String, Object> map = this.status;
            if (map == null) {
                return MessageText.getString("azbuddy.dchat.status.notavail");
            }
            int status = ((Number)map.get("status")).intValue();
            int dht_count = ((Number)map.get("dht_nodes")).intValue();
            int nodes_local = ((Number)map.get("nodes_local")).intValue();
            int nodes_live = ((Number)map.get("nodes_live")).intValue();
            int nodes_dying = ((Number)map.get("nodes_dying")).intValue();
            int req_in = ((Number)map.get("req_in")).intValue();
            double req_in_rate = ((Number)map.get("req_in_rate")).doubleValue();
            int req_out_ok = ((Number)map.get("req_out_ok")).intValue();
            int req_out_fail = ((Number)map.get("req_out_fail")).intValue();
            double req_out_rate = ((Number)map.get("req_out_rate")).doubleValue();
            if (status == 0 || status == 1) {
                String arg2;
                String arg1;
                if (this.isPrivateChat()) {
                    arg1 = MessageText.getString("label.private.chat") + ": ";
                    arg2 = "";
                } else if (status == 0) {
                    arg1 = MessageText.getString("pairing.status.initialising") + ": ";
                    arg2 = "DHT=" + (dht_count < 0 ? "..." : String.valueOf(dht_count)) + ", ";
                } else if (status == 1) {
                    arg1 = "";
                    arg2 = "DHT=" + dht_count + ", ";
                } else {
                    arg1 = "";
                    arg2 = "";
                }
                String arg3 = nodes_local + "/" + nodes_live + "/" + nodes_dying;
                String arg4 = DisplayFormatters.formatDecimal(req_in_rate, 1) + "/" + DisplayFormatters.formatDecimal(req_out_rate, 1);
                String str = MessageText.getString("azbuddy.dchat.node.status", new String[]{arg1, arg2, arg3, arg4});
                if (this.isReadOnly()) {
                    str = str + ", R-";
                } else if (this.amManager()) {
                    str = this.read_only ? str + ", R+" : str + ", M+";
                } else if (this.isManaged()) {
                    str = str + ", M-";
                }
                return str;
            }
            return MessageText.getString("azbuddy.dchat.status.destroyed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sortMessages(boolean force_change) {
            Object object = this.chat_lock;
            synchronized (object) {
                if (force_change) {
                    this.sort_force_changed = true;
                }
                if (this.sort_event != null) {
                    return;
                }
                this.sort_event = SimpleTimer.addEvent("msgsort", SystemTime.getOffsetTime(500L), new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent event2) {
                        boolean changed = false;
                        Iterator iterator = ChatInstance.this.chat_lock;
                        synchronized (iterator) {
                            ChatInstance.this.sort_event = null;
                            changed = ChatInstance.this.sortMessagesSupport();
                            if (ChatInstance.this.sort_force_changed) {
                                changed = true;
                                ChatInstance.this.sort_force_changed = false;
                            }
                        }
                        if (changed) {
                            for (ChatListener l : ChatInstance.this.listeners) {
                                l.messagesChanged();
                            }
                        }
                    }
                });
            }
        }

        private boolean sortMessagesSupport() {
            ChatMessage msg;
            Object prev_msg;
            int num_messages = this.messages.size();
            ByteArrayHashMap<ChatMessage> id_map = new ByteArrayHashMap<ChatMessage>(num_messages);
            HashMap<Object, ChatMessage> prev_map = new HashMap<Object, ChatMessage>(num_messages);
            HashMap<Object, ChatMessage> next_map = new HashMap<Object, ChatMessage>(num_messages);
            for (ChatMessage msg2 : this.messages) {
                byte[] id = msg2.getID();
                id_map.put(id, msg2);
            }
            for (ChatMessage msg2 : this.messages) {
                ChatMessage prev_msg2;
                byte[] prev_id = msg2.getPreviousID();
                if (prev_id == null || (prev_msg2 = (ChatMessage)id_map.get(prev_id)) == null) continue;
                msg2.setPreviousID(prev_msg2.getID());
                prev_map.put(msg2, prev_msg2);
                next_map.put(prev_msg2, msg2);
            }
            Comparator<ChatMessage> message_comparator = new Comparator<ChatMessage>(){

                @Override
                public int compare(ChatMessage o1, ChatMessage o2) {
                    return o1.getUID() - o2.getUID();
                }
            };
            TreeSet<ChatMessage> linked_messages = new TreeSet<ChatMessage>(message_comparator);
            linked_messages.addAll(prev_map.keySet());
            block2: while (linked_messages.size() > 0) {
                ChatMessage start = (ChatMessage)linked_messages.iterator().next();
                linked_messages.remove(start);
                Object current = start;
                int loops = 0;
                while (true) {
                    if (++loops > num_messages) {
                        Debug.out("infinte loop");
                        continue block2;
                    }
                    prev_msg = (ChatMessage)prev_map.get(current);
                    if (prev_msg == null) continue block2;
                    linked_messages.remove(prev_msg);
                    if (prev_msg == start) {
                        prev_map.put(current, null);
                        next_map.put(prev_msg, null);
                        continue block2;
                    }
                    current = prev_msg;
                }
            }
            TreeSet<ChatMessage> chain_heads = new TreeSet<ChatMessage>(message_comparator);
            block4: for (ChatMessage msg3 : this.messages) {
                prev_msg = (ChatMessage)prev_map.get(msg3);
                if (prev_msg == null) continue;
                int loops = 0;
                while (true) {
                    if (++loops > num_messages) {
                        Debug.out("infinte loop");
                        continue block4;
                    }
                    ChatMessage prev_prev = (ChatMessage)prev_map.get(prev_msg);
                    if (prev_prev == null) {
                        chain_heads.add((ChatMessage)prev_msg);
                        continue block4;
                    }
                    prev_msg = prev_prev;
                }
            }
            HashSet<ChatMessage> remainder_set = new HashSet<ChatMessage>(this.messages);
            List<ChatMessage> result = null;
            for (ChatMessage head : chain_heads) {
                ArrayList<ChatMessage> chain = new ArrayList<ChatMessage>(num_messages);
                msg = head;
                while (msg != null) {
                    chain.add(msg);
                    remainder_set.remove(msg);
                    msg = (ChatMessage)next_map.get(msg);
                }
                if (result == null) {
                    result = chain;
                    continue;
                }
                result = this.merge(result, chain);
            }
            if (remainder_set.size() > 0) {
                ArrayList<ChatMessage> remainder = new ArrayList<ChatMessage>(remainder_set);
                Collections.sort(remainder, new Comparator<ChatMessage>(){

                    @Override
                    public int compare(ChatMessage m1, ChatMessage m2) {
                        long l = m1.getTimeStamp() - m2.getTimeStamp();
                        if (l < 0L) {
                            return -1;
                        }
                        if (l > 0L) {
                            return 1;
                        }
                        return m1.getUID() - m2.getUID();
                    }
                });
                result = result == null ? remainder : this.merge(result, remainder);
            }
            if (result == null) {
                return false;
            }
            boolean changed = false;
            if (this.messages.size() != result.size()) {
                Debug.out("Inconsistent: " + this.messages.size() + "/" + result.size());
                changed = true;
            }
            HashSet<ChatParticipant> participants = new HashSet<ChatParticipant>();
            for (int i = 0; i < result.size(); ++i) {
                msg = result.get(i);
                ChatParticipant p = msg.getParticipant();
                participants.add(p);
                if (changed || this.messages.get(i) == msg) continue;
                changed = true;
            }
            if (changed) {
                this.messages = result;
                for (ChatParticipant p : participants) {
                    p.resetMessages();
                }
                HashSet<ChatParticipant> updated = new HashSet<ChatParticipant>();
                for (ChatMessage msg4 : this.messages) {
                    ChatParticipant p = msg4.getParticipant();
                    if (!p.replayMessage(msg4)) continue;
                    updated.add(p);
                }
                for (ChatParticipant p : updated) {
                    this.updated(p);
                }
            }
            return changed;
        }

        private List<ChatMessage> merge(List<ChatMessage> list1, List<ChatMessage> list2) {
            int size1 = list1.size();
            int size2 = list2.size();
            ArrayList<ChatMessage> result = new ArrayList<ChatMessage>(size1 + size2);
            int pos1 = 0;
            int pos2 = 0;
            while (true) {
                long t2;
                if (pos1 == size1) {
                    for (int i = pos2; i < size2; ++i) {
                        result.add(list2.get(i));
                    }
                    break;
                }
                if (pos2 == size2) {
                    for (int i = pos1; i < size1; ++i) {
                        result.add(list1.get(i));
                    }
                    break;
                }
                ChatMessage m1 = list1.get(pos1);
                ChatMessage m2 = list2.get(pos2);
                long t1 = m1.getTimeStamp();
                if (t1 < (t2 = m2.getTimeStamp()) || t1 == t2 && m1.getUID() < m2.getUID()) {
                    result.add(m1);
                    ++pos1;
                    continue;
                }
                result.add(m2);
                ++pos2;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(Map<String, Object> message_map) throws IPCException {
            ChatMessage msg = new ChatMessage(this.message_uid_next.incrementAndGet(), message_map);
            ChatParticipant new_participant = null;
            boolean sort_outstanding = false;
            byte[] prev_id = msg.getPreviousID();
            Iterator<ChatListener> iterator = this.chat_lock;
            synchronized (iterator) {
                byte[] pk;
                ChatParticipant participant;
                int old_msgs = this.messages.size();
                this.messages.add(msg);
                if (this.messages.size() > 512) {
                    ChatMessage removed = this.messages.remove(0);
                    removed.getParticipant().removeMessage(removed);
                }
                if ((participant = this.participants.get(pk = msg.getPublicKey())) == null) {
                    new_participant = participant = new ChatParticipant(this, pk);
                    this.participants.put(pk, participant);
                    participant.addMessage(msg);
                } else {
                    participant.addMessage(msg);
                }
                if (this.sort_event != null) {
                    sort_outstanding = true;
                } else if (!(old_msgs == 0 || prev_id != null && Arrays.equals(prev_id, this.messages.get(old_msgs - 1).getID()) || msg.getMessageType() != 1)) {
                    this.sortMessages(true);
                    sort_outstanding = true;
                }
            }
            if (new_participant != null) {
                for (ChatListener l : this.listeners) {
                    l.participantAdded(new_participant);
                }
            }
            if (!sort_outstanding) {
                for (ChatListener l : this.listeners) {
                    l.messageReceived(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Object> chatRequested(Map<String, Object> message_map) throws IPCException {
            if (BuddyPluginBeta.this.private_chat_state == 1) {
                throw new IPCException("Private chat disabled by recipient");
            }
            try {
                ChatParticipant participant;
                Object new_handler = message_map.get("handler");
                byte[] remote_pk = (byte[])message_map.get("pk");
                Object object = this.chat_lock;
                synchronized (object) {
                    participant = this.participants.get(remote_pk);
                }
                if (participant == null) {
                    throw new IPCException("Private chat requires you send at least one message to the main chat first");
                }
                if (BuddyPluginBeta.this.private_chat_state == 2 && !participant.isPinned()) {
                    throw new IPCException("Recipient will only accept private chats from pinned participants");
                }
                BuddyPluginViewInterface ui = BuddyPluginBeta.this.plugin.getSWTUI();
                if (ui == null) {
                    throw new IPCException("Chat unavailable");
                }
                ChatInstance inst = BuddyPluginBeta.this.getChat(participant, new_handler);
                if (!this.isSharedNickname()) {
                    inst.setSharedNickname(false);
                    inst.setInstanceNickname(this.getInstanceNickname());
                }
                ui.openChat(inst);
                HashMap<String, Object> reply = new HashMap<String, Object>();
                reply.put("nickname", participant.getName());
                return reply;
            }
            catch (IPCException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IPCException(e);
            }
        }

        public void sendMessage(final String message) {
            this.dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    ChatInstance.this.sendMessageSupport(message, null);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessageSupport(String message, Map flags) {
            if (this.handler == null || this.msgsync_pi == null) {
                Debug.out("No handler/plugin");
            } else {
                if (message.equals("!dump!")) {
                    Object object = this.chat_lock;
                    synchronized (object) {
                        for (ChatMessage msg : this.messages) {
                            System.out.println(BuddyPluginBeta.this.pkToString(msg.getID()) + ", " + BuddyPluginBeta.this.pkToString(msg.getPreviousID()) + " - " + msg.getMessage());
                        }
                    }
                    return;
                }
                if (message.equals("!sort!")) {
                    this.sortMessages(false);
                    return;
                }
                if (message.equals("!ftux!")) {
                    BuddyPluginBeta.this.plugin.getBeta().setFTUXAccepted(false);
                    return;
                }
                if (message.startsWith("/")) {
                    String[] bits = message.split("[\\s]+", 3);
                    String command = bits[0].toLowerCase(Locale.US);
                    boolean ok = false;
                    try {
                        if (command.equals("/join")) {
                            if (bits.length > 1) {
                                BuddyPluginBeta.this.getAndShowChat("Public", bits[1]);
                                ok = true;
                            }
                        } else if (command.equals("/ajoin")) {
                            if (bits.length > 1 && BuddyPluginBeta.this.isI2PAvailable()) {
                                BuddyPluginBeta.this.getAndShowChat("I2P", bits[1]);
                                ok = true;
                            }
                        } else if (command.equals("/msg") || command.equals("/query")) {
                            if (bits.length > 1) {
                                String nick = bits[1];
                                String pm = bits.length == 2 ? "" : bits[2].trim();
                                ChatParticipant p = this.getParticipant(nick);
                                if (p == null) {
                                    throw new Exception("Nick not found: " + nick);
                                }
                                if (p.isMe()) {
                                    throw new Exception("Can't chat to yourself");
                                }
                                ChatInstance ci = p.createPrivateChat();
                                if (pm.length() > 0) {
                                    ci.sendMessage(pm);
                                }
                                BuddyPluginBeta.this.showChat(ci);
                                ok = true;
                            }
                        } else if (command.equals("/ignore") && bits.length > 1) {
                            ChatParticipant p;
                            String nick = bits[1];
                            boolean ignore = true;
                            if (nick.equals("-r") && bits.length > 2) {
                                nick = bits[2];
                                ignore = false;
                            }
                            if ((p = this.getParticipant(nick)) == null) {
                                throw new Exception("Nick not found: " + nick);
                            }
                            p.setIgnored(ignore);
                            this.updated(p);
                            ok = true;
                        }
                        if (!ok) {
                            Debug.outNoStack("Unhandled command: " + message);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    return;
                }
                try {
                    ChatMessage prev_message = null;
                    Object command = this.chat_lock;
                    synchronized (command) {
                        if (this.messages.size() > 0) {
                            prev_message = this.messages.get(this.messages.size() - 1);
                        }
                    }
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("handler", this.handler);
                    HashMap<String, Object> payload = new HashMap<String, Object>();
                    payload.put("msg", message.getBytes("UTF-8"));
                    payload.put("nick", this.getNickname().getBytes("UTF-8"));
                    if (prev_message != null) {
                        payload.put("pre", prev_message.getID());
                    }
                    if (flags != null) {
                        payload.put("f", flags);
                    }
                    options.put("content", BEncoder.encode(payload));
                    Map reply = (Map)this.msgsync_pi.getIPC().invoke("sendMessage", new Object[]{options});
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }

        public String export() {
            if (this.handler == null || this.msgsync_pi == null) {
                return "";
            }
            try {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("handler", this.handler);
                Map reply = (Map)this.msgsync_pi.getIPC().invoke("exportMessageHandler", new Object[]{options});
                return (String)reply.get("export_data");
            }
            catch (Throwable e) {
                Debug.out(e);
                return "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChatParticipant[] getParticipants() {
            Object object = this.chat_lock;
            synchronized (object) {
                return this.participants.values().toArray(new ChatParticipant[this.participants.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChatParticipant getParticipant(String nick) {
            Object object = this.chat_lock;
            synchronized (object) {
                for (ChatParticipant cp : this.participants.values()) {
                    if (!cp.getName().equals(nick)) continue;
                    return cp;
                }
            }
            return null;
        }

        protected void updated(ChatParticipant p) {
            for (ChatListener l : this.listeners) {
                l.participantChanged(p);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerNick(ChatParticipant p, String old_nick, String new_nick) {
            Object object = this.chat_lock;
            synchronized (object) {
                List<ChatParticipant> list;
                if (old_nick != null) {
                    list = this.nick_clash_map.get(old_nick);
                    if (list != null && list.remove(p)) {
                        if (list.size() == 0) {
                            this.nick_clash_map.remove(old_nick);
                        } else if (list.size() == 1) {
                            list.get(0).setNickClash(false);
                        }
                    } else {
                        Debug.out("inconsistent");
                    }
                }
                if ((list = this.nick_clash_map.get(new_nick)) == null) {
                    list = new ArrayList<ChatParticipant>();
                    this.nick_clash_map.put(new_nick, list);
                }
                if (list.contains(p)) {
                    Debug.out("inconsistent");
                } else {
                    list.add(p);
                    if (list.size() > 1) {
                        p.setNickClash(true);
                        if (list.size() == 2) {
                            list.get(0).setNickClash(true);
                        }
                    } else {
                        p.setNickClash(false);
                    }
                }
            }
        }

        public void addListener(ChatListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ChatListener listener) {
            this.listeners.remove(listener);
        }

        public boolean isDestroyed() {
            return this.destroyed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void destroy() {
            String meta_key2222;
            Object object = this.chat_lock;
            synchronized (object) {
                --this.reference_count;
                if (this.reference_count > 0) {
                    return;
                }
            }
            if (this.persistent) return;
            this.destroyed = true;
            if (this.handler == null) return;
            if (this.is_private_chat) {
                HashMap<String, Integer> flags = new HashMap<String, Integer>();
                flags.put("s", 1);
                this.sendMessageSupport("", flags);
            }
            try {
                try {
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("handler", this.handler);
                    Map map = (Map)this.msgsync_pi.getIPC().invoke("removeMessageHandler", new Object[]{options});
                }
                catch (Throwable e) {
                    Debug.out(e);
                    Object var4_5 = null;
                    String meta_key2222 = this.network + ":" + this.key;
                    Map map = BuddyPluginBeta.this.chat_instances_map;
                    synchronized (map) {
                        ChatInstance inst = (ChatInstance)BuddyPluginBeta.this.chat_instances_map.remove(meta_key2222);
                        if (inst != null) {
                            BuddyPluginBeta.this.chat_instances_list.remove(inst);
                        }
                        if (BuddyPluginBeta.this.chat_instances_map.size() != 0) return;
                        if (BuddyPluginBeta.this.timer == null) return;
                        BuddyPluginBeta.this.timer.cancel();
                        BuddyPluginBeta.this.timer = null;
                        return;
                    }
                }
                Object var4_4 = null;
                meta_key2222 = this.network + ":" + this.key;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                String meta_key2222 = this.network + ":" + this.key;
                Map map2 = BuddyPluginBeta.this.chat_instances_map;
                synchronized (map2) {
                    ChatInstance inst = (ChatInstance)BuddyPluginBeta.this.chat_instances_map.remove(meta_key2222);
                    if (inst != null) {
                        BuddyPluginBeta.this.chat_instances_list.remove(inst);
                    }
                    if (BuddyPluginBeta.this.chat_instances_map.size() != 0) throw throwable;
                    if (BuddyPluginBeta.this.timer == null) throw throwable;
                    BuddyPluginBeta.this.timer.cancel();
                    BuddyPluginBeta.this.timer = null;
                    throw throwable;
                }
            }
            Map map = BuddyPluginBeta.this.chat_instances_map;
            synchronized (map) {
                ChatInstance inst = (ChatInstance)BuddyPluginBeta.this.chat_instances_map.remove(meta_key2222);
                if (inst != null) {
                    BuddyPluginBeta.this.chat_instances_list.remove(inst);
                }
                if (BuddyPluginBeta.this.chat_instances_map.size() != 0) return;
                if (BuddyPluginBeta.this.timer == null) return;
                BuddyPluginBeta.this.timer.cancel();
                BuddyPluginBeta.this.timer = null;
                return;
            }
        }
    }

    public static interface ChatListener {
        public void messageReceived(ChatMessage var1);

        public void messagesChanged();

        public void participantAdded(ChatParticipant var1);

        public void participantChanged(ChatParticipant var1);

        public void participantRemoved(ChatParticipant var1);

        public void stateChanged(boolean var1);

        public void updated();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChatMessage {
        public static final int MT_NORMAL = 1;
        public static final int MT_INFO = 2;
        public static final int MT_ERROR = 3;
        private final int uid;
        private final Map<String, Object> map;
        private ChatParticipant participant;
        private final byte[] message_id;
        private byte[] previous_id;
        private long timestamp;
        private boolean is_ignored;
        private boolean is_nick_clash;

        private ChatMessage(int _uid, Map<String, Object> _map) {
            this.uid = _uid;
            this.map = _map;
            this.message_id = (byte[])this.map.get("id");
            this.timestamp = SystemTime.getCurrentTime() - (long)(this.getAge() * 1000);
            Map<String, Object> payload = this.getPayload();
            this.previous_id = (byte[])payload.get("pre");
        }

        protected int getUID() {
            return this.uid;
        }

        private void setParticipant(ChatParticipant p) {
            this.participant = p;
        }

        public ChatParticipant getParticipant() {
            return this.participant;
        }

        private void setNickClash(boolean clash) {
            this.is_nick_clash = clash;
        }

        public boolean isNickClash() {
            return this.is_nick_clash;
        }

        private Map<String, Object> getPayload() {
            try {
                byte[] content_bytes = (byte[])this.map.get("content");
                if (content_bytes != null && content_bytes.length > 0) {
                    return BDecoder.decode(content_bytes);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new HashMap<String, Object>();
        }

        private int getMessageStatus() {
            Number status;
            Map flags;
            Map<String, Object> payload = this.getPayload();
            if (payload != null && (flags = (Map)payload.get("f")) != null && (status = (Number)flags.get("s")) != null) {
                return status.intValue();
            }
            return 0;
        }

        public String getMessage() {
            try {
                byte[] msg_bytes;
                String report = (String)this.map.get("error");
                if (report != null) {
                    if (report.length() > 2 && report.charAt(1) == ':') {
                        return report.substring(2);
                    }
                    return report;
                }
                if (this.getMessageStatus() == 1) {
                    return this.participant.getName() + " has quit";
                }
                Map<String, Object> payload = this.getPayload();
                if (payload != null && (msg_bytes = (byte[])payload.get("msg")) != null) {
                    return new String(msg_bytes, "UTF-8");
                }
                return new String((byte[])this.map.get("content"), "UTF-8");
            }
            catch (Throwable e) {
                Debug.out(e);
                return "";
            }
        }

        public int getMessageType() {
            String report = (String)this.map.get("error");
            if (report == null) {
                if (this.getMessageStatus() == 1) {
                    return 2;
                }
                return 1;
            }
            if (report.length() < 2 || report.charAt(1) != ':') {
                return 3;
            }
            char type = report.charAt(0);
            if (type == 'i') {
                return 2;
            }
            return 3;
        }

        public boolean isIgnored() {
            return this.is_ignored;
        }

        public void setIgnored(boolean b) {
            this.is_ignored = b;
        }

        public byte[] getID() {
            return this.message_id;
        }

        public byte[] getPreviousID() {
            return this.previous_id;
        }

        private void setPreviousID(byte[] pid) {
            this.previous_id = pid;
        }

        public byte[] getPublicKey() {
            return (byte[])this.map.get("pk");
        }

        public Map<String, Object> getContact() {
            return (Map)this.map.get("contact");
        }

        public InetSocketAddress getAddress() {
            return (InetSocketAddress)this.map.get("address");
        }

        private int getAge() {
            return ((Number)this.map.get("age")).intValue();
        }

        public long getTimeStamp() {
            return this.timestamp;
        }

        public String getNickName() {
            Object nick;
            Map<String, Object> payload = this.getPayload();
            if (payload != null && (nick = (byte[])payload.get("nick")) != null) {
                try {
                    String str = new String((byte[])nick, "UTF-8");
                    if (str.length() > 0) {
                        return str;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.getMessageType() != 1 && ((String)(nick = (Object)this.participant.getChat().getNickname())).length() > 0) {
                return nick;
            }
            return BuddyPluginBeta.this.pkToString(this.getPublicKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChatParticipant {
        private final ChatInstance chat;
        private final byte[] pk;
        private String nickname;
        private boolean is_ignored;
        private boolean is_pinned;
        private boolean nick_clash;
        private List<ChatMessage> messages = new ArrayList<ChatMessage>();
        private Boolean is_me;

        private ChatParticipant(ChatInstance _chat, byte[] _pk) {
            this.chat = _chat;
            this.pk = _pk;
            this.nickname = BuddyPluginBeta.this.pkToString(this.pk);
            this.is_pinned = COConfigurationManager.getBooleanParameter(this.getPinKey(), false);
            this.chat.registerNick(this, null, this.nickname);
        }

        public ChatInstance getChat() {
            return this.chat;
        }

        public byte[] getPublicKey() {
            return this.pk;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Object> getContact() {
            Object object = this.chat.chat_lock;
            synchronized (object) {
                return this.messages.get(this.messages.size() - 1).getContact();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InetSocketAddress getAddress() {
            Object object = this.chat.chat_lock;
            synchronized (object) {
                return this.messages.get(this.messages.size() - 1).getAddress();
            }
        }

        public boolean isMe() {
            if (this.is_me != null) {
                return this.is_me;
            }
            byte[] chat_key = this.chat.getPublicKey();
            if (chat_key != null) {
                this.is_me = Arrays.equals(this.pk, chat_key);
            }
            return this.is_me;
        }

        public String getName() {
            return this.getName(true);
        }

        public String getName(boolean use_nick) {
            if (use_nick) {
                return this.nickname;
            }
            return BuddyPluginBeta.this.pkToString(this.pk);
        }

        public boolean hasNickname() {
            return !this.nickname.equals(BuddyPluginBeta.this.pkToString(this.pk));
        }

        private void addMessage(ChatMessage message) {
            this.messages.add(message);
            message.setParticipant(this);
            message.setIgnored(this.is_ignored);
            String new_nickname = message.getNickName();
            if (!this.nickname.equals(new_nickname)) {
                this.chat.registerNick(this, this.nickname, new_nickname);
                message.setNickClash(this.isNickClash());
                this.nickname = new_nickname;
                this.chat.updated(this);
            } else {
                message.setNickClash(this.isNickClash());
            }
        }

        private boolean replayMessage(ChatMessage message) {
            this.messages.add(message);
            message.setIgnored(this.is_ignored);
            String new_nickname = message.getNickName();
            if (!this.nickname.equals(new_nickname)) {
                this.chat.registerNick(this, this.nickname, new_nickname);
                message.setNickClash(this.isNickClash());
                this.nickname = new_nickname;
                return true;
            }
            message.setNickClash(this.isNickClash());
            return false;
        }

        private void removeMessage(ChatMessage message) {
            this.messages.remove(message);
        }

        private void resetMessages() {
            String new_nickname = BuddyPluginBeta.this.pkToString(this.pk);
            if (!this.nickname.equals(new_nickname)) {
                this.chat.registerNick(this, this.nickname, new_nickname);
                this.nickname = new_nickname;
            }
            this.messages.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ChatMessage> getMessages() {
            Object object = this.chat.chat_lock;
            synchronized (object) {
                return new ArrayList<ChatMessage>(this.messages);
            }
        }

        public boolean isIgnored() {
            return this.is_ignored;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setIgnored(boolean b) {
            if (b != this.is_ignored) {
                this.is_ignored = b;
                Object object = this.chat.chat_lock;
                synchronized (object) {
                    for (ChatMessage message : this.messages) {
                        message.setIgnored(b);
                    }
                }
            }
        }

        public boolean isPinned() {
            return this.is_pinned;
        }

        private String getPinKey() {
            return "azbuddy.chat.pinned." + ByteFormatter.encodeString(this.pk, 0, 16);
        }

        public void setPinned(boolean b) {
            if (b != this.is_pinned) {
                this.is_pinned = b;
                String key = this.getPinKey();
                if (this.is_pinned) {
                    COConfigurationManager.setParameter(key, true);
                } else {
                    COConfigurationManager.removeParameter(key);
                }
                COConfigurationManager.setDirty();
            }
        }

        public boolean isNickClash() {
            return this.nick_clash;
        }

        private void setNickClash(boolean b) {
            this.nick_clash = b;
        }

        public ChatInstance createPrivateChat() throws Exception {
            ChatInstance inst = BuddyPluginBeta.this.getChat(this);
            ChatInstance parent = this.getChat();
            if (!parent.isSharedNickname()) {
                inst.setSharedNickname(false);
                inst.setInstanceNickname(parent.getInstanceNickname());
            }
            return inst;
        }
    }

    public static interface FTUXStateChangeListener {
        public void stateChanged(boolean var1);
    }
}

