/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy;

import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyMessage;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyMessageHandler;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyReplyListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginException;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginTimeoutException;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnection;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnectionListener;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageRegistration;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.plugins.utils.security.SEPublicKey;
import org.gudy.azureus2.plugins.utils.security.SEPublicKeyLocator;
import org.gudy.azureus2.plugins.utils.security.SESecurityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddyPluginBuddy {
    private static final boolean TRACE = false;
    private static final int CONNECTION_IDLE_TIMEOUT = 300000;
    private static final int CONNECTION_KEEP_ALIVE = 60000;
    private static final int MAX_ACTIVE_CONNECTIONS = 5;
    private static final int MAX_QUEUED_MESSAGES = 256;
    private static final int RT_REQUEST_DATA = 1;
    private static final int RT_REPLY_DATA = 2;
    private static final int RT_REPLY_ERROR = 99;
    private BuddyPlugin plugin;
    private long created_time;
    private int subsystem;
    private boolean authorised;
    private String public_key;
    private String nick_name;
    private List<Long> recent_ygm;
    private int last_status_seq;
    private long post_time;
    private InetAddress ip;
    private int tcp_port;
    private int udp_port;
    private int online_status = 0;
    private int version = 2;
    private boolean online;
    private long last_time_online;
    private long status_check_count;
    private long last_status_check_time;
    private boolean check_active;
    private List<buddyConnection> connections = new ArrayList<buddyConnection>();
    private List<buddyMessage> messages = new ArrayList<buddyMessage>();
    private buddyMessage current_message;
    private int next_connection_id;
    private int next_message_id;
    private boolean ygm_active;
    private boolean ygm_pending;
    private long latest_ygm_time;
    private String last_message_received;
    private Set<Long> offline_seq_set;
    private int message_out_count;
    private int message_in_count;
    private int message_out_bytes;
    private int message_in_bytes;
    private String received_frag_details = "";
    private BuddyPluginBuddyMessageHandler persistent_msg_handler;
    private Map<Object, Object> user_data = new LightHashMap<Object, Object>();
    private boolean keep_alive_outstanding;
    private volatile long last_connect_attempt = SystemTime.getCurrentTime();
    private volatile int consec_connect_fails;
    private long last_auto_reconnect = -1L;
    private Object rss_lock = new Object();
    private Set<String> rss_local_cats;
    private Set<String> rss_remote_cats;
    private Set<String> rss_cats_read;
    private AESemaphore outgoing_connect_sem = new AESemaphore("BPB:outcon", 1);
    private volatile boolean closing;
    private volatile boolean destroyed;

    protected BuddyPluginBuddy(BuddyPlugin _plugin, long _created_time, int _subsystem, boolean _authorised, String _pk, String _nick_name, int _version, String _rss_local_cats, String _rss_remote_cats, int _last_status_seq, long _last_time_online, List<Long> _recent_ygm) {
        this.plugin = _plugin;
        this.created_time = _created_time;
        this.subsystem = _subsystem;
        this.authorised = _authorised;
        this.public_key = _pk;
        this.nick_name = _nick_name;
        this.version = Math.max(this.version, _version);
        this.rss_local_cats = this.stringToCats(_rss_local_cats);
        this.rss_remote_cats = this.stringToCats(_rss_remote_cats);
        this.last_status_seq = _last_status_seq;
        this.last_time_online = _last_time_online;
        this.recent_ygm = _recent_ygm;
        this.persistent_msg_handler = new BuddyPluginBuddyMessageHandler(this, new File(this.plugin.getBuddyConfigDir(), this.public_key));
    }

    protected void setInitialStatus(long now, int num_buddies) {
        if (this.last_time_online == 0L && now - this.created_time > 604800000L) {
            this.last_status_check_time = now + (long)RandomUtils.nextInt(300000 * num_buddies);
        }
    }

    protected BuddyPlugin getPlugin() {
        return this.plugin;
    }

    public BuddyPluginBuddyMessageHandler getMessageHandler() {
        return this.persistent_msg_handler;
    }

    protected void persistentDispatchPending() {
        this.plugin.persistentDispatchPending(this);
    }

    protected void checkPersistentDispatch() {
        this.persistent_msg_handler.checkPersistentDispatch();
    }

    protected void persistentDispatch() {
        this.persistent_msg_handler.persistentDispatch();
    }

    public Map readConfigFile(File name) {
        return this.plugin.readConfigFile(name);
    }

    public boolean writeConfigFile(File name, Map data) {
        return this.plugin.writeConfigFile(name, data);
    }

    protected long getCreatedTime() {
        return this.created_time;
    }

    public int getSubsystem() {
        return this.subsystem;
    }

    protected void setSubsystem(int _s) {
        this.subsystem = _s;
    }

    public boolean isAuthorised() {
        return this.authorised;
    }

    protected void setAuthorised(boolean _a) {
        this.authorised = _a;
    }

    public String getPublicKey() {
        return this.public_key;
    }

    protected byte[] getRawPublicKey() {
        return Base32.decode(this.public_key);
    }

    protected String getShortString() {
        return this.public_key.substring(0, 16) + "...";
    }

    public String getNickName() {
        return this.nick_name;
    }

    public int getVersion() {
        return this.version;
    }

    protected void setVersion(int v) {
        if (this.version < v) {
            this.version = v;
            this.plugin.fireDetailsChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalAuthorisedRSSTagsOrCategoriesAsString() {
        Object object = this.rss_lock;
        synchronized (object) {
            return this.catsToString(this.rss_local_cats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getLocalAuthorisedRSSTagsOrCategories() {
        Object object = this.rss_lock;
        synchronized (object) {
            return this.rss_local_cats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalAuthorisedRSSTagOrCategory(String category) {
        boolean dirty;
        category = this.plugin.normaliseCat(category);
        Object object = this.rss_lock;
        synchronized (object) {
            if (this.rss_local_cats == null) {
                this.rss_local_cats = new HashSet<String>();
            }
            if (dirty = !this.rss_local_cats.contains(category)) {
                this.rss_local_cats.add(category);
            }
        }
        if (dirty) {
            this.plugin.setConfigDirty();
            this.plugin.fireDetailsChanged(this);
            if (this.isConnected()) {
                this.sendKeepAlive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalAuthorisedRSSTagOrCategory(String category) {
        boolean dirty;
        category = this.plugin.normaliseCat(category);
        Object object = this.rss_lock;
        synchronized (object) {
            if (this.rss_local_cats == null) {
                return;
            }
            dirty = this.rss_local_cats.remove(category);
        }
        if (dirty) {
            this.plugin.setConfigDirty();
            this.plugin.fireDetailsChanged(this);
            if (this.isConnected()) {
                this.sendKeepAlive();
            }
        }
    }

    public void setLocalAuthorisedRSSTagsOrCategories(String new_cats) {
        this.setLocalAuthorisedRSSTagsOrCategories(this.stringToCats(new_cats));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalAuthorisedRSSTagsOrCategories(Set<String> new_cats) {
        boolean dirty;
        this.plugin.normaliseCats(new_cats);
        Object object = this.rss_lock;
        synchronized (object) {
            dirty = !this.catsIdentical(new_cats, this.rss_local_cats);
            if (dirty) {
                this.rss_local_cats = new_cats;
            }
        }
        if (dirty) {
            this.plugin.setConfigDirty();
            this.plugin.fireDetailsChanged(this);
            if (this.isConnected()) {
                this.sendKeepAlive();
            }
        }
    }

    public Set<String> getRemoteAuthorisedRSSTagsOrCategories() {
        return this.rss_remote_cats;
    }

    public String getRemoteAuthorisedRSSTagsOrCategoriesAsString() {
        return this.catsToString(this.rss_remote_cats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRemoteAuthorisedRSSTagsOrCategories(Set<String> new_cats) {
        boolean dirty;
        this.plugin.normaliseCats(new_cats);
        Object object = this.rss_lock;
        synchronized (object) {
            dirty = !this.catsIdentical(new_cats, this.rss_remote_cats);
            if (dirty) {
                this.rss_remote_cats = new_cats;
            }
        }
        if (dirty) {
            this.plugin.setConfigDirty();
            this.plugin.fireDetailsChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalRSSTagOrCategoryAuthorised(String category) {
        category = this.plugin.normaliseCat(category);
        Object object = this.rss_lock;
        synchronized (object) {
            if (this.rss_local_cats != null) {
                return this.rss_local_cats.contains(category);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRemoteRSSTagOrCategoryAuthorised(String category) {
        category = this.plugin.normaliseCat(category);
        Object object = this.rss_lock;
        synchronized (object) {
            if (this.rss_remote_cats != null) {
                return this.rss_remote_cats.contains(category);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localRSSTagOrCategoryRead(String str) {
        boolean dirty;
        Object object = this.rss_lock;
        synchronized (object) {
            if (this.rss_cats_read == null) {
                this.rss_cats_read = new HashSet<String>();
            }
            dirty = this.rss_cats_read.add(str);
        }
        if (dirty) {
            this.plugin.fireDetailsChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalReadTagsOrCategoriesAsString() {
        Object object = this.rss_lock;
        synchronized (object) {
            return this.catsToString(this.rss_cats_read);
        }
    }

    public URL getSubscriptionURL(String cat) {
        String url = "azplug:?id=azbuddy&name=Friends&arg=";
        String arg = "pk=" + this.getPublicKey() + "&cat=" + cat;
        try {
            url = url + URLEncoder.encode(arg, "UTF-8");
            return new URL(url);
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    public void subscribeToCategory(String cat) throws BuddyPluginException {
        AZ3Functions.provider az3 = AZ3Functions.getProvider();
        if (az3 == null) {
            throw new BuddyPluginException("AZ3 subsystem not available");
        }
        try {
            az3.subscribeToRSS(this.getName() + ": " + cat, this.getSubscriptionURL(cat), 15, false, this.getPublicKey() + ":" + cat);
        }
        catch (Throwable e) {
            throw new BuddyPluginException("Failed to add subscription", e);
        }
    }

    public boolean isSubscribedToTagOrCategory(String cat, String creator_ref) {
        if (creator_ref == null) {
            return false;
        }
        return creator_ref.equals(this.getPublicKey() + ":" + cat);
    }

    protected String catsToString(Set<String> cats) {
        if (cats == null || cats.size() == 0) {
            return null;
        }
        String str = "";
        for (String s : cats) {
            str = str + (str.length() == 0 ? "" : ",") + s;
        }
        return str;
    }

    protected boolean catsIdentical(Set<String> c1, Set<String> c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.equals(c2);
    }

    protected Set<String> stringToCats(String str) {
        if (str == null) {
            return null;
        }
        String[] bits = str.split(",");
        HashSet<String> res = new HashSet<String>(bits.length);
        for (String b : bits) {
            if ((b = b.trim()).length() <= 0) continue;
            res.add(b);
        }
        if (res.size() == 0) {
            return null;
        }
        return res;
    }

    public int getOnlineStatus() {
        return this.online_status;
    }

    protected void setOnlineStatus(int s) {
        if (this.online_status != s) {
            this.online_status = s;
            this.plugin.fireDetailsChanged(this);
        }
    }

    public String getName() {
        if (this.nick_name != null) {
            return this.nick_name;
        }
        return this.getShortString();
    }

    public void remove() {
        this.persistent_msg_handler.destroy();
        this.plugin.removeBuddy(this);
    }

    public InetAddress getIP() {
        return this.ip;
    }

    public InetAddress getAdjustedIP() {
        if (this.ip == null) {
            return null;
        }
        InetSocketAddress address = new InetSocketAddress(this.ip, this.tcp_port);
        InetSocketAddress adjusted_address = AddressUtils.adjustTCPAddress(address, true);
        if (adjusted_address != address) {
            return adjusted_address.getAddress();
        }
        address = new InetSocketAddress(this.ip, this.udp_port);
        adjusted_address = AddressUtils.adjustUDPAddress(address, true);
        if (adjusted_address != address) {
            return adjusted_address.getAddress();
        }
        return this.ip;
    }

    public List getAdjustedIPs() {
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        if (this.ip == null) {
            return result;
        }
        InetAddress adjusted = this.getAdjustedIP();
        if (adjusted == this.ip) {
            result.add(this.ip);
        } else {
            List l = AddressUtils.getLANAddresses(adjusted.getHostAddress());
            for (int i = 0; i < l.size(); ++i) {
                try {
                    result.add(InetAddress.getByName((String)l.get(i)));
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public int getTCPPort() {
        return this.tcp_port;
    }

    public int getUDPPort() {
        return this.udp_port;
    }

    public boolean isOnline(boolean is_connected) {
        boolean connected = this.isConnected();
        if (connected) {
            return true;
        }
        if (!this.online) {
            return false;
        }
        return !is_connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isIdle() {
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            return this.connections.size() == 0;
        }
    }

    public long getLastTimeOnline() {
        return this.last_time_online;
    }

    public BuddyPlugin.cryptoResult encrypt(byte[] payload) throws BuddyPluginException {
        return this.plugin.encrypt(this, payload);
    }

    public BuddyPlugin.cryptoResult decrypt(byte[] payload) throws BuddyPluginException {
        return this.plugin.decrypt(this, payload, this.getName());
    }

    public boolean verify(byte[] payload, byte[] signature) throws BuddyPluginException {
        return this.plugin.verify(this, payload, signature);
    }

    public BuddyPluginBuddyMessage storeMessage(int type, Map msg) {
        return this.persistent_msg_handler.storeExplicitMessage(type, msg);
    }

    public List<BuddyPluginBuddyMessage> retrieveMessages(int type) {
        return this.persistent_msg_handler.retrieveExplicitMessages(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessagePending() throws BuddyPluginException {
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            if (this.ygm_active) {
                this.ygm_pending = true;
                return;
            }
            this.ygm_active = true;
        }
        this.plugin.setMessagePending(this, new BuddyPlugin.operationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void complete() {
                boolean retry;
                BuddyPluginBuddy buddyPluginBuddy = BuddyPluginBuddy.this;
                synchronized (buddyPluginBuddy) {
                    BuddyPluginBuddy.this.ygm_active = false;
                    retry = BuddyPluginBuddy.this.ygm_pending;
                    BuddyPluginBuddy.this.ygm_pending = false;
                }
                if (retry) {
                    try {
                        BuddyPluginBuddy.this.setMessagePending();
                    }
                    catch (BuddyPluginException e) {
                        BuddyPluginBuddy.this.log("Failed to send YGM", e);
                    }
                }
            }
        });
    }

    public long getLastMessagePending() {
        return this.latest_ygm_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addYGMMarker(long marker) {
        Long l = new Long(marker);
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            if (this.recent_ygm == null) {
                this.recent_ygm = new ArrayList<Long>();
            }
            if (this.recent_ygm.contains(l)) {
                return false;
            }
            this.recent_ygm.add(l);
            if (this.recent_ygm.size() > 16) {
                this.recent_ygm.remove(0);
            }
            this.latest_ygm_time = SystemTime.getCurrentTime();
        }
        this.plugin.setConfigDirty();
        this.plugin.fireDetailsChanged(this);
        return true;
    }

    protected void setLastMessageReceived(String str) {
        this.last_message_received = str;
        this.plugin.fireDetailsChanged(this);
    }

    public String getLastMessageReceived() {
        return this.last_message_received == null ? "" : this.last_message_received;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Long> getYGMMarkers() {
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            return this.recent_ygm == null ? null : new ArrayList<Long>(this.recent_ygm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getLastStatusSeq() {
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            return this.last_status_seq;
        }
    }

    protected void buddyConnectionEstablished(boolean outgoing) {
        this.buddyActive();
    }

    protected void buddyMessageSent(int size, boolean record_active) {
        ++this.message_out_count;
        this.message_out_bytes += size;
        if (record_active) {
            this.buddyActive();
        }
    }

    protected void buddyMessageReceived(int size) {
        ++this.message_in_count;
        this.message_in_bytes += size;
        this.received_frag_details = "";
        this.buddyActive();
    }

    protected void buddyMessageFragmentReceived(int num_received, int total) {
        this.received_frag_details = num_received + "/" + total;
        this.plugin.fireDetailsChanged(this);
    }

    public String getMessageInFragmentDetails() {
        return this.received_frag_details;
    }

    public int getMessageInCount() {
        return this.message_in_count;
    }

    public int getMessageOutCount() {
        return this.message_out_count;
    }

    public int getBytesInCount() {
        return this.message_in_bytes;
    }

    public int getBytesOutCount() {
        return this.message_out_bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        boolean connected = false;
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            for (int i = 0; i < this.connections.size(); ++i) {
                buddyConnection c = this.connections.get(i);
                if (!c.isConnected() || c.hasFailed()) continue;
                connected = true;
            }
        }
        return connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buddyActive() {
        long now = SystemTime.getCurrentTime();
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            this.last_time_online = now;
            this.online = true;
        }
        this.persistentDispatchPending();
        this.plugin.fireDetailsChanged(this);
    }

    public void ping() throws BuddyPluginException {
        this.plugin.checkAvailable();
        try {
            HashMap<String, Long> ping_request = new HashMap<String, Long>();
            ping_request.put("type", new Long(1L));
            this.sendMessage(0, ping_request, 60000, new BuddyPluginBuddyReplyListener(){

                public void replyReceived(BuddyPluginBuddy from_buddy, Map reply) {
                    BuddyPluginBuddy.this.log("Ping reply received:" + reply);
                }

                public void sendFailed(BuddyPluginBuddy to_buddy, BuddyPluginException cause) {
                    BuddyPluginBuddy.this.log("Ping failed to " + BuddyPluginBuddy.this.getString(), cause);
                }
            });
        }
        catch (Throwable e) {
            throw new BuddyPluginException("Ping failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCloseRequest(boolean restarting) {
        ArrayList<buddyConnection> to_send = new ArrayList<buddyConnection>();
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            this.closing = true;
            for (int i = 0; i < this.connections.size(); ++i) {
                buddyConnection c = this.connections.get(i);
                if (!c.isConnected() || c.hasFailed() || c.isActive()) continue;
                to_send.add(c);
            }
        }
        for (int i = 0; i < to_send.size(); ++i) {
            buddyConnection c = (buddyConnection)to_send.get(i);
            try {
                HashMap<String, Long> close_request = new HashMap<String, Long>();
                close_request.put("type", new Long(3L));
                close_request.put("r", new Long(restarting ? 1L : 0L));
                close_request.put("os", new Long(this.plugin.getCurrentStatusSeq()));
                buddyMessage message = new buddyMessage(0, close_request, 60000);
                message.setListener(new BuddyPluginBuddyReplyListener(){

                    public void replyReceived(BuddyPluginBuddy from_buddy, Map reply) {
                        BuddyPluginBuddy.this.log("Close reply received:" + reply);
                    }

                    public void sendFailed(BuddyPluginBuddy to_buddy, BuddyPluginException cause) {
                        BuddyPluginBuddy.this.log("Close failed to " + BuddyPluginBuddy.this.getString(), cause);
                    }
                });
                c.sendCloseMessage(message);
                continue;
            }
            catch (Throwable e) {
                this.log("Close request failed", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receivedCloseRequest(Map request2) {
        block13: {
            ArrayList<buddyConnection> closing = new ArrayList<buddyConnection>();
            BuddyPluginBuddy buddyPluginBuddy = this;
            synchronized (buddyPluginBuddy) {
                closing.addAll(this.connections);
            }
            for (int i = 0; i < closing.size(); ++i) {
                ((buddyConnection)closing.get(i)).remoteClosing();
            }
            try {
                boolean restarting;
                boolean bl = restarting = (Long)request2.get("r") == 1L;
                if (restarting) {
                    this.logMessage("restarting");
                    break block13;
                }
                this.logMessage("going offline");
                boolean details_change = false;
                BuddyPluginBuddy buddyPluginBuddy2 = this;
                synchronized (buddyPluginBuddy2) {
                    if (this.offline_seq_set == null) {
                        this.offline_seq_set = new HashSet<Long>();
                    }
                    this.offline_seq_set.add(new Long(this.last_status_seq));
                    this.offline_seq_set.add((Long)request2.get("os"));
                    if (this.online) {
                        this.online = false;
                        this.consec_connect_fails = 0;
                        details_change = true;
                    }
                }
                if (details_change) {
                    this.plugin.fireDetailsChanged(this);
                }
            }
            catch (Throwable e) {
                Debug.out("Failed to decode close request", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(final int subsystem, final Map content, final int timeout_millis, final BuddyPluginBuddyReplyListener listener) throws BuddyPluginException {
        this.plugin.checkAvailable();
        boolean wait = false;
        if (this.ip == null) {
            BuddyPluginBuddy buddyPluginBuddy = this;
            synchronized (buddyPluginBuddy) {
                wait = this.check_active;
            }
            if (!wait && SystemTime.getCurrentTime() - this.last_status_check_time > 30000L) {
                this.plugin.updateBuddyStatus(this);
                wait = true;
            }
        }
        if (wait) {
            new AEThread2("BuddyPluginBuddy:sendWait", true){

                public void run() {
                    try {
                        long start = SystemTime.getCurrentTime();
                        for (int i = 0; i < 20 && BuddyPluginBuddy.this.ip == null; ++i) {
                            Thread.sleep(1000L);
                        }
                        long elapsed = SystemTime.getCurrentTime() - start;
                        int new_tm = timeout_millis;
                        if (elapsed > 0L && timeout_millis > 0 && (new_tm = (int)((long)new_tm - elapsed)) <= 0) {
                            listener.sendFailed(BuddyPluginBuddy.this, new BuddyPluginException("Timeout"));
                            return;
                        }
                        BuddyPluginBuddy.this.sendMessageSupport(content, subsystem, new_tm, listener);
                    }
                    catch (Throwable e) {
                        if (e instanceof BuddyPluginException) {
                            listener.sendFailed(BuddyPluginBuddy.this, (BuddyPluginException)e);
                        }
                        listener.sendFailed(BuddyPluginBuddy.this, new BuddyPluginException("Send failed", e));
                    }
                }
            }.start();
        } else {
            this.sendMessageSupport(content, subsystem, timeout_millis, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessageSupport(Map content, int subsystem, int timeout_millis, final BuddyPluginBuddyReplyListener original_listener) throws BuddyPluginException {
        boolean too_many_messages = false;
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            too_many_messages = this.messages.size() >= 256;
        }
        if (too_many_messages) {
            throw new BuddyPluginException("Too many messages queued");
        }
        final buddyMessage message = new buddyMessage(subsystem, content, timeout_millis);
        BuddyPluginBuddyReplyListener listener_delegate = new BuddyPluginBuddyReplyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void replyReceived(BuddyPluginBuddy from_buddy, Map reply) {
                try {
                    BuddyPluginBuddy buddyPluginBuddy = BuddyPluginBuddy.this;
                    synchronized (buddyPluginBuddy) {
                        if (BuddyPluginBuddy.this.current_message != message) {
                            Debug.out("Inconsistent: reply received not for current message");
                        }
                        BuddyPluginBuddy.this.current_message = null;
                    }
                    original_listener.replyReceived(from_buddy, reply);
                    Object var6_5 = null;
                    BuddyPluginBuddy.this.dispatchMessage();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    BuddyPluginBuddy.this.dispatchMessage();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sendFailed(BuddyPluginBuddy to_buddy, BuddyPluginException cause) {
                BuddyPluginBuddy.this.logMessage("Msg " + message.getString() + " failed: " + Debug.getNestedExceptionMessage(cause));
                try {
                    boolean was_active = cause instanceof BuddyPluginTimeoutException ? ((BuddyPluginTimeoutException)cause).wasActive() : true;
                    if (was_active) {
                        BuddyPluginBuddy buddyPluginBuddy = BuddyPluginBuddy.this;
                        synchronized (buddyPluginBuddy) {
                            if (BuddyPluginBuddy.this.current_message != message) {
                                Debug.out("Inconsistent: error received not for current message");
                            }
                            BuddyPluginBuddy.this.current_message = null;
                        }
                    }
                    long now = SystemTime.getCurrentTime();
                    int retry_count = message.getRetryCount();
                    if (retry_count < 1 && !message.timedOut(now)) {
                        message.setRetry();
                        BuddyPluginBuddy buddyPluginBuddy = BuddyPluginBuddy.this;
                        synchronized (buddyPluginBuddy) {
                            BuddyPluginBuddy.this.messages.add(0, message);
                        }
                    } else {
                        original_listener.sendFailed(to_buddy, cause);
                    }
                    Object var10_10 = null;
                    BuddyPluginBuddy.this.dispatchMessage();
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    BuddyPluginBuddy.this.dispatchMessage();
                    throw throwable;
                }
            }
        };
        message.setListener(listener_delegate);
        BuddyPluginBuddy buddyPluginBuddy2 = this;
        synchronized (buddyPluginBuddy2) {
            this.messages.add(message);
            int size = this.messages.size();
        }
        this.dispatchMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void dispatchMessage() {
        void var3_15;
        void var3_6;
        buddyConnection c;
        int i;
        buddyConnection bc = null;
        buddyMessage allocated_message = null;
        Object var3_3 = null;
        boolean inform_dirty = false;
        BuddyPluginBuddy buddyPluginBuddy = this;
        // MONITORENTER : buddyPluginBuddy
        if (this.current_message != null || this.messages.size() == 0 || this.closing) {
            // MONITOREXIT : buddyPluginBuddy
            return;
        }
        allocated_message = this.current_message = this.messages.remove(0);
        for (i = 0; i < this.connections.size(); ++i) {
            c = this.connections.get(i);
            if (c.hasFailed()) continue;
            bc = c;
        }
        if (bc == null) {
            if (this.destroyed) {
                BuddyPluginException buddyPluginException = new BuddyPluginException("Friend destroyed");
            } else if (this.connections.size() >= 5) {
                BuddyPluginException buddyPluginException = new BuddyPluginException("Too many active connections");
            }
        }
        // MONITOREXIT : buddyPluginBuddy
        if (var3_6 != null) {
            allocated_message.reportFailed((Throwable)var3_6);
            return;
        }
        if (bc == null) {
            try {
                void var3_11;
                void var3_8;
                this.outgoing_connect_sem.reserve();
                buddyPluginBuddy = this;
                // MONITORENTER : buddyPluginBuddy
                if (this.current_message != allocated_message) {
                    BuddyPluginException buddyPluginException = new BuddyPluginException("current message no longer active");
                } else if (this.closing) {
                    // MONITOREXIT : buddyPluginBuddy
                    Object var12_23 = null;
                    this.outgoing_connect_sem.release();
                    return;
                }
                if (var3_8 == null) {
                    for (i = 0; i < this.connections.size(); ++i) {
                        c = this.connections.get(i);
                        if (c.hasFailed()) continue;
                        bc = c;
                    }
                    if (bc == null) {
                        if (this.destroyed) {
                            BuddyPluginException buddyPluginException = new BuddyPluginException("Friend destroyed");
                        } else if (this.connections.size() >= 5) {
                            BuddyPluginException buddyPluginException = new BuddyPluginException("Too many active connections");
                        }
                    }
                }
                // MONITOREXIT : buddyPluginBuddy
                if (bc == null && var3_11 == null) {
                    try {
                        GenericMessageConnection generic_connection = this.outgoingConnection();
                        BuddyPluginBuddy buddyPluginBuddy2 = this;
                        // MONITORENTER : buddyPluginBuddy2
                        if (this.current_message != allocated_message) {
                            BuddyPluginException buddyPluginException = new BuddyPluginException("current message no longer active");
                            generic_connection.close();
                        } else {
                            bc = new buddyConnection(generic_connection, true);
                            inform_dirty = this.connections.size() == 0;
                            this.connections.add(bc);
                        }
                        // MONITOREXIT : buddyPluginBuddy2
                    }
                    catch (Throwable e) {
                        Throwable throwable = e;
                    }
                }
                Object var12_24 = null;
                this.outgoing_connect_sem.release();
            }
            catch (Throwable throwable) {
                Object var12_25 = null;
                this.outgoing_connect_sem.release();
                throw throwable;
            }
        }
        if (var3_15 != null) {
            allocated_message.reportFailed((Throwable)var3_15);
            return;
        }
        try {
            bc.sendMessage(allocated_message);
        }
        catch (BuddyPluginException e) {
            allocated_message.reportFailed(e);
        }
        if (!inform_dirty) return;
        this.plugin.setConfigDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(buddyConnection bc) {
        int size;
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            this.connections.remove(bc);
            size = this.connections.size();
        }
        if (size == 0) {
            this.plugin.setConfigDirty();
        }
        if (size == 0 && bc.isConnected() && !bc.isClosing() && !bc.isRemoteClosing() && this.consec_connect_fails < 3) {
            if (this.consec_connect_fails == 0) {
                long now = SystemTime.getMonotonousTime();
                boolean do_it = false;
                BuddyPluginBuddy buddyPluginBuddy2 = this;
                synchronized (buddyPluginBuddy2) {
                    if (this.last_auto_reconnect == -1L || now - this.last_auto_reconnect > 30000L) {
                        this.last_auto_reconnect = now;
                        do_it = true;
                    }
                }
                if (do_it) {
                    new DelayedEvent("BuddyPluginBuddy:recon", new Random().nextInt(3000), new AERunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void runSupport() {
                            int size;
                            BuddyPluginBuddy buddyPluginBuddy = BuddyPluginBuddy.this;
                            synchronized (buddyPluginBuddy) {
                                size = BuddyPluginBuddy.this.connections.size();
                            }
                            if (BuddyPluginBuddy.this.consec_connect_fails == 0 && size == 0) {
                                BuddyPluginBuddy.this.log("Attempting reconnect after dropped connection");
                                BuddyPluginBuddy.this.sendKeepAlive();
                            }
                        }
                    });
                }
            } else {
                long delay = 60000L;
                if (SystemTime.getCurrentTime() - this.last_connect_attempt >= (delay <<= Math.min(3, this.consec_connect_fails))) {
                    this.sendKeepAlive();
                }
            }
        }
        this.plugin.fireDetailsChanged(this);
        this.dispatchMessage();
    }

    protected long getLastStatusCheckTime() {
        return this.last_status_check_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean statusCheckActive() {
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            return this.check_active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean statusCheckStarts() {
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            if (this.check_active) {
                return false;
            }
            this.last_status_check_time = SystemTime.getCurrentTime();
            this.check_active = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void statusCheckFailed() {
        boolean details_change = false;
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            try {
                if (this.online) {
                    this.online = false;
                    this.consec_connect_fails = 0;
                    details_change = true;
                }
                Object var4_3 = null;
                ++this.status_check_count;
                this.check_active = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ++this.status_check_count;
                this.check_active = false;
                throw throwable;
            }
        }
        if (details_change) {
            this.plugin.fireDetailsChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCachedStatus(InetAddress _ip, int _tcp_port, int _udp_port) {
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            if (this.ip == null) {
                this.ip = _ip;
                this.tcp_port = _tcp_port;
                this.udp_port = _udp_port;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void statusCheckComplete(long _post_time, InetAddress _ip, int _tcp_port, int _udp_port, String _nick_name, int _online_status, int _status_seq, int _version) {
        boolean details_change = false;
        boolean config_dirty = false;
        long now = SystemTime.getCurrentTime();
        if (now < this.last_time_online) {
            this.last_time_online = now;
        }
        boolean is_connected = this.isConnected();
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            block20: {
                try {
                    boolean timed_out;
                    boolean seq_change;
                    if (this.offline_seq_set != null) {
                        if (this.offline_seq_set.contains(new Long(_status_seq))) {
                            Object var19_14 = null;
                            ++this.status_check_count;
                            this.check_active = false;
                            return;
                        }
                        this.offline_seq_set = null;
                    }
                    boolean bl = seq_change = _status_seq != this.last_status_seq;
                    if (seq_change) {
                        this.last_status_seq = _status_seq;
                        this.last_time_online = now;
                        timed_out = false;
                        details_change = true;
                    } else {
                        boolean bl2 = timed_out = now - this.last_time_online >= 1800000L;
                    }
                    if (this.online) {
                        if (timed_out) {
                            this.online = false;
                            this.consec_connect_fails = 0;
                            details_change = true;
                        }
                    } else if (seq_change || !timed_out) {
                        this.online = true;
                        details_change = true;
                    }
                    this.post_time = _post_time;
                    if (!this.addressesEqual(this.ip, _ip) || this.tcp_port != _tcp_port || this.udp_port != _udp_port || this.version < _version) {
                        this.ip = _ip;
                        this.tcp_port = _tcp_port;
                        this.udp_port = _udp_port;
                        if (this.version < _version) {
                            this.version = _version;
                        }
                        details_change = true;
                    }
                    if (!is_connected && this.online_status != _online_status) {
                        this.online_status = _online_status;
                        details_change = true;
                    }
                    if (this.plugin.stringsEqual(this.nick_name, _nick_name)) break block20;
                    this.nick_name = _nick_name;
                    config_dirty = true;
                    details_change = true;
                }
                catch (Throwable throwable) {
                    Object var19_16 = null;
                    ++this.status_check_count;
                    this.check_active = false;
                    throw throwable;
                }
            }
            Object var19_15 = null;
            ++this.status_check_count;
            {
            }
            this.check_active = false;
        }
        if (config_dirty) {
            this.plugin.setConfigDirty();
        }
        if (details_change) {
            if (this.online) {
                this.persistentDispatchPending();
            }
            this.plugin.fireDetailsChanged(this);
        }
        this.plugin.logMessage(this.getString());
    }

    protected boolean addressesEqual(InetAddress ip1, InetAddress ip2) {
        if (ip1 == null && ip2 == null) {
            return true;
        }
        if (ip1 == null || ip2 == null) {
            return false;
        }
        return ip1.equals(ip2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        boolean messages_queued;
        long now = SystemTime.getCurrentTime();
        ArrayList<buddyMessage> failed = null;
        ArrayList<buddyConnection> connections_to_check = null;
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            boolean bl = messages_queued = this.messages.size() > 0;
            if (messages_queued) {
                Iterator<buddyMessage> it = this.messages.iterator();
                while (it.hasNext()) {
                    buddyMessage message = it.next();
                    if (!message.timedOut(now)) continue;
                    it.remove();
                    if (failed == null) {
                        failed = new ArrayList<buddyMessage>();
                    }
                    failed.add(message);
                }
            }
            if (this.connections.size() > 0) {
                connections_to_check = new ArrayList<buddyConnection>(this.connections);
            }
        }
        boolean send_keep_alive = false;
        if (connections_to_check == null) {
            if (this.online && this.ip != null && !messages_queued && this.consec_connect_fails < 3) {
                long delay = 60000L;
                send_keep_alive = now - this.last_connect_attempt >= (delay <<= Math.min(3, this.consec_connect_fails));
            }
        } else {
            for (int i = 0; i < connections_to_check.size(); ++i) {
                buddyConnection connection = (buddyConnection)connections_to_check.get(i);
                boolean closed = connection.checkTimeout(now);
                if (this.ip == null || closed || messages_queued || !connection.isConnected() || connection.isActive() || now - connection.getLastActive(now) <= 60000L) continue;
                send_keep_alive = true;
            }
        }
        if (send_keep_alive) {
            this.sendKeepAlive();
        }
        if (failed != null) {
            for (int i = 0; i < failed.size(); ++i) {
                ((buddyMessage)failed.get(i)).reportFailed(new BuddyPluginTimeoutException("Timeout", false));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendKeepAlive() {
        boolean send_keep_alive = true;
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            if (this.keep_alive_outstanding) {
                send_keep_alive = false;
            } else {
                this.keep_alive_outstanding = true;
            }
        }
        if (send_keep_alive) {
            try {
                HashMap<String, Long> ping_request = new HashMap<String, Long>();
                ping_request.put("type", new Long(1L));
                this.sendMessageSupport(ping_request, 0, 60000, new BuddyPluginBuddyReplyListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void replyReceived(BuddyPluginBuddy from_buddy, Map reply) {
                        BuddyPluginBuddy buddyPluginBuddy = BuddyPluginBuddy.this;
                        synchronized (buddyPluginBuddy) {
                            BuddyPluginBuddy.this.keep_alive_outstanding = false;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void sendFailed(BuddyPluginBuddy to_buddy, BuddyPluginException cause) {
                        BuddyPluginBuddy buddyPluginBuddy = BuddyPluginBuddy.this;
                        synchronized (buddyPluginBuddy) {
                            BuddyPluginBuddy.this.keep_alive_outstanding = false;
                        }
                    }
                });
            }
            catch (Throwable e) {
                BuddyPluginBuddy buddyPluginBuddy2 = this;
                synchronized (buddyPluginBuddy2) {
                    this.keep_alive_outstanding = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectionsString() {
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            String str = "";
            for (int i = 0; i < this.connections.size(); ++i) {
                str = str + (str.length() == 0 ? "" : ",") + this.connections.get(i).getString(true);
            }
            return str;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        ArrayList<buddyConnection> to_disconnect = new ArrayList<buddyConnection>();
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            to_disconnect.addAll(this.connections);
        }
        for (int i = 0; i < to_disconnect.size(); ++i) {
            ((buddyConnection)to_disconnect.get(i)).disconnect();
        }
    }

    protected boolean isClosing() {
        return this.closing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        ArrayList<buddyConnection> to_close = new ArrayList<buddyConnection>();
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            this.destroyed = true;
            to_close.addAll(this.connections);
        }
        for (int i = 0; i < to_close.size(); ++i) {
            ((buddyConnection)to_close.get(i)).close();
        }
    }

    protected void logMessage(String str) {
        this.plugin.logMessage(this.getShortString() + ": " + str);
    }

    protected GenericMessageConnection outgoingConnection() throws BuddyPluginException {
        InetSocketAddress notional_target;
        int udp_port;
        GenericMessageRegistration msg_registration = this.plugin.getMessageRegistration();
        if (msg_registration == null) {
            throw new BuddyPluginException("Messaging system unavailable");
        }
        InetAddress ip = this.getIP();
        if (ip == null) {
            throw new BuddyPluginException("Friend offline (no usable IP address)");
        }
        InetSocketAddress tcp_target = null;
        InetSocketAddress udp_target = null;
        int tcp_port = this.getTCPPort();
        if (tcp_port > 0) {
            tcp_target = new InetSocketAddress(ip, tcp_port);
        }
        if ((udp_port = this.getUDPPort()) > 0) {
            udp_target = new InetSocketAddress(ip, udp_port);
        }
        if ((notional_target = tcp_target) == null) {
            notional_target = udp_target;
        }
        if (notional_target == null) {
            throw new BuddyPluginException("Friend offline (no usable protocols)");
        }
        GenericMessageEndpoint endpoint = msg_registration.createEndpoint(notional_target);
        if (tcp_target != null) {
            endpoint.addTCP(tcp_target);
        }
        if (udp_target != null) {
            endpoint.addUDP(udp_target);
        }
        GenericMessageConnection con = null;
        try {
            this.last_connect_attempt = SystemTime.getCurrentTime();
            con = msg_registration.createConnection(endpoint);
            this.plugin.addRateLimiters(con);
            String reason = "Friend: Outgoing connection establishment";
            SESecurityManager sec_man = this.plugin.getSecurityManager();
            con = sec_man.getSTSConnection(con, sec_man.getPublicKey(1, reason), new SEPublicKeyLocator(){

                public boolean accept(Object context2, SEPublicKey other_key) {
                    String other_key_str = Base32.encode(other_key.encodeRawPublicKey());
                    if (other_key_str.equals(BuddyPluginBuddy.this.public_key)) {
                        BuddyPluginBuddy.this.consec_connect_fails = 0;
                        return true;
                    }
                    BuddyPluginBuddy.this.log(BuddyPluginBuddy.this.getString() + ": connection failed due to pk mismatch");
                    return false;
                }
            }, reason, 2);
            con.connect();
            return con;
        }
        catch (Throwable e) {
            if (con != null) {
                ++this.consec_connect_fails;
                try {
                    con.close();
                }
                catch (Throwable f) {
                    this.log("Failed to close connection", f);
                }
            }
            throw new BuddyPluginException("Failed to send message", e);
        }
    }

    protected void incomingConnection(GenericMessageConnection _connection) throws BuddyPluginException {
        this.addConnection(_connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnection(GenericMessageConnection _connection) throws BuddyPluginException {
        buddyConnection bc = new buddyConnection(_connection, false);
        boolean inform_dirty = false;
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            if (this.destroyed) {
                throw new BuddyPluginException("Friend has been destroyed");
            }
            inform_dirty = this.connections.size() == 0;
            this.connections.add(bc);
        }
        if (inform_dirty) {
            this.plugin.setConfigDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserData(Object key, Object value) {
        Map<Object, Object> map = this.user_data;
        synchronized (map) {
            this.user_data.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getUserData(Object key) {
        Map<Object, Object> map = this.user_data;
        synchronized (map) {
            return this.user_data.get(key);
        }
    }

    protected void log(String str) {
        this.plugin.log(str);
    }

    protected void log(String str, Throwable e) {
        this.plugin.log(str, e);
    }

    public String getString() {
        return "pk=" + this.getShortString() + (this.nick_name == null ? "" : ",nick=" + this.nick_name) + ",ip=" + this.ip + ",tcp=" + this.tcp_port + ",udp=" + this.udp_port + ",online=" + this.online + ",age=" + (SystemTime.getCurrentTime() - this.post_time);
    }

    protected class buddyConnection
    implements fragmentHandlerReceiver {
        private fragmentHandler fragment_handler;
        private int connection_id;
        private boolean outgoing;
        private String dir_str;
        private volatile buddyMessage active_message;
        private volatile boolean connected;
        private volatile boolean closing;
        private volatile boolean remote_closing;
        private volatile boolean failed;
        private long last_active = SystemTime.getCurrentTime();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected buddyConnection(GenericMessageConnection _connection, boolean _outgoing) {
            this.fragment_handler = new fragmentHandler(_connection, this);
            this.outgoing = _outgoing;
            BuddyPluginBuddy buddyPluginBuddy = BuddyPluginBuddy.this;
            synchronized (buddyPluginBuddy) {
                this.connection_id = BuddyPluginBuddy.this.next_connection_id++;
            }
            String string = this.dir_str = this.outgoing ? "Outgoing" : "Incoming";
            if (!this.outgoing) {
                this.connected = true;
                BuddyPluginBuddy.this.buddyConnectionEstablished(false);
            }
            this.fragment_handler.start();
        }

        protected boolean isConnected() {
            return this.connected;
        }

        protected boolean hasFailed() {
            return this.failed;
        }

        protected boolean isOutgoing() {
            return this.outgoing;
        }

        protected long getLastActive(long now) {
            if (now < this.last_active) {
                this.last_active = now;
            }
            return this.last_active;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendMessage(buddyMessage message) throws BuddyPluginException {
            BuddyPluginException failed_error = null;
            buddyMessage msg_to_send = null;
            buddyConnection buddyConnection2 = this;
            synchronized (buddyConnection2) {
                if (BuddyPluginBuddy.this.isClosing()) {
                    throw new BuddyPluginException("Close in progress");
                }
                if (this.active_message != null) {
                    Debug.out("Inconsistent: active message already set");
                    failed_error = new BuddyPluginException("Inconsistent state");
                } else {
                    if (this.failed || this.closing) {
                        throw new BuddyPluginException("Connection failed");
                    }
                    this.active_message = message;
                    if (this.connected) {
                        msg_to_send = this.active_message;
                    }
                }
            }
            if (failed_error != null) {
                this.failed(failed_error);
                throw failed_error;
            }
            if (msg_to_send != null) {
                this.send(msg_to_send);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendCloseMessage(buddyMessage message) {
            boolean ok_to_send;
            buddyConnection buddyConnection2 = this;
            synchronized (buddyConnection2) {
                ok_to_send = this.active_message == null && this.connected && !this.failed && !this.closing;
            }
            if (ok_to_send) {
                this.send(message);
            }
        }

        public boolean isActive() {
            return this.active_message != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connected() {
            buddyMessage msg_to_send = null;
            buddyConnection buddyConnection2 = this;
            synchronized (buddyConnection2) {
                this.last_active = SystemTime.getCurrentTime();
                this.connected = true;
                msg_to_send = this.active_message;
            }
            BuddyPluginBuddy.this.buddyConnectionEstablished(true);
            if (msg_to_send != null) {
                this.send(msg_to_send);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean checkTimeout(long now) {
            buddyMessage bm = null;
            boolean close = false;
            buddyConnection buddyConnection2 = this;
            synchronized (buddyConnection2) {
                if (this.active_message != null && this.active_message.timedOut(now)) {
                    bm = this.active_message;
                    this.active_message = null;
                }
                if (now < this.last_active) {
                    this.last_active = now;
                }
                if (now - this.last_active > 300000L) {
                    close = true;
                }
            }
            if (bm != null) {
                bm.reportFailed(new BuddyPluginTimeoutException("Timeout", true));
            }
            if (close) {
                this.close();
            }
            return close;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void send(buddyMessage msg) {
            Map request2 = msg.getRequest();
            HashMap<String, Object> send_map = new HashMap<String, Object>();
            send_map.put("type", new Long(1L));
            send_map.put("req", request2);
            send_map.put("ss", new Long(msg.getSubsystem()));
            send_map.put("id", new Long(msg.getID()));
            send_map.put("oz", new Long(BuddyPluginBuddy.this.plugin.getOnlineStatus()));
            send_map.put("v", new Long(2L));
            String loc_cat = BuddyPluginBuddy.this.getLocalAuthorisedRSSTagsOrCategoriesAsString();
            if (loc_cat != null) {
                send_map.put("cat", loc_cat);
            }
            try {
                this.fragment_handler.send(send_map, true, true);
                buddyConnection buddyConnection2 = this;
                synchronized (buddyConnection2) {
                    this.last_active = SystemTime.getCurrentTime();
                }
            }
            catch (BuddyPluginException e) {
                try {
                    this.failed(e);
                }
                catch (Throwable f) {
                    Debug.printStackTrace(f);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(Map data_map) {
            block26: {
                buddyConnection buddyConnection2 = this;
                synchronized (buddyConnection2) {
                    this.last_active = SystemTime.getCurrentTime();
                }
                try {
                    buddyMessage bm;
                    byte[] b_rem_cat;
                    Long l_ver;
                    int type = ((Long)data_map.get("type")).intValue();
                    Long l_os = (Long)data_map.get("oz");
                    if (l_os != null) {
                        BuddyPluginBuddy.this.setOnlineStatus(l_os.intValue());
                    }
                    if ((l_ver = (Long)data_map.get("v")) != null) {
                        BuddyPluginBuddy.this.setVersion(l_ver.intValue());
                    }
                    if ((b_rem_cat = (byte[])data_map.get("cat")) == null) {
                        BuddyPluginBuddy.this.setRemoteAuthorisedRSSTagsOrCategories(null);
                    } else {
                        BuddyPluginBuddy.this.setRemoteAuthorisedRSSTagsOrCategories(BuddyPluginBuddy.this.stringToCats(new String(b_rem_cat, "UTF-8")));
                    }
                    if (type == 1) {
                        int reply_type;
                        Map<String, String> reply;
                        Long subsystem = (Long)data_map.get("ss");
                        Map request2 = (Map)data_map.get("req");
                        String error = null;
                        if (request2 == null || subsystem == null) {
                            reply = null;
                        } else {
                            try {
                                reply = BuddyPluginBuddy.this.plugin.requestReceived(BuddyPluginBuddy.this, subsystem.intValue(), request2);
                            }
                            catch (Throwable e) {
                                error = Debug.getNestedExceptionMessage(e);
                                reply = null;
                            }
                        }
                        if (reply == null) {
                            reply_type = 99;
                            reply = new HashMap<String, String>();
                            reply.put("error", error == null ? "No handlers available to process request" : error);
                        } else {
                            reply_type = 2;
                        }
                        HashMap<String, Object> reply_map = new HashMap<String, Object>();
                        reply_map.put("ss", subsystem);
                        reply_map.put("type", new Long(reply_type));
                        reply_map.put("id", data_map.get("id"));
                        reply_map.put("oz", new Long(BuddyPluginBuddy.this.plugin.getOnlineStatus()));
                        String loc_cat = BuddyPluginBuddy.this.getLocalAuthorisedRSSTagsOrCategoriesAsString();
                        if (loc_cat != null) {
                            reply_map.put("cat", loc_cat);
                        }
                        reply_map.put("rep", reply);
                        this.fragment_handler.send(reply_map, false, false);
                        break block26;
                    }
                    if (type != 2 && type != 99) break block26;
                    long id = (Long)data_map.get("id");
                    buddyConnection request2 = this;
                    synchronized (request2) {
                        if (this.active_message != null && (long)this.active_message.getID() == id) {
                            bm = this.active_message;
                            this.active_message = null;
                        } else {
                            bm = null;
                        }
                    }
                    Map reply = (Map)data_map.get("rep");
                    if (bm == null) {
                        BuddyPluginBuddy.this.logMessage("reply discarded as no matching request: " + reply);
                    } else if (type == 99) {
                        bm.setDontRetry();
                        bm.reportFailed(new BuddyPluginException(new String((byte[])reply.get("error"))));
                    } else {
                        bm.reportComplete(reply);
                    }
                }
                catch (Throwable e) {
                    this.failed(e);
                }
            }
        }

        protected void close() {
            this.closing = true;
            this.failed(new BuddyPluginException("Closing"));
        }

        protected boolean isClosing() {
            return this.closing;
        }

        protected void remoteClosing() {
            this.remote_closing = true;
        }

        protected boolean isRemoteClosing() {
            return this.remote_closing;
        }

        protected void disconnect() {
            this.fragment_handler.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Throwable error) {
            buddyMessage bm = null;
            if (!this.connected && this.outgoing) {
                BuddyPluginBuddy.this.consec_connect_fails++;
            }
            buddyConnection buddyConnection2 = this;
            synchronized (buddyConnection2) {
                if (this.failed) {
                    return;
                }
                this.failed = true;
                bm = this.active_message;
                this.active_message = null;
            }
            BuddyPluginBuddy.this.logMessage("Con " + this.getString() + " failed: " + Debug.getNestedExceptionMessage(error));
            try {
                if (!this.closing) {
                    // empty if block
                }
                this.fragment_handler.close();
                Object var6_5 = null;
                BuddyPluginBuddy.this.removeConnection(this);
                if (bm != null) {
                    bm.reportFailed(error);
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                BuddyPluginBuddy.this.removeConnection(this);
                if (bm != null) {
                    bm.reportFailed(error);
                }
                throw throwable;
            }
        }

        protected String getString() {
            return this.getString(false);
        }

        protected String getString(boolean short_form) {
            if (short_form) {
                return this.fragment_handler.getString();
            }
            return "id=" + this.connection_id + ",dir=" + (this.outgoing ? "out" : "in");
        }
    }

    protected class buddyMessage {
        private int message_id;
        private Map request;
        private int subsystem;
        private BuddyPluginBuddyReplyListener listener;
        private int timeout_millis;
        private long queue_time = SystemTime.getCurrentTime();
        private boolean timed_out;
        private int retry_count;
        private boolean complete;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected buddyMessage(int _subsystem, Map _request, int _timeout) {
            BuddyPluginBuddy buddyPluginBuddy = BuddyPluginBuddy.this;
            synchronized (buddyPluginBuddy) {
                this.message_id = BuddyPluginBuddy.this.next_message_id++;
            }
            this.request = _request;
            this.subsystem = _subsystem;
            this.timeout_millis = _timeout;
        }

        protected void setListener(BuddyPluginBuddyReplyListener _listener) {
            this.listener = _listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int getRetryCount() {
            buddyMessage buddyMessage2 = this;
            synchronized (buddyMessage2) {
                return this.retry_count;
            }
        }

        protected void setDontRetry() {
            this.retry_count = 99;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setRetry() {
            buddyMessage buddyMessage2 = this;
            synchronized (buddyMessage2) {
                ++this.retry_count;
                this.complete = false;
                this.timed_out = false;
            }
        }

        protected boolean timedOut(long now) {
            if (this.timed_out) {
                return true;
            }
            if (now < this.queue_time) {
                this.queue_time = now;
                return false;
            }
            this.timed_out = now - this.queue_time >= (long)this.timeout_millis;
            return this.timed_out;
        }

        protected Map getRequest() {
            return this.request;
        }

        protected int getSubsystem() {
            return this.subsystem;
        }

        protected int getID() {
            return this.message_id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reportComplete(Map reply) {
            buddyMessage buddyMessage2 = this;
            synchronized (buddyMessage2) {
                if (this.complete) {
                    return;
                }
                this.complete = true;
            }
            try {
                this.listener.replyReceived(BuddyPluginBuddy.this, reply);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reportFailed(Throwable error) {
            buddyMessage buddyMessage2 = this;
            synchronized (buddyMessage2) {
                if (this.complete) {
                    return;
                }
                this.complete = true;
            }
            try {
                if (error instanceof BuddyPluginException) {
                    this.listener.sendFailed(BuddyPluginBuddy.this, (BuddyPluginException)error);
                } else {
                    this.listener.sendFailed(BuddyPluginBuddy.this, new BuddyPluginException("", error));
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }

        protected String getString() {
            return "id=" + this.message_id + ",ss=" + this.subsystem + (this.retry_count == 0 ? "" : ",retry=" + this.retry_count);
        }
    }

    protected class fragmentHandler
    implements GenericMessageConnectionListener {
        private GenericMessageConnection connection;
        private fragmentHandlerReceiver receiver;
        private int next_fragment_id = 0;
        private fragmentAssembly current_request_frag;
        private fragmentAssembly current_reply_frag;
        private int send_count;
        private int recv_count;

        protected fragmentHandler(GenericMessageConnection _connection, fragmentHandlerReceiver _receiver) {
            this.connection = _connection;
            this.receiver = _receiver;
        }

        public void start() {
            this.connection.addListener(this);
        }

        public void connected(GenericMessageConnection connection) {
            this.receiver.connected();
        }

        public void failed(GenericMessageConnection connection, Throwable error) throws MessageException {
            this.receiver.failed(error);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void send(Map data_map, boolean is_request, boolean record_active) throws BuddyPluginException {
            byte[] data;
            block12: {
                int chunk_num;
                int fragment_id;
                int max_chunk;
                int data_length;
                block11: {
                    try {
                        data = BEncoder.encode(data_map);
                        data_length = data.length;
                        BuddyPluginBuddy.this.plugin.checkMaxMessageSize(data_length);
                        max_chunk = this.connection.getMaximumMessageSize() - 1024;
                        if (data_length > max_chunk) {
                            fragmentHandler fragmentHandler2 = this;
                            synchronized (fragmentHandler2) {
                                fragment_id = this.next_fragment_id++;
                            }
                            chunk_num = 0;
                            break block11;
                        }
                        PooledByteBuffer buffer = BuddyPluginBuddy.this.plugin.getPluginInterface().getUtilities().allocatePooledByteBuffer(data);
                        try {
                            this.connection.send(buffer);
                            buffer = null;
                            Object var18_20 = null;
                            if (buffer != null) {
                                buffer.returnToPool();
                            }
                            break block12;
                        }
                        catch (Throwable throwable) {
                            Object var18_21 = null;
                            if (buffer == null) throw throwable;
                            buffer.returnToPool();
                            throw throwable;
                        }
                    }
                    catch (Throwable e) {
                        throw new BuddyPluginException("Send failed", e);
                    }
                }
                for (int i = 0; i < data_length; ++chunk_num, i += max_chunk) {
                    Object var16_18;
                    int end = Math.min(data_length, i + max_chunk);
                    if (end <= i) continue;
                    byte[] chunk = new byte[end - i];
                    System.arraycopy(data, i, chunk, 0, chunk.length);
                    HashMap<String, Object> chunk_map = new HashMap<String, Object>();
                    chunk_map.put("type", new Long(5L));
                    chunk_map.put("f", new Long(fragment_id));
                    chunk_map.put("l", new Long(data_length));
                    chunk_map.put("c", new Long(max_chunk));
                    chunk_map.put("i", new Long(chunk_num));
                    chunk_map.put("q", new Long(is_request ? 1L : 0L));
                    chunk_map.put("d", chunk);
                    byte[] chunk_data = BEncoder.encode(chunk_map);
                    PooledByteBuffer chunk_buffer = BuddyPluginBuddy.this.plugin.getPluginInterface().getUtilities().allocatePooledByteBuffer(chunk_data);
                    try {
                        this.connection.send(chunk_buffer);
                        chunk_buffer = null;
                        var16_18 = null;
                        if (chunk_buffer == null) continue;
                        chunk_buffer.returnToPool();
                        continue;
                    }
                    catch (Throwable throwable) {
                        var16_18 = null;
                        if (chunk_buffer == null) throw throwable;
                        chunk_buffer.returnToPool();
                        throw throwable;
                    }
                }
            }
            BuddyPluginBuddy.this.buddyMessageSent(data.length, record_active);
            ++this.send_count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(GenericMessageConnection connection, PooledByteBuffer message) throws MessageException {
            try {
                block15: {
                    try {
                        if (this.recv_count >= 4 && !BuddyPluginBuddy.this.isAuthorised()) {
                            throw new MessageException("Too many messages received while in unauthorised state");
                        }
                        byte[] content = message.toByteArray();
                        Map<String, Object> data_map = BDecoder.decode(content);
                        if (((Long)data_map.get("type")).intValue() == 5) {
                            fragmentAssembly assembly;
                            Map<String, Object> chunk_map = data_map;
                            int fragment_id = ((Long)chunk_map.get("f")).intValue();
                            int data_length = ((Long)chunk_map.get("l")).intValue();
                            int chunk_size = ((Long)chunk_map.get("c")).intValue();
                            int chunk_num = ((Long)chunk_map.get("i")).intValue();
                            boolean is_request = ((Long)chunk_map.get("q")).intValue() == 1;
                            byte[] chunk_data = (byte[])chunk_map.get("d");
                            BuddyPluginBuddy.this.plugin.checkMaxMessageSize(data_length);
                            if (is_request) {
                                if (this.current_request_frag == null) {
                                    this.current_request_frag = new fragmentAssembly(fragment_id, data_length, chunk_size);
                                }
                                assembly = this.current_request_frag;
                            } else {
                                if (this.current_reply_frag == null) {
                                    this.current_reply_frag = new fragmentAssembly(fragment_id, data_length, chunk_size);
                                }
                                assembly = this.current_reply_frag;
                            }
                            if (assembly.getID() != fragment_id) {
                                throw new BuddyPluginException("Fragment receive error: concurrent decode not supported");
                            }
                            if (assembly.receive(chunk_num, chunk_data)) {
                                if (is_request) {
                                    this.current_request_frag = null;
                                } else {
                                    this.current_reply_frag = null;
                                }
                                BuddyPluginBuddy.this.buddyMessageReceived(data_length);
                                ++this.recv_count;
                                this.receiver.receive(BDecoder.decode(assembly.getData()));
                            } else {
                                BuddyPluginBuddy.this.buddyMessageFragmentReceived(assembly.getChunksReceived(), assembly.getTotalChunks());
                            }
                            break block15;
                        }
                        BuddyPluginBuddy.this.buddyMessageReceived(content.length);
                        ++this.recv_count;
                        this.receiver.receive(data_map);
                    }
                    catch (Throwable e) {
                        this.receiver.failed(e);
                        Object var14_15 = null;
                        message.returnToPool();
                    }
                }
                Object var14_14 = null;
                message.returnToPool();
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                message.returnToPool();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close() {
            try {
                this.connection.close();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.receiver.failed(new Exception("Connection closed"));
                throw throwable;
            }
        }

        protected String getString() {
            return this.connection.getType();
        }

        protected class fragmentAssembly {
            private int id;
            private byte[] data;
            private int chunk_size;
            private int num_chunks;
            private Set chunks_received = new HashSet();

            protected fragmentAssembly(int _id, int _length, int _chunk_size) {
                this.id = _id;
                this.chunk_size = _chunk_size;
                this.data = new byte[_length];
                this.num_chunks = (_length + this.chunk_size - 1) / this.chunk_size;
            }

            protected int getID() {
                return this.id;
            }

            protected int getChunksReceived() {
                return this.chunks_received.size();
            }

            protected int getTotalChunks() {
                return this.num_chunks;
            }

            protected boolean receive(int chunk_num, byte[] chunk) {
                Integer i = new Integer(chunk_num);
                if (this.chunks_received.contains(i)) {
                    return false;
                }
                this.chunks_received.add(i);
                System.arraycopy(chunk, 0, this.data, chunk_num * this.chunk_size, chunk.length);
                return this.chunks_received.size() == this.num_chunks;
            }

            protected byte[] getData() {
                return this.data;
            }
        }
    }

    static interface fragmentHandlerReceiver {
        public void connected();

        public void receive(Map var1);

        public void failed(Throwable var1);
    }
}

