/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener;

import com.aelitis.azureus.core.util.http.HTTPAuthHelper;
import com.aelitis.azureus.core.util.http.HTTPAuthHelperListener;
import com.aelitis.azureus.ui.swt.browser.BrowserWrapper;
import com.aelitis.azureus.ui.swt.browser.CookiesListener;
import com.aelitis.azureus.ui.swt.browser.listener.ExternalLoginCookieListener;
import com.aelitis.azureus.ui.swt.browser.listener.ExternalLoginListener;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.progress.ProgressWindow;

public class ExternalLoginWindow {
    Display display;
    Shell shell;
    BrowserWrapper browser;
    ExternalLoginListener listener;
    String originalLoginUrl;
    Map cookies = new HashMap();
    Set sniffer_cookies = new HashSet();
    Set js_cookies = new HashSet();
    HTTPAuthHelper sniffer;

    public ExternalLoginWindow(ExternalLoginListener _listener, String name, String _loginUrl, boolean captureMode, String authMode, boolean isMine) {
        this.listener = _listener;
        this.originalLoginUrl = _loginUrl;
        this.shell = ShellFactory.createMainShell(96);
        this.shell.setSize(800, 600);
        Utils.centreWindow(this.shell);
        this.display = this.shell.getDisplay();
        this.shell.setText(MessageText.getString("externalLogin.title"));
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (ExternalLoginWindow.this.sniffer != null) {
                    ExternalLoginWindow.this.sniffer.destroy();
                }
            }
        });
        Label explain = new Label((Composite)this.shell, 64);
        if (captureMode) {
            explain.setText(MessageText.getString("externalLogin.explanation.capture", new String[]{name}));
        } else {
            explain.setText(MessageText.getString("externalLogin.explanation", new String[]{name}));
        }
        this.browser = new BrowserWrapper(Utils.createSafeBrowser((Composite)this.shell, 2048));
        if (this.browser == null) {
            this.shell.dispose();
            return;
        }
        ExternalLoginCookieListener cookieListener = new ExternalLoginCookieListener(new CookiesListener(){

            public void cookiesFound(String cookies) {
                ExternalLoginWindow.this.foundCookies(cookies, true);
            }
        }, this.browser);
        cookieListener.hook();
        Label separator = new Label((Composite)this.shell, 258);
        Button alt_method = null;
        if (isMine) {
            final Button f_alt_method = alt_method = new Button((Composite)this.shell, 32);
            alt_method.setText(MessageText.getString("externalLogin.auth_method_proxy"));
            alt_method.setSelection(authMode == "proxy");
            alt_method.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    ExternalLoginWindow.this.setCaptureMethod(ExternalLoginWindow.this.browser, !f_alt_method.getSelection(), true);
                }
            });
        }
        this.setCaptureMethod(this.browser, authMode == "transparent", true);
        Button cancel = new Button((Composite)this.shell, 8);
        cancel.setText(MessageText.getString("Button.cancel"));
        Button done = new Button((Composite)this.shell, 8);
        done.setText(MessageText.getString("Button.done"));
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (ExternalLoginWindow.this.listener != null) {
                    ExternalLoginWindow.this.listener.canceled(ExternalLoginWindow.this);
                }
                ExternalLoginWindow.this.shell.dispose();
            }
        });
        done.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (ExternalLoginWindow.this.listener != null) {
                    ExternalLoginWindow.this.listener.done(ExternalLoginWindow.this, ExternalLoginWindow.this.cookiesToString());
                }
                ExternalLoginWindow.this.shell.dispose();
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment(0, 5);
        explain.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment((Control)explain, 5);
        data.bottom = new FormAttachment((Control)separator, -5);
        this.browser.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment((Control)cancel, -5);
        separator.setLayoutData((Object)data);
        if (isMine) {
            data = new FormData();
            data.width = 100;
            data.left = new FormAttachment(0, 5);
            data.right = new FormAttachment((Control)cancel, -5);
            data.bottom = new FormAttachment(100, -5);
            alt_method.setLayoutData((Object)data);
        }
        data = new FormData();
        data.width = 100;
        data.right = new FormAttachment((Control)done, -5);
        data.bottom = new FormAttachment(100, -5);
        cancel.setLayoutData((Object)data);
        data = new FormData();
        data.width = 100;
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -5);
        done.setLayoutData((Object)data);
        this.shell.layout();
        this.shell.open();
    }

    protected void setCaptureMethod(final BrowserWrapper browser, boolean transparent, boolean show_progress) {
        if (this.sniffer != null) {
            this.sniffer.destroy();
            this.sniffer = null;
        }
        if (show_progress) {
            final ProgressWindow prog_wind = new ProgressWindow(this.shell, "externalLogin.wait", 2144, 500);
            browser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent arg0) {
                }

                public void completed(ProgressEvent arg0) {
                    if (browser.isDisposed() || browser.getShell().isDisposed()) {
                        return;
                    }
                    browser.removeProgressListener(this);
                    prog_wind.destroy();
                }
            });
        }
        if (transparent) {
            browser.setUrl(this.originalLoginUrl);
        } else {
            try {
                final HTTPAuthHelper this_sniffer = this.sniffer = new HTTPAuthHelper(new URL(this.originalLoginUrl));
                this_sniffer.addListener(new HTTPAuthHelperListener(){

                    public void cookieFound(HTTPAuthHelper helper, String cookie_name, String cookie_value) {
                        if (helper == this_sniffer) {
                            ExternalLoginWindow.this.foundCookies(cookie_name + "=" + cookie_value, false);
                        }
                    }
                });
                this_sniffer.start();
                String str = this.originalLoginUrl.toString();
                int pos = str.indexOf("://");
                str = str.substring(pos + 3);
                pos = str.indexOf("/");
                if (pos != -1) {
                    str = str.substring(pos);
                }
                if (!str.startsWith("/")) {
                    str = "/" + str;
                }
                browser.setUrl("http://localhost:" + this.sniffer.getPort() + str);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void foundCookies(String _cookies, boolean _from_js) {
        String[] x = _cookies.split(";");
        Map map = this.cookies;
        synchronized (map) {
            for (int i = 0; i < x.length; ++i) {
                String cookie = x[i];
                String[] bits = cookie.split("=");
                if (bits.length != 2) continue;
                String name = bits[0];
                String value = bits[1];
                if (_from_js) {
                    this.js_cookies.add(name);
                } else {
                    this.sniffer_cookies.add(name);
                }
                this.cookies.put(name, value);
            }
        }
        if (this.listener != null) {
            this.listener.cookiesFound(this, this.cookiesToString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String cookiesToString() {
        Map map = this.cookies;
        synchronized (map) {
            String res = "";
            for (Map.Entry entry : this.cookies.entrySet()) {
                res = res + (res.length() == 0 ? "" : ";") + entry.getKey() + "=" + entry.getValue();
            }
            return res;
        }
    }

    public boolean proxyCaptureModeRequired() {
        if (this.sniffer_cookies.size() > this.js_cookies.size()) {
            return true;
        }
        return this.sniffer != null && this.sniffer.wasHTTPOnlyCookieDetected();
    }

    public void close() {
        Utils.execSWTThread(new Runnable(){

            public void run() {
                ExternalLoginWindow.this.shell.close();
            }
        });
    }

    public static void main(String[] args) {
        Display display = new Display();
        ExternalLoginWindow slw = new ExternalLoginWindow(new ExternalLoginListener(){

            public void cookiesFound(ExternalLoginWindow window, String cookies) {
                System.out.println("Cookies found: " + cookies);
            }

            public void canceled(ExternalLoginWindow window) {
                System.out.println("Cancelled");
            }

            public void done(ExternalLoginWindow window, String cookies) {
                System.out.println("Done");
            }
        }, "test", "http://www.sf.net/", false, "proxy", true);
        while (!slw.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        System.out.println("Found httponly cookies=" + slw.proxyCaptureModeRequired());
    }
}

