/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.subscriptions;

import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;

public class ColumnSubscriptionName
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellSWTPaintListener,
TableCellMouseListener {
    public static String COLUMN_ID = "name";
    int imageWidth = -1;
    int imageHeight = -1;

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnSubscriptionName(String sTableID) {
        super(COLUMN_ID, -2, 350, sTableID);
        this.setMinWidth(300);
    }

    public void refresh(TableCell cell) {
        String name = null;
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub != null) {
            name = sub.getName();
        }
        if (name == null) {
            name = "";
        }
        if (!cell.setSortValue((Comparable)((Object)name)) && cell.isValid()) {
            return;
        }
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        Rectangle bounds = cell.getBounds();
        ImageLoader imageLoader = ImageLoader.getInstance();
        Image viewImage = imageLoader.getImage("ic_view");
        if (this.imageWidth == -1 || this.imageHeight == -1) {
            this.imageWidth = viewImage.getBounds().width;
            this.imageHeight = viewImage.getBounds().height;
        }
        bounds.width -= this.imageWidth + 5;
        GCStringPrinter.printString(gc, cell.getSortValue().toString(), bounds, true, false, 16384);
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub != null && !sub.isSearchTemplate()) {
            gc.drawImage(viewImage, bounds.x + bounds.width, bounds.y + bounds.height / 2 - this.imageHeight / 2);
        }
        imageLoader.releaseImage("ic_view");
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        Subscription sub;
        TableCell cell;
        int cellWidth;
        if (event2.eventType == 1 && event2.button == 1 && event2.x > (cellWidth = (cell = event2.cell).getWidth()) - this.imageWidth - 5 && event2.x < cellWidth - 5 && (sub = (Subscription)cell.getDataSource()) != null && !sub.isSearchTemplate()) {
            String key = "Subscription_" + ByteFormatter.encodeString(sub.getPublicKey());
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi != null) {
                mdi.showEntryByID(key);
            }
        }
    }
}

