/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.utils;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseListener;

public class ColumnImageClickArea
implements TableCellMouseMoveListener,
TableRowMouseListener {
    private static final boolean DEBUG = false;
    private String imageID;
    private final String columnID;
    private Rectangle area;
    private String id;
    private Image image;
    private Rectangle imageArea;
    private Image imgOnRow;
    private Image imgOver;
    private Image imgOffRow;
    private boolean mouseDownOn;
    private boolean cellContainsMouse;
    private TableRow rowContainingMouse;
    private float scale = 1.0f;
    private String tooltip;
    private boolean isVisible = true;

    public ColumnImageClickArea(String columnID, String id, String imageID) {
        this.columnID = columnID;
        this.id = id;
        this.setImageID(imageID);
    }

    public void setImageID(String imageID) {
        ImageLoader imageLoader = ImageLoader.getInstance();
        if (this.imgOver != null) {
            imageLoader.releaseImage(this.imageID + "-over");
        }
        if (this.imgOnRow != null) {
            imageLoader.releaseImage(this.imageID + "-mouseonrow");
        }
        if (this.imgOffRow != null) {
            imageLoader.releaseImage(this.imageID);
        }
        this.imageID = imageID;
        if (imageID == null) {
            this.imgOffRow = null;
            this.imgOnRow = null;
        } else {
            this.imgOnRow = imageLoader.getImage(imageID + "-mouseonrow");
            this.imgOver = imageLoader.getImage(imageID + "-over");
            this.imgOffRow = imageLoader.getImage(imageID);
            if (!ImageLoader.isRealImage(this.imgOnRow)) {
                this.imgOnRow = this.imgOffRow;
            }
            if (!ImageLoader.isRealImage(this.imgOver)) {
                this.imgOver = this.imgOffRow;
            }
        }
        this.image = null;
    }

    public void addCell(TableCell cell) {
        cell.addListeners(this);
        TableRow row = cell.getTableRow();
        if (row != null) {
            row.addMouseListener(this);
        }
    }

    public Rectangle getArea() {
        if (this.area == null) {
            this.area = new Rectangle(0, 0, 0, 0);
        }
        return this.area;
    }

    public void setArea(Rectangle area) {
        this.area = area;
    }

    public String getId() {
        return this.id;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (!ImageLoader.isRealImage(image)) {
            this.image = null;
            this.imageArea = new Rectangle(0, 0, 0, 0);
        } else {
            this.image = image;
            this.imageArea = image.getBounds();
        }
        if (this.area == null) {
            this.area = new Rectangle(this.imageArea.x, this.imageArea.y, this.imageArea.width, this.imageArea.height);
            return;
        }
        this.area.width = (int)((float)this.imageArea.width * this.scale);
        this.area.height = (int)((float)this.imageArea.height * this.scale);
    }

    public void setPosition(int x, int y) {
        if (this.area == null) {
            this.area = new Rectangle(x, y, 0, 0);
            return;
        }
        this.area.x = x;
        this.area.y = y;
    }

    public void drawImage(TableCell cell, GC gcImage) {
        if (!this.isVisible) {
            return;
        }
        Image image = this.image;
        if (image == null) {
            image = this.cellContainsMouse && ImageLoader.isRealImage(this.imgOver) ? this.imgOver : (this.rowContainingMouse == cell.getTableRow() && ImageLoader.isRealImage(this.imgOnRow) ? this.imgOnRow : this.imgOffRow);
        }
        if (ImageLoader.isRealImage(image)) {
            this.imageArea = image.getBounds();
            Rectangle area = this.getArea();
            area.width = (int)((float)this.imageArea.width * this.scale);
            area.height = (int)((float)this.imageArea.height * this.scale);
            gcImage.drawImage(image, this.imageArea.x, this.imageArea.y, this.imageArea.width, this.imageArea.height, area.x, area.y, area.width, area.height);
        }
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        if (!this.isVisible) {
            return;
        }
        if (event2.eventType == 0) {
            this.mouseDownOn = false;
            Point pt = new Point(event2.x, event2.y);
            this.mouseDownOn = this.getArea().contains(pt);
            TableCellCore cell = (TableCellCore)event2.row.getTableCell(this.columnID);
            if (cell != null) {
                cell.invalidate();
                cell.refreshAsync();
            }
        } else if (event2.eventType == 1 && this.mouseDownOn) {
            this.mouseDownOn = false;
            TableCellMouseEvent mouseEvent = new TableCellMouseEvent();
            mouseEvent.button = event2.button;
            mouseEvent.cell = event2.cell;
            mouseEvent.eventType = 1;
            mouseEvent.keyboardState = event2.keyboardState;
            mouseEvent.skipCoreFunctionality = event2.skipCoreFunctionality;
            mouseEvent.x = event2.x;
            mouseEvent.y = event2.y;
            mouseEvent.data = this;
            ((TableColumnCore)event2.cell.getTableColumn()).invokeCellMouseListeners(mouseEvent);
            ((TableCellCore)event2.cell).invokeMouseListeners(mouseEvent);
        } else if (event2.eventType == 3) {
            boolean contains = this.getArea().contains(event2.x, event2.y);
            this.setContainsMouse(event2.cell, contains);
        } else if (event2.eventType == 5) {
            this.setContainsMouse(event2.cell, false);
        } else if (event2.eventType == 2) {
            event2.skipCoreFunctionality = true;
        }
    }

    public void rowMouseTrigger(TableRowMouseEvent event2) {
        if (!this.isVisible) {
            return;
        }
        if (event2.eventType == 5) {
            if (this.rowContainingMouse == event2.row) {
                this.rowContainingMouse = null;
            }
            this.setContainsMouse(null, false);
            TableCellCore cell = (TableCellCore)event2.row.getTableCell(this.columnID);
            if (cell != null) {
                cell.invalidate();
                cell.refreshAsync();
            }
        } else if (event2.eventType == 4) {
            this.rowContainingMouse = event2.row;
            TableCellCore cell = (TableCellCore)event2.row.getTableCell(this.columnID);
            if (cell != null) {
                cell.invalidate();
                cell.refreshAsync();
            }
        }
    }

    private void setContainsMouse(TableCell cell, boolean contains) {
        if (this.cellContainsMouse != contains) {
            this.cellContainsMouse = contains;
            if (cell != null) {
                TableCellCore cellCore = (TableCellCore)cell;
                cellCore.invalidate();
                cellCore.refreshAsync();
                cellCore.setCursorID(this.cellContainsMouse ? 21 : 0);
                if (this.tooltip != null) {
                    if (this.cellContainsMouse) {
                        cellCore.setToolTip(this.tooltip);
                    } else {
                        Object oldTT = cellCore.getToolTip();
                        if (this.tooltip.equals(oldTT)) {
                            cellCore.setToolTip(null);
                        }
                    }
                }
            }
        }
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.setImage(this.image);
    }

    public Rectangle getImageArea() {
        return new Rectangle(this.imageArea.x, this.imageArea.y, this.imageArea.width, this.imageArea.height);
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }
}

