/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.vuzeactivity;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;

public class ColumnActivityNew
extends CoreTableColumnSWT
implements TableCellSWTPaintListener,
TableCellAddedListener,
TableCellRefreshListener,
TableCellMouseListener {
    public static final String COLUMN_ID = "activityNew";
    private static int WIDTH = 38;
    private static Image imgNew;
    private static Image imgOld;

    public ColumnActivityNew(String tableID) {
        super(COLUMN_ID, tableID);
        this.initializeAsGraphic(WIDTH);
        this.setAlignment(3);
        imgNew = ImageLoader.getInstance().getImage("image.activity.unread");
        imgOld = ImageLoader.getInstance().getImage("image.activity.read");
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        Image img;
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)cell.getDataSource();
        Rectangle cellBounds = cell.getBounds();
        Image image = img = entry.getReadOn() <= 0L ? imgNew : imgOld;
        if (img != null && !img.isDisposed()) {
            Rectangle imgBounds = img.getBounds();
            gc.drawImage(img, cellBounds.x + (cellBounds.width - imgBounds.width) / 2, cellBounds.y + (cellBounds.height - imgBounds.height) / 2);
        }
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    public void refresh(TableCell cell) {
        int sortVal;
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)cell.getDataSource();
        boolean isRead = entry.getReadOn() > 0L;
        int n = sortVal = isRead ? 1 : 0;
        if (cell.setSortValue(sortVal)) {
            cell.invalidate();
        }
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        VuzeActivitiesEntry entry;
        if (event2.eventType == 0 && event2.button == 1 && (entry = (VuzeActivitiesEntry)event2.cell.getDataSource()).canFlipRead()) {
            entry.setRead(!entry.isRead());
            event2.cell.invalidate();
        }
    }
}

