/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.mdi;

import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.swt.mdi.BaseMDI;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.TabbedEntry;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTabFolder;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.PluginUISWTSkinObject;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.views.IViewAlwaysInitialize;

public class TabbedMDI
extends BaseMDI
implements AEDiagnosticsEvidenceGenerator {
    private CTabFolder tabFolder;
    private LinkedList<MdiEntry> select_history = new LinkedList();

    public TabbedMDI() {
        AEDiagnostics.addEvidenceGenerator(this);
    }

    public Object skinObjectCreated(SWTSkinObject skinObject, Object params) {
        super.skinObjectCreated(skinObject, params);
        this.creatMDI();
        try {
            UIFunctionsManager.getUIFunctions().getUIUpdater().addUpdater(this);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return null;
    }

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        UIManager ui_manager = PluginInitializer.getDefaultInterface().getUIManager();
        ui_manager.addUIListener(new UIManagerListener(){

            public void UIDetached(UIInstance instance) {
            }

            public void UIAttached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    final AESemaphore wait_sem = new AESemaphore("TabbedMDI:wait");
                    Utils.execSWTThread(new AERunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void runSupport() {
                            try {
                                try {
                                    TabbedMDI.this.loadCloseables();
                                }
                                catch (Throwable t) {
                                    Debug.out(t);
                                }
                                TabbedMDI.this.setupPluginViews();
                                Object var3_2 = null;
                                wait_sem.release();
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                wait_sem.release();
                                throw throwable;
                            }
                        }
                    });
                    if (!wait_sem.reserve(10000L)) {
                        Debug.out("eh?");
                    }
                }
            }
        });
        return super.skinObjectInitialShow(skinObject, params);
    }

    private void creatMDI() {
        this.tabFolder = this.soMain instanceof SWTSkinObjectTabFolder ? ((SWTSkinObjectTabFolder)this.soMain).getTabFolder() : new CTabFolder((Composite)this.soMain.getControl(), 2240);
        COConfigurationManager.addAndFireParameterListener("GUI_SWT_bFancyTab", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        boolean simple = !COConfigurationManager.getBooleanParameter("GUI_SWT_bFancyTab");
                        TabbedMDI.this.tabFolder.setSimple(simple);
                    }
                });
            }
        });
        Display display = this.tabFolder.getDisplay();
        float[] hsb = this.tabFolder.getBackground().getRGB().getHSB();
        hsb[2] = (float)((double)hsb[2] * (Constants.isOSX ? 0.9 : 0.97));
        this.tabFolder.setBackground(ColorCache.getColor((Device)display, hsb));
        hsb = this.tabFolder.getForeground().getRGB().getHSB();
        hsb[2] = (float)((double)hsb[2] * (Constants.isOSX ? 1.1 : 0.03));
        this.tabFolder.setForeground(ColorCache.getColor((Device)display, hsb));
        this.tabFolder.setSelectionBackground(new Color[]{display.getSystemColor(25), display.getSystemColor(25), display.getSystemColor(22)}, new int[]{10, 90}, true);
        this.tabFolder.setSelectionForeground(display.getSystemColor(24));
        this.tabFolder.setSimple(!COConfigurationManager.getBooleanParameter("GUI_SWT_bFancyTab"));
        this.tabFolder.setMinimumCharacters(25);
        this.tabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TabbedEntry entry = (TabbedEntry)event2.item.getData("TabbedEntry");
                TabbedMDI.this.showEntry(entry);
            }
        });
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event2) {
                MdiEntry next;
                final TabbedEntry entry = (TabbedEntry)event2.item.getData("TabbedEntry");
                if (TabbedMDI.this.select_history.remove(entry) && TabbedMDI.this.select_history.size() > 0 && !(next = (MdiEntry)TabbedMDI.this.select_history.getLast()).isDisposed() && next != entry) {
                    event2.doit = false;
                    TabbedMDI.this.showEntry(next);
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            entry.close(true);
                        }
                    });
                }
            }
        });
        this.tabFolder.getDisplay().addFilter(1, new Listener(){

            public void handleEvent(Event event2) {
                if (TabbedMDI.this.tabFolder.isDisposed()) {
                    return;
                }
                Control focus_control = TabbedMDI.this.tabFolder.getDisplay().getFocusControl();
                if (focus_control != null && focus_control.getShell() != TabbedMDI.this.tabFolder.getShell()) {
                    return;
                }
                int key = event2.character;
                if ((event2.stateMask & SWT.MOD1) != 0 && event2.character <= '\u001a' && event2.character > '\u0000') {
                    key += 96;
                }
                if (key == 27 || event2.keyCode == 0x100000D && event2.stateMask == 262144) {
                    MdiEntry entry = TabbedMDI.this.getCurrentEntry();
                    if (entry != null) {
                        entry.close(false);
                    }
                    event2.doit = false;
                } else if (event2.keyCode == 0x100000F || event2.character == '\t' && (event2.stateMask & 0x40000) != 0) {
                    if ((event2.stateMask & 0x20000) == 0) {
                        event2.doit = false;
                        TabbedMDI.this.selectNextTab(true);
                    } else if (event2.stateMask == 131072) {
                        TabbedMDI.this.selectNextTab(false);
                        event2.doit = false;
                    }
                }
            }
        });
        this.tabFolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TabbedMDI.this.saveCloseables();
            }
        });
    }

    private void selectNextTab(boolean selectNext) {
        if (this.tabFolder == null || this.tabFolder.isDisposed()) {
            return;
        }
        int nextOrPrevious = selectNext ? 1 : -1;
        int index = this.tabFolder.getSelectionIndex() + nextOrPrevious;
        if (index == 0 && selectNext || index == -2 || this.tabFolder.getItemCount() < 2) {
            return;
        }
        if (index == this.tabFolder.getItemCount()) {
            index = 0;
        } else if (index < 0) {
            index = this.tabFolder.getItemCount() - 1;
        }
        CTabItem item = this.tabFolder.getItem(index);
        MdiEntry entry = (MdiEntry)item.getData("TabbedEntry");
        if (entry != null) {
            this.showEntry(entry);
        }
    }

    protected boolean wasEntryLoadedOnce(String id) {
        boolean loadedOnce = COConfigurationManager.getBooleanParameter("tab.once." + id, false);
        return loadedOnce;
    }

    protected void setEntryLoadedOnce(String id) {
        COConfigurationManager.setParameter("tab.once." + id, true);
    }

    public void showEntry(MdiEntry newEntry) {
        MdiEntrySWT oldEntry;
        if (newEntry == null) {
            return;
        }
        this.select_history.remove(newEntry);
        this.select_history.add(newEntry);
        if (this.select_history.size() > 64) {
            this.select_history.removeFirst();
        }
        if (newEntry == (oldEntry = this.currentEntry)) {
            this.triggerSelectionListener(newEntry, newEntry);
            return;
        }
        if (oldEntry != null) {
            oldEntry.hide();
        }
        this.currentEntry = (MdiEntrySWT)newEntry;
        ((BaseMdiEntry)newEntry).show();
        this.triggerSelectionListener(newEntry, oldEntry);
    }

    public void updateUI() {
        MdiEntry currentEntry = this.getCurrentEntry();
        if (currentEntry != null) {
            currentEntry.updateUI();
        }
    }

    private MdiEntry createEntryFromSkinRef(String parentID, String id, String configID, String title, ViewTitleInfo titleInfo, Object params, boolean closeable, int index) {
        MdiEntry oldEntry = this.getEntry(id);
        if (oldEntry != null) {
            return oldEntry;
        }
        TabbedEntry entry = new TabbedEntry(this, this.skin, id);
        entry.setTitle(title);
        entry.setSkinRef(configID, params);
        this.setupNewEntry(entry, id, index);
        return entry;
    }

    public MdiEntry createEntryFromSkinRef(String parentID, String id, String configID, String title, ViewTitleInfo titleInfo, Object params, boolean closeable, String preferedAfterID) {
        return this.createEntryFromSkinRef(parentID, id, configID, title, titleInfo, params, closeable, "".equals(preferedAfterID) ? 0 : -1);
    }

    public MdiEntry createEntryFromEventListener(String parentID, UISWTViewEventListener l, String id, boolean closeable, Object datasource, String preferredAfterID) {
        MdiEntry oldEntry = this.getEntry(id);
        if (oldEntry != null) {
            return oldEntry;
        }
        TabbedEntry entry = new TabbedEntry(this, this.skin, id);
        entry.setDatasource(datasource);
        entry.setPreferredAfterID(preferredAfterID);
        entry.setEventListener(l);
        this.setupNewEntry(entry, id, -1);
        if (l instanceof IViewAlwaysInitialize) {
            entry.build();
        }
        return entry;
    }

    public MdiEntry createEntryFromView(String parentID, UISWTViewCore view, String id, Object datasource, boolean closeable, boolean show, boolean expand) {
        MdiEntry oldEntry;
        int i;
        if (id == null && (i = (id = view.getClass().getName()).lastIndexOf(46)) > 0) {
            id = id.substring(i + 1);
        }
        if ((oldEntry = this.getEntry(id)) != null) {
            if (show) {
                this.showEntry(oldEntry);
            }
            return oldEntry;
        }
        TabbedEntry entry = new TabbedEntry(this, this.skin, id);
        entry.setCoreView(view);
        entry.setDatasource(datasource);
        this.setupNewEntry(entry, id, -1);
        if (view instanceof IViewAlwaysInitialize) {
            entry.build();
        }
        if (show) {
            this.showEntry(entry);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupNewEntry(final TabbedEntry entry, final String id, final int index) {
        Map map = this.mapIdToEntry;
        synchronized (map) {
            this.mapIdToEntry.put(id, entry);
        }
        entry.setCloseable(true);
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                TabbedMDI.this.swt_setupNewEntry(entry, id, index);
            }
        });
    }

    private void swt_setupNewEntry(TabbedEntry entry, String id, int index) {
        if (index < 0 || index >= this.tabFolder.getItemCount()) {
            index = this.tabFolder.getItemCount();
        }
        CTabItem cTabItem = new CTabItem(this.tabFolder, 64, index);
        cTabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TabbedMDI.this.tabFolder.getItemCount() == 0) {
                    TabbedMDI.this.currentEntry = null;
                }
            }
        });
        cTabItem.setData("TabbedEntry", (Object)entry);
        entry.setSwtItem(cTabItem);
    }

    public String getUpdateUIName() {
        String name = "MDI";
        MdiEntry entry = this.getCurrentEntry();
        if (entry != null) {
            name = name + "-" + entry.getId();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        MdiEntrySWT[] entries;
        for (MdiEntrySWT entry : entries = this.getEntriesSWT()) {
            Object var10_9;
            UISWTViewCore view;
            if (entry == null || (view = entry.getCoreView()) instanceof AEDiagnosticsEvidenceGenerator) continue;
            writer.println("TabbedMdi View (No Generator): " + entry.getId());
            try {
                try {
                    writer.indent();
                    writer.println("Parent: " + entry.getParentID());
                    writer.println("Title: " + entry.getTitle());
                }
                catch (Exception e) {
                    var10_9 = null;
                    writer.exdent();
                    continue;
                }
                var10_9 = null;
                writer.exdent();
            }
            catch (Throwable throwable) {
                var10_9 = null;
                writer.exdent();
                throw throwable;
            }
        }
    }

    public MdiEntrySWT getEntryFromSkinObject(PluginUISWTSkinObject pluginSkinObject) {
        if (pluginSkinObject instanceof SWTSkinObject) {
            for (Control control = ((SWTSkinObject)pluginSkinObject).getControl(); control != null && !control.isDisposed(); control = control.getParent()) {
                Object entry = control.getData("BaseMDIEntry");
                if (!(entry instanceof BaseMdiEntry)) continue;
                BaseMdiEntry mdiEntry = (BaseMdiEntry)entry;
                return mdiEntry;
            }
        }
        return null;
    }

    public MdiEntry createHeader(String id, String title, String preferredAfterID) {
        return null;
    }
}

