/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.player;

import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.swt.player.PlayerInstaller;
import com.aelitis.azureus.ui.swt.player.PlayerInstallerListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.views.skin.VuzeMessageBox;
import com.aelitis.azureus.ui.swt.views.skin.VuzeMessageBoxListener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Utils;

public class PlayerInstallWindow
implements PlayerInstallerListener {
    private static final boolean FAKE_DELAY = Constants.IS_CVS_VERSION;
    private VuzeMessageBox box;
    private ProgressBar progressBar;
    private SWTSkinObjectText soProgressText;
    private String progressText;
    private SWTSkinObjectText soInstallPct;
    private PlayerInstaller installer;

    public PlayerInstallWindow(PlayerInstaller installer) {
        this.installer = installer;
        installer.setListener(this);
    }

    public void open() {
        this.box = new VuzeMessageBox("", "", null, 0);
        this.box.setSubTitle(MessageText.getString("dlg.player.install.subtitle"));
        this.box.addResourceBundle(PlayerInstallWindow.class, "com/aelitis/azureus/ui/skin/", "skin3_dlg_register");
        this.box.setIconResource("image.player.dlg.header");
        this.progressText = MessageText.getString("dlg.player.install.description");
        this.box.setListener(new VuzeMessageBoxListener(){

            public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                SWTSkin skin = soExtra.getSkin();
                skin.createSkinObject("dlg.register.install", "dlg.register.install", soExtra);
                SWTSkinObjectContainer soProgressBar = (SWTSkinObjectContainer)skin.getSkinObject("progress-bar");
                if (soProgressBar != null) {
                    PlayerInstallWindow.this.progressBar = new ProgressBar(soProgressBar.getComposite(), 256);
                    PlayerInstallWindow.this.progressBar.setMinimum(0);
                    PlayerInstallWindow.this.progressBar.setMaximum(100);
                    PlayerInstallWindow.this.progressBar.setLayoutData((Object)Utils.getFilledFormData());
                }
                PlayerInstallWindow.this.soInstallPct = (SWTSkinObjectText)skin.getSkinObject("install-pct");
                PlayerInstallWindow.this.soProgressText = (SWTSkinObjectText)skin.getSkinObject("progress-text");
                if (PlayerInstallWindow.this.soProgressText != null && PlayerInstallWindow.this.progressText != null) {
                    PlayerInstallWindow.this.soProgressText.setText(PlayerInstallWindow.this.progressText);
                }
            }
        });
        this.box.open(new UserPrompterResultListener(){

            public void prompterClosed(int result) {
                PlayerInstallWindow.this.installer.setListener(null);
                PlayerInstallWindow.this.installer.cancel();
            }
        });
    }

    public void failed() {
        if (this.box != null) {
            this.box.close(0);
        }
    }

    public void finished() {
        if (this.box != null) {
            this.box.close(0);
        }
    }

    public void progress(final int percent) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                int pct;
                int n = pct = percent == 100 ? 99 : percent;
                if (PlayerInstallWindow.this.soInstallPct != null) {
                    PlayerInstallWindow.this.soInstallPct.setText(MessageText.getString("dlg.auth.install.pct", new String[]{"" + pct}));
                }
                if (PlayerInstallWindow.this.progressBar != null && !PlayerInstallWindow.this.progressBar.isDisposed()) {
                    PlayerInstallWindow.this.progressBar.setSelection(pct);
                }
            }
        });
    }
}

