/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.plugininstall;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.swt.plugininstall.SimplePluginInstallWindow;
import com.aelitis.azureus.ui.swt.plugininstall.SimplePluginInstallerListener;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallationListener;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;

public class SimplePluginInstaller {
    private String plugin_id;
    private UIFunctions.actionListener action_listener;
    private SimplePluginInstallerListener listener;
    private PluginInstaller installer;
    private volatile UpdateCheckInstance instance;
    private boolean completed;
    private boolean cancelled;

    public SimplePluginInstaller(String _plugin_id, String _resource_prefix, final UIFunctions.actionListener _action_listener) {
        this.plugin_id = _plugin_id;
        PluginInterface existing = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID(this.plugin_id);
        if (existing != null) {
            if (existing.getPluginState().isOperational()) {
                _action_listener.actionComplete(true);
            } else {
                _action_listener.actionComplete(new Exception("Plugin is installed but not operational"));
            }
            return;
        }
        this.action_listener = new UIFunctions.actionListener(){
            private boolean informed = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionComplete(Object result) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (this.informed) {
                        return;
                    }
                    this.informed = true;
                }
                _action_listener.actionComplete(result);
            }
        };
        SimplePluginInstallWindow window = new SimplePluginInstallWindow(this, _resource_prefix);
        window.open();
        AEThread2 installerThread = new AEThread2("plugin installer", true){

            public void run() {
                SimplePluginInstaller.this.install();
            }
        };
        installerThread.start();
    }

    public void setListener(SimplePluginInstallerListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        UpdateCheckInstance to_cancel = null;
        SimplePluginInstaller simplePluginInstaller = this;
        synchronized (simplePluginInstaller) {
            if (this.completed) {
                return;
            }
            this.cancelled = true;
            to_cancel = this.instance;
        }
        if (to_cancel != null) {
            to_cancel.cancel();
        }
        this.action_listener.actionComplete(new Exception("Cancelled"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean install() {
        try {
            boolean kill_it;
            this.installer = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInstaller();
            StandardPlugin sp = this.installer.getStandardPlugin(this.plugin_id);
            if (sp == null) {
                throw new Exception("Unknown plugin");
            }
            HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
            properties.put(1, 3);
            properties.put(3, true);
            final AESemaphore sem = new AESemaphore("plugin-install");
            final Object[] result = new Object[]{null};
            this.instance = this.installer.install(new InstallablePlugin[]{sp}, false, properties, new PluginInstallationListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void completed() {
                    SimplePluginInstaller simplePluginInstaller = SimplePluginInstaller.this;
                    synchronized (simplePluginInstaller) {
                        SimplePluginInstaller.this.completed = true;
                    }
                    result[0] = true;
                    if (SimplePluginInstaller.this.listener != null) {
                        SimplePluginInstaller.this.listener.finished();
                    }
                    sem.release();
                }

                public void cancelled() {
                    result[0] = new Exception("Cancelled");
                    if (SimplePluginInstaller.this.listener != null) {
                        SimplePluginInstaller.this.listener.finished();
                    }
                    sem.release();
                }

                public void failed(PluginException e) {
                    result[0] = e;
                    if (SimplePluginInstaller.this.listener != null) {
                        SimplePluginInstaller.this.listener.finished();
                    }
                    sem.release();
                }
            });
            SimplePluginInstaller simplePluginInstaller = this;
            synchronized (simplePluginInstaller) {
                kill_it = this.cancelled;
            }
            if (kill_it) {
                this.instance.cancel();
                this.action_listener.actionComplete(new Exception("Cancelled"));
                return false;
            }
            this.instance.addListener(new UpdateCheckInstanceListener(){

                public void cancelled(UpdateCheckInstance instance) {
                }

                public void complete(UpdateCheckInstance instance) {
                    Update[] updates;
                    for (Update update : updates = instance.getUpdates()) {
                        ResourceDownloader[] rds;
                        for (ResourceDownloader rd : rds = update.getDownloaders()) {
                            rd.addListener(new ResourceDownloaderAdapter(){

                                public void reportActivity(ResourceDownloader downloader, String activity) {
                                }

                                public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
                                    if (SimplePluginInstaller.this.listener != null) {
                                        SimplePluginInstaller.this.listener.progress(percentage);
                                    }
                                }
                            });
                        }
                    }
                }
            });
            sem.reserve();
            this.action_listener.actionComplete(result[0]);
            return result[0] instanceof Boolean;
        }
        catch (Throwable e) {
            if (this.listener != null) {
                this.listener.finished();
            }
            this.action_listener.actionComplete(e);
            return false;
        }
    }
}

