/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.ui.IUIIntializer;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsUserPrompter;
import com.aelitis.azureus.ui.UIStatusTextClickListener;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.common.updater.UIUpdater;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.shells.main.MainHelpers;
import com.aelitis.azureus.ui.swt.shells.main.MainWindow;
import com.aelitis.azureus.ui.swt.shells.main.MainWindowImpl;
import com.aelitis.azureus.ui.swt.uiupdater.UIUpdaterSWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.impl.TorrentOpenOptions;
import org.gudy.azureus2.core3.util.AERunStateHandler;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarManager;
import org.gudy.azureus2.ui.swt.UIExitUtilsSWT;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.IMainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.IMainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.IMainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.minibar.AllTransfersBar;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.systray.SystemTraySWT;

public class MainWindowDelayStub
implements MainWindow {
    private Display display;
    private IUIIntializer initialiser;
    private Shell shell;
    private AzureusCore core;
    private AESemaphore core_sem = new AESemaphore("");
    private volatile MainWindow main_window;
    private SystemTraySWT swt_tray;
    private volatile UIFunctionsSWT delayed_uif = new UIFunctionsSWTImpl();

    public MainWindowDelayStub(AzureusCore _core, Display _display, IUIIntializer _uiInitializer) {
        this.core = _core;
        this.display = _display;
        this.initialiser = _uiInitializer;
        this.init();
        this.core_sem.releaseForever();
    }

    public MainWindowDelayStub(Display _display, IUIIntializer _uiInitializer) {
        this.display = _display;
        this.initialiser = _uiInitializer;
        this.init();
    }

    private void init() {
        final AESemaphore sem = new AESemaphore("shell:create");
        Utils.execSWTThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    MainWindowDelayStub.this.shell = new Shell(MainWindowDelayStub.this.display, 1264);
                    UIFunctionsManagerSWT.setUIFunctions(MainWindowDelayStub.this.delayed_uif);
                    boolean bEnableTray = COConfigurationManager.getBooleanParameter("Enable System Tray");
                    if (bEnableTray) {
                        MainWindowDelayStub.this.swt_tray = SystemTraySWT.getTray();
                    }
                    MainHelpers.initTransferBar();
                    if (MainWindowDelayStub.this.initialiser != null) {
                        MainWindowDelayStub.this.initialiser.initializationComplete();
                        MainWindowDelayStub.this.initialiser.abortProgress();
                    }
                    AERunStateHandler.addListener(new AERunStateHandler.RunStateChangeListener(){
                        private boolean handled = false;

                        public void runStateChanged(long run_state) {
                            if (AERunStateHandler.isDelayedUI() || this.handled) {
                                return;
                            }
                            this.handled = true;
                            MainWindowDelayStub.this.checkMainWindow();
                        }
                    }, false);
                    Object var3_2 = null;
                    sem.release();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    sem.release();
                    throw throwable;
                }
            }
        });
        sem.reserve();
    }

    private void log(String str) {
        Debug.out(str);
    }

    public void init(AzureusCore _core) {
        this.core = _core;
        this.core_sem.releaseForever();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMainWindow() {
        boolean activated = false;
        MainWindowDelayStub mainWindowDelayStub = this;
        synchronized (mainWindowDelayStub) {
            if (this.main_window == null) {
                final AESemaphore wait_sem = new AESemaphore("cmw");
                AzureusCoreLifecycleAdapter listener = new AzureusCoreLifecycleAdapter(){

                    public void componentCreated(AzureusCore core, AzureusCoreComponent component) {
                        if (component instanceof UIFunctions) {
                            wait_sem.release();
                        }
                    }
                };
                this.core.addLifecycleListener(listener);
                this.main_window = new MainWindowImpl(this.core, this.display, null);
                if (!wait_sem.reserve(30000L)) {
                    Debug.out("Gave up waiting for UIFunction component to be created");
                }
                activated = true;
            }
        }
        if (activated) {
            AERunStateHandler.setResourceMode(0L);
        }
    }

    private void fixup(Fixup f) {
        this.core_sem.reserve();
        this.checkMainWindow();
        f.fix(this.main_window);
    }

    private Object fixup(Fixup2 f) {
        this.core_sem.reserve();
        this.checkMainWindow();
        return f.fix(this.main_window);
    }

    private void fixup(Fixup3 f) {
        this.core_sem.reserve();
        this.checkMainWindow();
        UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uif == this.delayed_uif) {
            Debug.out("eh?");
        } else {
            f.fix(uif);
        }
    }

    private Object fixup(Fixup4 f) {
        this.core_sem.reserve();
        this.checkMainWindow();
        UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uif == this.delayed_uif) {
            Debug.out("eh?");
            return null;
        }
        return f.fix(uif);
    }

    public Shell getShell() {
        return this.shell;
    }

    public IMainMenu getMainMenu() {
        return (IMainMenu)this.fixup(new Fixup2(){

            public Object fix(MainWindow mw) {
                return mw.getMainMenu();
            }
        });
    }

    public IMainStatusBar getMainStatusBar() {
        if (this.main_window != null) {
            return this.main_window.getMainStatusBar();
        }
        return null;
    }

    public boolean isReady() {
        this.log("isReady");
        return false;
    }

    public void setVisible(final boolean visible, final boolean tryTricks) {
        this.fixup(new Fixup(){

            public void fix(MainWindow mw) {
                mw.setVisible(visible, tryTricks);
            }
        });
    }

    public UISWTInstanceImpl getUISWTInstanceImpl() {
        this.log("getUISWTInstanceImpl");
        return null;
    }

    public void setSelectedLanguageItem() {
        this.log("setSelectedLanguageItem");
    }

    public boolean dispose(final boolean for_restart, boolean close_already_in_progress) {
        if (this.main_window != null) {
            return this.main_window.dispose(for_restart, close_already_in_progress);
        }
        this.log("dispose");
        UIExitUtilsSWT.uiShutdown();
        if (this.swt_tray != null) {
            this.swt_tray.dispose();
        }
        try {
            AllTransfersBar transfer_bar = AllTransfersBar.getBarIfOpen(this.core.getGlobalManager());
            if (transfer_bar != null) {
                transfer_bar.forceSaveLocation();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!SWTThread.getInstance().isTerminated()) {
            Utils.getOffOfSWTThread(new AERunnable(){

                public void runSupport() {
                    if (!SWTThread.getInstance().isTerminated()) {
                        SWTThread.getInstance().getInitializer().stopIt(for_restart, false);
                    }
                }
            });
        }
        return true;
    }

    public boolean isVisible(int windowElement) {
        this.log("isVisible");
        return false;
    }

    public void setVisible(int windowElement, boolean value) {
        this.log("setVisible");
    }

    public void setHideAll(boolean hide) {
        this.log("setHideAll");
    }

    public Rectangle getMetrics(int windowElement) {
        this.log("getMetrics");
        return null;
    }

    private static interface Fixup {
        public void fix(MainWindow var1);
    }

    private static interface Fixup2 {
        public Object fix(MainWindow var1);
    }

    private static interface Fixup3 {
        public void fix(UIFunctionsSWT var1);
    }

    private static interface Fixup4 {
        public Object fix(UIFunctionsSWT var1);
    }

    private class UIFunctionsSWTImpl
    implements UIFunctionsSWT {
        private UIFunctionsSWTImpl() {
        }

        public void bringToFront() {
            MainWindowDelayStub.this.fixup(new Fixup3(){

                public void fix(UIFunctionsSWT uif) {
                    uif.bringToFront();
                }
            });
        }

        public void bringToFront(final boolean tryTricks) {
            MainWindowDelayStub.this.fixup(new Fixup3(){

                public void fix(UIFunctionsSWT uif) {
                    uif.bringToFront(tryTricks);
                }
            });
        }

        public int getVisibilityState() {
            UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uif != null && uif != this) {
                return uif.getVisibilityState();
            }
            return 1;
        }

        public void runOnUIThread(final int ui_type, final Runnable runnable) {
            MainWindowDelayStub.this.fixup(new Fixup3(){

                public void fix(UIFunctionsSWT uif) {
                    uif.runOnUIThread(ui_type, runnable);
                }
            });
        }

        public void refreshLanguage() {
            MainWindowDelayStub.this.log("refreshLanguage");
        }

        public void refreshIconBar() {
            MainWindowDelayStub.this.log("refreshIconBar");
        }

        public void setStatusText(String string) {
        }

        public void setStatusText(int statustype, String string, UIStatusTextClickListener l) {
            MainWindowDelayStub.this.log("setStatusText");
        }

        public boolean dispose(boolean for_restart, boolean close_already_in_progress) {
            return MainWindowDelayStub.this.dispose(for_restart, close_already_in_progress);
        }

        public boolean viewURL(String url, String target, int w, int h, boolean allowResize, boolean isModal) {
            MainWindowDelayStub.this.log("viewURL");
            return false;
        }

        public boolean viewURL(String url, String target, double wPct, double hPct, boolean allowResize, boolean isModal) {
            MainWindowDelayStub.this.log("viewURL");
            return false;
        }

        public void viewURL(String url, String target, String sourceRef) {
            MainWindowDelayStub.this.log("viewURL");
        }

        public UIFunctionsUserPrompter getUserPrompter(String title, String text, String[] buttons, int defaultOption) {
            MainWindowDelayStub.this.log("getUserPrompter");
            return null;
        }

        public void promptUser(String title, String text, String[] buttons, int defaultOption, String rememberID, String rememberText, boolean bRememberByDefault, int autoCloseInMS, UserPrompterResultListener l) {
            MainWindowDelayStub.this.log("promptUser");
        }

        public UIUpdater getUIUpdater() {
            return UIUpdaterSWT.getInstance();
        }

        public void openView(final int viewID, final Object datasource) {
            MainWindowDelayStub.this.fixup(new Fixup3(){

                public void fix(UIFunctionsSWT uif) {
                    uif.openView(viewID, datasource);
                }
            });
        }

        public void doSearch(String searchText) {
            MainWindowDelayStub.this.log("doSearch");
        }

        public void doSearch(String searchText, boolean toSubscribe) {
            MainWindowDelayStub.this.log("doSearch");
        }

        public void installPlugin(String plugin_id, String resource_prefix, UIFunctions.actionListener listener) {
            MainWindowDelayStub.this.log("installPlugin");
        }

        public void performAction(final int action_id, final Object args, final UIFunctions.actionListener listener) {
            MainWindowDelayStub.this.fixup(new Fixup3(){

                public void fix(UIFunctionsSWT uif) {
                    uif.performAction(action_id, args, listener);
                }
            });
        }

        public MultipleDocumentInterface getMDI() {
            MainWindowDelayStub.this.log("getMDI");
            return null;
        }

        public void forceNotify(int iconID, String title, String text, String details, Object[] relatedObjects, int timeoutSecs) {
            MainWindowDelayStub.this.log("forceNotify");
        }

        public Shell getMainShell() {
            return MainWindowDelayStub.this.shell;
        }

        public void addPluginView(String viewID, UISWTViewEventListener l) {
            MainWindowDelayStub.this.log("addPluginView");
        }

        public void closeDownloadBars() {
        }

        public boolean isGlobalTransferBarShown() {
            if (!AzureusCoreFactory.isCoreRunning()) {
                return false;
            }
            return AllTransfersBar.getManager().isOpen(AzureusCoreFactory.getSingleton().getGlobalManager());
        }

        public void showGlobalTransferBar() {
            AllTransfersBar.open(this.getMainShell());
        }

        public void closeGlobalTransferBar() {
            AllTransfersBar.closeAllTransfersBar();
        }

        public UISWTView[] getPluginViews() {
            MainWindowDelayStub.this.log("getPluginViews");
            return new UISWTView[0];
        }

        public void openPluginView(String sParentID, String sViewID, UISWTViewEventListener l, Object dataSource, boolean bSetFocus) {
            MainWindowDelayStub.this.log("openPluginView");
        }

        public void openPluginView(UISWTViewCore view, String name) {
            MainWindowDelayStub.this.log("openPluginView");
        }

        public void removePluginView(String viewID) {
            MainWindowDelayStub.this.log("removePluginView");
        }

        public void closePluginView(UISWTViewCore view) {
            MainWindowDelayStub.this.log("closePluginView");
        }

        public void closePluginViews(String sViewID) {
            MainWindowDelayStub.this.log("closePluginViews");
        }

        public UISWTInstance getUISWTInstance() {
            MainWindowDelayStub.this.log("getUISWTInstance");
            return null;
        }

        public void refreshTorrentMenu() {
            MainWindowDelayStub.this.log("refreshTorrentMenu");
        }

        public IMainStatusBar getMainStatusBar() {
            return null;
        }

        public IMainMenu createMainMenu(final Shell shell) {
            return (IMainMenu)MainWindowDelayStub.this.fixup(new Fixup4(){

                public Object fix(UIFunctionsSWT uif) {
                    return uif.createMainMenu(shell);
                }
            });
        }

        public IMainWindow getMainWindow() {
            return MainWindowDelayStub.this;
        }

        public void closeAllDetails() {
            MainWindowDelayStub.this.log("closeAllDetails");
        }

        public boolean hasDetailViews() {
            MainWindowDelayStub.this.log("hasDetailViews");
            return false;
        }

        public Shell showCoreWaitDlg() {
            return null;
        }

        public boolean isProgramInstalled(final String extension, final String name) {
            return (Boolean)MainWindowDelayStub.this.fixup(new Fixup4(){

                public Object fix(UIFunctionsSWT uif) {
                    return uif.isProgramInstalled(extension, name);
                }
            });
        }

        public MultipleDocumentInterfaceSWT getMDISWT() {
            MainWindowDelayStub.this.log("getMDISWT");
            return null;
        }

        public void promptForSearch() {
            MainWindowDelayStub.this.log("promptForSearch");
        }

        public UIToolBarManager getToolBarManager() {
            MainWindowDelayStub.this.log("getToolBarManager");
            return null;
        }

        public void openRemotePairingWindow() {
            MainWindowDelayStub.this.log("openRemotePairingWindow");
        }

        public void playOrStreamDataSource(Object ds, String referal, boolean launch_already_checked, boolean complete_only) {
            MainWindowDelayStub.this.log("playOrStreamDataSource");
        }

        public void setHideAll(boolean hidden) {
            MainWindowDelayStub.this.log("setHideAll");
        }

        public void showErrorMessage(String keyPrefix, String details, String[] textParams) {
            MainWindowDelayStub.this.log("showErrorMessage");
        }

        public boolean addTorrentWithOptions(final boolean force, final TorrentOpenOptions torrentOptions) {
            return (Boolean)MainWindowDelayStub.this.fixup(new Fixup4(){

                public Object fix(UIFunctionsSWT uif) {
                    return uif.addTorrentWithOptions(force, torrentOptions);
                }
            });
        }

        public void openTorrentOpenOptions(final Shell shell, final String sPathOfFilesToOpen, final String[] sFilesToOpen, final boolean defaultToStopped, final boolean forceOpen) {
            MainWindowDelayStub.this.fixup(new Fixup3(){

                public void fix(UIFunctionsSWT uif) {
                    uif.openTorrentOpenOptions(shell, sPathOfFilesToOpen, sFilesToOpen, defaultToStopped, forceOpen);
                }
            });
        }

        public void openTorrentWindow() {
            MainWindowDelayStub.this.fixup(new Fixup3(){

                public void fix(UIFunctionsSWT uif) {
                    uif.openTorrentWindow();
                }
            });
        }
    }
}

