/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTBGImagePainter
implements Listener {
    private static boolean DEBUG = false;
    private static boolean TEST_SWT_PAINTING = false;
    private Rectangle lastResizeRect = Utils.EMPTY_RECT;
    private final Shell shell;
    private String imgSrcID;
    private String imgSrcLeftID;
    private String imgSrcRightID;
    private Image imgSrc;
    private Image imgSrcLeft;
    private Image imgSrcRight;
    private Rectangle imgSrcBounds;
    private Rectangle imgSrcLeftBounds;
    private Rectangle imgSrcRightBounds;
    private Image lastImage = null;
    boolean inEvent = false;
    Rectangle lastBounds = Utils.EMPTY_RECT;
    Point lastShellBGSize = new Point(0, 0);
    private final int tileMode;
    private final Control control;
    private boolean bDirty;
    private int fdWidth = -1;
    private int fdHeight = -1;
    private ImageLoader imageLoader = null;

    private SWTBGImagePainter(Control control, int tileMode) {
        this.control = control;
        this.shell = control.getShell();
        this.tileMode = tileMode;
        control.setData("BGPainter", (Object)this);
    }

    public SWTBGImagePainter(Control control, Image bgImage, int tileMode) {
        this(control, null, null, bgImage, tileMode);
    }

    public SWTBGImagePainter(Control control, Image bgImageLeft, Image bgImageRight, Image bgImage, int tileMode) {
        this(control, tileMode);
        this.setImages(bgImageLeft, bgImageRight, bgImage);
        if (this.bDirty && control.isVisible()) {
            this.buildBackground(control);
        }
        if (!TEST_SWT_PAINTING) {
            control.addListener(11, (Listener)this);
            control.addListener(9, (Listener)this);
            control.getShell().addListener(22, (Listener)this);
        }
        control.addListener(12, (Listener)this);
    }

    public SWTBGImagePainter(Control control, ImageLoader imageLoader, String bgImageLeftId, String bgImageRightId, String bgImageId, int tileMode) {
        this(control, tileMode);
        this.setImage(imageLoader, bgImageLeftId, bgImageRightId, bgImageId);
        if (this.bDirty && control.isVisible()) {
            this.buildBackground(control);
        }
        if (!TEST_SWT_PAINTING) {
            control.addListener(11, (Listener)this);
            control.addListener(9, (Listener)this);
            control.getShell().addListener(22, (Listener)this);
        }
        control.addListener(12, (Listener)this);
    }

    public void dispose() {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        if (!TEST_SWT_PAINTING) {
            this.control.removeListener(11, (Listener)this);
            this.control.removeListener(9, (Listener)this);
            this.control.getShell().removeListener(22, (Listener)this);
        }
        this.control.removeListener(12, (Listener)this);
        this.control.setBackgroundImage(null);
        FormData formData = (FormData)this.control.getLayoutData();
        formData.width = -1;
        formData.height = -1;
        this.control.setData("BGPainter", null);
    }

    public void setImage(Image bgImageLeft, Image bgImageRight, Image bgImage) {
        this.setImages(bgImageLeft, bgImageRight, bgImage);
        if (this.bDirty) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (!SWTBGImagePainter.this.control.isVisible()) {
                        return;
                    }
                    SWTBGImagePainter.this.buildBackground(SWTBGImagePainter.this.control);
                }
            });
        }
    }

    public void setImage(ImageLoader imageLoader, String idLeft, String idRight, String id) {
        this.setImages(imageLoader, idLeft, idRight, id);
        if (this.bDirty) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (!SWTBGImagePainter.this.control.isVisible()) {
                        return;
                    }
                    SWTBGImagePainter.this.buildBackground(SWTBGImagePainter.this.control);
                }
            });
        }
    }

    private boolean imagesEqual(Image image1, Image image2) {
        if (image1 == image2) {
            return true;
        }
        return !ImageLoader.isRealImage(image1) && !ImageLoader.isRealImage(image2);
    }

    private void setImages(Image bgImageLeft, Image bgImageRight, Image bgImage) {
        if (this.imagesEqual(this.imgSrc, bgImage) && this.imagesEqual(this.imgSrcLeft, bgImageLeft) && this.imagesEqual(this.imgSrcRight, bgImageRight)) {
            if (DEBUG) {
                System.out.println("same");
            }
            return;
        }
        this.imgSrcLeftID = null;
        this.imgSrcRightID = null;
        this.imgSrcID = null;
        if (DEBUG) {
            System.out.println("SI " + bgImageLeft + ";" + bgImageRight + ";" + bgImage + ";" + this.control.getData("SkinObject") + "/" + this.control.isVisible() + this.control.getSize() + "\\" + Debug.getStackTrace(true, false));
        }
        this.imgSrc = bgImage;
        if (this.imgSrc != null) {
            this.imgSrcBounds = this.imgSrc.getBounds();
        }
        this.lastShellBGSize = new Point(0, 0);
        if (ImageLoader.isRealImage(bgImageLeft)) {
            this.imgSrcLeft = bgImageLeft;
            this.imgSrcLeftBounds = this.imgSrcLeft.getBounds();
        } else {
            this.imgSrcLeft = null;
            this.imgSrcLeftBounds = Utils.EMPTY_RECT;
        }
        if (ImageLoader.isRealImage(bgImageRight)) {
            this.imgSrcRight = bgImageRight;
            this.imgSrcRightBounds = this.imgSrcRight.getBounds();
        } else {
            this.imgSrcRight = null;
            this.imgSrcRightBounds = Utils.EMPTY_RECT;
        }
        if (TEST_SWT_PAINTING) {
            this.control.removeListener(11, (Listener)this);
            this.control.removeListener(9, (Listener)this);
            if (this.imgSrcRight == null && this.imgSrcLeft == null && this.tileMode == 0) {
                this.control.setBackgroundImage(this.imgSrc);
            } else {
                this.control.addListener(11, (Listener)this);
                this.control.addListener(9, (Listener)this);
                this.bDirty = true;
                this.buildBackground(this.control);
            }
        } else {
            this.bDirty = true;
        }
        if ((this.tileMode & 3) != 3) {
            FormData fd;
            int width = -1;
            int height = -1;
            if (this.tileMode == 1 || this.tileMode == 0) {
                width = this.imgSrcBounds.width + this.imgSrcLeftBounds.width + this.imgSrcRightBounds.width;
            }
            if (this.tileMode == 2 || this.tileMode == 0) {
                height = this.imgSrcBounds.height;
            }
            if ((fd = (FormData)this.control.getLayoutData()) == null) {
                fd = new FormData();
            }
            if (fd.width == this.fdWidth || fd.height == this.fdHeight) {
                if (fd.width == this.fdWidth) {
                    this.fdWidth = fd.width = width;
                }
                if (fd.height == this.fdHeight) {
                    this.fdHeight = fd.height = height;
                }
                this.control.setLayoutData((Object)fd);
                if (this.control.isVisible()) {
                    this.bDirty = true;
                    this.control.getParent().layout(true, true);
                }
            }
        }
    }

    public void setImages(ImageLoader imageLoader, String bgImageLeftId, String bgImageRightId, String bgImageId) {
        Image imgSrcLeft;
        this.imageLoader = imageLoader;
        this.imgSrcLeftID = bgImageLeftId;
        this.imgSrcRightID = bgImageRightId;
        this.imgSrcID = bgImageId;
        this.imgSrcLeftBounds = Utils.EMPTY_RECT;
        this.imgSrcRightBounds = Utils.EMPTY_RECT;
        if (this.imgSrcID != null) {
            Image imgSrc = imageLoader.getImage(this.imgSrcID);
            this.imgSrcBounds = imgSrc.getBounds();
            imageLoader.releaseImage(this.imgSrcID);
        }
        if (ImageLoader.isRealImage(imgSrcLeft = imageLoader.getImage(this.imgSrcLeftID))) {
            this.imgSrcLeftBounds = imgSrcLeft.getBounds();
        }
        imageLoader.releaseImage(this.imgSrcLeftID);
        Image imgSrcRight = imageLoader.getImage(this.imgSrcRightID);
        if (ImageLoader.isRealImage(imgSrcRight)) {
            this.imgSrcRightBounds = imgSrcRight.getBounds();
        }
        imageLoader.releaseImage(this.imgSrcRightID);
        if (TEST_SWT_PAINTING) {
            this.control.removeListener(11, (Listener)this);
            this.control.removeListener(9, (Listener)this);
            this.control.addListener(11, (Listener)this);
            this.control.addListener(9, (Listener)this);
            this.bDirty = true;
            this.buildBackground(this.control);
        } else {
            this.bDirty = true;
        }
        if ((this.tileMode & 3) != 3) {
            FormData fd;
            int width = -1;
            int height = -1;
            if (this.tileMode == 1 || this.tileMode == 0) {
                width = this.imgSrcBounds.width + this.imgSrcLeftBounds.width + this.imgSrcRightBounds.width;
            }
            if (this.tileMode == 2 || this.tileMode == 0) {
                height = this.imgSrcBounds.height;
            }
            if ((fd = (FormData)this.control.getLayoutData()) == null) {
                fd = new FormData();
            }
            if (fd.width == this.fdWidth || fd.height == this.fdHeight) {
                if (fd.width == this.fdWidth) {
                    this.fdWidth = fd.width = width;
                }
                if (fd.height == this.fdHeight) {
                    this.fdHeight = fd.height = height;
                }
                this.control.setLayoutData((Object)fd);
                if (this.control.isVisible()) {
                    this.bDirty = true;
                    this.control.getParent().layout(true, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void buildBackground(Control control) {
        ArrayList<String> imagesToRelease;
        block70: {
            block69: {
                block68: {
                    block67: {
                        block66: {
                            Iterator iterator;
                            block65: {
                                if (this.inEvent) return;
                                if (this.shell == null) return;
                                if (this.shell.isDisposed()) return;
                                if (control == null) return;
                                if (control.isDisposed()) {
                                    return;
                                }
                                this.inEvent = true;
                                imagesToRelease = new ArrayList<String>(0);
                                if (this.imgSrcLeftID != null && this.imageLoader.imageExists(this.imgSrcLeftID)) {
                                    imagesToRelease.add(this.imgSrcLeftID);
                                    this.imgSrcLeft = this.imageLoader.getImage(this.imgSrcLeftID);
                                    this.imgSrcLeftBounds = this.imgSrcLeft.getBounds();
                                }
                                if (this.imgSrcRightID != null && this.imageLoader.imageExists(this.imgSrcRightID)) {
                                    imagesToRelease.add(this.imgSrcRightID);
                                    this.imgSrcRight = this.imageLoader.getImage(this.imgSrcRightID);
                                    this.imgSrcRightBounds = this.imgSrcRight.getBounds();
                                }
                                if (this.imgSrcID != null) {
                                    Image[] images = this.imageLoader.getImages(this.imgSrcID);
                                    imagesToRelease.add(this.imgSrcID);
                                    if (images.length == 1) {
                                        this.imgSrc = images[0];
                                        this.imgSrcBounds = this.imgSrc.getBounds();
                                    } else if (images.length == 2) {
                                        this.imgSrcLeft = images[0];
                                        this.imgSrcLeftBounds = this.imgSrcLeft.getBounds();
                                        this.imgSrc = images[1];
                                        this.imgSrcBounds = this.imgSrc.getBounds();
                                        this.imgSrcRight = images[1];
                                        this.imgSrcRightBounds = this.imgSrcRight.getBounds();
                                    } else if (images.length == 3) {
                                        this.imgSrcLeft = images[0];
                                        this.imgSrcLeftBounds = this.imgSrcLeft.getBounds();
                                        this.imgSrc = images[1];
                                        this.imgSrcBounds = this.imgSrc.getBounds();
                                        this.imgSrcRight = images[2];
                                        this.imgSrcRightBounds = this.imgSrcRight.getBounds();
                                    }
                                }
                                try {
                                    Point ofs;
                                    boolean bTileX;
                                    Point size = control.getSize();
                                    if (size.x <= 0 || size.y <= 0 || this.imgSrc == null || this.imgSrc.isDisposed()) {
                                        if (DEBUG) {
                                            System.out.println("- size " + control.getData("ConfigID"));
                                        }
                                        Image image = new Image((Device)this.shell.getDisplay(), 1, 1);
                                        control.setBackgroundImage(image);
                                        if (this.lastImage != null) {
                                            this.lastImage.dispose();
                                        }
                                        this.lastImage = image;
                                        this.imgSrc = image;
                                        this.imgSrcBounds = new Rectangle(0, 0, 1, 1);
                                        this.lastBounds = control.getBounds();
                                        this.inEvent = false;
                                        Object var23_6 = null;
                                        iterator = imagesToRelease.iterator();
                                        break block65;
                                    }
                                    Composite parent = control.getParent();
                                    Image imgBG = parent.getBackgroundImage();
                                    if (imgBG != null && imgBG.isDisposed()) {
                                        imgBG = null;
                                    }
                                    Rectangle imgBGBounds = imgBG == null ? new Rectangle(0, 0, 1, 1) : imgBG.getBounds();
                                    Rectangle compositeArea = control.getBounds();
                                    boolean bTileY = (this.tileMode & 1) > 0;
                                    boolean bl = bTileX = (this.tileMode & 2) > 0;
                                    if (!this.bDirty && imgBG == null && bTileX && bTileY) {
                                        this.inEvent = false;
                                        break block66;
                                    }
                                    if (!this.bDirty && imgBG == null && compositeArea.width == this.lastBounds.width && compositeArea.height == this.lastBounds.height) {
                                        this.inEvent = false;
                                        break block67;
                                    }
                                    if (!this.bDirty && compositeArea.equals((Object)this.lastBounds) && imgBGBounds.width == this.lastShellBGSize.x && imgBGBounds.height == this.lastShellBGSize.y) {
                                        this.inEvent = false;
                                        break block68;
                                    }
                                    if (TEST_SWT_PAINTING && !this.bDirty && compositeArea.width == this.lastBounds.width && compositeArea.height == this.lastBounds.height) {
                                        this.inEvent = false;
                                        break block69;
                                    }
                                    if (DEBUG) {
                                        System.out.println(System.currentTimeMillis() + "@" + Integer.toHexString(this.hashCode()) + "BGPain: " + control.getData("SkinObject") + "/" + "; image" + size + ";" + this.tileMode + ";lB=" + this.lastBounds + "/" + compositeArea + ";" + "lBG=" + this.lastShellBGSize + "/" + imgBGBounds.width + "x" + imgBGBounds.height + ";" + this.bDirty);
                                    }
                                    this.lastBounds = compositeArea;
                                    this.lastShellBGSize = new Point(imgBGBounds.width, imgBGBounds.height);
                                    Image newImage = new Image((Device)this.shell.getDisplay(), size.x, size.y);
                                    if (control.getParent() == this.shell) {
                                        ofs = control.getLocation();
                                        Rectangle clientArea = this.shell.getClientArea();
                                        ofs.x += clientArea.x;
                                        ofs.y += clientArea.y;
                                    } else {
                                        Point controlPos = new Point(0, 0);
                                        if (control instanceof Composite) {
                                            Composite composite = (Composite)control;
                                            Rectangle compArea = composite.getClientArea();
                                            controlPos.x = compArea.x;
                                            controlPos.y = compArea.y;
                                        }
                                        Point locControl = control.toDisplay(controlPos.x, controlPos.y);
                                        Rectangle clientArea = this.shell.getClientArea();
                                        Point locShell = control.getParent().toDisplay(clientArea.x, clientArea.y);
                                        ofs = new Point(locControl.x - locShell.x, locControl.y - locShell.y);
                                    }
                                    ofs.x %= imgBGBounds.width;
                                    ofs.y %= imgBGBounds.height;
                                    GC gc = new GC((Drawable)newImage);
                                    try {
                                        control.setBackgroundImage(null);
                                        gc.setBackground(control.getBackground());
                                        gc.fillRectangle(0, 0, size.x, size.y);
                                        if (imgBG != null) {
                                            for (int y = 0; y < size.y; y += imgBGBounds.height) {
                                                for (int x = 0; x < size.x; x += imgBGBounds.width) {
                                                    gc.drawImage(imgBG, x - ofs.x, y - ofs.y);
                                                }
                                            }
                                        }
                                        int maxY = bTileY ? size.y : this.imgSrcBounds.height;
                                        int maxX = bTileX ? size.x : this.imgSrcBounds.width;
                                        int x0 = 0;
                                        if ((this.tileMode & 4) > 0) {
                                            x0 = (size.x - this.imgSrcBounds.width) / 2;
                                            maxX += x0;
                                        }
                                        int y0 = 0;
                                        if ((this.tileMode & 8) > 0) {
                                            y0 = (size.y - this.imgSrcBounds.height) / 2;
                                            maxY += y0;
                                        }
                                        if (this.imgSrcRight != null) {
                                            int width = this.imgSrcRightBounds.width;
                                            maxX -= width;
                                        }
                                        if (this.imgSrcLeft != null) {
                                            gc.drawImage(this.imgSrcLeft, 0, 0);
                                            x0 += this.imgSrcLeftBounds.width;
                                        }
                                        for (int y = y0; y < maxY; y += this.imgSrcBounds.height) {
                                            for (int x = x0; x < maxX; x += this.imgSrcBounds.width) {
                                                if (x + this.imgSrcBounds.width >= maxX) {
                                                    int width = maxX - x;
                                                    gc.drawImage(this.imgSrc, 0, 0, width, this.imgSrcBounds.height, x, y, width, this.imgSrcBounds.height);
                                                    continue;
                                                }
                                                gc.drawImage(this.imgSrc, x, y);
                                            }
                                        }
                                        if (this.imgSrcRight != null) {
                                            gc.drawImage(this.imgSrcRight, maxX, 0);
                                        }
                                        Object var21_47 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var21_48 = null;
                                        gc.dispose();
                                        throw throwable;
                                    }
                                    gc.dispose();
                                    control.setBackgroundImage(newImage);
                                    if (this.lastImage != null) {
                                        this.lastImage.dispose();
                                    }
                                    this.lastImage = newImage;
                                    this.bDirty = false;
                                    break block70;
                                }
                                catch (Throwable throwable) {
                                    Object var23_12 = null;
                                    for (String key : imagesToRelease) {
                                        this.imageLoader.releaseImage(key);
                                    }
                                    if (this.imgSrcID != null && this.imgSrc != null) {
                                        this.imgSrc = null;
                                    }
                                    if (this.imgSrcLeftID != null && this.imgSrcLeft != null) {
                                        this.imgSrcLeft = null;
                                    }
                                    if (this.imgSrcRightID != null && this.imgSrcRight != null) {
                                        this.imgSrcRight = null;
                                    }
                                    this.inEvent = false;
                                    throw throwable;
                                }
                            }
                            while (iterator.hasNext()) {
                                String key = (String)iterator.next();
                                this.imageLoader.releaseImage(key);
                            }
                            if (this.imgSrcID != null && this.imgSrc != null) {
                                this.imgSrc = null;
                            }
                            if (this.imgSrcLeftID != null && this.imgSrcLeft != null) {
                                this.imgSrcLeft = null;
                            }
                            if (this.imgSrcRightID != null && this.imgSrcRight != null) {
                                this.imgSrcRight = null;
                            }
                            this.inEvent = false;
                            return;
                        }
                        Object var23_7 = null;
                        for (String key : imagesToRelease) {
                            this.imageLoader.releaseImage(key);
                        }
                        if (this.imgSrcID != null && this.imgSrc != null) {
                            this.imgSrc = null;
                        }
                        if (this.imgSrcLeftID != null && this.imgSrcLeft != null) {
                            this.imgSrcLeft = null;
                        }
                        if (this.imgSrcRightID != null && this.imgSrcRight != null) {
                            this.imgSrcRight = null;
                        }
                        this.inEvent = false;
                        return;
                    }
                    Object var23_8 = null;
                    for (String key : imagesToRelease) {
                        this.imageLoader.releaseImage(key);
                    }
                    if (this.imgSrcID != null && this.imgSrc != null) {
                        this.imgSrc = null;
                    }
                    if (this.imgSrcLeftID != null && this.imgSrcLeft != null) {
                        this.imgSrcLeft = null;
                    }
                    if (this.imgSrcRightID != null && this.imgSrcRight != null) {
                        this.imgSrcRight = null;
                    }
                    this.inEvent = false;
                    return;
                }
                Object var23_9 = null;
                for (String key : imagesToRelease) {
                    this.imageLoader.releaseImage(key);
                }
                if (this.imgSrcID != null && this.imgSrc != null) {
                    this.imgSrc = null;
                }
                if (this.imgSrcLeftID != null && this.imgSrcLeft != null) {
                    this.imgSrcLeft = null;
                }
                if (this.imgSrcRightID != null && this.imgSrcRight != null) {
                    this.imgSrcRight = null;
                }
                this.inEvent = false;
                return;
            }
            Object var23_10 = null;
            for (String key : imagesToRelease) {
                this.imageLoader.releaseImage(key);
            }
            if (this.imgSrcID != null && this.imgSrc != null) {
                this.imgSrc = null;
            }
            if (this.imgSrcLeftID != null && this.imgSrcLeft != null) {
                this.imgSrcLeft = null;
            }
            if (this.imgSrcRightID != null && this.imgSrcRight != null) {
                this.imgSrcRight = null;
            }
            this.inEvent = false;
            return;
        }
        Object var23_11 = null;
        for (String key : imagesToRelease) {
            this.imageLoader.releaseImage(key);
        }
        if (this.imgSrcID != null && this.imgSrc != null) {
            this.imgSrc = null;
        }
        if (this.imgSrcLeftID != null && this.imgSrcLeft != null) {
            this.imgSrcLeft = null;
        }
        if (this.imgSrcRightID != null && this.imgSrcRight != null) {
            this.imgSrcRight = null;
        }
        this.inEvent = false;
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display, 2144);
        shell.setLayout((Layout)new FillLayout());
        Composite c = new Composite((Composite)shell, 2048);
        c.setLayout((Layout)new FillLayout());
        c.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawLine(0, 0, 100, 50);
            }
        });
        Label lbl = new Label(c, 0);
        lbl.setText("text");
        shell.open();
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void handleEvent(Event event2) {
        if (event2.type == 11) {
            Control control = (Control)event2.widget;
            Rectangle resizeRect = control.getBounds();
            if (resizeRect.equals((Object)this.lastResizeRect)) {
                return;
            }
            this.lastResizeRect = resizeRect;
            if (DEBUG) {
                System.out.println("BGPaint:HE: " + control.getData("ConfigID") + ";" + event2 + ";" + control.isVisible());
            }
            this.buildBackground(control);
        } else if (event2.type == 9) {
            Control control = (Control)event2.widget;
            if (DEBUG) {
                System.out.println("BGPaint:P: " + control.getData("ConfigID") + ";" + event2 + ";" + control.isVisible());
            }
            if (!TEST_SWT_PAINTING) {
                this.buildBackground(control);
            }
        } else if (event2.type == 22) {
            if (DEBUG) {
                System.out.println("BGPaint:S: " + this.control.getData("ConfigID") + ";" + event2 + ";" + this.control.isVisible());
            }
            if (!TEST_SWT_PAINTING) {
                this.buildBackground(this.control);
            }
        } else if (event2.type == 12) {
            if (DEBUG) {
                System.out.println("dispose.. " + this.lastImage + ";" + this.control.getData("SkinObject"));
            }
            if (this.lastImage != null && !this.lastImage.isDisposed()) {
                this.lastImage.dispose();
                this.lastImage = null;
            }
        }
    }
}

