/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectExpandBar;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinObjectExpandItem
extends SWTSkinObjectContainer
implements ExpandListener {
    private ExpandItem expandItem;
    private boolean expanded;
    private boolean textOverride;
    private Composite composite;
    private boolean fillHeight;

    public SWTSkinObjectExpandItem(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parent) {
        super(skin, properties, null, sID, sConfigID, "expanditem", parent);
        this.createExpandItem();
    }

    private void createExpandItem() {
        if (!(this.parent instanceof SWTSkinObjectExpandBar)) {
            return;
        }
        final SWTSkinObjectExpandBar soExpandBar = (SWTSkinObjectExpandBar)this.parent;
        int style = 0;
        if (this.properties.getIntValue(this.sConfigID + ".border", 0) == 1) {
            style = 2048;
        }
        ExpandBar expandBar = soExpandBar.getExpandbar();
        expandBar.addExpandListener((ExpandListener)this);
        this.expandItem = new ExpandItem(expandBar, style);
        String lastExpandStateID = "ui.skin." + this.sConfigID + ".expanded";
        if (COConfigurationManager.hasParameter(lastExpandStateID, true)) {
            boolean lastExpandState = COConfigurationManager.getBooleanParameter(lastExpandStateID, false);
            this.setExpanded(lastExpandState);
        } else if (this.properties.getBooleanValue(this.sConfigID + ".expanded", false)) {
            this.setExpanded(true);
        }
        this.composite = this.createComposite(soExpandBar.getComposite());
        this.expandItem.setControl((Control)this.composite);
        this.composite.setLayoutData(null);
        this.composite.setData("skin.layedout", (Object)true);
        soExpandBar.addExpandItem(this);
        this.expandItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                soExpandBar.removeExpandItem(SWTSkinObjectExpandItem.this);
            }
        });
        this.composite.addListener(11, new Listener(){
            private Map<Rectangle, Long> resize_history = new HashMap<Rectangle, Long>();

            public void handleEvent(Event event2) {
                Rectangle bounds = SWTSkinObjectExpandItem.this.composite.getBounds();
                long now = SystemTime.getMonotonousTime();
                Long prev = this.resize_history.get(bounds);
                if (prev != null && now - prev < 500L) {
                    return;
                }
                Iterator<Long> it = this.resize_history.values().iterator();
                while (it.hasNext()) {
                    if (now - it.next() < 500L) continue;
                    it.remove();
                }
                this.resize_history.put(bounds, now);
                Utils.execSWTThreadLater(0, new AERunnable(){

                    public void runSupport() {
                        SWTSkinObjectExpandBar soExpandBar = (SWTSkinObjectExpandBar)SWTSkinObjectExpandItem.this.parent;
                        if (!SWTSkinObjectExpandItem.this.expandItem.isDisposed()) {
                            soExpandBar.handleResize(SWTSkinObjectExpandItem.this.expandItem);
                        }
                    }
                });
            }
        });
    }

    public void relayout() {
        super.relayout();
        SWTSkinObjectExpandBar soExpandBar = (SWTSkinObjectExpandBar)this.parent;
        soExpandBar.handleResize(this.expandItem);
    }

    protected void resizeComposite() {
        int newHeight;
        SWTSkinObjectExpandBar soExpandBar = (SWTSkinObjectExpandBar)this.parent;
        ExpandBar expandBar = soExpandBar.getExpandbar();
        if (this.composite.isDisposed()) {
            return;
        }
        if (!this.composite.isVisible()) {
            return;
        }
        Rectangle clientArea = expandBar.getClientArea();
        if (this.properties.getBooleanValue(this.sConfigID + ".fillheight", false)) {
            ExpandItem[] items = expandBar.getItems();
            int h = expandBar.getSpacing();
            for (ExpandItem item : items) {
                h += expandBar.getSpacing();
                int hh = item.getHeaderHeight();
                int ih = item.getHeight();
                if (hh < 0) {
                    hh += item.getHeight();
                } else if (hh > ih) {
                    hh -= ih;
                }
                h += hh;
                if (this.expandItem == item || !item.getExpanded() || !item.getControl().isVisible()) continue;
                h += item.getHeight();
            }
            newHeight = clientArea.height - h;
        } else {
            newHeight = this.composite.computeSize((int)clientArea.width, (int)-1, (boolean)true).y;
            expandBar.computeSize(-1, -1, true);
        }
        if (this.expandItem.getHeight() != newHeight) {
            this.expandItem.setHeight(newHeight);
        }
    }

    public ExpandItem getExpandItem() {
        return this.expandItem;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    private void setExpandedVariable(boolean expand) {
        this.expanded = expand;
        String lastExpandStateID = "ui.skin." + this.sConfigID + ".expanded";
        COConfigurationManager.setParameter(lastExpandStateID, expand);
    }

    public void setExpanded(final boolean expand) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SWTSkinObjectExpandItem.this.expandItem.setExpanded(expand);
                SWTSkinObjectExpandItem.this.setExpandedVariable(expand);
                Utils.execSWTThreadLater(0, new AERunnable(){

                    public void runSupport() {
                        SWTSkinObjectExpandBar soExpandBar = (SWTSkinObjectExpandBar)SWTSkinObjectExpandItem.this.parent;
                        soExpandBar.handleResize(SWTSkinObjectExpandItem.this.expandItem);
                    }
                });
            }
        });
    }

    public void itemCollapsed(ExpandEvent e) {
        if (e.item == this.expandItem) {
            this.setExpandedVariable(false);
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    SWTSkinObjectExpandBar soExpandBar = (SWTSkinObjectExpandBar)SWTSkinObjectExpandItem.this.parent;
                    soExpandBar.handleResize(SWTSkinObjectExpandItem.this.expandItem);
                }
            });
        }
    }

    public void itemExpanded(ExpandEvent e) {
        if (e.item == this.expandItem) {
            this.setExpandedVariable(true);
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    SWTSkinObjectExpandBar soExpandBar = (SWTSkinObjectExpandBar)SWTSkinObjectExpandItem.this.parent;
                    soExpandBar.handleResize(SWTSkinObjectExpandItem.this.expandItem);
                }
            });
        }
    }

    public String switchSuffix(String suffix, int level, boolean walkUp, boolean walkDown) {
        if ((suffix = super.switchSuffix(suffix, level, walkUp, walkDown)) == null) {
            return null;
        }
        String sPrefix = this.sConfigID + ".text";
        String text = this.properties.getStringValue(sPrefix + suffix);
        if (text != null) {
            this.setText(text, true);
        }
        this.fillHeight = this.properties.getBooleanValue(this.sConfigID + ".fillheight", false);
        return suffix;
    }

    public void setText(String text) {
        this.setText(text, false);
    }

    private void setText(final String text, boolean auto) {
        if (!auto) {
            this.textOverride = true;
        } else if (this.textOverride) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (SWTSkinObjectExpandItem.this.expandItem != null && !SWTSkinObjectExpandItem.this.expandItem.isDisposed()) {
                    if (Constants.isWindows) {
                        SWTSkinObjectExpandItem.this.expandItem.setText(text.replaceAll("&", "&&"));
                    } else {
                        SWTSkinObjectExpandItem.this.expandItem.setText(text);
                    }
                }
            }
        });
    }

    public boolean fillsHeight() {
        return this.fillHeight;
    }

    public void dispose() {
        SWTSkinObjectExpandBar soExpandBar;
        ExpandBar expandbar;
        super.dispose();
        if (this.parent instanceof SWTSkinObjectExpandBar && (expandbar = (soExpandBar = (SWTSkinObjectExpandBar)this.parent).getExpandbar()) != null && !expandbar.isDisposed()) {
            expandbar.removeExpandListener((ExpandListener)this);
        }
    }
}

