/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionListener;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.BrowserWrapper;
import com.aelitis.azureus.ui.swt.browser.CookiesListener;
import com.aelitis.azureus.ui.swt.browser.OpenCloseSearchDetailsListener;
import com.aelitis.azureus.ui.swt.browser.listener.ConfigListener;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.browser.listener.ExternalLoginCookieListener;
import com.aelitis.azureus.ui.swt.browser.listener.MetaSearchListener;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import com.aelitis.azureus.ui.swt.browser.listener.VuzeListener;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionMDIEntry;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionManagerUI;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionsViewBase;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableObject;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionViewInternal
implements SubscriptionsViewBase,
OpenCloseSearchDetailsListener,
UIPluginViewToolBarListener {
    private static boolean subscription_proxy_init_done;
    private static AEProxyFactory.PluginHTTPProxy subscription_proxy;
    private static boolean subscription_proxy_set;
    private static AESemaphore subscription_proxy_sem;
    private static List<SubscriptionViewInternal> pending;
    private Subscription subs;
    private Composite parent_composite;
    private Composite composite;
    private BrowserWrapper mainBrowser;
    private BrowserContext mainBrowserContext;
    private BrowserWrapper detailsBrowser;
    private SubscriptionMDIEntry mdiInfo;
    private UISWTView swtView;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initProxy() {
        Class<SubscriptionViewInternal> clazz = SubscriptionViewInternal.class;
        synchronized (SubscriptionViewInternal.class) {
            if (subscription_proxy_init_done) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            subscription_proxy_init_done = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            new AEThread2("ST_test"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ArrayList to_redo2;
                    try {
                        String test_url = ConstantsVuze.getDefaultContentNetwork().getSubscriptionURL("derp");
                        try {
                            boolean use_proxy;
                            URL url = new URL(test_url);
                            url = UrlUtils.setProtocol(url, "https");
                            url = UrlUtils.setPort(url, 443);
                            boolean bl = use_proxy = !COConfigurationManager.getStringParameter("browser.internal.proxy.id", "none").equals("none");
                            if (!use_proxy) {
                                Boolean looks_ok = AEProxyFactory.testPluginHTTPProxy(url, true);
                                boolean bl2 = use_proxy = looks_ok != null && looks_ok == false;
                            }
                            if (use_proxy) {
                                subscription_proxy = AEProxyFactory.getPluginHTTPProxy("subscriptions", url, true);
                                if (subscription_proxy != null) {
                                    UrlFilter.getInstance().addUrlWhitelist("https?://" + ((InetSocketAddress)subscription_proxy.getProxy().address()).getAddress().getHostAddress() + ":?[0-9]*/.*");
                                }
                            }
                        }
                        catch (Throwable throwable) {
                        }
                        Object var6_6 = null;
                        to_redo2 = null;
                        Class<SubscriptionViewInternal> clazz = SubscriptionViewInternal.class;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        ArrayList to_redo2 = null;
                        Class<SubscriptionViewInternal> clazz = SubscriptionViewInternal.class;
                        synchronized (SubscriptionViewInternal.class) {
                            subscription_proxy_set = true;
                            to_redo2 = new ArrayList(pending);
                            pending.clear();
                            // ** MonitorExit[var8_11] (shouldn't be in output)
                            subscription_proxy_sem.releaseForever();
                            for (SubscriptionViewInternal view : to_redo2) {
                                try {
                                    view.mainBrowserContext.setAutoReloadPending(false, subscription_proxy == null);
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                                if (subscription_proxy == null) continue;
                                try {
                                    view.updateBrowserProxy(subscription_proxy);
                                }
                                catch (Throwable e) {}
                            }
                            throw throwable;
                        }
                    }
                    synchronized (SubscriptionViewInternal.class) {
                        subscription_proxy_set = true;
                        to_redo2 = new ArrayList(pending);
                        pending.clear();
                        // ** MonitorExit[var8_10] (shouldn't be in output)
                        subscription_proxy_sem.releaseForever();
                        for (SubscriptionViewInternal view : to_redo2) {
                            try {
                                view.mainBrowserContext.setAutoReloadPending(false, subscription_proxy == null);
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            if (subscription_proxy == null) continue;
                            try {
                                view.updateBrowserProxy(subscription_proxy);
                            }
                            catch (Throwable e) {}
                        }
                    }
                    {
                        return;
                    }
                }
            }.start();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AEProxyFactory.PluginHTTPProxy getSubscriptionProxy(SubscriptionViewInternal view) {
        SubscriptionViewInternal.initProxy();
        boolean force_proxy = !COConfigurationManager.getStringParameter("browser.internal.proxy.id", "none").equals("none");
        subscription_proxy_sem.reserve(force_proxy ? 60000L : 2500L);
        Class<SubscriptionViewInternal> clazz = SubscriptionViewInternal.class;
        synchronized (SubscriptionViewInternal.class) {
            if (subscription_proxy_set) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return subscription_proxy;
            }
            pending.add(view);
            try {
                view.mainBrowserContext.setAutoReloadPending(true, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }

    @Override
    public void refreshView() {
        UISWTViewEventListener eventListener;
        MdiEntrySWT entry;
        if (this.subs == null) {
            return;
        }
        String key = "Subscription_" + ByteFormatter.encodeString(this.subs.getPublicKey());
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null && (entry = mdi.getEntrySWT(key)) != null && (eventListener = entry.getEventListener()) instanceof SubscriptionViewInternal) {
            SubscriptionViewInternal subsView = (SubscriptionViewInternal)eventListener;
            subsView.updateBrowser(false);
        }
    }

    private void initialize(Composite _parent_composite) {
        this.parent_composite = _parent_composite;
        this.composite = new Composite(this.parent_composite, 0);
        this.composite.setLayout((Layout)new FormLayout());
        this.subs.addListener(new SubscriptionListener(){

            public void subscriptionChanged(Subscription subs) {
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        SubscriptionViewInternal.this.updateInfo();
                    }
                });
            }

            public void subscriptionDownloaded(Subscription subs, boolean auto) {
                if (auto) {
                    SubscriptionViewInternal.this.updateBrowser(true);
                }
            }
        });
        this.updateInfo();
    }

    protected void createBrowsers() {
        if (this.mainBrowser != null && !this.mainBrowser.isDisposed()) {
            return;
        }
        try {
            this.mainBrowser = new BrowserWrapper(this.composite, Utils.getInitialBrowserStyle(0));
            this.mainBrowser.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ((Browser)e.widget).setUrl("about:blank");
                    ((Browser)e.widget).setVisible(false);
                }
            });
            this.mainBrowserContext = new BrowserContext("browser-window" + Math.random(), this.mainBrowser, null, true);
            this.mainBrowserContext.addListener(new BrowserContext.loadingListener(){

                public void browserLoadingChanged(boolean loading, String url) {
                    if (((SubscriptionViewInternal)SubscriptionViewInternal.this).mdiInfo.spinnerImage != null) {
                        ((SubscriptionViewInternal)SubscriptionViewInternal.this).mdiInfo.spinnerImage.setVisible(loading);
                    }
                }
            });
            this.mainBrowserContext.addMessageListener(new TorrentListener());
            this.mainBrowserContext.addMessageListener(new VuzeListener());
            this.mainBrowserContext.addMessageListener(new DisplayListener(this.mainBrowser));
            this.mainBrowserContext.addMessageListener(new ConfigListener(this.mainBrowser));
            this.mainBrowserContext.addMessageListener(new MetaSearchListener(this));
            ContentNetwork contentNetwork = ContentNetworkManagerFactory.getSingleton().getContentNetwork(this.mainBrowserContext.getContentNetworkID());
            String url = contentNetwork.getSubscriptionURL(this.subs.getID());
            Boolean edit_mode = (Boolean)this.subs.getUserData(SubscriptionManagerUI.SUB_EDIT_MODE_KEY);
            if (edit_mode != null) {
                if (edit_mode.booleanValue()) {
                    url = url + "&editMode=1";
                }
                this.subs.setUserData(SubscriptionManagerUI.SUB_EDIT_MODE_KEY, null);
            }
            this.mainBrowser.setData("StartURL", url);
            AEProxyFactory.PluginHTTPProxy proxy = SubscriptionViewInternal.getSubscriptionProxy(this);
            if (proxy != null) {
                url = proxy.proxifyURL(url);
                this.mainBrowser.setData("StartURL", url);
            }
            this.mainBrowser.setUrl(url);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment((Control)this.composite, 0);
            data.bottom = new FormAttachment(100, 0);
            this.mainBrowser.setLayoutData(data);
            this.detailsBrowser = new BrowserWrapper(this.composite, Utils.getInitialBrowserStyle(0));
            this.detailsBrowser.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ((Browser)e.widget).setUrl("about:blank");
                    ((Browser)e.widget).setVisible(false);
                }
            });
            BrowserContext detailsContext = new BrowserContext("browser-window" + Math.random(), this.detailsBrowser, null, false);
            detailsContext.addListener(new BrowserContext.loadingListener(){

                public void browserLoadingChanged(boolean loading, String url) {
                    if (((SubscriptionViewInternal)SubscriptionViewInternal.this).mdiInfo.spinnerImage != null) {
                        ((SubscriptionViewInternal)SubscriptionViewInternal.this).mdiInfo.spinnerImage.setVisible(loading);
                    }
                }
            });
            ClientMessageContext.torrentURLHandler url_handler = new ClientMessageContext.torrentURLHandler(){

                public void handleTorrentURL(final String url) {
                    Utils.execSWTThreadWithObject("SMUI", new AERunnableObject(){

                        public Object runSupport() {
                            Subscription subs;
                            String subscriptionId = (String)SubscriptionViewInternal.this.detailsBrowser.getData("subscription_id");
                            String subscriptionResultId = (String)SubscriptionViewInternal.this.detailsBrowser.getData("subscription_result_id");
                            if (subscriptionId != null && subscriptionResultId != null && (subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(subscriptionId)) != null) {
                                subs.addPotentialAssociation(subscriptionResultId, url);
                            }
                            return null;
                        }
                    }, 10000L);
                }
            };
            detailsContext.setTorrentURLHandler(url_handler);
            TorrentListener torrent_listener = new TorrentListener();
            torrent_listener.setTorrentURLHandler(url_handler);
            detailsContext.addMessageListener(torrent_listener);
            detailsContext.addMessageListener(new VuzeListener());
            detailsContext.addMessageListener(new DisplayListener(this.detailsBrowser));
            detailsContext.addMessageListener(new ConfigListener(this.detailsBrowser));
            url = "about:blank";
            this.detailsBrowser.setUrl(url);
            this.detailsBrowser.setData("StartURL", url);
            ExternalLoginCookieListener cookieListener = new ExternalLoginCookieListener(new CookiesListener(){

                public void cookiesFound(String cookies) {
                    if (SubscriptionViewInternal.this.detailsBrowser != null) {
                        SubscriptionViewInternal.this.detailsBrowser.setData("current-cookies", cookies);
                    }
                }
            }, this.detailsBrowser);
            cookieListener.hook();
            data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment((Control)this.mainBrowser.getBrowser(), 0);
            data.bottom = new FormAttachment(100, 0);
            this.detailsBrowser.setLayoutData(data);
            this.mainBrowser.setVisible(true);
            this.detailsBrowser.setVisible(false);
            this.mainBrowser.getParent().layout(true, true);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        list.put("share", 1L);
        list.put("remove", 1L);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if (item.getID().equals("remove")) {
            this.mdiInfo.removeWithConfirm();
        }
        return false;
    }

    protected void destroyBrowsers() {
        if (this.mainBrowser != null) {
            this.mainBrowser.dispose();
            this.mainBrowser = null;
        }
        if (this.detailsBrowser != null) {
            this.detailsBrowser.dispose();
            this.detailsBrowser = null;
        }
    }

    @Override
    public void closeSearchResults(Map params) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SubscriptionViewInternal.this.detailsBrowser.setVisible(false);
                FormData gd = (FormData)SubscriptionViewInternal.this.mainBrowser.getLayoutData();
                gd.bottom = new FormAttachment(100, 0);
                SubscriptionViewInternal.this.mainBrowser.setLayoutData(gd);
                SubscriptionViewInternal.this.mainBrowser.getParent().layout(true);
                SubscriptionViewInternal.this.detailsBrowser.setUrl("about:blank");
            }
        });
    }

    @Override
    public void openSearchResults(final Map params) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                String listenerAdded;
                String url = MapUtils.getMapString(params, "url", "http://google.com/search?q=" + Math.random());
                if (UrlFilter.getInstance().urlCanRPC(url)) {
                    url = ConstantsVuze.getDefaultContentNetwork().appendURLSuffix(url, false, true);
                }
                if ((listenerAdded = (String)SubscriptionViewInternal.this.detailsBrowser.getData("g.nt.la")) == null) {
                    final BrowserWrapper browser = SubscriptionViewInternal.this.detailsBrowser;
                    SubscriptionViewInternal.this.detailsBrowser.setData("g.nt.la", "");
                    SubscriptionViewInternal.this.detailsBrowser.addProgressListener(new ProgressListener(){

                        public void changed(ProgressEvent event2) {
                        }

                        public void completed(ProgressEvent event2) {
                            String execAfterLoad = (String)browser.getData("execAfterLoad");
                            browser.setData("execAfterLoad", null);
                            if (execAfterLoad != null && !execAfterLoad.equals("")) {
                                boolean bl = browser.execute(execAfterLoad);
                            }
                        }
                    });
                }
                String execAfterLoad = MapUtils.getMapString(params, "execAfterLoad", null);
                SubscriptionViewInternal.this.detailsBrowser.setData("execAfterLoad", execAfterLoad);
                SubscriptionViewInternal.this.detailsBrowser.setData("subscription_id", MapUtils.getMapString(params, "subs_id", null));
                SubscriptionViewInternal.this.detailsBrowser.setData("subscription_result_id", MapUtils.getMapString(params, "subs_rid", null));
                SubscriptionViewInternal.this.detailsBrowser.setUrl(url);
                SubscriptionViewInternal.this.detailsBrowser.setData("StartURL", url);
                SubscriptionViewInternal.this.detailsBrowser.setVisible(true);
                FormData data = (FormData)SubscriptionViewInternal.this.mainBrowser.getLayoutData();
                data.bottom = null;
                data.height = MapUtils.getMapInt(params, "top-height", 120);
                SubscriptionViewInternal.this.mainBrowser.getParent().layout(true, true);
            }
        });
    }

    private void updateBrowserProxy(final AEProxyFactory.PluginHTTPProxy proxy) {
        Utils.execSWTThread(new Runnable(){

            public void run() {
                String url;
                if (SubscriptionViewInternal.this.mainBrowser != null && !SubscriptionViewInternal.this.mainBrowser.isDisposed() && SubscriptionViewInternal.this.mainBrowser.isVisible() && (url = (String)SubscriptionViewInternal.this.mainBrowser.getData("StartURL")) != null) {
                    url = proxy.proxifyURL(url);
                    SubscriptionViewInternal.this.mainBrowser.setData("StartURL", url);
                    SubscriptionViewInternal.this.mainBrowser.setUrl(url);
                }
            }
        });
    }

    @Override
    public void updateBrowser(final boolean is_auto) {
        if (this.mainBrowser != null && !this.mainBrowser.isDisposed()) {
            Utils.execSWTThread(new Runnable(){

                public void run() {
                    if (SubscriptionViewInternal.this.mainBrowser != null && !SubscriptionViewInternal.this.mainBrowser.isDisposed() && SubscriptionViewInternal.this.mainBrowser.isVisible()) {
                        String url = (String)SubscriptionViewInternal.this.mainBrowser.getData("StartURL");
                        if (is_auto && url.endsWith("&editMode=1")) {
                            url = url.substring(0, url.lastIndexOf("&editMode=1"));
                            SubscriptionViewInternal.this.mainBrowser.setData("StartURL", url);
                        }
                        SubscriptionViewInternal.this.mainBrowser.setUrl(url);
                    }
                }
            });
        }
    }

    protected void updateInfo() {
    }

    private Composite getComposite() {
        return this.composite;
    }

    private String getFullTitle() {
        if (this.subs == null) {
            return "";
        }
        return this.subs.getName();
    }

    @Override
    public void resizeMainBrowser() {
        if (this.mainBrowser != null) {
            Utils.execSWTThreadLater(0, new Runnable(){

                public void run() {
                    if (SubscriptionViewInternal.this.mainBrowser != null && !SubscriptionViewInternal.this.mainBrowser.isDisposed() && SubscriptionViewInternal.this.mainBrowser.isVisible()) {
                        FormData data = (FormData)SubscriptionViewInternal.this.mainBrowser.getLayoutData();
                        data.bottom = new FormAttachment(100, -1);
                        SubscriptionViewInternal.this.mainBrowser.getParent().layout(true);
                        Utils.execSWTThreadLater(0, new Runnable(){

                            public void run() {
                                if (SubscriptionViewInternal.this.mainBrowser != null && !SubscriptionViewInternal.this.mainBrowser.isDisposed() && SubscriptionViewInternal.this.mainBrowser.isVisible()) {
                                    FormData data = (FormData)SubscriptionViewInternal.this.mainBrowser.getLayoutData();
                                    data.bottom = new FormAttachment(100, 0);
                                    SubscriptionViewInternal.this.mainBrowser.getParent().layout(true);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    public void resizeSecondaryBrowser() {
    }

    private void viewActivated() {
        if (this.subs != null && this.mdiInfo == null) {
            this.mdiInfo = (SubscriptionMDIEntry)this.subs.getUserData(SubscriptionManagerUI.SUB_ENTRYINFO_KEY);
        }
        this.createBrowsers();
    }

    private void viewDeactivated() {
        if (this.mdiInfo != null && this.mdiInfo.spinnerImage != null) {
            this.mdiInfo.spinnerImage.setVisible(false);
        }
        this.destroyBrowsers();
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                this.viewActivated();
                break;
            }
            case 4: {
                this.viewDeactivated();
                break;
            }
        }
        return true;
    }

    private void dataSourceChanged(Object data) {
        if (data instanceof Subscription) {
            this.subs = (Subscription)data;
            this.mdiInfo = (SubscriptionMDIEntry)this.subs.getUserData(SubscriptionManagerUI.SUB_ENTRYINFO_KEY);
        }
        if (this.subs != null && this.swtView != null) {
            this.swtView.setTitle(this.getFullTitle());
        }
    }

    static {
        subscription_proxy_sem = new AESemaphore("sps");
        pending = new ArrayList<SubscriptionViewInternal>();
        COConfigurationManager.addParameterListener("browser.internal.proxy.id", new ParameterListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void parameterChanged(String parameterName) {
                Class<SubscriptionViewInternal> clazz = SubscriptionViewInternal.class;
                synchronized (SubscriptionViewInternal.class) {
                    if (!subscription_proxy_init_done) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    subscription_proxy_init_done = false;
                    subscription_proxy_set = false;
                    if (subscription_proxy != null) {
                        subscription_proxy.destroy();
                        subscription_proxy = null;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }
}

