/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.toolbar;

import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.views.skin.ToolBarView;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarActivationListener;

public class ToolBarItemSO
implements ToolBarItem {
    String imageID = "image.toolbar.run";
    String id;
    private SWTSkinButtonUtility skinButton;
    private SWTSkinObjectText skinTitle;
    boolean enabled = false;
    private String textID;
    private String tooltipID;
    private boolean alwaysAvailable = false;
    private final ToolBarView tbView;
    private UIToolBarActivationListener defaultActivation;
    private final boolean isPluginItem;
    private String groupID = "main";
    private long defaultState;
    private boolean isDown;

    public ToolBarItemSO(ToolBarView tbView, String id, String imageid) {
        this.tbView = tbView;
        this.id = id;
        this.imageID = imageid;
        this.isPluginItem = false;
    }

    public ToolBarItemSO(ToolBarView tbView, String id, String imageid, String textID) {
        this.tbView = tbView;
        this.id = id;
        this.imageID = imageid;
        this.textID = textID;
        this.tooltipID = textID + ".tooltip";
        this.isPluginItem = false;
    }

    public ToolBarItemSO(ToolBarView tbView, String id, boolean isPluginItem) {
        this.tbView = tbView;
        this.id = id;
        this.isPluginItem = isPluginItem;
    }

    public boolean triggerToolBarItem(long activationType, Object datasource) {
        return this.tbView.triggerToolBarItem(this, activationType, datasource);
    }

    public String getID() {
        return this.id;
    }

    public void setSkinButton(SWTSkinButtonUtility btn) {
        this.skinButton = btn;
        this.skinButton.setDisabled(!this.enabled);
    }

    public SWTSkinButtonUtility getSkinButton() {
        return this.skinButton;
    }

    public void setSkinTitle(SWTSkinObjectText s) {
        this.skinTitle = s;
    }

    public long getState() {
        long state = (this.isEnabled() ? 1L : 0L) | (this.isDown ? 2L : 0L);
        return state;
    }

    public void setState(long state) {
        this.setEnabled((state & 1L) > 0L);
        boolean bl = this.isDown = (state & 2L) > 0L;
        if (this.skinButton != null) {
            this.skinButton.getSkinObject().switchSuffix(this.isDown ? "-selected" : "", 4, false);
        }
    }

    private boolean isEnabled() {
        if (this.skinButton != null) {
            return !this.skinButton.isDisabled();
        }
        return this.enabled;
    }

    private void setEnabled(boolean enabled) {
        if (this.alwaysAvailable && !enabled) {
            return;
        }
        this.enabled = enabled;
        if (this.skinButton != null) {
            this.skinButton.setDisabled(!enabled);
        }
    }

    public String getImageID() {
        return this.imageID;
    }

    public void setImageID(String imageID) {
        this.imageID = imageID;
        if (this.skinButton != null) {
            this.skinButton.setImage(imageID);
        }
    }

    public void setTextID(String textID) {
        this.textID = textID;
        if (this.skinTitle != null) {
            this.skinTitle.setTextID(textID);
        }
    }

    public String getTextID() {
        return this.textID;
    }

    public String getTooltipID() {
        return this.tooltipID;
    }

    public void setTooltipID(String tooltipID) {
        this.tooltipID = tooltipID;
    }

    public void setAlwaysAvailable(boolean alwaysAvailable) {
        this.alwaysAvailable = alwaysAvailable;
        if (alwaysAvailable) {
            this.setEnabled(true);
        }
    }

    public boolean isAlwaysAvailable() {
        return this.alwaysAvailable;
    }

    public void setDefaultActivationListener(UIToolBarActivationListener defaultActivation) {
        this.defaultActivation = defaultActivation;
    }

    public UIToolBarActivationListener getDefaultActivationListener() {
        return this.defaultActivation;
    }

    public void dispose() {
        this.skinButton = null;
        this.skinTitle = null;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    public void setDefaultState(long state) {
        this.defaultState = state;
    }

    public long getDefaultState() {
        return this.defaultState;
    }
}

