/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.ui.mdi.MdiCloseListener;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.mdi.MdiListener;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ContentNetworkUtils;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;

public class Browse
extends SkinView
implements MdiCloseListener {
    private SWTSkinObjectBrowser browserSkinObject;
    private SWTSkinObject soMain;
    private MdiEntryVitalityImage vitalityImage;
    private ContentNetwork contentNetwork;

    public SWTSkinObjectBrowser getBrowserSkinObject() {
        return this.browserSkinObject;
    }

    public Object skinObjectCreated(SWTSkinObject skinObject, Object params) {
        MdiEntry entry;
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null && (entry = mdi.getEntryBySkinView(this)) != null) {
            entry.addListener(this);
        }
        return super.skinObjectCreated(skinObject, params);
    }

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        MdiEntry entry;
        this.soMain = skinObject;
        Object creationParams = skinObject.getData("CreationParams");
        this.contentNetwork = creationParams instanceof ContentNetwork ? (ContentNetwork)creationParams : ConstantsVuze.getDefaultContentNetwork();
        this.browserSkinObject = SWTSkinUtils.findBrowserSO(this.soMain);
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null && (entry = mdi.getEntryBySkinView(this)) != null) {
            this.vitalityImage = entry.addVitalityImage("image.sidebar.vitality.dots");
            this.vitalityImage.setVisible(false);
            mdi.addListener(new MdiListener(){
                long lastSelect = 0L;

                public void mdiEntrySelected(MdiEntry newEntry, MdiEntry oldEntry) {
                    if (entry == newEntry) {
                        if (entry == oldEntry) {
                            if (this.lastSelect < SystemTime.getOffsetTime(-1000L) && Browse.this.browserSkinObject != null) {
                                Browse.this.browserSkinObject.restart();
                            }
                        } else {
                            this.lastSelect = SystemTime.getCurrentTime();
                        }
                    }
                }
            });
        }
        this.browserSkinObject.addListener(new SWTSkinObjectListener(){

            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    Browse.this.browserSkinObject.removeListener(this);
                    Browse.this.browserSkinObject.addListener(new BrowserContext.loadingListener(){

                        public void browserLoadingChanged(boolean loading, String url) {
                            if (Browse.this.vitalityImage != null) {
                                Browse.this.vitalityImage.setVisible(loading);
                            }
                        }
                    });
                    Browse.this.browserSkinObject.getContext().setContentNetworkID(Browse.this.contentNetwork.getID());
                    Browse.this.browserSkinObject.enablePluginProxy("VHDN");
                    Browse.this.browserSkinObject.setStartURL(ContentNetworkUtils.getUrl(Browse.this.contentNetwork, 6));
                }
                return null;
            }
        });
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        String menuID = "sidebar." + ContentNetworkUtils.getTarget(this.contentNetwork);
        MenuItem item = menuManager.addMenuItem(menuID, "Button.reload");
        item.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                Browse.this.browserSkinObject.refresh();
            }
        });
        if (Constants.isCVSVersion()) {
            MenuItem parent = menuManager.addMenuItem(menuID, "CVS Only");
            parent.setStyle(5);
            MenuItem menuItem = menuManager.addMenuItem(parent, "Button.reset");
            menuItem.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    Browse.this.browserSkinObject.getContext().executeInBrowser("sendMessage('display','reset-url', {});");
                }
            });
            menuItem = menuManager.addMenuItem(parent, "Tux RPC Test");
            menuItem.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    Browse.this.browserSkinObject.setURL("c:\\test\\BrowserMessaging.html");
                }
            });
            menuItem = menuManager.addMenuItem(parent, "URL..");
            menuItem.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("", "!URL!");
                    entryWindow.prompt(new UIInputReceiverListener(){

                        public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                            if (entryWindow.hasSubmittedInput()) {
                                Browse.this.browserSkinObject.setURL(entryWindow.getSubmittedInput());
                            }
                        }
                    });
                }
            });
        }
        return null;
    }

    public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
        this.contentNetwork.setPersistentProperty("active", Boolean.FALSE);
    }
}

