/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.ui.InitializerListener;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentListener;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.Initializer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.views.skin.SB_Transfers;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.views.ViewUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBC_LibraryView
extends SkinView
implements UIPluginViewToolBarListener {
    private static final String ID = "library-list";
    public static final int MODE_BIGTABLE = 0;
    public static final int MODE_SMALLTABLE = 1;
    public static final int TORRENTS_ALL = 0;
    public static final int TORRENTS_COMPLETE = 1;
    public static final int TORRENTS_INCOMPLETE = 2;
    public static final int TORRENTS_UNOPENED = 3;
    private static final String[] modeViewIDs = new String[]{"library-big-area", "library-small-area"};
    private static final String[] modeIDs = new String[]{"library.table.big", "library.table.small"};
    private static boolean header_show_uptime;
    private static boolean header_show_rates;
    private static volatile OverallStats totalStats;
    private static volatile int selection_count;
    private static volatile long selection_size;
    private static volatile long selection_done;
    private static volatile DownloadManager[] selection_dms;
    private int viewMode = -1;
    private SWTSkinButtonUtility btnSmallTable;
    private SWTSkinButtonUtility btnBigTable;
    private SWTSkinObject soListArea;
    private int torrentFilterMode = 0;
    private String torrentFilter;
    private SWTSkinObject soWait;
    private SWTSkinObject soWaitProgress;
    private SWTSkinObjectText soWaitTask;
    private int waitProgress = 0;
    private SWTSkinObjectText soLibraryInfo;
    private Object datasource;
    private MdiEntry currentEntry;

    public void setViewMode(int viewMode, boolean save) {
        SWTSkinObject soOldViewArea;
        if (viewMode >= modeViewIDs.length || viewMode < 0 || viewMode == this.viewMode) {
            return;
        }
        int oldViewMode = this.viewMode;
        this.viewMode = viewMode;
        if (oldViewMode >= 0 && oldViewMode < modeViewIDs.length && (soOldViewArea = this.getSkinObject(modeViewIDs[oldViewMode])) != null) {
            soOldViewArea.setVisible(false);
        }
        SelectedContentManager.clearCurrentlySelectedContent();
        SWTSkinObject soViewArea = this.getSkinObject(modeViewIDs[viewMode]);
        if (soViewArea == null) {
            soViewArea = this.skin.createSkinObject(modeIDs[viewMode] + this.torrentFilterMode, modeIDs[viewMode], this.soListArea);
            soViewArea.getControl().setData("SBC_LibraryView:ViewMode", (Object)viewMode);
            this.skin.layout();
            soViewArea.setVisible(true);
            soViewArea.getControl().setLayoutData((Object)Utils.getFilledFormData());
        } else {
            soViewArea.setVisible(true);
        }
        if (save) {
            COConfigurationManager.setParameter(this.torrentFilter + ".viewmode", viewMode);
        }
        String entryID = null;
        if (this.torrentFilterMode == 0) {
            entryID = "Library";
        } else if (this.torrentFilterMode == 1) {
            entryID = "LibraryCD";
        } else if (this.torrentFilterMode == 2) {
            entryID = "LibraryDL";
        } else if (this.torrentFilterMode == 3) {
            entryID = "LibraryUnopened";
        }
        if (entryID != null) {
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            this.currentEntry = mdi.getEntry(entryID);
            if (this.currentEntry != null) {
                this.currentEntry.setLogID(entryID + "-" + viewMode);
            }
        }
        SB_Transfers.triggerCountRefreshListeners();
    }

    @Override
    public Object skinObjectInitialShow(final SWTSkinObject skinObject, Object params) {
        this.soWait = null;
        try {
            this.soWait = this.getSkinObject("library-wait");
            this.soWaitProgress = this.getSkinObject("library-wait-progress");
            this.soWaitTask = (SWTSkinObjectText)this.getSkinObject("library-wait-task");
            if (this.soWaitProgress != null) {
                this.soWaitProgress.getControl().addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        Control c = (Control)e.widget;
                        Point size = c.getSize();
                        e.gc.setBackground(ColorCache.getColor((Device)e.display, "#23a7df"));
                        int breakX = size.x * SBC_LibraryView.this.waitProgress / 100;
                        e.gc.fillRectangle(0, 0, breakX, size.y);
                        e.gc.setBackground(ColorCache.getColor((Device)e.display, "#cccccc"));
                        e.gc.fillRectangle(breakX, 0, size.x - breakX, size.y);
                    }
                });
            }
            this.soLibraryInfo = (SWTSkinObjectText)this.getSkinObject("library-info");
            if (this.soLibraryInfo != null) {
                SB_Transfers.addCountRefreshListener(new SB_Transfers.countRefreshListener(){
                    final Map<Composite, ExtraInfoProvider> extra_info_map = new HashMap<Composite, ExtraInfoProvider>();
                    {
                        SBC_LibraryView.this.soLibraryInfo.getControl().getParent().setData("ViewUtils:ViewTitleExtraInfo", (Object)new ViewUtils.ViewTitleExtraInfo(){

                            public void update(Composite reporter, boolean seeding_view, int count, int active) {
                                ExtraInfoProvider provider2 = this.getProvider(reporter);
                                if (provider2 == null) {
                                    return;
                                }
                                if (provider2.value != count || provider2.active != active) {
                                    provider2.value = count;
                                    provider2.active = active;
                                    if (SBC_LibraryView.this.viewMode == provider2.view_mode && provider2.enabled) {
                                        SB_Transfers.triggerCountRefreshListeners();
                                    }
                                }
                            }

                            public void setEnabled(Composite reporter, boolean seeding_view, boolean enabled) {
                                ExtraInfoProvider provider2 = this.getProvider(reporter);
                                if (provider2 == null) {
                                    return;
                                }
                                if (provider2.enabled != enabled) {
                                    provider2.enabled = enabled;
                                    if (SBC_LibraryView.this.viewMode == provider2.view_mode) {
                                        SB_Transfers.triggerCountRefreshListeners();
                                    }
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            private ExtraInfoProvider getProvider(Composite reporter) {
                                Map<Composite, ExtraInfoProvider> map = extra_info_map;
                                synchronized (map) {
                                    ExtraInfoProvider provider2 = extra_info_map.get(reporter);
                                    if (provider2 != null) {
                                        return provider2;
                                    }
                                    for (Composite temp = reporter; temp != null; temp = temp.getParent()) {
                                        Integer vm = (Integer)temp.getData("SBC_LibraryView:ViewMode");
                                        if (vm == null) continue;
                                        provider2 = new ExtraInfoProvider(vm);
                                        extra_info_map.put(reporter, provider2);
                                        return provider2;
                                    }
                                    Debug.out("No view mode found for " + reporter);
                                    return null;
                                }
                            }
                        });
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void countRefreshed(SB_Transfers.stats statsWithLowNoise, SB_Transfers.stats statsNoLowNoise) {
                        String s;
                        Object id;
                        SB_Transfers.stats stats2;
                        SB_Transfers.stats stats3 = stats2 = SBC_LibraryView.this.viewMode == 1 ? statsWithLowNoise : statsNoLowNoise;
                        if (SBC_LibraryView.this.torrentFilterMode == 2) {
                            id = "library.incomplete.header";
                            if (stats2.numDownloading != 1) {
                                id = (String)id + ".p";
                            }
                            s = MessageText.getString((String)id, new String[]{String.valueOf(stats2.numDownloading), String.valueOf(stats2.numIncomplete - stats2.numDownloading)});
                        } else if (SBC_LibraryView.this.torrentFilterMode == 0) {
                            String id2;
                            if (SBC_LibraryView.this.datasource instanceof Category) {
                                Category cat = (Category)SBC_LibraryView.this.datasource;
                                id2 = "library.category.header";
                                s = MessageText.getString(id2, new String[]{cat.getType() != 0 ? MessageText.getString(cat.getName()) : cat.getName()});
                            } else if (SBC_LibraryView.this.datasource instanceof Tag) {
                                Tag tag = (Tag)SBC_LibraryView.this.datasource;
                                id2 = "library.tag.header";
                                s = MessageText.getString(id2, new String[]{tag.getTagName(true)});
                            } else {
                                id = "library.all.header";
                                if (stats2.numComplete + stats2.numIncomplete != 1) {
                                    id = (String)id + ".p";
                                }
                                s = MessageText.getString((String)id, new String[]{String.valueOf(stats2.numComplete + stats2.numIncomplete), String.valueOf(stats2.numSeeding + stats2.numDownloading)});
                                if (stats2.numQueued > 0) {
                                    s = s + ", " + MessageText.getString("label.num_queued", new String[]{String.valueOf(stats2.numQueued)});
                                }
                            }
                        } else if (SBC_LibraryView.this.torrentFilterMode == 3) {
                            id = "library.unopened.header";
                            if (stats2.numUnOpened != 1) {
                                id = (String)id + ".p";
                            }
                            s = MessageText.getString((String)id, new String[]{String.valueOf(stats2.numUnOpened)});
                        } else {
                            s = "";
                        }
                        id = this.extra_info_map;
                        synchronized (id) {
                            int filter_total = 0;
                            int filter_active = 0;
                            boolean filter_enabled = false;
                            for (ExtraInfoProvider provider2 : this.extra_info_map.values()) {
                                if (SBC_LibraryView.this.viewMode != provider2.view_mode || !provider2.enabled) continue;
                                filter_enabled = true;
                                filter_total += provider2.value;
                                filter_active += provider2.active;
                            }
                            if (filter_enabled) {
                                String extra = MessageText.getString("filter.header.matches2", new String[]{String.valueOf(filter_total), String.valueOf(filter_active)});
                                s = s + " " + extra;
                            }
                        }
                        if (selection_count > 1) {
                            s = s + ", " + MessageText.getString("label.num_selected", new String[]{String.valueOf(selection_count)});
                            String size_str = null;
                            String rate_str = null;
                            if (selection_size > 0L) {
                                size_str = selection_size == selection_done ? DisplayFormatters.formatByteCountToKiBEtc(selection_size) : DisplayFormatters.formatByteCountToKiBEtc(selection_done) + "/" + DisplayFormatters.formatByteCountToKiBEtc(selection_size);
                            }
                            DownloadManager[] dms = selection_dms;
                            if (header_show_rates && dms.length > 1) {
                                long total_data_up = 0L;
                                long total_prot_up = 0L;
                                long total_data_down = 0L;
                                long total_prot_down = 0L;
                                for (DownloadManager dm : dms) {
                                    DownloadManagerStats dm_stats = dm.getStats();
                                    total_prot_up += dm_stats.getProtocolSendRate();
                                    total_data_up += dm_stats.getDataSendRate();
                                    total_prot_down += dm_stats.getProtocolReceiveRate();
                                    total_data_down += dm_stats.getDataReceiveRate();
                                }
                                rate_str = MessageText.getString("ConfigView.download.abbreviated") + DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(total_data_down, total_prot_down) + " " + MessageText.getString("ConfigView.upload.abbreviated") + DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(total_data_up, total_prot_up);
                            }
                            if (size_str != null || rate_str != null) {
                                String temp = size_str == null ? rate_str : (rate_str == null ? size_str : size_str + "; " + rate_str);
                                s = s + " (" + temp + ")";
                            }
                        }
                        if (header_show_uptime && totalStats != null) {
                            String op;
                            long up_secs = totalStats.getSessionUpTime() / 60L * 60L;
                            if (up_secs < 60L) {
                                up_secs = 60L;
                                op = "<";
                            } else {
                                op = " ";
                            }
                            String up_str = TimeFormatter.format2(up_secs, false);
                            s = s + "; " + MessageText.getString("label.uptime_coarse", new String[]{op, up_str});
                        }
                        SBC_LibraryView.this.soLibraryInfo.setText(s);
                    }

                    class ExtraInfoProvider {
                        int view_mode;
                        boolean enabled;
                        int value;
                        int active;

                        ExtraInfoProvider(int vm) {
                            this.view_mode = vm;
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!AzureusCoreFactory.isCoreRunning()) {
            Initializer initializer;
            if (this.soWait != null) {
                this.soWait.setVisible(true);
            }
            if ((initializer = Initializer.getLastInitializer()) != null) {
                initializer.addListener(new InitializerListener(){

                    public void reportPercent(final int percent) {
                        Utils.execSWTThread(new AERunnable(){

                            public void runSupport() {
                                if (SBC_LibraryView.this.soWaitProgress != null && !SBC_LibraryView.this.soWaitProgress.isDisposed()) {
                                    SBC_LibraryView.this.waitProgress = percent;
                                    SBC_LibraryView.this.soWaitProgress.getControl().redraw();
                                    SBC_LibraryView.this.soWaitProgress.getControl().update();
                                }
                            }
                        });
                        if (percent > 100) {
                            initializer.removeListener(this);
                        }
                    }

                    public void reportCurrentTask(String currentTask) {
                        if (SBC_LibraryView.this.soWaitTask != null && !SBC_LibraryView.this.soWaitTask.isDisposed()) {
                            SBC_LibraryView.this.soWaitTask.setText(currentTask);
                        }
                    }
                });
            }
        }
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(final AzureusCore core) {
                PluginInterface pi = PluginInitializer.getDefaultInterface();
                final UIManager uim = pi.getUIManager();
                uim.addUIListener(new UIManagerListener(){

                    public void UIDetached(UIInstance instance) {
                    }

                    public void UIAttached(UIInstance instance) {
                        if (instance instanceof UISWTInstance) {
                            uim.removeUIListener(this);
                            Utils.execSWTThread(new AERunnable(){

                                public void runSupport() {
                                    if (SBC_LibraryView.this.soWait != null) {
                                        SBC_LibraryView.this.soWait.setVisible(false);
                                    }
                                    if (!skinObject.isDisposed()) {
                                        SBC_LibraryView.this.setupView(core, skinObject);
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        return null;
    }

    private void setupView(AzureusCore core, SWTSkinObject skinObject) {
        this.torrentFilter = skinObject.getSkinObjectID();
        if (this.torrentFilter.equalsIgnoreCase("LibraryDL")) {
            this.torrentFilterMode = 2;
        } else if (this.torrentFilter.equalsIgnoreCase("LibraryCD")) {
            this.torrentFilterMode = 1;
        } else if (this.torrentFilter.equalsIgnoreCase("LibraryUnopened")) {
            this.torrentFilterMode = 3;
        }
        this.soListArea = this.getSkinObject("library-list-area");
        this.soListArea.getControl().setData("TorrentFilterMode", (Object)new Long(this.torrentFilterMode));
        this.soListArea.getControl().setData("DataSource", this.datasource);
        this.setViewMode(COConfigurationManager.getIntParameter(this.torrentFilter + ".viewmode"), false);
        SWTSkinObject so = this.getSkinObject("library-list-button-smalltable");
        if (so != null) {
            this.btnSmallTable = new SWTSkinButtonUtility(so);
            this.btnSmallTable.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    SBC_LibraryView.this.setViewMode(1, true);
                }
            });
        }
        if ((so = this.getSkinObject("library-list-button-bigtable")) != null) {
            this.btnBigTable = new SWTSkinButtonUtility(so);
            this.btnBigTable.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    SBC_LibraryView.this.setViewMode(0, true);
                }
            });
        }
        SB_Transfers.setupViewTitleWithCore(core);
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        long stateSmall = 1L;
        long stateBig = 1L;
        if (this.viewMode == 0) {
            stateBig |= 2L;
        } else {
            stateSmall |= 2L;
        }
        list.put("modeSmall", stateSmall);
        list.put("modeBig", stateBig);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        String itemKey = item.getID();
        if (itemKey.equals("modeSmall") && this.isVisible()) {
            this.setViewMode(1, true);
            return true;
        }
        if (itemKey.equals("modeBig") && this.isVisible()) {
            this.setViewMode(0, true);
            return true;
        }
        return false;
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public Object dataSourceChanged(SWTSkinObject skinObject, Object params) {
        this.datasource = params;
        if (this.soListArea != null) {
            this.soListArea.getControl().setData("DataSource", params);
        }
        return null;
    }

    public int getViewMode() {
        return this.viewMode;
    }

    protected void addHeaderInfoExtender(HeaderInfoExtender extender) {
    }

    protected void removeHeaderInfoExtender(HeaderInfoExtender extender) {
    }

    protected void refreshHeaderInfo() {
        SB_Transfers.triggerCountRefreshListeners();
    }

    static /* synthetic */ DownloadManager[] access$602(DownloadManager[] x0) {
        selection_dms = x0;
        return x0;
    }

    static {
        selection_dms = new DownloadManager[0];
        SimpleTimer.addPeriodicEvent("SBLV:updater", 60000L, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                if (header_show_uptime) {
                    SB_Transfers.triggerCountRefreshListeners();
                }
            }
        });
        COConfigurationManager.addAndFireParameterListeners(new String[]{"MyTorrentsView.showuptime", "MyTorrentsView.showrates"}, new ParameterListener(){
            private TimerEventPeriodic rate_event;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void parameterChanged(String name) {
                header_show_uptime = COConfigurationManager.getBooleanParameter("MyTorrentsView.showuptime");
                header_show_rates = COConfigurationManager.getBooleanParameter("MyTorrentsView.showrates");
                SB_Transfers.triggerCountRefreshListeners();
                2 var2_2 = this;
                synchronized (var2_2) {
                    if (header_show_rates) {
                        if (this.rate_event == null) {
                            this.rate_event = SimpleTimer.addPeriodicEvent("SBLV:rate-updater", 1000L, new TimerEventPerformer(){

                                public void perform(TimerEvent event2) {
                                    SB_Transfers.triggerCountRefreshListeners();
                                }
                            });
                        }
                    } else if (this.rate_event != null) {
                        this.rate_event.cancel();
                        this.rate_event = null;
                    }
                }
            }
        });
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                totalStats = StatsFactory.getStats();
            }
        });
        SelectedContentManager.addCurrentlySelectedContentListener(new SelectedContentListener(){

            public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewId) {
                selection_count = currentContent.length;
                long total_size = 0L;
                long total_done = 0L;
                ArrayList<DownloadManager> dms = new ArrayList<DownloadManager>(currentContent.length);
                for (ISelectedContent sc : currentContent) {
                    DownloadManager dm = sc.getDownloadManager();
                    if (dm == null) continue;
                    dms.add(dm);
                    int file_index = sc.getFileIndex();
                    if (file_index == -1) {
                        DiskManagerFileInfo[] file_infos;
                        for (DiskManagerFileInfo file_info : file_infos = dm.getDiskManagerFileInfoSet().getFiles()) {
                            if (file_info.isSkipped()) continue;
                            total_size += file_info.getLength();
                            total_done += file_info.getDownloaded();
                        }
                        continue;
                    }
                    DiskManagerFileInfo file_info = dm.getDiskManagerFileInfoSet().getFiles()[file_index];
                    if (file_info.isSkipped()) continue;
                    total_size += file_info.getLength();
                    total_done += file_info.getDownloaded();
                }
                selection_size = total_size;
                selection_done = total_done;
                SBC_LibraryView.access$602(dms.toArray(new DownloadManager[dms.size()]));
                SB_Transfers.triggerCountRefreshListeners();
            }
        });
    }

    protected static interface HeaderInfoExtender {
    }
}

