/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.content.ContentException;
import com.aelitis.azureus.core.content.RelatedAttributeLookupListener;
import com.aelitis.azureus.core.content.RelatedContentManager;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagDiscovery;
import com.aelitis.azureus.core.tag.TagException;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableColumnCoreCreationListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.table.TableViewFilterCheck;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagName;
import com.aelitis.azureus.ui.swt.columns.tagdiscovery.ColumnTagDiscoveryAddedOn;
import com.aelitis.azureus.ui.swt.columns.tagdiscovery.ColumnTagDiscoveryName;
import com.aelitis.azureus.ui.swt.columns.tagdiscovery.ColumnTagDiscoveryNetwork;
import com.aelitis.azureus.ui.swt.columns.tagdiscovery.ColumnTagDiscoveryTorrent;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectButton;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AEMonitor2;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.table.TableSelectedRowsListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.tableitems.ColumnDateSizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBC_TagDiscovery
extends SkinView
implements UIUpdatable,
UIPluginViewToolBarListener,
TableViewFilterCheck<TagDiscovery>,
TableViewSWTMenuFillListener,
TableSelectionListener,
ViewTitleInfo {
    private static final String TABLE_TAGDISCOVERY = "TagDiscoveryView";
    private static final boolean DEBUG = false;
    private static final String ID_VITALITY_ACTIVE = "image.sidebar.vitality.dl";
    TableViewSWT<TagDiscovery> tv;
    private Text txtFilter;
    private Composite table_parent;
    private boolean columnsAdded = false;
    private int scansRemaining = 0;
    private AEMonitor2 mon_scansRemaining = new AEMonitor2("scansRemaining");
    private Map<String, TagDiscovery> mapTagDiscoveries = new HashMap<String, TagDiscovery>();
    private MdiEntry entry;
    private SWTSkinObjectText soTitle;
    private MdiEntryVitalityImage vitalityImage;

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        Object[] datasources;
        if (this.tv == null || !this.tv.isVisible()) {
            return false;
        }
        if (item.getID().equals("remove") && (datasources = this.tv.getSelectedDataSources().toArray()).length > 0) {
            for (Object object : datasources) {
                if (!(object instanceof TagDiscovery)) continue;
                TagDiscovery discovery = (TagDiscovery)object;
            }
            return true;
        }
        return false;
    }

    @Override
    public void filterSet(String filter2) {
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        if (this.tv == null || !this.tv.isVisible()) {
            return;
        }
        list.put("remove", this.tv.getSelectedDataSources().size() > 0 ? 1L : 0L);
    }

    @Override
    public void updateUI() {
        if (this.tv != null) {
            this.tv.refreshTable(false);
        }
    }

    @Override
    public String getUpdateUIName() {
        return TABLE_TAGDISCOVERY;
    }

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        MultipleDocumentInterfaceSWT mdi;
        this.soTitle = (SWTSkinObjectText)this.getSkinObject("title");
        SWTSkinObjectButton soScanButton = (SWTSkinObjectButton)this.getSkinObject("scan-button");
        if (soScanButton != null) {
            soScanButton.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    SBC_TagDiscovery.this.startScan();
                }
            });
        }
        if ((mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT()) != null) {
            this.entry = mdi.getEntry("TagDiscovery");
            if (this.entry != null) {
                this.entry.setViewTitleInfo(this);
                this.vitalityImage = this.entry.addVitalityImage(ID_VITALITY_ACTIVE);
                this.vitalityImage.setVisible(false);
            }
        }
        this.initColumns();
        return null;
    }

    @Override
    public Object getTitleInfoProperty(int propertyID) {
        int num;
        if (propertyID == 0 && (num = this.mapTagDiscoveries.size()) > 0) {
            return "" + num;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initColumns() {
        Class<SBC_TagDiscovery> clazz = SBC_TagDiscovery.class;
        synchronized (SBC_TagDiscovery.class) {
            if (this.columnsAdded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.columnsAdded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            TableColumnManager tableManager = TableColumnManager.getInstance();
            tableManager.registerColumn(TagDiscovery.class, ColumnTagDiscoveryName.COLUMN_ID, new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDiscoveryName(column);
                }
            });
            tableManager.registerColumn(TagDiscovery.class, ColumnTagDiscoveryTorrent.COLUMN_ID, new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDiscoveryTorrent(column);
                }
            });
            tableManager.registerColumn(TagDiscovery.class, ColumnTagDiscoveryAddedOn.COLUMN_ID, new TableColumnCoreCreationListener(){

                @Override
                public TableColumnCore createTableColumnCore(Class<?> forDataSourceType, String tableID, String columnID) {
                    return new ColumnDateSizer(TagDiscovery.class, columnID, TableColumnCreator.DATE_COLUMN_WIDTH, tableID){};
                }

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDiscoveryAddedOn(column);
                }
            });
            tableManager.registerColumn(TagDiscovery.class, ColumnTagDiscoveryNetwork.COLUMN_ID, new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDiscoveryNetwork(column);
                }
            });
            tableManager.setDefaultColumnNames(TABLE_TAGDISCOVERY, new String[]{ColumnTagDiscoveryName.COLUMN_ID, ColumnTagDiscoveryTorrent.COLUMN_ID, ColumnTagDiscoveryAddedOn.COLUMN_ID});
            tableManager.setDefaultSortColumnName(TABLE_TAGDISCOVERY, ColumnTagDiscoveryAddedOn.COLUMN_ID);
            return;
        }
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        if (this.tv != null) {
            this.tv.delete();
            this.tv = null;
        }
        Utils.disposeSWTObjects(new Object[]{this.table_parent});
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        super.skinObjectShown(skinObject, params);
        SWTSkinObject so_list = this.getSkinObject("tag-discovery-list");
        if (so_list == null) {
            System.out.println("NO tag-discovery-list");
            return null;
        }
        this.initTable((Composite)so_list.getControl());
        if (this.tv == null) {
            return null;
        }
        TagDiscovery[] tagDiscoveries = this.mapTagDiscoveries.values().toArray(new TagDiscovery[0]);
        this.tv.addDataSources((TagDiscovery[])tagDiscoveries);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startScan() {
        try {
            this.mon_scansRemaining.enter();
            if (this.scansRemaining > 0) {
                Object var2_1 = null;
                this.mon_scansRemaining.exit();
                return;
            }
            Object var2_2 = null;
            this.mon_scansRemaining.exit();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.mon_scansRemaining.exit();
            throw throwable;
        }
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void azureusCoreRunning(AzureusCore core) {
                GlobalManager gm = core.getGlobalManager();
                try {
                    try {
                        SBC_TagDiscovery.this.mon_scansRemaining.enter();
                        SBC_TagDiscovery.this.scansRemaining = 0;
                        Object var4_3 = null;
                        SBC_TagDiscovery.this.mon_scansRemaining.exit();
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        SBC_TagDiscovery.this.mon_scansRemaining.exit();
                        throw throwable;
                    }
                    RelatedContentManager rcm = RelatedContentManager.getSingleton();
                    List<DownloadManager> dms = gm.getDownloadManagers();
                    for (final DownloadManager dm : dms) {
                        TOTorrent torrent = dm.getTorrent();
                        if (torrent == null) continue;
                        try {
                            Object var10_15;
                            final byte[] hash = torrent.getHash();
                            try {
                                SBC_TagDiscovery.this.mon_scansRemaining.enter();
                                SBC_TagDiscovery.this.scansRemaining++;
                                if (SBC_TagDiscovery.this.vitalityImage != null && SBC_TagDiscovery.this.scansRemaining == 1) {
                                    SBC_TagDiscovery.this.vitalityImage.setVisible(true);
                                }
                                if (SBC_TagDiscovery.this.soTitle != null) {
                                    SBC_TagDiscovery.this.soTitle.setText(MessageText.getString("tag.discovery.view.heading") + " : Scanning " + SBC_TagDiscovery.this.scansRemaining);
                                }
                                var10_15 = null;
                                SBC_TagDiscovery.this.mon_scansRemaining.exit();
                            }
                            catch (Throwable throwable) {
                                var10_15 = null;
                                SBC_TagDiscovery.this.mon_scansRemaining.exit();
                                throw throwable;
                            }
                            try {
                                rcm.lookupAttributes(hash, dm.getDownloadState().getNetworks(), new RelatedAttributeLookupListener(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void tagFound(String tag, String network) {
                                        String key = Base32.encode(hash) + tag;
                                        TagManager tm = TagManagerFactory.getTagManager();
                                        TagType tt_manual = tm.getTagType(3);
                                        List<Tag> existingDMTags = tt_manual.getTagsForTaggable(dm);
                                        for (Tag existingTag : existingDMTags) {
                                            if (!existingTag.getTagName(true).equalsIgnoreCase(tag)) continue;
                                            return;
                                        }
                                        Map map = SBC_TagDiscovery.this.mapTagDiscoveries;
                                        synchronized (map) {
                                            if (!SBC_TagDiscovery.this.mapTagDiscoveries.containsKey(key)) {
                                                TagDiscovery tagDiscovery = new TagDiscovery(tag, network, dm.getDisplayName(), hash);
                                                SBC_TagDiscovery.this.mapTagDiscoveries.put(key, tagDiscovery);
                                                ViewTitleInfoManager.refreshTitleInfo(SBC_TagDiscovery.this);
                                                SBC_TagDiscovery.this.tv.addDataSource(tagDiscovery);
                                            }
                                        }
                                    }

                                    public void lookupStart() {
                                    }

                                    public void lookupFailed(ContentException error) {
                                    }

                                    public void lookupComplete() {
                                        SBC_TagDiscovery.this.decreaseScansRemaining();
                                    }
                                });
                            }
                            catch (Throwable e) {
                                SBC_TagDiscovery.this.decreaseScansRemaining();
                            }
                        }
                        catch (TOTorrentException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (ContentException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decreaseScansRemaining() {
        try {
            this.mon_scansRemaining.enter();
            --this.scansRemaining;
            if (this.soTitle != null) {
                if (this.scansRemaining <= 0) {
                    this.soTitle.setTextID("tag.discovery.view.heading");
                } else {
                    this.soTitle.setText(MessageText.getString("tag.discovery.view.heading") + " : Scanning " + this.scansRemaining);
                }
            }
            if (this.vitalityImage != null && this.scansRemaining <= 0) {
                this.vitalityImage.setVisible(false);
            }
            Object var2_1 = null;
            this.mon_scansRemaining.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mon_scansRemaining.exit();
            throw throwable;
        }
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void initTable(Composite control) {
        if (this.tv == null) {
            this.tv = TableViewFactory.createTableViewSWT(TagDiscovery.class, TABLE_TAGDISCOVERY, TABLE_TAGDISCOVERY, new TableColumnCore[0], ColumnTagName.COLUMN_ID, 0x10010002);
            if (this.txtFilter != null) {
                this.tv.enableFilterCheck(this.txtFilter, this);
            }
            this.tv.setRowDefaultHeight(16);
            this.table_parent = new Composite(control, 2048);
            this.table_parent.setLayoutData((Object)Utils.getFilledFormData());
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.table_parent.setLayout((Layout)layout);
            this.tv.addMenuFillListener(this);
            this.tv.addSelectionListener(this, false);
            this.tv.initialize(this.table_parent);
        }
        control.layout(true);
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        List<Object> ds = this.tv.getSelectedDataSources();
        MenuItem menuTagIt = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)menuTagIt, "TagDiscoveriesView.menu.tagit");
        menuTagIt.addListener(13, (Listener)new TableSelectedRowsListener(this.tv){

            public void run(TableRowCore row) {
                TagDiscovery tagDiscovery = (TagDiscovery)row.getDataSource(true);
                TagManager tm = TagManagerFactory.getTagManager();
                TagType manual_tt = tm.getTagType(3);
                Tag tag = manual_tt.getTag(tagDiscovery.getName(), true);
                if (tag == null) {
                    try {
                        tag = manual_tt.createTag(tagDiscovery.getName(), true);
                        tag.setPublic(true);
                        tag.setGroup("Discovery");
                        tag.setVisible(true);
                    }
                    catch (TagException e) {
                        return;
                    }
                }
                byte[] hash = tagDiscovery.getHash();
                DownloadManager dm = AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManager(new HashWrapper(hash));
                tag.addTaggable(dm);
                String key = Base32.encode(hash) + tag.getTagName(true);
                SBC_TagDiscovery.this.mapTagDiscoveries.remove(key);
                SBC_TagDiscovery.this.tv.removeDataSource(tagDiscovery);
                ViewTitleInfoManager.refreshTitleInfo(SBC_TagDiscovery.this);
            }
        });
    }

    @Override
    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
    }

    @Override
    public void selected(TableRowCore[] row) {
    }

    @Override
    public void deselected(TableRowCore[] rows) {
    }

    @Override
    public void focusChanged(TableRowCore focus) {
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        Object obj;
        if (rows.length == 1 && (obj = rows[0].getDataSource()) instanceof TagDiscovery) {
            TagDiscovery tag = (TagDiscovery)obj;
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    @Override
    public boolean filterCheck(TagDiscovery ds, String filter2, boolean regex) {
        return false;
    }
}

