/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.BrowserWrapper;
import com.aelitis.azureus.ui.swt.browser.CookiesListener;
import com.aelitis.azureus.ui.swt.browser.OpenCloseSearchDetailsListener;
import com.aelitis.azureus.ui.swt.browser.listener.ExternalLoginCookieListener;
import com.aelitis.azureus.ui.swt.browser.listener.MetaSearchListener;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.PropertiesWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

public class SearchResultsTabArea
extends SkinView
implements OpenCloseSearchDetailsListener {
    private static boolean search_proxy_init_done;
    private static AEProxyFactory.PluginHTTPProxy search_proxy;
    private static boolean search_proxy_set;
    private static AESemaphore search_proxy_sem;
    private static List<SearchResultsTabArea> pending;
    private SWTSkinObjectBrowser browserSkinObject;
    private SWTSkin skin;
    private boolean searchResultsInitialized = false;
    protected String title;
    private MdiEntryVitalityImage vitalityImage;
    private boolean menu_added;
    public SearchQuery sq;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initProxy() {
        Class<SearchResultsTabArea> clazz = SearchResultsTabArea.class;
        synchronized (SearchResultsTabArea.class) {
            if (search_proxy_init_done) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            search_proxy_init_done = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            new AEThread2("ST_test"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ArrayList to_redo2;
                    try {
                        String test_url = System.getProperty("metasearch", "1").equals("1") ? ConstantsVuze.getDefaultContentNetwork().getXSearchService("derp", false) : ConstantsVuze.getDefaultContentNetwork().getSearchService("derp");
                        try {
                            boolean use_proxy;
                            URL url = new URL(test_url);
                            url = UrlUtils.setProtocol(url, "https");
                            url = UrlUtils.setPort(url, 443);
                            boolean bl = use_proxy = !COConfigurationManager.getStringParameter("browser.internal.proxy.id", "none").equals("none");
                            if (!use_proxy) {
                                Boolean looks_ok = AEProxyFactory.testPluginHTTPProxy(url, true);
                                boolean bl2 = use_proxy = looks_ok != null && looks_ok == false;
                            }
                            if (use_proxy) {
                                search_proxy = AEProxyFactory.getPluginHTTPProxy("search", url, true);
                                if (search_proxy != null) {
                                    UrlFilter.getInstance().addUrlWhitelist("https?://" + ((InetSocketAddress)search_proxy.getProxy().address()).getAddress().getHostAddress() + ":?[0-9]*/.*");
                                }
                            }
                        }
                        catch (Throwable throwable) {
                        }
                        Object var6_6 = null;
                        to_redo2 = null;
                        Class<SearchResultsTabArea> clazz = SearchResultsTabArea.class;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        ArrayList to_redo2 = null;
                        Class<SearchResultsTabArea> clazz = SearchResultsTabArea.class;
                        synchronized (SearchResultsTabArea.class) {
                            search_proxy_set = true;
                            to_redo2 = new ArrayList(pending);
                            pending.clear();
                            // ** MonitorExit[var8_11] (shouldn't be in output)
                            search_proxy_sem.releaseForever();
                            for (SearchResultsTabArea area : to_redo2) {
                                Throwable e22;
                                try {
                                    SearchQuery sq;
                                    try {
                                        area.browserSkinObject.setAutoReloadPending(false, search_proxy == null);
                                    }
                                    catch (Throwable e22) {
                                        // empty catch block
                                    }
                                    if (search_proxy == null || (sq = area.sq) == null) continue;
                                    area.anotherSearch(sq);
                                }
                                catch (Throwable e22) {}
                            }
                            throw throwable;
                        }
                    }
                    synchronized (SearchResultsTabArea.class) {
                        search_proxy_set = true;
                        to_redo2 = new ArrayList(pending);
                        pending.clear();
                        // ** MonitorExit[var8_10] (shouldn't be in output)
                        search_proxy_sem.releaseForever();
                        for (SearchResultsTabArea area : to_redo2) {
                            Throwable e22;
                            try {
                                SearchQuery sq;
                                try {
                                    area.browserSkinObject.setAutoReloadPending(false, search_proxy == null);
                                }
                                catch (Throwable e22) {
                                    // empty catch block
                                }
                                if (search_proxy == null || (sq = area.sq) == null) continue;
                                area.anotherSearch(sq);
                            }
                            catch (Throwable e22) {}
                        }
                    }
                    {
                        return;
                    }
                }
            }.start();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AEProxyFactory.PluginHTTPProxy getSearchProxy(SearchResultsTabArea area) {
        SearchResultsTabArea.initProxy();
        boolean force_proxy = !COConfigurationManager.getStringParameter("browser.internal.proxy.id", "none").equals("none");
        search_proxy_sem.reserve(force_proxy ? 60000L : 2500L);
        Class<SearchResultsTabArea> clazz = SearchResultsTabArea.class;
        synchronized (SearchResultsTabArea.class) {
            if (search_proxy_set) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return search_proxy;
            }
            pending.add(area);
            try {
                area.browserSkinObject.setAutoReloadPending(true, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.skin = skinObject.getSkin();
        this.browserSkinObject = (SWTSkinObjectBrowser)this.skin.getSkinObject("searchresults", skinObject);
        this.browserSkinObject.addListener(new SWTSkinObjectListener(){

            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    SearchResultsTabArea.this.browserSkinObject.removeListener(this);
                    SearchResultsTabArea.this.createBrowseArea(SearchResultsTabArea.this.browserSkinObject);
                }
                return null;
            }
        });
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(final AzureusCore core) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        SearchResultsTabArea.this.initCoreStuff(core);
                    }
                });
            }
        });
        if (this.sq != null) {
            this.anotherSearch(this.sq);
        }
        this.closeSearchResults(null);
        return null;
    }

    private void initCoreStuff(AzureusCore core) {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        final MenuManager menuManager = uim.getMenuManager();
        if (!this.menu_added) {
            this.menu_added = true;
            final MenuItem template_menu = menuManager.addMenuItem("sidebar.Search", "Search.menu.engines");
            template_menu.setStyle(5);
            template_menu.addFillListener(new MenuItemFillListener(){

                public void menuWillBeShown(MenuItem menu, Object data) {
                    template_menu.removeAllChildItems();
                    Engine[] engines = MetaSearchManagerFactory.getSingleton().getMetaSearch().getEngines(true, false);
                    Arrays.sort(engines, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            return ((Engine)o1).getName().compareToIgnoreCase(((Engine)o2).getName());
                        }
                    });
                    for (int i = 0; i < engines.length; ++i) {
                        String cookies;
                        WebEngine we;
                        final Engine engine = engines[i];
                        MenuItem engine_menu = menuManager.addMenuItem(template_menu, "!" + engine.getName() + "!");
                        engine_menu.setStyle(5);
                        MenuItem mi = menuManager.addMenuItem(engine_menu, "MyTorrentsView.menu.exportmenu");
                        mi.addListener(new MenuItemListener(){

                            public void selected(MenuItem menu, Object target) {
                                final Shell shell = Utils.findAnyShell();
                                shell.getDisplay().asyncExec((Runnable)new AERunnable(){

                                    public void runSupport() {
                                        FileDialog dialog = new FileDialog(shell, 139264);
                                        dialog.setFilterPath(TorrentOpener.getFilterPathData());
                                        dialog.setText(MessageText.getString("metasearch.export.select.template.file"));
                                        dialog.setFilterExtensions(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                                        dialog.setFilterNames(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                                        String path = TorrentOpener.setFilterPathData(dialog.open());
                                        if (path != null) {
                                            String lc = path.toLowerCase();
                                            if (!lc.endsWith(".vuze") && !lc.endsWith(".vuz")) {
                                                path = path + ".vuze";
                                            }
                                            try {
                                                engine.exportToVuzeFile(new File(path));
                                            }
                                            catch (Throwable e) {
                                                Debug.out(e);
                                            }
                                        }
                                    }
                                });
                            }
                        });
                        if (Constants.IS_CVS_VERSION) {
                            MenuItem copy_mi = menuManager.addMenuItem(engine_menu, "ConfigView.copy.to.clipboard.tooltip");
                            copy_mi.addListener(new MenuItemListener(){

                                public void selected(MenuItem menu, Object target) {
                                    Shell shell = Utils.findAnyShell();
                                    shell.getDisplay().asyncExec((Runnable)new AERunnable(){

                                        public void runSupport() {
                                            try {
                                                ClipboardCopy.copyToClipBoard(engine.exportToVuzeFile().exportToJSON());
                                            }
                                            catch (Throwable e) {
                                                Debug.out(e);
                                            }
                                        }
                                    });
                                }
                            });
                        }
                        if (engine instanceof WebEngine && (we = (WebEngine)engine).isNeedsAuth() && (cookies = we.getCookies()) != null && cookies.length() > 0) {
                            MenuItem mi2 = menuManager.addMenuItem(engine_menu, "Subscription.menu.resetauth");
                            mi2.addListener(new MenuItemListener(){

                                public void selected(MenuItem menu, Object target) {
                                    we.setCookies(null);
                                }
                            });
                        }
                        if (engine_menu.getItems().length > 0) {
                            mi = menuManager.addMenuItem(engine_menu, "Subscription.menu.sep");
                            mi.setStyle(4);
                        }
                        mi = menuManager.addMenuItem(engine_menu, "Button.remove");
                        mi.addListener(new MenuItemListener(){

                            public void selected(MenuItem menu, Object target) {
                                engine.setSelectionState(0);
                            }
                        });
                        mi = menuManager.addMenuItem(engine_menu, "Subscription.menu.sep2");
                        mi.setStyle(4);
                        mi = menuManager.addMenuItem(engine_menu, "Subscription.menu.properties");
                        mi.addListener(new MenuItemListener(){

                            public void selected(MenuItem menu, Object target) {
                                WebEngine web_engine;
                                String auth_str = String.valueOf(false);
                                String engine_str = engine.getNameEx();
                                if (engine instanceof WebEngine && (web_engine = (WebEngine)engine).isNeedsAuth()) {
                                    auth_str = String.valueOf(true) + ": cookies=" + this.toString(web_engine.getRequiredCookies());
                                }
                                String[] keys = new String[]{"subs.prop.template", "subs.prop.auth"};
                                String[] values = new String[]{engine_str, auth_str};
                                new PropertiesWindow(engine.getName(), keys, values);
                            }

                            private String toString(String[] strs) {
                                String res = "";
                                for (int i = 0; i < strs.length; ++i) {
                                    res = res + (i == 0 ? "" : ",") + strs[i];
                                }
                                return res;
                            }
                        });
                        if (engine_menu.getItems().length != 0) continue;
                        engine_menu.setEnabled(false);
                    }
                }
            });
            MenuItem export_menu = menuManager.addMenuItem("sidebar.Search", "search.export.all");
            export_menu.setStyle(1);
            export_menu.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    final Shell shell = Utils.findAnyShell();
                    shell.getDisplay().asyncExec((Runnable)new AERunnable(){

                        public void runSupport() {
                            FileDialog dialog = new FileDialog(shell, 139264);
                            dialog.setFilterPath(TorrentOpener.getFilterPathData());
                            dialog.setText(MessageText.getString("metasearch.export.select.template.file"));
                            dialog.setFilterExtensions(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                            dialog.setFilterNames(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                            String path = TorrentOpener.setFilterPathData(dialog.open());
                            if (path != null) {
                                String lc = path.toLowerCase();
                                if (!lc.endsWith(".vuze") && !lc.endsWith(".vuz")) {
                                    path = path + ".vuze";
                                }
                                try {
                                    MetaSearchManagerFactory.getSingleton().getMetaSearch().exportEngines(new File(path));
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    private void createBrowseArea(SWTSkinObjectBrowser browserSkinObject) {
        MdiEntry entry;
        this.browserSkinObject = browserSkinObject;
        browserSkinObject.getContext().addMessageListener(new MetaSearchListener(this));
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null && (entry = mdi.getEntryBySkinView(this)) != null) {
            this.vitalityImage = entry.addVitalityImage("image.sidebar.vitality.dots");
            if (this.vitalityImage != null) {
                this.vitalityImage.setVisible(false);
            }
        }
        browserSkinObject.addListener(new BrowserContext.loadingListener(){

            public void browserLoadingChanged(boolean loading, String url) {
                if (SearchResultsTabArea.this.vitalityImage != null) {
                    SearchResultsTabArea.this.vitalityImage.setVisible(loading);
                }
            }
        });
        SWTSkinObject soSearchResults = this.getSkinObject("searchresults-search-results");
        if (soSearchResults instanceof SWTSkinObjectBrowser) {
            SWTSkinObjectBrowser browserSearchResults = (SWTSkinObjectBrowser)soSearchResults;
            browserSearchResults.addListener(new BrowserContext.loadingListener(){

                public void browserLoadingChanged(boolean loading, String url) {
                    if (SearchResultsTabArea.this.vitalityImage != null) {
                        SearchResultsTabArea.this.vitalityImage.setVisible(loading);
                    }
                }
            });
        }
    }

    public void restart() {
        if (this.browserSkinObject != null) {
            this.browserSkinObject.restart();
        }
    }

    public void openSearchResults(final Map params) {
        if (!this.searchResultsInitialized) {
            this.searchResultsInitialized = true;
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    SWTSkinObject soSearchResults = SearchResultsTabArea.this.getSkinObject("searchresults-search-results");
                    if (soSearchResults != null) {
                        SWTSkinObjectBrowser browserSkinObject = (SWTSkinObjectBrowser)soSearchResults;
                        final BrowserWrapper browser = browserSkinObject.getBrowser();
                        browser.addTitleListener(new TitleListener(){

                            public void changed(TitleEvent event2) {
                                if (event2.widget.isDisposed() || browser.getShell().isDisposed()) {
                                    return;
                                }
                                SearchResultsTabArea.this.title = event2.title;
                                int i = SearchResultsTabArea.this.title.toLowerCase().indexOf("details:");
                                if (i > 0) {
                                    SearchResultsTabArea.this.title = SearchResultsTabArea.this.title.substring(i + 9);
                                }
                            }
                        });
                        ExternalLoginCookieListener cookieListener = new ExternalLoginCookieListener(new CookiesListener(){

                            public void cookiesFound(String cookies) {
                                browser.setData("current-cookies", cookies);
                            }
                        }, browser);
                        cookieListener.hook();
                    }
                }
            });
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                String listenerAdded;
                SWTSkinObject soSearchResults = SearchResultsTabArea.this.getSkinObject("searchresults-search-results");
                if (soSearchResults == null) {
                    return;
                }
                Control controlTop = SearchResultsTabArea.this.browserSkinObject.getControl();
                Control controlBottom = soSearchResults.getControl();
                final BrowserWrapper search = ((SWTSkinObjectBrowser)soSearchResults).getBrowser();
                String url = MapUtils.getMapString(params, "url", "http://google.com/search?q=" + Math.random());
                if (UrlFilter.getInstance().urlCanRPC(url)) {
                    url = ConstantsVuze.getDefaultContentNetwork().appendURLSuffix(url, false, true);
                }
                if ((listenerAdded = (String)search.getData("g.nt.la")) == null) {
                    search.setData("g.nt.la", "");
                    search.addProgressListener(new ProgressListener(){

                        public void changed(ProgressEvent event2) {
                        }

                        public void completed(ProgressEvent event2) {
                            String execAfterLoad = (String)search.getData("execAfterLoad");
                            search.setData("execAfterLoad", null);
                            if (execAfterLoad != null && !execAfterLoad.equals("")) {
                                boolean bl = search.execute(execAfterLoad);
                            }
                        }
                    });
                }
                String execAfterLoad = MapUtils.getMapString(params, "execAfterLoad", null);
                search.setData("execAfterLoad", execAfterLoad);
                search.setUrl(url);
                FormData gd = (FormData)controlBottom.getLayoutData();
                gd.top = new FormAttachment(controlTop, 0);
                gd.height = -1;
                controlBottom.setLayoutData((Object)gd);
                gd = (FormData)controlTop.getLayoutData();
                gd.bottom = null;
                gd.height = MapUtils.getMapInt(params, "top-height", 120);
                controlTop.setLayoutData((Object)gd);
                soSearchResults.setVisible(true);
                controlBottom.setVisible(true);
                search.setVisible(true);
                controlTop.getParent().layout(true);
            }
        });
    }

    public void closeSearchResults(Map params) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                BrowserContext context2;
                SWTSkinObject soSearchResults = SearchResultsTabArea.this.skin.getSkinObject("searchresults-search-results");
                if (soSearchResults == null) {
                    return;
                }
                Control controlTop = SearchResultsTabArea.this.browserSkinObject.getControl();
                Control controlBottom = soSearchResults.getControl();
                BrowserWrapper search = ((SWTSkinObjectBrowser)soSearchResults).getBrowser();
                soSearchResults.setVisible(false);
                FormData gd = (FormData)controlBottom.getLayoutData();
                if (gd == null) {
                    return;
                }
                gd.top = null;
                gd.height = 0;
                controlBottom.setLayoutData((Object)gd);
                gd = (FormData)controlTop.getLayoutData();
                gd.bottom = new FormAttachment(controlBottom, 0);
                gd.height = -1;
                controlTop.setLayoutData((Object)gd);
                controlBottom.getParent().layout(true);
                if (search != null) {
                    search.setUrl("about:blank");
                }
                if ((context2 = SearchResultsTabArea.this.browserSkinObject.getContext()) != null) {
                    context2.executeInBrowser("searchResultsClosed()");
                }
            }
        });
    }

    public void resizeMainBrowser() {
    }

    public void resizeSecondaryBrowser() {
    }

    public Object dataSourceChanged(SWTSkinObject skinObject, Object params) {
        if (params instanceof SearchQuery) {
            this.sq = (SearchQuery)params;
            if (this.browserSkinObject != null) {
                this.anotherSearch(this.sq.term, this.sq.toSubscribe);
            }
        }
        return null;
    }

    public void anotherSearch(String searchText, boolean toSubscribe) {
        this.anotherSearch(new SearchQuery(searchText, toSubscribe));
    }

    public void anotherSearch(SearchQuery sq) {
        this.sq = sq;
        String url = System.getProperty("metasearch", "1").equals("1") ? ConstantsVuze.getDefaultContentNetwork().getXSearchService(sq.term, sq.toSubscribe) : ConstantsVuze.getDefaultContentNetwork().getSearchService(sq.term);
        AEProxyFactory.PluginHTTPProxy proxy = SearchResultsTabArea.getSearchProxy(this);
        if (proxy != null) {
            url = proxy.proxifyURL(url);
        }
        this.closeSearchResults(null);
        if (Utils.isThisThreadSWT()) {
            try {
                this.browserSkinObject.getBrowser().setText("");
                final BrowserWrapper browser = this.browserSkinObject.getBrowser();
                final boolean[] done = new boolean[]{false};
                browser.addLocationListener(new LocationListener(){

                    public void changing(LocationEvent event2) {
                    }

                    public void changed(LocationEvent event2) {
                        done[0] = true;
                        browser.removeLocationListener(this);
                    }
                });
                this.browserSkinObject.getBrowser().setUrl("about:blank");
                this.browserSkinObject.getBrowser().refresh();
                this.browserSkinObject.getBrowser().update();
                Display display = Utils.getDisplay();
                if (display != null) {
                    long until = SystemTime.getCurrentTime() + 300L;
                    while (!done[0] && until > SystemTime.getCurrentTime()) {
                        if (display.readAndDispatch()) continue;
                        display.sleep();
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.browserSkinObject.setURL(url);
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        String id = "Search";
        MdiEntry entry = mdi.getEntry(id);
        if (entry != null) {
            ViewTitleInfoManager.refreshTitleInfo(entry.getViewTitleInfo());
        }
    }

    static {
        search_proxy_sem = new AESemaphore("sps");
        pending = new ArrayList<SearchResultsTabArea>();
        COConfigurationManager.addParameterListener("browser.internal.proxy.id", new ParameterListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void parameterChanged(String parameterName) {
                Class<SearchResultsTabArea> clazz = SearchResultsTabArea.class;
                synchronized (SearchResultsTabArea.class) {
                    if (!search_proxy_init_done) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    search_proxy_init_done = false;
                    search_proxy_set = false;
                    if (search_proxy != null) {
                        search_proxy.destroy();
                        search_proxy = null;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public static class SearchQuery {
        public String term;
        public boolean toSubscribe;

        public SearchQuery(String term, boolean toSubscribe) {
            this.term = term;
            this.toSubscribe = toSubscribe;
        }
    }
}

