/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.ui.UIFunctionsUserPrompter;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectImage;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import com.aelitis.azureus.ui.swt.views.skin.StandardButtonsArea;
import com.aelitis.azureus.ui.swt.views.skin.VuzeMessageBoxListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VuzeMessageBox
implements UIFunctionsUserPrompter,
SkinnedDialog.SkinnedDialogClosedListener {
    private String title;
    private String text;
    private int result = -1;
    private ArrayList<UserPrompterResultListener> resultListeners = new ArrayList(1);
    private VuzeMessageBoxListener vuzeMessageBoxListener;
    private SWTSkinObjectContainer soExtra;
    private SkinnedDialog dlg;
    private String iconResource;
    private String subtitle;
    private List<rbInfo> listRBs = new ArrayList<rbInfo>();
    private SWTSkin skin;
    private String textIconResource;
    private boolean closed;
    private boolean opened;
    private StandardButtonsArea buttonsArea;

    public VuzeMessageBox(String title, String text, String[] buttons, int defaultOption) {
        this.title = title;
        this.text = text;
        this.buttonsArea = new StandardButtonsArea(){

            protected void clicked(int buttonValue) {
                VuzeMessageBox.this.closeWithButtonVal(buttonValue);
            }
        };
        this.buttonsArea.setButtonIDs(buttons);
        this.buttonsArea.setDefaultButtonPos(defaultOption);
    }

    public void setButtonEnabled(int buttonVal, boolean enable) {
        this.buttonsArea.setButtonEnabled(buttonVal, enable);
    }

    public void setButtonVals(Integer[] buttonVals) {
        this.buttonsArea.setButtonVals(buttonVals);
    }

    public void setSubTitle(String s) {
        this.subtitle = s;
    }

    @Override
    public int getAutoCloseInMS() {
        return 0;
    }

    @Override
    public String getHtml() {
        return null;
    }

    @Override
    public String getRememberID() {
        return null;
    }

    @Override
    public String getRememberText() {
        return null;
    }

    @Override
    public boolean isAutoClosed() {
        return false;
    }

    @Override
    public void open(final UserPrompterResultListener l) {
        this.opened = true;
        Utils.execSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                if (VuzeMessageBox.this.closed) {
                    return;
                }
                VuzeMessageBox vuzeMessageBox = VuzeMessageBox.this;
                synchronized (vuzeMessageBox) {
                    VuzeMessageBox.this._open(l);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _open(UserPrompterResultListener l) {
        SWTSkinObjectContainer soBottomArea;
        SWTSkinObjectImage soIcon;
        SWTSkinObjectImage soTopLogo;
        SWTSkinObjectText soText;
        if (l != null) {
            ArrayList<UserPrompterResultListener> arrayList = this.resultListeners;
            synchronized (arrayList) {
                this.resultListeners.add(l);
            }
        }
        this.dlg = new SkinnedDialog("skin3_dlg_generic", "shell", 2144){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void setSkin(SWTSkin skin) {
                super.setSkin(skin);
                VuzeMessageBox.this.skin = skin;
                List list = VuzeMessageBox.this.listRBs;
                synchronized (list) {
                    for (rbInfo rb : VuzeMessageBox.this.listRBs) {
                        VuzeMessageBox.this.addResourceBundle(rb.cla, rb.path, rb.name);
                    }
                    VuzeMessageBox.this.listRBs.clear();
                }
            }
        };
        this.dlg.setTitle(this.title);
        this.dlg.addCloseListener(this);
        SWTSkinObjectText soTopTitle = (SWTSkinObjectText)this.skin.getSkinObject("top-title");
        if (soTopTitle != null) {
            soTopTitle.setText(this.subtitle == null ? this.title : this.subtitle);
        }
        if ((soText = (SWTSkinObjectText)this.skin.getSkinObject("middle-title")) != null) {
            soText.setText(this.text);
        }
        if (this.iconResource != null && (soTopLogo = (SWTSkinObjectImage)this.dlg.getSkin().getSkinObject("top-logo")) != null) {
            soTopLogo.setImageByID(this.iconResource, null);
        }
        if (this.textIconResource != null && (soIcon = (SWTSkinObjectImage)this.dlg.getSkin().getSkinObject("text-icon")) != null) {
            soIcon.setImageByID(this.textIconResource, null);
        }
        if (this.iconResource == null && this.textIconResource == null && soTopTitle != null && soText != null) {
            soTopTitle.setStyle(soText.getStyle() & 0xFEFDFFFF);
        }
        if ((soBottomArea = (SWTSkinObjectContainer)this.skin.getSkinObject("bottom-area")) != null) {
            if (this.buttonsArea.getButtonCount() == 0) {
                soBottomArea.setVisible(false);
            } else {
                this.buttonsArea.swt_createButtons(soBottomArea.getComposite());
            }
        }
        if (this.vuzeMessageBoxListener != null) {
            this.soExtra = (SWTSkinObjectContainer)this.skin.getSkinObject("middle-extra");
            try {
                this.vuzeMessageBoxListener.shellReady(this.dlg.getShell(), this.soExtra);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        if (this.closed) {
            return;
        }
        this.dlg.open();
    }

    public Button[] getButtons() {
        return this.buttonsArea.getButtons();
    }

    @Override
    public void setAutoCloseInMS(int autoCloseInMS) {
    }

    @Override
    public void setHtml(String html) {
    }

    @Override
    public void setIconResource(String resource) {
        SWTSkinObjectImage soTopLogo;
        this.iconResource = resource;
        if (this.dlg != null && (soTopLogo = (SWTSkinObjectImage)this.dlg.getSkin().getSkinObject("top-logo")) != null) {
            soTopLogo.setImageByID(this.iconResource, null);
        }
    }

    @Override
    public void setRelatedObject(Object relatedObject) {
    }

    @Override
    public void setRelatedObjects(Object[] relatedObjects) {
    }

    @Override
    public void setRemember(String rememberID, boolean rememberByDefault, String rememberText) {
    }

    @Override
    public void setRememberText(String rememberText) {
    }

    @Override
    public void setUrl(String url) {
    }

    @Override
    public int waitUntilClosed() {
        if (this.opened) {
            final AESemaphore2 sem = new AESemaphore2("waitUntilClosed");
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    Shell shell;
                    if (VuzeMessageBox.this.dlg == null) {
                        sem.release();
                        return;
                    }
                    if (!VuzeMessageBox.this.opened) {
                        VuzeMessageBox.this.dlg.open();
                    }
                    if ((shell = VuzeMessageBox.this.dlg.getShell()) == null || shell.isDisposed()) {
                        sem.release();
                        return;
                    }
                    shell.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            sem.release();
                        }
                    });
                }
            });
            if (Utils.isThisThreadSWT() && this.dlg != null) {
                Shell shell = this.dlg.getShell();
                if (shell != null) {
                    Display d = shell.getDisplay();
                    while (!shell.isDisposed()) {
                        if (d.readAndDispatch()) continue;
                        d.sleep();
                    }
                }
                return this.buttonsArea.getButtonVal(this.result);
            }
            sem.reserve();
        }
        return this.buttonsArea.getButtonVal(this.result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skinDialogClosed(SkinnedDialog dialog) {
        ArrayList<UserPrompterResultListener> arrayList = this.resultListeners;
        synchronized (arrayList) {
            int realResult = this.buttonsArea.getButtonVal(this.result);
            for (UserPrompterResultListener l : this.resultListeners) {
                try {
                    l.prompterClosed(realResult);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    public void setListener(VuzeMessageBoxListener l) {
        this.vuzeMessageBoxListener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int buttonNo) {
        VuzeMessageBox vuzeMessageBox = this;
        synchronized (vuzeMessageBox) {
            this.closed = true;
            this.result = buttonNo;
            if (this.dlg != null) {
                this.dlg.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWithButtonVal(int buttonVal) {
        VuzeMessageBox vuzeMessageBox = this;
        synchronized (vuzeMessageBox) {
            this.closed = true;
            this.result = this.buttonsArea.getButtonPosFromVal(buttonVal);
            if (this.dlg != null) {
                this.dlg.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceBundle(Class<?> cla, String path, String name) {
        List<rbInfo> list = this.listRBs;
        synchronized (list) {
            if (this.skin == null) {
                this.listRBs.add(new rbInfo(cla, path, name));
                return;
            }
        }
        String sFile = path + name;
        ClassLoader loader = cla.getClassLoader();
        ResourceBundle subBundle = ResourceBundle.getBundle(sFile, Locale.getDefault(), loader);
        SWTSkinProperties skinProperties = this.skin.getSkinProperties();
        skinProperties.addResourceBundle(subBundle, path, loader);
    }

    public void setTextIconResource(String resource) {
        SWTSkinObjectImage soIcon;
        this.textIconResource = resource;
        if (this.dlg != null && (soIcon = (SWTSkinObjectImage)this.dlg.getSkin().getSkinObject("text-icon")) != null) {
            soIcon.setImageByID(this.textIconResource, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(UserPrompterResultListener l) {
        if (l == null) {
            return;
        }
        ArrayList<UserPrompterResultListener> arrayList = this.resultListeners;
        synchronized (arrayList) {
            this.resultListeners.add(l);
        }
    }

    public void setDefaultButtonByPos(int pos) {
        if (this.dlg == null) {
            this.buttonsArea.setDefaultButtonPos(pos);
        }
    }

    @Override
    public void setOneInstanceOf(String instanceID) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class rbInfo {
        Class<?> cla;
        String path;
        String name;

        public rbInfo(Class<?> cla, String path, String name) {
            this.cla = cla;
            this.path = path;
            this.name = name;
        }
    }
}

