/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.download.StreamManager;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.util.DataSourceUtils;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class PlayUtils {
    public static final boolean COMPLETE_PLAY_ONLY = true;
    public static final int fileSizeThreshold = 90;
    public static final String playableFileExtensions = ".avi .flv .flc .mp4 .divx .h264 .mkv .mov .mp2 .m4v .mp3 .aac, .mts, .m2ts";
    private static volatile String actualPlayableFileExtensions = ".avi .flv .flc .mp4 .divx .h264 .mkv .mov .mp2 .m4v .mp3 .aac, .mts, .m2ts";
    private static Boolean hasQuickTime;
    private static AtomicInteger dm_uid;
    private static Map<String, Object[]> ext_play_cache;

    public static boolean prepareForPlay(DownloadManager dm) {
        EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(dm);
        if (edm != null) {
            edm.setProgressiveMode(true);
            return true;
        }
        return false;
    }

    public static boolean canProgressiveOrIsComplete(TOTorrent torrent) {
        if (torrent == null) {
            return false;
        }
        try {
            DownloadManagerEnhancer enhancer = DownloadManagerEnhancer.getSingleton();
            EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(torrent.getHash());
            if (edm == null) {
                return enhancer.isProgressiveAvailable() && PlatformTorrentUtils.isContentProgressive(torrent);
            }
            boolean complete = edm.getDownloadManager().isDownloadComplete(false);
            if (complete) {
                return true;
            }
            if (!edm.supportsProgressiveMode()) {
                return false;
            }
        }
        catch (TOTorrentException e) {
            return false;
        }
        return true;
    }

    public static boolean canUseEMP(DiskManagerFileInfo file) {
        return PlayUtils.isExternallyPlayable(file);
    }

    public static boolean canUseEMP(TOTorrent torrent, int file_index) {
        return PlayUtils.canUseEMP(torrent, file_index, true);
    }

    public static boolean canUseEMP(TOTorrent torrent, int file_index, boolean complete_only) {
        if (torrent == null) {
            return false;
        }
        return PlayUtils.canPlayViaExternalEMP(torrent, file_index, complete_only);
    }

    private static boolean canPlay(DownloadManager dm, int file_index) {
        if (dm == null) {
            return false;
        }
        TOTorrent torrent = dm.getTorrent();
        return PlayUtils.canUseEMP(torrent, file_index);
    }

    private static boolean canPlay(TOTorrent torrent, int file_index) {
        if (!PlatformTorrentUtils.isContent(torrent, false)) {
            return false;
        }
        if (!AzureusCoreFactory.isCoreRunning()) {
            return false;
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        DownloadManager dm = gm.getDownloadManager(torrent);
        if (dm != null) {
            return dm.getAssumedComplete() || PlayUtils.canUseEMP(torrent, file_index);
        }
        return PlayUtils.canUseEMP(torrent, file_index);
    }

    public static boolean canPlayDS(Object ds, int file_index) {
        if (!Constants.isWindows && !Constants.isOSX) {
            return false;
        }
        if (ds == null) {
            return false;
        }
        if (ds instanceof org.gudy.azureus2.core3.disk.DiskManagerFileInfo) {
            org.gudy.azureus2.core3.disk.DiskManagerFileInfo fi = (org.gudy.azureus2.core3.disk.DiskManagerFileInfo)ds;
            return PlayUtils.canPlayDS(fi.getDownloadManager(), fi.getIndex());
        }
        DownloadManager dm = DataSourceUtils.getDM(ds);
        if (dm != null) {
            return PlayUtils.canPlay(dm, file_index);
        }
        TOTorrent torrent = DataSourceUtils.getTorrent(ds);
        if (torrent != null) {
            return PlayUtils.canPlay(torrent, file_index);
        }
        if (ds instanceof VuzeActivitiesEntry) {
            return ((VuzeActivitiesEntry)ds).isPlayable();
        }
        if (ds instanceof SelectedContentV3) {
            SelectedContentV3 sel = (SelectedContentV3)ds;
            return sel.canPlay();
        }
        return false;
    }

    public static boolean isStreamPermitted() {
        return true;
    }

    private static boolean canStream(DownloadManager dm, int file_index) {
        org.gudy.azureus2.core3.disk.DiskManagerFileInfo file;
        if (dm == null) {
            return false;
        }
        if (file_index == -1) {
            file = dm.getDownloadState().getPrimaryFile();
            if (file == null) {
                org.gudy.azureus2.core3.disk.DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                if (files.length == 0) {
                    return false;
                }
                file = files[0];
            }
            file_index = file.getIndex();
        } else {
            file = dm.getDiskManagerFileInfoSet().getFiles()[file_index];
        }
        if (file.getDownloaded() == file.getLength()) {
            return false;
        }
        if (!StreamManager.getSingleton().isStreamingUsable()) {
            return false;
        }
        TOTorrent torrent = dm.getTorrent();
        return PlayUtils.canUseEMP(torrent, file_index, false);
    }

    public static boolean canStreamDS(Object ds, int file_index) {
        if (!Constants.isWindows && !Constants.isOSX) {
            return false;
        }
        if (ds == null) {
            return false;
        }
        if (ds instanceof org.gudy.azureus2.core3.disk.DiskManagerFileInfo) {
            org.gudy.azureus2.core3.disk.DiskManagerFileInfo fi = (org.gudy.azureus2.core3.disk.DiskManagerFileInfo)ds;
            return PlayUtils.canStreamDS(fi.getDownloadManager(), fi.getIndex());
        }
        DownloadManager dm = DataSourceUtils.getDM(ds);
        if (dm != null) {
            return PlayUtils.canStream(dm, file_index);
        }
        return false;
    }

    public static URL getMediaServerContentURL(DiskManagerFileInfo file) {
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getPluginInterfaceByID("azupnpav", false);
        if (pi == null) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not found"));
            return null;
        }
        if (!pi.getPluginState().isOperational()) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not operational"));
            return null;
        }
        try {
            Object url;
            UIFunctions uif;
            if (hasQuickTime == null && (uif = UIFunctionsManager.getUIFunctions()) != null) {
                hasQuickTime = uif.isProgramInstalled(".qtl", "Quicktime");
                try {
                    pi.getIPC().invoke("setQuickTimeAvailable", new Object[]{hasQuickTime});
                }
                catch (Throwable e) {
                    Logger.log(new LogEvent(LogIDs.UI3, 1, "IPC to media server plugin failed", e));
                }
            }
            if ((url = pi.getIPC().invoke("getContentURL", new Object[]{file})) instanceof String) {
                return new URL((String)url);
            }
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LogIDs.UI3, 1, "IPC to media server plugin failed", e));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExternallyPlayable(Download d, int file_index, boolean complete_only) {
        if (d == null) {
            return false;
        }
        boolean use_cache = d.getState() != 4;
        String cache_key = null;
        long now = 0L;
        if (use_cache) {
            Object[] cached;
            Integer uid = (Integer)d.getUserData(PlayUtils.class);
            if (uid == null) {
                uid = dm_uid.getAndIncrement();
                d.setUserData(PlayUtils.class, uid);
            }
            cache_key = uid + "/" + file_index + "/" + complete_only;
            Map<String, Object[]> map = ext_play_cache;
            synchronized (map) {
                cached = ext_play_cache.get(cache_key);
            }
            now = SystemTime.getMonotonousTime();
            if (cached != null && now - (Long)cached[0] < 60000L) {
                return (Boolean)cached[1];
            }
        }
        boolean result = PlayUtils.isExternallyPlayableSupport(d, file_index, complete_only);
        if (use_cache) {
            Map<String, Object[]> map = ext_play_cache;
            synchronized (map) {
                ext_play_cache.put(cache_key, new Object[]{now, result});
            }
        }
        return result;
    }

    private static boolean isExternallyPlayableSupport(Download d, int file_index, boolean complete_only) {
        int primary_file_index = -1;
        if (file_index == -1) {
            DownloadManager dm = PluginCoreUtils.unwrap(d);
            if (dm == null) {
                return false;
            }
            DiskManagerFileInfo file = null;
            try {
                file = PluginCoreUtils.wrap(dm.getDownloadState().getPrimaryFile());
            }
            catch (DownloadException e) {
                return false;
            }
            if (file == null) {
                return false;
            }
            if (file.getDownloaded() != file.getLength() && (complete_only || PlayUtils.getMediaServerContentURL(file) == null)) {
                return false;
            }
            primary_file_index = file.getIndex();
        } else {
            DiskManagerFileInfo file = d.getDiskManagerFileInfo(file_index);
            if (file.getDownloaded() != file.getLength() && (complete_only || PlayUtils.getMediaServerContentURL(file) == null)) {
                return false;
            }
            primary_file_index = file_index;
        }
        if (primary_file_index == -1) {
            return false;
        }
        return PlayUtils.isExternallyPlayable(d.getDiskManagerFileInfo()[primary_file_index]);
    }

    public static int[] getExternallyPlayableFileIndexes(Download d, boolean complete_only) {
        DiskManagerFileInfo[] fileInfos = d.getDiskManagerFileInfo();
        int count = d.getDiskManagerFileCount();
        int[] playableIndexes = new int[]{};
        for (int i = 0; i < count; ++i) {
            DiskManagerFileInfo fileInfo2 = d.getDiskManagerFileInfo(i);
            if (complete_only && fileInfo2.getLength() != fileInfo2.getDownloaded() || !PlayUtils.isExternallyPlayable(fileInfo2)) continue;
            int[] newPlayableIndexes = new int[playableIndexes.length + 1];
            System.arraycopy(playableIndexes, 0, newPlayableIndexes, 0, playableIndexes.length);
            newPlayableIndexes[playableIndexes.length] = i;
            playableIndexes = newPlayableIndexes;
        }
        return playableIndexes;
    }

    private static boolean isExternallyPlayable(DiskManagerFileInfo file) {
        String name = file.getFile(true).getName();
        try {
            String is;
            Download dl = file.getDownload();
            if (dl != null && (is = PluginCoreUtils.unwrap(dl).getDownloadState().getAttribute("incompfilesuffix")) != null && name.endsWith(is)) {
                name = name.substring(0, name.length() - is.length());
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        int extIndex = name.lastIndexOf(".");
        if (extIndex > -1) {
            String ext = name.substring(extIndex);
            if (ext == null) {
                return false;
            }
            ext = ext.toLowerCase();
            if (PlayUtils.getPlayableFileExtensions().indexOf(ext) > -1) {
                return true;
            }
        }
        return false;
    }

    public static boolean isExternallyPlayable(TOTorrent torrent, int file_index, boolean complete_only) {
        if (torrent == null) {
            return false;
        }
        try {
            Download download = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getDownloadManager().getDownload(torrent.getHash());
            if (download != null) {
                return PlayUtils.isExternallyPlayable(download, file_index, complete_only);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static final boolean canPlayViaExternalEMP(TOTorrent torrent, int file_index, boolean complete_only) {
        if (torrent == null) {
            return false;
        }
        return PlayUtils.isExternallyPlayable(torrent, file_index, complete_only);
    }

    public static String getPlayableFileExtensions() {
        return actualPlayableFileExtensions;
    }

    public static void setPlayableFileExtensions(String str) {
        actualPlayableFileExtensions = str;
    }

    public static int getPrimaryFileIndex(Download dl) {
        EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(PluginCoreUtils.unwrap(dl));
        if (edm == null) {
            return -1;
        }
        return edm.getPrimaryFileIndex();
    }

    public static boolean isEMPAvailable() {
        PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp");
        return pi != null && !pi.getPluginState().isDisabled();
    }

    public static boolean playURL(URL url, String name) {
        try {
            Method ow;
            PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp");
            if (pi == null || pi.getPluginState().isDisabled()) {
                return false;
            }
            Class<?> ewp_class = pi.getPlugin().getClass().getClassLoader().loadClass("com.azureus.plugins.azemp.ui.swt.emp.EmbeddedPlayerWindowSWT");
            if (ewp_class != null && (ow = ewp_class.getMethod("openWindow", URL.class, String.class)) != null) {
                ow.invoke(null, url, name);
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    static {
        dm_uid = new AtomicInteger();
        ext_play_cache = new LinkedHashMap<String, Object[]>(100, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Object[]> eldest) {
                return this.size() > 100;
            }
        };
    }
}

