/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.natpmp.impl;

import com.aelitis.azureus.core.util.NetUtils;
import com.aelitis.net.natpmp.NATPMPDeviceAdapter;
import com.aelitis.net.natpmp.NatPMPDevice;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.SocketTimeoutException;

public class NatPMPDeviceImpl
implements NatPMPDevice {
    static final int NATMAP_VER = 0;
    static final int NATMAP_PORT = 5351;
    static final int NATMAP_RESPONSE_MASK = 128;
    static final int NATMAP_INIT_RETRY = 250;
    static final int NATMAP_MAX_RETRY = 2250;
    static final int NATMAP_DEFAULT_LEASE = 86400;
    static final String NATMAP_LLM = "224.0.0.1";
    static final byte NATOp_AddrRequest = 0;
    static final byte NATOp_MapUDP = 1;
    static final byte NATOp_MapTCP = 2;
    static final int NATAddrRequest = 2;
    static final int NATPortMapRequestLen = 12;
    static final int NATAddrReplyLen = 12;
    static final int NATPortMapReplyLen = 16;
    static final int NATResultSuccess = 0;
    static final int NATResultUnsupportedVer = 1;
    static final int NATResultNotAuth = 2;
    static final int NATResultNetFailure = 3;
    static final int NATResultNoResc = 4;
    static final int NATResultUnsupportedOp = 5;
    private String current_router_address = "?";
    private InetAddress hostInet;
    private InetAddress natPriInet;
    private InetAddress natPubInet;
    private NetworkInterface networkInterface;
    private int nat_epoch = 0;
    private NATPMPDeviceAdapter adapter;
    private static NatPMPDeviceImpl NatPMPDeviceSingletonRef;

    public static synchronized NatPMPDeviceImpl getSingletonObject(NATPMPDeviceAdapter adapter) throws Exception {
        if (NatPMPDeviceSingletonRef == null) {
            NatPMPDeviceSingletonRef = new NatPMPDeviceImpl(adapter);
        }
        return NatPMPDeviceSingletonRef;
    }

    private NatPMPDeviceImpl(NATPMPDeviceAdapter _adapter) throws Exception {
        this.adapter = _adapter;
        this.hostInet = NetUtils.getLocalHost();
        this.checkRouterAddress();
    }

    protected void checkRouterAddress() throws Exception {
        String natAddr = this.adapter.getRouterAddress().trim();
        if (natAddr.length() == 0) {
            natAddr = this.convertHost2RouterAddress(this.hostInet);
        }
        if (natAddr.equals(this.current_router_address)) {
            return;
        }
        this.current_router_address = natAddr;
        this.log("Using Router IP: " + natAddr);
        this.natPriInet = InetAddress.getByName(natAddr);
        this.networkInterface = NetworkInterface.getByInetAddress(this.natPriInet);
    }

    public DatagramPacket sendNATMsg(InetAddress dstInet, DatagramPacket dstPkt, byte[] recBuf) throws Exception {
        int retryInterval = 250;
        boolean recRep = false;
        DatagramSocket skt = new DatagramSocket();
        skt.connect(dstInet, 5351);
        skt.setSoTimeout(250);
        skt.send(dstPkt);
        DatagramPacket recPkt = new DatagramPacket(recBuf, recBuf.length);
        while (!recRep && retryInterval < 2250) {
            try {
                skt.receive(recPkt);
                recRep = true;
            }
            catch (SocketTimeoutException ste) {
                Thread.sleep(retryInterval);
                retryInterval += retryInterval * 2;
            }
        }
        if (!recRep) {
            throw new PortUnreachableException();
        }
        return recPkt;
    }

    public boolean connect() throws Exception {
        this.checkRouterAddress();
        try {
            byte[] reqBuf = new byte[]{0, 0};
            DatagramPacket dstPkt = new DatagramPacket(reqBuf, reqBuf.length);
            byte[] recBuf = new byte[12];
            this.sendNATMsg(this.natPriInet, dstPkt, recBuf);
            int recErr = NatPMPDeviceImpl.unsigned16ByteArrayToInt(recBuf, 2);
            int recEpoch = NatPMPDeviceImpl.unsigned32ByteArrayToInt(recBuf, 4);
            String recPubAddr = NatPMPDeviceImpl.unsigned8ByteArrayToInt(recBuf, 8) + "." + NatPMPDeviceImpl.unsigned8ByteArrayToInt(recBuf, 9) + "." + NatPMPDeviceImpl.unsigned8ByteArrayToInt(recBuf, 10) + "." + NatPMPDeviceImpl.unsigned8ByteArrayToInt(recBuf, 11);
            this.natPubInet = InetAddress.getByName(recPubAddr);
            this.nat_epoch = recEpoch;
            if (recErr != 0) {
                throw new Exception("NAT-PMP connection error: " + recErr);
            }
            this.log("Err: " + recErr);
            this.log("Uptime: " + recEpoch);
            this.log("Public Address: " + recPubAddr);
            return true;
        }
        catch (PortUnreachableException e) {
            return false;
        }
    }

    public int addPortMapping(boolean tcp, int publicPort, int privatePort) throws Exception {
        return this.portMappingProtocol(tcp, publicPort, privatePort, 86400);
    }

    public void deletePortMapping(boolean tcp, int publicPort, int privatePort) throws Exception {
        this.portMappingProtocol(tcp, publicPort, privatePort, 0);
    }

    public int portMappingProtocol(boolean tcp, int publicPort, int privatePort, int lifetime) throws Exception {
        int NATOp = tcp ? 2 : 1;
        byte[] pubPort = this.intToByteArray(publicPort);
        byte[] priPort = this.intToByteArray(privatePort);
        byte[] portLifeTime = this.intToByteArray(lifetime);
        byte[] dstBuf = new byte[12];
        dstBuf[0] = 0;
        dstBuf[1] = NATOp;
        dstBuf[2] = 0;
        dstBuf[3] = 0;
        dstBuf[4] = priPort[2];
        dstBuf[5] = priPort[3];
        dstBuf[6] = pubPort[2];
        dstBuf[7] = pubPort[3];
        for (int i = 0; i < 4; ++i) {
            dstBuf[8 + i] = portLifeTime[i];
        }
        DatagramPacket dstPkt = new DatagramPacket(dstBuf, dstBuf.length);
        byte[] recBuf = new byte[16];
        this.sendNATMsg(this.natPriInet, dstPkt, recBuf);
        int recOP = NatPMPDeviceImpl.unsigned8ByteArrayToInt(recBuf, 1);
        int recCode = NatPMPDeviceImpl.unsigned16ByteArrayToInt(recBuf, 2);
        int recEpoch = NatPMPDeviceImpl.unsigned32ByteArrayToInt(recBuf, 4);
        int recPubPort = NatPMPDeviceImpl.unsigned16ByteArrayToInt(recBuf, 10);
        int recLifetime = NatPMPDeviceImpl.unsigned32ByteArrayToInt(recBuf, 12);
        this.log("Seconds since Start of Epoch: " + recEpoch);
        this.log("Returned Mapped Port Lifetime: " + recLifetime);
        if (recCode != 0) {
            throw new Exception("An error occured while getting a port mapping: " + recCode);
        }
        if (recOP != NATOp + 128) {
            throw new Exception("Received the incorrect port type: " + recOP);
        }
        if (lifetime != recLifetime) {
            this.log("Received different port life time!");
        }
        return recPubPort;
    }

    public InetAddress getLocalAddress() {
        return this.hostInet;
    }

    public NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    public String getExternalIPAddress() {
        return this.natPubInet.getHostAddress();
    }

    public int getEpoch() {
        return this.nat_epoch;
    }

    protected void log(String str) {
        this.adapter.log(str);
    }

    public static int unsigned32ByteArrayToInt(byte[] b, int offset) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
        }
        return value;
    }

    public static int unsigned16ByteArrayToInt(byte[] b, int offset) {
        int value = 0;
        for (int i = 0; i < 2; ++i) {
            int shift = (1 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
        }
        return value;
    }

    public static int unsigned8ByteArrayToInt(byte[] b, int offset) {
        return b[offset] & 0xFF;
    }

    public short unsignedByteArrayToShort(byte[] buf) {
        if (buf.length == 2) {
            int i = (buf[0] & 0xFF) << 8 | buf[1] & 0xFF;
            return (short)i;
        }
        return -1;
    }

    public byte[] shortToByteArray(short v) {
        byte[] b = new byte[]{(byte)(0xFF & v >> 8), (byte)(0xFF & v >> 0)};
        return b;
    }

    public byte[] intToByteArray(int v) {
        byte[] b = new byte[4];
        int i = 0;
        int shift = 24;
        while (i < 4) {
            b[i] = (byte)(0xFF & v >> shift);
            ++i;
            shift -= 8;
        }
        return b;
    }

    public String intArrayString(int[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            sb.append(buf[i]).append(" ");
        }
        return sb.toString();
    }

    public String byteArrayString(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            sb.append(buf[i]).append(" ");
        }
        return sb.toString();
    }

    private String convertHost2RouterAddress(InetAddress inet) {
        byte[] rawIP = inet.getAddress();
        rawIP[3] = 1;
        String newIP = (rawIP[0] & 0xFF) + "." + (rawIP[1] & 0xFF) + "." + (rawIP[2] & 0xFF) + "." + (rawIP[3] & 0xFF);
        return newIP;
    }
}

