/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.device;

import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPRootDeviceListener;
import com.aelitis.net.upnp.impl.UPnPImpl;
import com.aelitis.net.upnp.impl.device.UPnPDeviceImpl;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UPnPRootDeviceImpl
implements UPnPRootDevice {
    public static final String[] ROUTERS = new String[]{"3Com ADSL 11g"};
    public static final String[] BAD_ROUTER_VERSIONS = new String[]{"2.05"};
    public static final boolean[] BAD_ROUTER_REPORT_FAIL = new boolean[]{true};
    private final UPnPImpl upnp;
    private final NetworkInterface network_interface;
    private final InetAddress local_address;
    private final String usn;
    private final URL location;
    private final List<URL> alt_locations = new ArrayList<URL>();
    private URL url_base_for_relative_urls;
    private URL saved_url_base_for_relative_urls;
    private String info;
    private UPnPDeviceImpl root_device;
    private boolean port_mapping_result_received;
    private boolean destroyed;
    private List listeners = new ArrayList();

    public UPnPRootDeviceImpl(UPnPImpl _upnp, NetworkInterface _network_interface, InetAddress _local_address, String _usn, URL _location) throws UPnPException {
        this.upnp = _upnp;
        this.network_interface = _network_interface;
        this.local_address = _local_address;
        this.usn = _usn;
        this.location = _location;
        SimpleXMLParserDocument doc = this.upnp.downloadXML(this, this.location);
        SimpleXMLParserDocumentNode url_base_node = doc.getChild("URLBase");
        try {
            String url_str;
            if (url_base_node != null && (url_str = url_base_node.getValue().trim()).length() > 0) {
                this.url_base_for_relative_urls = new URL(url_str);
            }
            this.upnp.log("Relative URL base is " + (this.url_base_for_relative_urls == null ? "unspecified" : this.url_base_for_relative_urls.toString()));
        }
        catch (MalformedURLException e) {
            this.upnp.log("Invalid URLBase - " + (url_base_node == null ? "mill" : url_base_node.getValue()));
            this.upnp.log(e);
            Debug.printStackTrace(e);
        }
        SimpleXMLParserDocumentNode device = doc.getChild("Device");
        if (device == null) {
            throw new UPnPException("Root device '" + this.usn + "(" + this.location + ") is missing the device description");
        }
        this.root_device = new UPnPDeviceImpl(this, "", device);
        this.info = this.root_device.getFriendlyName();
        String version = this.root_device.getModelNumber();
        if (version != null) {
            this.info = this.info + "/" + version;
        }
    }

    @Override
    public Map getDiscoveryCache() {
        try {
            HashMap<String, byte[]> cache = new HashMap<String, byte[]>();
            cache.put("ni", this.network_interface.getName().getBytes("UTF-8"));
            cache.put("la", this.local_address.getHostAddress().getBytes("UTF-8"));
            cache.put("usn", this.usn.getBytes("UTF-8"));
            cache.put("loc", this.location.toExternalForm().getBytes("UTF-8"));
            return cache;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public void portMappingResult(boolean ok) {
        if (this.port_mapping_result_received) {
            return;
        }
        this.port_mapping_result_received = true;
        this.info = ok ? this.info + "/OK" : this.info + "/Failed";
        String model = this.root_device.getModelName();
        String version = this.root_device.getModelNumber();
        if (model == null || version == null) {
            return;
        }
        for (int i = 0; i < ROUTERS.length; ++i) {
            if (!ROUTERS[i].equals(model) || !this.isBadVersion(version, BAD_ROUTER_VERSIONS[i])) continue;
            boolean report_on_fail = BAD_ROUTER_REPORT_FAIL[i];
            if (report_on_fail && ok) break;
            String url = this.root_device.getModelURL();
            this.upnp.logAlert("Device '" + model + "', version '" + version + "' has known problems with UPnP. Please update to the latest software version (see " + (url == null ? "the manufacturer's web site" : url) + ") and refer to http://wiki.vuze.com/w/UPnP", false, 3);
            break;
        }
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    protected String getAbsoluteURL(String url) {
        String lc_url = url.toLowerCase().trim();
        if (lc_url.startsWith("http://") || lc_url.startsWith("https://")) {
            return url;
        }
        if (this.url_base_for_relative_urls != null) {
            String abs_url = this.url_base_for_relative_urls.toString();
            if (!abs_url.endsWith("/")) {
                abs_url = abs_url + "/";
            }
            abs_url = url.startsWith("/") ? abs_url + url.substring(1) : abs_url + url;
            return abs_url;
        }
        String abs_url = this.location.toString();
        int p1 = abs_url.indexOf("://") + 3;
        p1 = abs_url.indexOf("/", p1);
        abs_url = abs_url.substring(0, p1);
        return abs_url + (url.startsWith("/") ? "" : "/") + url;
    }

    protected synchronized void clearRelativeBaseURL() {
        if (this.url_base_for_relative_urls != null) {
            this.saved_url_base_for_relative_urls = this.url_base_for_relative_urls;
            this.url_base_for_relative_urls = null;
        }
    }

    protected synchronized void restoreRelativeBaseURL() {
        if (this.saved_url_base_for_relative_urls != null) {
            this.url_base_for_relative_urls = this.saved_url_base_for_relative_urls;
            this.saved_url_base_for_relative_urls = null;
        }
    }

    @Override
    public UPnP getUPnP() {
        return this.upnp;
    }

    @Override
    public NetworkInterface getNetworkInterface() {
        return this.network_interface;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.local_address;
    }

    @Override
    public String getUSN() {
        return this.usn;
    }

    @Override
    public URL getLocation() {
        return this.location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAlternativeLocation(URL alt_location) {
        List<URL> list = this.alt_locations;
        synchronized (list) {
            if (!this.alt_locations.contains(alt_location)) {
                this.alt_locations.add(alt_location);
                if (this.alt_locations.size() > 10) {
                    this.alt_locations.remove(0);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> getAlternativeLocations() {
        List<URL> list = this.alt_locations;
        synchronized (list) {
            return new ArrayList<URL>(this.alt_locations);
        }
    }

    @Override
    public UPnPDevice getDevice() {
        return this.root_device;
    }

    public void destroy(boolean replaced) {
        this.destroyed = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((UPnPRootDeviceListener)this.listeners.get(i)).lost(this, replaced);
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void addListener(UPnPRootDeviceListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(UPnPRootDeviceListener l) {
        this.listeners.remove(l);
    }

    protected boolean isBadVersion(String current, String bad) {
        char c;
        int i;
        if (bad.equals("any")) {
            return true;
        }
        Comparator comp2 = this.upnp.getAdapter().getAlphanumericComparator();
        HashSet<Character> delimiters = new HashSet<Character>();
        char current_delim = '1';
        char bad_delim = '1';
        for (i = 0; i < current.length(); ++i) {
            c = current.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            delimiters.add(new Character(c));
            current_delim = c;
        }
        for (i = 0; i < bad.length(); ++i) {
            c = bad.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            delimiters.add(new Character(c));
            bad_delim = c;
        }
        if (delimiters.size() != 1 || current_delim != bad_delim) {
            return comp2.compare(current, bad) <= 0;
        }
        StringTokenizer current_tk = new StringTokenizer(current, "" + current_delim);
        StringTokenizer bad_tk = new StringTokenizer(bad, "" + bad_delim);
        int num_current = current_tk.countTokens();
        int num_bad = bad_tk.countTokens();
        for (int i2 = 0; i2 < Math.min(num_current, num_bad); ++i2) {
            String bad_token;
            String current_token = current_tk.nextToken();
            int res = comp2.compare(current_token, bad_token = bad_tk.nextToken());
            if (res == 0) continue;
            return res < 0;
        }
        return num_current <= num_bad;
    }
}

