/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.spoof;

import ghostfucker.spoof.PerfectSpoof;
import ghostfucker.spoof.client.SimpleClient;
import ghostfucker.spoof.client.Validator;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXB;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;

public class Configuration {
    private final Map<String, Map<String, SimpleClient>> versionClientMapping = new HashMap<String, Map<String, SimpleClient>>();

    public Configuration() {
        this.readClientFiles();
        if (this.versionClientMapping.keySet().size() == 0) {
            PerfectSpoof.isAvailable = false;
        }
    }

    public String[] getNames() {
        Object[] objectArray;
        Set<String> set = this.versionClientMapping.keySet();
        if (set.size() > 0) {
            objectArray = set.toArray(new String[set.size()]);
        } else {
            Object[] objectArray2 = new String[1];
            objectArray = objectArray2;
            objectArray2[0] = "";
        }
        Object[] names = objectArray;
        Arrays.sort(names);
        return names;
    }

    public String[] getVersions(String client) {
        Object[] objectArray;
        Set<Object> set;
        Map<String, SimpleClient> map = this.versionClientMapping.get(client);
        Set<Object> set2 = set = map == null ? new HashSet(0) : map.keySet();
        if (set.size() > 0) {
            objectArray = set.toArray(new String[set.size()]);
        } else {
            Object[] objectArray2 = new String[1];
            objectArray = objectArray2;
            objectArray2[0] = "";
        }
        Object[] versions = objectArray;
        Arrays.sort(versions);
        return versions;
    }

    public SimpleClient getClient(String client, String version) {
        Map<String, SimpleClient> map = this.versionClientMapping.get(client);
        if (map != null) {
            return map.get(version);
        }
        SimpleClient sc = new SimpleClient();
        sc.peerId = new SimpleClient.PeerId();
        sc.peerId.type = "";
        sc.peerId.preFix = "";
        return sc;
    }

    private void readClientFiles() {
        File dir = new File("clientfiles/");
        if (!dir.exists()) {
            return;
        }
        File[] clients = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        FileFilter versionFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".client");
            }
        };
        for (File client : clients) {
            HashMap<String, SimpleClient> versionClientMap = new HashMap<String, SimpleClient>();
            for (File version : client.listFiles(versionFilter)) {
                SimpleClient simpleClient = this.readClient(version);
                if (simpleClient == null || !this.isValid(simpleClient, version)) continue;
                versionClientMap.put(version.getName().replace(".client", ""), simpleClient);
            }
            if (versionClientMap.size() <= 0) continue;
            this.versionClientMapping.put(client.getName(), versionClientMap);
        }
    }

    private SimpleClient readClient(File client) {
        try {
            return (SimpleClient)JAXB.unmarshal((File)client, SimpleClient.class);
        }
        catch (Exception e) {
            Logger.log(new LogAlert(false, 3, "Cannot read " + client.getParentFile().getName() + "/" + client.getName(), (Throwable)e));
            return null;
        }
    }

    private boolean isValid(SimpleClient c, File file) {
        try {
            new Validator(c).run();
        }
        catch (Validator.ValidationException ve) {
            Logger.log(new LogAlert(false, 3, "Ivalid client configuration: " + file.getParentFile().getName() + "/" + file.getName(), (Throwable)ve));
            return false;
        }
        return true;
    }
}

