/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.spoof.client;

import ghostfucker.spoof.client.Client;
import ghostfucker.spoof.ut.ID;
import ghostfucker.utils.PropertyReader;
import ghostfucker.utils.sun.net.www.protocol.PSurlConnection;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSClient {
    private int protocol;
    private String azmpName;
    private String azmpVersion;
    private Object ltepName;
    private byte[] reservedBytes;
    private int idType;
    private String preFix;
    private int idLength;
    private String idCharSet;
    private Map<String, String> idExceptions;
    private boolean idToLowerCase;
    private String clientId;
    private byte[] peerId;
    private PropertyReader idFile;
    private int keyLength;
    private String globalKey;
    private String keyCharSet;
    private boolean announceInfoHashToLowerCase;
    private Map<String, String> announceInfoHashExceptions;
    private int staticNumwant;
    private String announce;
    private String conCat = "";
    private String ip;
    private int ipMode;
    private static final String[] OPTIONAL_ANNOUNCE_KEYS = new String[]{"supportcrypto", "requirecrypto", "cryptoport", "event"};
    private boolean isScrapeDisabled;
    private boolean scrapeInfoHashToLowerCase;
    private Map<String, String> scrapeInfoHashExceptions;
    private String message;

    public void init(Client c, String message) {
        String[] tmp;
        int ipIndex;
        if (c.protocol.type.equalsIgnoreCase("AZMP")) {
            this.protocol = 2;
            this.azmpName = c.protocol.clientName.azmp;
            this.azmpVersion = c.protocol.clientVersion.azmp;
            this.ltepName = c.protocol.clientName.isEncodingDisabled ? (Object)c.protocol.clientName.ltep.getBytes() : c.protocol.clientName.ltep;
        } else if (c.protocol.type.equalsIgnoreCase("LTEP")) {
            this.protocol = 3;
            this.ltepName = c.protocol.clientName.isEncodingDisabled ? (Object)c.protocol.clientName.ltep.getBytes() : c.protocol.clientName.ltep;
        } else {
            this.protocol = 1;
        }
        this.reservedBytes = PSClient.decodeReservedBytes(c.protocol.reservedBytes);
        if (COConfigurationManager.getBooleanParameter("PSisCid")) {
            c.peerId.type = "custom";
        }
        this.preFix = c.peerId.preFix;
        if (c.peerId.type.equalsIgnoreCase("custom")) {
            if (c.peerId.isGlobal) {
                if (COConfigurationManager.getBooleanParameter("PSisCidFromFile")) {
                    int id = (int)(Math.random() * (double)c.peerId.propertyReader.getSize());
                    this.clientId = this.preFix + c.peerId.propertyReader.getValue(id);
                } else {
                    this.clientId = this.preFix + COConfigurationManager.getStringParameter("PScid");
                }
                this.peerId = PSClient.clientIdToByteArray(this.clientId);
            } else {
                this.idType = 0;
                this.idFile = c.peerId.propertyReader;
            }
            message = message + " (CID)";
        } else if (c.peerId.type.equalsIgnoreCase("ut")) {
            Map<String, String> exceptions = PSClient.parseExceptions(c.peerId.exceptions, c.peerId.isLowerCase);
            if (c.peerId.isGlobal) {
                this.peerId = ID.create((String)this.preFix);
                this.clientId = PSClient.clientIdToString(this.peerId, exceptions, c.peerId.isLowerCase);
            } else {
                this.idType = 1;
                this.idExceptions = exceptions;
                this.idToLowerCase = c.peerId.isLowerCase;
            }
        } else if (c.peerId.type.equalsIgnoreCase("hex")) {
            Map<String, String> exceptions = PSClient.parseExceptions(c.peerId.exceptions, c.peerId.isLowerCase);
            String charSet = PSClient.getCharset(c.peerId.charSet, c.peerId.type);
            if (c.peerId.isGlobal) {
                this.clientId = PSClient.generateHexPeerId(this.preFix, c.peerId.length, charSet, exceptions, c.peerId.isLowerCase);
                this.peerId = PSClient.clientIdToByteArray(this.clientId);
            } else {
                this.idType = 2;
                this.idLength = c.peerId.length;
                this.idCharSet = charSet;
                this.idExceptions = exceptions;
                this.idToLowerCase = c.peerId.isLowerCase;
            }
        } else {
            String charSet = PSClient.getCharset(c.peerId.charSet, c.peerId.type);
            if (c.peerId.isGlobal) {
                this.clientId = PSClient.generateAlphaNumPeerId(this.preFix, c.peerId.length, charSet);
                this.peerId = PSClient.clientIdToByteArray(this.clientId);
            } else {
                this.idType = 3;
                this.idLength = c.peerId.length;
                this.idCharSet = charSet;
            }
        }
        String keyCharSet = PSClient.getCharset(c.key.charSet, c.key.type);
        if (c.key.isGlobal) {
            this.globalKey = PSClient.generateClientKey(keyCharSet, c.key.length);
        } else {
            this.keyLength = c.key.length;
            this.keyCharSet = keyCharSet;
        }
        this.announceInfoHashToLowerCase = c.announce.infoHash.isLowerCase;
        this.announceInfoHashExceptions = PSClient.parseExceptions(c.announce.infoHash.exceptions, c.announce.infoHash.isLowerCase);
        this.staticNumwant = c.announce.query.staticNumwant;
        StringBuilder sb = new StringBuilder();
        for (String s : c.announce.query.param) {
            sb.append(s);
        }
        this.announce = sb.toString();
        this.announce = PSClient.prepareAnnounceString(this.announce);
        String conCat = "" + this.announce.charAt(0);
        if (conCat.equals("?") || conCat.equals("&")) {
            this.announce = this.announce.substring(1);
            this.conCat = conCat;
        }
        if ((ipIndex = this.announce.indexOf("{ip}")) != -1) {
            String[] ips = PSClient.getIps();
            this.ip = ips[c.announce.query.ipType];
            if (this.ip == null) {
                if (c.announce.query.ipType > 0) {
                    this.ip = ips[-(~c.announce.query.ipType | 2)];
                }
                if (c.announce.query.ipFallBack == 1) {
                    while (--c.announce.query.ipType >= 0 && this.ip == null) {
                        this.ip = ips[c.announce.query.ipType];
                    }
                }
            }
            if (this.ip != null) {
                this.ip = PSClient.replaceAll(this.ip, "/", "");
                int pIndex = this.ip.indexOf(37);
                if (pIndex != -1) {
                    this.ip = this.ip.substring(0, pIndex);
                }
                try {
                    this.ip = URLEncoder.encode(this.ip, "ISO-8859-1");
                }
                catch (UnsupportedEncodingException uee) {
                    this.ip = URLEncoder.encode(this.ip);
                }
                if (c.announce.infoHash.isLowerCase) {
                    this.ip = PSClient.hexToLowerCase(this.ip);
                }
            }
            int start = ipIndex;
            char tmp2 = this.announce.charAt(start);
            while (tmp2 != '&' && tmp2 != '?' && start > 0) {
                tmp2 = this.announce.charAt(--start);
            }
            if (this.ip == null) {
                this.announce = PSClient.replaceAll(this.announce, this.announce.substring(start, ipIndex) + "{ip}", "");
            } else {
                this.ip = this.announce.substring(start, ipIndex) + this.ip;
                this.announce = PSClient.replaceAll(this.announce, this.announce.substring(start, ipIndex), "");
            }
            this.ipMode = c.announce.query.ipMode;
        }
        String[][] header = new String[c.announce.header.field.size()][2];
        int hostIndex = 0;
        int i = 0;
        for (String s : c.announce.header.field) {
            if (s.contains("{osName}")) {
                s = PSClient.replaceAll(s, "{osName}", Constants.OSName);
            }
            if (s.contains("{javaVersion}")) {
                s = PSClient.replaceAll(s, "{javaVersion}", Constants.JAVA_VERSION);
            }
            if (s.toUpperCase().contains("HOST")) {
                hostIndex = i;
            }
            tmp = s.split(":", 2);
            header[i][0] = tmp[0];
            header[i++][1] = tmp[1];
        }
        PSurlConnection.Config.add((byte)0, (String[][])header, (int)hostIndex, (String)c.announce.protocol, (boolean)c.announce.header.showDefaultPort);
        this.isScrapeDisabled = c.scrape.isDisabled;
        if (!this.isScrapeDisabled) {
            this.scrapeInfoHashToLowerCase = c.scrape.infoHash.isLowerCase;
            this.scrapeInfoHashExceptions = PSClient.parseExceptions(c.scrape.infoHash.exceptions, c.scrape.infoHash.isLowerCase);
        }
        if (!this.isScrapeDisabled) {
            header = new String[c.scrape.header.field.size()][2];
            hostIndex = 0;
            i = 0;
            for (String s : c.scrape.header.field) {
                if (s.contains("{osName}")) {
                    s = PSClient.replaceAll(s, "{osName}", Constants.OSName);
                }
                if (s.contains("{javaVersion}")) {
                    s = PSClient.replaceAll(s, "{javaVersion}", Constants.JAVA_VERSION);
                }
                if (s.toUpperCase().contains("HOST")) {
                    hostIndex = i;
                }
                tmp = s.split(":", 2);
                header[i][0] = tmp[0];
                header[i++][1] = tmp[1];
            }
            PSurlConnection.Config.add((byte)1, (String[][])header, (int)hostIndex, (String)c.scrape.protocol, (boolean)c.scrape.header.showDefaultPort);
        }
        this.message = message;
    }

    public Object getLtepName() {
        return this.ltepName;
    }

    public String getAzmpName() {
        return this.azmpName;
    }

    public String getAzmpVersion() {
        return this.azmpVersion;
    }

    public byte[] getReservedBytes() {
        return this.reservedBytes;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public int getProtocol(int current) {
        return current == 1 || this.protocol == 2 ? current : this.protocol;
    }

    public String getClientId() {
        return this.clientId;
    }

    public byte[] getPeerId() {
        if (this.peerId != null) {
            return this.peerId;
        }
        switch (this.idType) {
            case 0: {
                int id = (int)(Math.random() * (double)this.idFile.getSize());
                this.clientId = this.preFix + this.idFile.getValue(id);
                break;
            }
            case 1: {
                byte[] peerId = ID.create((String)this.preFix);
                this.clientId = PSClient.clientIdToString(peerId, this.idExceptions, this.idToLowerCase);
                return peerId;
            }
            case 2: {
                this.clientId = PSClient.generateHexPeerId(this.preFix, this.idLength, this.idCharSet, this.idExceptions, this.idToLowerCase);
                break;
            }
            default: {
                this.clientId = PSClient.generateAlphaNumPeerId(this.preFix, this.idLength, this.idCharSet);
            }
        }
        return PSClient.clientIdToByteArray(this.clientId);
    }

    public String getClientKey() {
        return this.globalKey != null ? this.globalKey : PSClient.generateClientKey(this.keyCharSet, this.keyLength);
    }

    public String getInfoHash(String oldInfoHash, byte type) {
        oldInfoHash = PSClient.normalizeInfoHash(oldInfoHash);
        switch (type) {
            case 0: {
                if (this.announceInfoHashToLowerCase) {
                    oldInfoHash = PSClient.hexToLowerCase(oldInfoHash);
                }
                oldInfoHash = PSClient.replaceAll(oldInfoHash, this.announceInfoHashExceptions);
                break;
            }
            case 1: {
                if (this.scrapeInfoHashToLowerCase) {
                    oldInfoHash = PSClient.hexToLowerCase(oldInfoHash);
                }
                oldInfoHash = this.scrapeInfoHashExceptions == null ? PSClient.replaceAll(oldInfoHash, this.announceInfoHashExceptions) : PSClient.replaceAll(oldInfoHash, this.scrapeInfoHashExceptions);
            }
        }
        return oldInfoHash;
    }

    public boolean isStaticNumwant() {
        return this.staticNumwant != 0;
    }

    public int getStaticNumwant() {
        return this.staticNumwant;
    }

    public String getAnnounce(String orgAnnounce, int paramIndex) {
        String announce = orgAnnounce.substring(0, paramIndex);
        Map<String, String> param = PSClient.announceStringToHashMap(orgAnnounce.substring(paramIndex), this.announce, this.ip, this.ipMode);
        char ch = orgAnnounce.charAt(paramIndex - 1);
        String conCat = ch == '?' || ch == '&' ? "" : this.conCat;
        return announce + conCat + PSClient.replaceAll(this.announce, param);
    }

    public boolean isScrapeDisabled() {
        return this.isScrapeDisabled;
    }

    public String getMessage() {
        return this.message;
    }

    private static byte[] decodeReservedBytes(String reservedBytes) {
        byte[] result = new byte[8];
        String[] hex = reservedBytes.split("\\|");
        for (int i = 0; i < hex.length; ++i) {
            result[i] = (byte)Integer.decode(hex[i]).intValue();
        }
        return result;
    }

    private static byte[] clientIdToByteArray(String peerId) {
        byte[] id = new byte[PSClient.getByteLength(peerId)];
        int i = 0;
        int k = 0;
        while (i < peerId.length()) {
            char ch = peerId.charAt(i);
            if (ch == '%') {
                ch = (char)Integer.parseInt(peerId.substring(i + 1, i + 3), 16);
                i += 2;
            }
            id[k] = (byte)ch;
            ++i;
            ++k;
        }
        return id;
    }

    private static boolean isDefaultChar(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9';
    }

    private static String replaceAll(String str, String regex, String replacement) {
        int index = str.indexOf(regex, 0);
        if (index == -1) {
            return str;
        }
        int currentIndex = 0;
        StringBuilder sb = new StringBuilder(str.length());
        while (index != -1) {
            sb.append(str.substring(currentIndex, index));
            sb.append(replacement);
            currentIndex = index + regex.length();
            index = str.indexOf(regex, currentIndex);
        }
        sb.append(str.substring(currentIndex));
        return sb.toString();
    }

    private static String replaceAll(String str, Map<String, String> replacement) {
        if (replacement == null) {
            return str;
        }
        for (String s : replacement.keySet()) {
            str = PSClient.replaceAll(str, s, replacement.get(s));
        }
        return str;
    }

    private static String hexToLowerCase(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            String tmp = "" + s.charAt(i);
            if (tmp.equals("%")) {
                tmp = s.substring(i, i + 3).toLowerCase();
                i += 2;
            }
            sb.append(tmp);
        }
        return sb.toString();
    }

    private static String clientIdToString(byte[] peerId, Map<String, String> exceptions, boolean isLowerCase) {
        StringBuilder sb = new StringBuilder();
        for (byte b : peerId) {
            char ch = (char)(b & 0xFF);
            if (PSClient.isDefaultChar(ch)) {
                sb.append(ch);
                continue;
            }
            sb.append('%');
            String hex = Integer.toHexString(ch);
            if (hex.length() == 1) {
                sb.append("0");
            }
            sb.append(hex);
        }
        String result = sb.toString();
        if (isLowerCase) {
            result = PSClient.hexToLowerCase(result);
        }
        result = PSClient.replaceAll(result, exceptions);
        return result;
    }

    private static Map<String, String> parseExceptions(String exceptions, boolean isLowerCase) {
        if (exceptions == null || exceptions.length() == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(exceptions.length());
        for (int i = 0; i < exceptions.length(); ++i) {
            char ch = exceptions.charAt(i);
            String hex = Integer.toHexString(ch);
            String key = "%" + (hex.length() == 1 ? "0" + hex : hex);
            map.put(isLowerCase ? key : key.toUpperCase(), "" + ch);
        }
        return map;
    }

    private static String getCharset(String charSet, String type) {
        if (charSet != null) {
            return charSet;
        }
        return type.equalsIgnoreCase("hex") ? "0123456789ABCDEF" : "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    }

    private static String generateHexPeerId(String preFix, int length, String charSet, Map<String, String> exceptions, boolean isLowerCase) {
        StringBuilder sb = new StringBuilder(preFix);
        for (int i = 0; i < length; ++i) {
            int pos1 = (int)(Math.random() * (double)charSet.length());
            int pos2 = (int)(Math.random() * (double)charSet.length());
            String hex = "" + charSet.charAt(pos1) + charSet.charAt(pos2);
            char hexVal = (char)Integer.parseInt(hex, 16);
            if (PSClient.isDefaultChar(hexVal)) {
                sb.append(hexVal);
                continue;
            }
            sb.append('%').append(hex);
        }
        String result = sb.toString();
        if (isLowerCase) {
            result = PSClient.hexToLowerCase(result);
        }
        result = PSClient.replaceAll(result, exceptions);
        return result;
    }

    private static String generateAlphaNumPeerId(String preFix, int length, String charSet) {
        StringBuilder sb = new StringBuilder(preFix);
        for (int i = 0; i < length; ++i) {
            int pos = (int)(Math.random() * (double)charSet.length());
            sb.append(charSet.charAt(pos));
        }
        return sb.toString();
    }

    private static String generateClientKey(String charSet, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int pos = (int)(Math.random() * (double)charSet.length());
            sb.append(charSet.charAt(pos));
        }
        return sb.toString();
    }

    private static String normalizeInfoHash(String infoHash) {
        infoHash = PSClient.replaceAll(infoHash, "*", "%2A");
        infoHash = PSClient.replaceAll(infoHash, "-", "%2D");
        infoHash = PSClient.replaceAll(infoHash, ".", "%2E");
        infoHash = PSClient.replaceAll(infoHash, "_", "%5F");
        return infoHash;
    }

    private static String prepareAnnounceString(String announce) {
        announce = PSClient.replaceAll(announce, "[info_hash]", "&info_hash={info_hash}");
        announce = PSClient.replaceAll(announce, "[peer_id]", "&peer_id={peer_id}");
        announce = PSClient.replaceAll(announce, "[port]", "&port={port}");
        announce = PSClient.replaceAll(announce, "[azudp]", "&azudp={azudp}");
        announce = PSClient.replaceAll(announce, "[uploaded]", "&uploaded={uploaded}");
        announce = PSClient.replaceAll(announce, "[downloaded]", "&downloaded={downloaded}");
        announce = PSClient.replaceAll(announce, "[left]", "&left={left}");
        announce = PSClient.replaceAll(announce, "[corrupt]", "&corrupt={corrupt}");
        announce = PSClient.replaceAll(announce, "[numwant]", "&numwant={numwant}");
        announce = PSClient.replaceAll(announce, "[no_peer_id]", "&no_peer_id={no_peer_id}");
        announce = PSClient.replaceAll(announce, "[compact]", "&compact={compact}");
        announce = PSClient.replaceAll(announce, "[key]", "&key={key}");
        announce = PSClient.replaceAll(announce, "[azver]", "&azver={azver}");
        announce = PSClient.replaceAll(announce, "[ip]", "&ip={ip}");
        return announce;
    }

    private static Map<String, String> announceStringToHashMap(String announce, String announceTemplate, String ip, int ipMode) {
        HashMap<String, String> announceParameter = new HashMap<String, String>();
        int index = 0;
        int endIndex = announce.indexOf("=", index);
        while (endIndex != -1) {
            String param = announce.substring(index, endIndex);
            index = endIndex + 1;
            if ((endIndex = announce.indexOf("&", index)) == -1) {
                endIndex = announce.length();
            }
            String val = announce.substring(index, endIndex);
            announceParameter.put("{" + param + "}", val);
            index = endIndex + 1;
            endIndex = announce.indexOf("=", index);
        }
        if (announceParameter.containsKey("{cryptoport}") && !announceTemplate.contains("cryptoport")) {
            String port = (String)announceParameter.get("{cryptoport}");
            announceParameter.put("{port}", port);
        }
        if (!(ip == null || announceParameter.containsKey("{event}") && ((String)announceParameter.get("{event}")).contains("stopped") && ipMode == 1)) {
            announceParameter.put("{ip}", ip);
        } else {
            announceParameter.put("{ip}", "");
        }
        PSClient.fillAnnounceMapWithDefaults(announceParameter);
        return announceParameter;
    }

    private static void fillAnnounceMapWithDefaults(Map<String, String> map) {
        for (String key : OPTIONAL_ANNOUNCE_KEYS) {
            String mapKey = String.format("{%s}", key);
            String val = map.get(mapKey);
            if (val != null) {
                map.put(mapKey, String.format("&%s=%s", key, val));
                continue;
            }
            map.put(mapKey, "");
        }
    }

    private static String[] getIps() {
        String[] ips = new String[3];
        try {
            NetworkInterface ni = PSClient.getActiveNetworkInterface();
            Enumeration<InetAddress> eia = ni.getInetAddresses();
            while (eia.hasMoreElements()) {
                InetAddress ia = eia.nextElement();
                if (ia instanceof Inet4Address) {
                    ips[0] = ia.toString();
                    continue;
                }
                if (!(ia instanceof Inet6Address)) continue;
                ips[1] = ia.toString();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Enumeration<NetworkInterface> eni = NetworkInterface.getNetworkInterfaces();
            while (eni.hasMoreElements()) {
                NetworkInterface ni = eni.nextElement();
                Enumeration<InetAddress> eia = ni.getInetAddresses();
                while (eia.hasMoreElements()) {
                    String s;
                    InetAddress ia = eia.nextElement();
                    if (!(ia instanceof Inet6Address) || !(s = ia.toString()).startsWith("/2001:") && !s.startsWith("/2002:") && !s.startsWith("2001:") && !s.startsWith("2002:")) continue;
                    ips[2] = s;
                    break;
                }
                if (ips[2] == null) continue;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ips;
    }

    private static NetworkInterface getActiveNetworkInterface() throws Exception {
        String[] hosts;
        for (String host : hosts = new String[]{"www.vuze.com", "www.google.com", "www.yahoo.com"}) {
            try {
                Socket s = new Socket(host, 80);
                return NetworkInterface.getByInetAddress(s.getLocalAddress());
            }
            catch (Exception e) {
            }
        }
        throw new Exception("Can't find active network interface");
    }

    public static int getByteLength(String s) {
        int length = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '%') {
                i += 2;
            }
            ++length;
        }
        return length;
    }

    public static boolean isValidCid(String cid, int length) {
        if (cid == null || length == 0) {
            return false;
        }
        int chars = cid.length();
        for (int i = 0; i < cid.length(); ++i) {
            if (cid.charAt(i) != '%') continue;
            if (cid.substring(i).length() < 3) {
                return false;
            }
            chars -= 2;
        }
        return chars == length;
    }
}

