/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.spoof.client;

import ghostfucker.spoof.client.Client;
import ghostfucker.spoof.client.PSClient;
import ghostfucker.spoof.client.SimpleClient;
import ghostfucker.utils.PropertyReader;
import java.io.IOException;
import org.gudy.azureus2.core3.config.COConfigurationManager;

public class Validator {
    private Client c;
    private SimpleClient sc;

    public Validator(Client c) {
        this.c = c;
    }

    public Validator(SimpleClient sc) {
        this.sc = sc;
    }

    public void run() throws ValidationException {
        if (this.sc == null) {
            this.validateClient();
        } else {
            this.validateSimpleClient();
        }
    }

    private void validateSimpleClient() throws ValidationException {
        Validator.validateObject(this.sc, "client");
        Validator.validateObject(this.sc.peerId, "peerId");
        Validator.validateString(this.sc.peerId.type, "peerId.type");
        Validator.validateString(this.sc.peerId.preFix, "peerId.preFix");
        this.sc.peerId.length -= PSClient.getByteLength(this.sc.peerId.preFix);
        Validator.validateInteger(this.sc.peerId.length, "peerId.length");
    }

    private void validateClient() throws ValidationException {
        Validator.validateObject(this.c, "client");
        this.validateProtocol();
        this.validatePeerId();
        this.validateKey();
        this.validateAnnounce();
        this.validateScrape();
        this.validateCustomId();
        this.ensureDefaultValues();
    }

    private void validateProtocol() throws ValidationException {
        Validator.validateObject(this.c.protocol, "protocol");
        Validator.validateString(this.c.protocol.type, "protocol.type");
        if (!this.c.protocol.type.equalsIgnoreCase("btlp")) {
            if (this.c.protocol.type.equalsIgnoreCase("ltep")) {
                Validator.validateObject(this.c.protocol.clientName, "protocol.clientName");
                Validator.validateString(this.c.protocol.clientName.ltep, "protocol.clientName.ltep");
            } else if (this.c.protocol.type.equalsIgnoreCase("azmp")) {
                Validator.validateObject(this.c.protocol.clientName, "protocol.clientName");
                Validator.validateString(this.c.protocol.clientName.ltep, "protocol.clientName.ltep");
                Validator.validateString(this.c.protocol.clientName.azmp, "protocol.clientName.azmp");
                Validator.validateObject(this.c.protocol.clientVersion, "protocol.clientVersion");
                Validator.validateString(this.c.protocol.clientVersion.azmp, ".protocol.clientVersion.azmp");
            } else {
                throw new ValidationException("Ivalid value: protocol.type");
            }
        }
        Validator.validateObject(this.c.protocol.reservedBytes, "protocol.reservedBytes");
        String[] reservedBits = this.c.protocol.reservedBytes.split("\\|");
        if (reservedBits.length == 8) {
            try {
                for (String rsvBit : reservedBits) {
                    Integer.decode(rsvBit);
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ValidationException("Ivalid value: protocol.reservedBytes");
    }

    private void validatePeerId() throws ValidationException {
        Validator.validateObject(this.c.peerId, "peerId");
        Validator.validateString(this.c.peerId.type, "peerId.type");
        Validator.validateString(this.c.peerId.preFix, "peerId.preFix");
        this.c.peerId.length -= PSClient.getByteLength(this.c.peerId.preFix);
        Validator.validateInteger(this.c.peerId.length, "c.peerId.length");
        if (this.c.peerId.type.equalsIgnoreCase("custom") || this.c.peerId.type.equalsIgnoreCase("ut")) {
            return;
        }
        if (this.c.peerId.type.equalsIgnoreCase("hex")) {
            Validator.validateOptionalString(this.c.peerId.exceptions, "peerId.exceptions", 255);
        } else if (!this.c.peerId.type.equalsIgnoreCase("anum")) {
            throw new ValidationException("Ivalid value: peerId.type");
        }
        Validator.validateOptionalString(this.c.peerId.charSet, "peerId.charSet", 255);
    }

    private void validateKey() throws ValidationException {
        Validator.validateObject(this.c.key, "key");
        Validator.validateString(this.c.key.type, "key.type");
        Validator.validateInteger(this.c.key.length, "key.length");
        if (this.c.key.type.equalsIgnoreCase("hex")) {
            Validator.validateOptionalString(this.c.key.exceptions, "key.exceptions", 255);
        } else if (!this.c.key.type.equalsIgnoreCase("anum")) {
            throw new ValidationException("Ivalid value: key.type");
        }
        Validator.validateOptionalString(this.c.key.charSet, "key.charSet", 255);
    }

    private void validateAnnounce() throws ValidationException {
        Validator.validateObject(this.c.announce, "announce");
        Validator.validateOptionalString(this.c.announce.protocol, "announce.protocol");
        this.validateInfoHash(this.c.announce.infoHash, "announce.infoHash");
        Validator.validateObject(this.c.announce.query, "announce.query");
        Validator.validateObject(this.c.announce.query.param, "announce.query.param");
        if (this.c.announce.query.param.size() == 0) {
            throw new ValidationException("Ivalid value: announce.query.param");
        }
        for (String s : this.c.announce.query.param) {
            Validator.validateString(s, "announce.query.param");
        }
        if (this.c.announce.query.ipType > 2 || this.c.announce.query.ipMode > 1 || this.c.announce.query.ipType != -1 && this.c.announce.query.ipMode == -1) {
            throw new ValidationException("Ivalid value: announce.query.(ipType|ipMode)");
        }
        this.validateHeader(this.c.announce.header, "announce.header");
    }

    private void validateScrape() throws ValidationException {
        if (this.c.scrape == null) {
            return;
        }
        Validator.validateOptionalString(this.c.scrape.protocol, "scrape.protocol");
        this.validateInfoHash(this.c.scrape.infoHash, "scrape.infoHash");
        if (this.c.scrape.header != null) {
            this.validateHeader(this.c.scrape.header, "scrape.header");
        }
    }

    private void validateInfoHash(Client.InfoHash infoHash, String elementName) throws ValidationException {
        if (infoHash != null) {
            Validator.validateOptionalString(infoHash.exceptions, elementName + ".exceptions", 255);
        }
    }

    private void validateHeader(Client.Header header, String elementName) throws ValidationException {
        Validator.validateObject(header, elementName);
        Validator.validateObject(header.field, elementName + ".field");
        if (header.field.size() == 0) {
            throw new ValidationException("Ivalid value: " + elementName + ".field");
        }
        String host = null;
        for (String s : header.field) {
            String[] tmp;
            if (s.toUpperCase().contains("HOST")) {
                host = s;
            }
            if ((tmp = s.split(":", 2)).length != 2) {
                throw new ValidationException("Invalid configuration: " + elementName + ".field");
            }
            Validator.validateString(tmp[0], elementName + ".field");
            Validator.validateString(tmp[1], elementName + ".field");
        }
        if (host == null || !host.toUpperCase().contains("{HOST}") || !host.toUpperCase().contains("{PORT}")) {
            throw new ValidationException("Invalid configuration: " + elementName + ".field");
        }
    }

    private void validateCustomId() throws ValidationException {
        block8: {
            if (COConfigurationManager.getBooleanParameter("PSisCid")) {
                try {
                    if (COConfigurationManager.getBooleanParameter("PSisCidFromFile")) {
                        PropertyReader propertyReader = null;
                        try {
                            propertyReader = new PropertyReader("clientfiles/CustomId.properties");
                        }
                        catch (IOException ioe) {
                            throw new ValidationException("Cannot read file: CustomID.properties", ioe);
                        }
                        for (int i = 0; i < propertyReader.getSize(); ++i) {
                            if (PSClient.isValidCid(propertyReader.getValue(i), this.c.peerId.length)) continue;
                            throw new ValidationException("Invalid custom id length (CustomId.properties - No. " + i + ")");
                        }
                        this.c.peerId.propertyReader = propertyReader;
                        break block8;
                    }
                    if (!PSClient.isValidCid(COConfigurationManager.getStringParameter("PScid"), this.c.peerId.length)) {
                        throw new ValidationException("Invalid custom id length");
                    }
                }
                catch (ValidationException ve) {
                    COConfigurationManager.setParameter("PSisCidFromFile", false);
                    COConfigurationManager.setParameter("PSisCid", false);
                    throw ve;
                }
            }
        }
    }

    private void ensureDefaultValues() {
        if (this.c.announce.infoHash == null) {
            this.c.announce.infoHash = new Client.InfoHash();
        }
        if (this.c.scrape == null) {
            this.c.scrape = new Client.Scrape();
        }
        if (!this.c.scrape.isDisabled) {
            if (this.c.scrape.protocol == null) {
                this.c.scrape.protocol = this.c.announce.protocol;
            }
            if (this.c.scrape.infoHash == null) {
                this.c.scrape.infoHash = this.c.announce.infoHash;
            }
            if (this.c.scrape.header == null) {
                this.c.scrape.header = this.c.announce.header;
            }
        }
    }

    private static void validateString(String str, String elementName) throws ValidationException {
        Validator.validateString(str, elementName, 42);
    }

    private static void validateString(String str, String elementName, int maxLength) throws ValidationException {
        Validator.validateObject(str, elementName);
        str = str.trim();
        if (str.length() > 0 || str.length() < maxLength) {
            return;
        }
        throw new ValidationException("Ivalid value: " + elementName);
    }

    private static void validateOptionalString(String str, String elementName) throws ValidationException {
        Validator.validateOptionalString(str, elementName, str == null ? 0 : str.length());
    }

    private static void validateOptionalString(String str, String elementName, int maxLength) throws ValidationException {
        if (str != null) {
            Validator.validateString(str, elementName, maxLength);
        }
    }

    private static void validateInteger(int i, String elementName) throws ValidationException {
        Validator.validateInteger(i, elementName, 1, 42);
    }

    private static void validateInteger(int i, String elementName, int min, int max) throws ValidationException {
        if (i < min || i > max) {
            throw new ValidationException("Ivalid value: " + elementName);
        }
    }

    private static void validateObject(Object obj, String elementName) throws ValidationException {
        if (obj == null) {
            throw new ValidationException("Required element not set: " + elementName);
        }
    }

    public static class ValidationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ValidationException(String message) {
            super(message);
        }

        public ValidationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

