/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.params;

import java.math.BigInteger;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.DHValidationParameters;

public class DHParameters
implements CipherParameters {
    private BigInteger g;
    private BigInteger p;
    private BigInteger q;
    private int j;
    private DHValidationParameters validation;

    public DHParameters(BigInteger p, BigInteger g) {
        this.g = g;
        this.p = p;
    }

    public DHParameters(BigInteger p, BigInteger g, BigInteger q, int j) {
        this.g = g;
        this.p = p;
        this.q = q;
        this.j = j;
    }

    public DHParameters(BigInteger p, BigInteger g, BigInteger q, int j, DHValidationParameters validation) {
        this.g = g;
        this.p = p;
        this.q = q;
        this.j = j;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public int getJ() {
        return this.j;
    }

    public DHValidationParameters getValidationParameters() {
        return this.validation;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DHParameters)) {
            return false;
        }
        DHParameters pm = (DHParameters)obj;
        if (this.getValidationParameters() != null ? !this.getValidationParameters().equals(pm.getValidationParameters()) : pm.getValidationParameters() != null) {
            return false;
        }
        if (this.getQ() != null ? !this.getQ().equals(pm.getQ()) : pm.getQ() != null) {
            return false;
        }
        return this.j == pm.getJ() && pm.getP().equals(this.p) && pm.getG().equals(this.g);
    }
}

