/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.category.impl;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.rssgen.RSSGeneratorPlugin;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.impl.TagTypeBase;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.core3.category.impl.CategoryImpl;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.core3.xml.util.XMLEscapeWriter;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryManagerImpl
extends TagTypeBase
implements RSSGeneratorPlugin.Provider {
    private static final int[] color_default = new int[]{189, 178, 57};
    private static final String PROVIDER = "categories";
    private static final String UNCAT_NAME = "__uncategorised__";
    private static final String ALL_NAME = "__all__";
    private static CategoryManagerImpl catMan;
    private static CategoryImpl catAll;
    private static CategoryImpl catUncategorized;
    private static boolean doneLoading;
    private static AEMonitor class_mon;
    private Map<String, CategoryImpl> categories = new HashMap<String, CategoryImpl>();
    private AEMonitor categories_mon = new AEMonitor("Categories");
    private static final int LDT_CATEGORY_ADDED = 1;
    private static final int LDT_CATEGORY_REMOVED = 2;
    private static final int LDT_CATEGORY_CHANGED = 3;
    private ListenerManager category_listeners = ListenerManager.createManager("CatListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            CategoryManagerListener target = (CategoryManagerListener)_listener;
            if (type == 1) {
                target.categoryAdded((Category)value);
            } else if (type == 2) {
                target.categoryRemoved((Category)value);
            } else if (type == 3) {
                target.categoryChanged((Category)value);
            }
        }
    });

    protected CategoryManagerImpl() {
        super(1, 63, "Category");
        this.addTagType();
        this.loadCategories();
    }

    public void addCategoryManagerListener(CategoryManagerListener l) {
        this.category_listeners.addListener(l);
    }

    public void removeCategoryManagerListener(CategoryManagerListener l) {
        this.category_listeners.removeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CategoryManagerImpl getInstance() {
        try {
            class_mon.enter();
            if (catMan == null) {
                catMan = new CategoryManagerImpl();
            }
            CategoryManagerImpl categoryManagerImpl = catMan;
            Object var2_1 = null;
            class_mon.exit();
            return categoryManagerImpl;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void loadCategories() {
        block32: {
            if (doneLoading) {
                return;
            }
            doneLoading = true;
            FileInputStream fin = null;
            BufferedInputStream bin = null;
            this.makeSpecialCategories();
            File configFile = FileUtil.getUserFile("categories.config");
            fin = new FileInputStream(configFile);
            bin = new BufferedInputStream(fin, 8192);
            Map<String, Object> map = BDecoder.decode(bin);
            List catList = (List)map.get(PROVIDER);
            for (int i = 0; i < catList.size(); ++i) {
                Map mCategory = (Map)catList.get(i);
                try {
                    String catName = new String((byte[])mCategory.get("name"), "UTF8");
                    Long l_maxup = (Long)mCategory.get("maxup");
                    Long l_maxdown = (Long)mCategory.get("maxdown");
                    HashMap<String, String> attributes = BDecoder.decodeStrings((Map)mCategory.get("attr"));
                    if (attributes == null) {
                        attributes = new HashMap<String, String>();
                    }
                    if (catName.equals(UNCAT_NAME)) {
                        catUncategorized.setUploadSpeed(l_maxup == null ? 0 : l_maxup.intValue());
                        catUncategorized.setDownloadSpeed(l_maxdown == null ? 0 : l_maxdown.intValue());
                        catUncategorized.setAttributes(attributes);
                        continue;
                    }
                    if (catName.equals(ALL_NAME)) {
                        catAll.setAttributes(attributes);
                        continue;
                    }
                    this.categories.put(catName, new CategoryImpl(this, catName, l_maxup == null ? 0 : l_maxup.intValue(), l_maxdown == null ? 0 : l_maxdown.intValue(), attributes));
                    continue;
                }
                catch (UnsupportedEncodingException e1) {
                    // empty catch block
                }
            }
            Object var13_15 = null;
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            this.checkConfig();
            {
                break block32;
                catch (FileNotFoundException e) {
                    Object var13_16 = null;
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        if (fin != null) {
                            fin.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    this.checkConfig();
                    break block32;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                    Object var13_17 = null;
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        if (fin != null) {
                            fin.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    this.checkConfig();
                }
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                try {
                    if (bin != null) {
                        bin.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                this.checkConfig();
                throw throwable;
            }
        }
    }

    protected void saveCategories(Category category) {
        this.saveCategories();
        this.category_listeners.dispatch(3, category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void saveCategories() {
        try {
            block15: {
                FileOutputStream fos;
                block14: {
                    this.categories_mon.enter();
                    HashMap map = new HashMap();
                    ArrayList list = new ArrayList(this.categories.size());
                    for (CategoryImpl cat : this.categories.values()) {
                        if (cat.getType() != 0) continue;
                        HashMap<String, Object> catMap = new HashMap<String, Object>();
                        catMap.put("name", cat.getName());
                        catMap.put("maxup", new Long(cat.getUploadSpeed()));
                        catMap.put("maxdown", new Long(cat.getDownloadSpeed()));
                        catMap.put("attr", cat.getAttributes());
                        list.add(catMap);
                    }
                    HashMap<String, Object> uncat = new HashMap<String, Object>();
                    uncat.put("name", UNCAT_NAME);
                    uncat.put("maxup", new Long(catUncategorized.getUploadSpeed()));
                    uncat.put("maxdown", new Long(catUncategorized.getDownloadSpeed()));
                    uncat.put("attr", catUncategorized.getAttributes());
                    list.add(uncat);
                    HashMap<String, Object> allcat = new HashMap<String, Object>();
                    allcat.put("name", ALL_NAME);
                    allcat.put("attr", catAll.getAttributes());
                    list.add(allcat);
                    map.put(PROVIDER, list);
                    fos = null;
                    byte[] torrentData = BEncoder.encode(map);
                    File oldFile = FileUtil.getUserFile("categories.config");
                    File newFile = FileUtil.getUserFile("categories.config.new");
                    fos = new FileOutputStream(newFile);
                    fos.write(torrentData);
                    fos.flush();
                    fos.getFD().sync();
                    fos.close();
                    fos = null;
                    if (oldFile.exists() && !oldFile.delete()) break block14;
                    newFile.renameTo(oldFile);
                }
                Object var11_11 = null;
                try {
                    if (fos != null) {
                        fos.close();
                    }
                    break block15;
                }
                catch (Exception e2) {}
                break block15;
                {
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                        Object var11_12 = null;
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                            break block15;
                        }
                        catch (Exception e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            Object var14_18 = null;
            this.checkConfig();
            this.categories_mon.exit();
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            this.checkConfig();
            this.categories_mon.exit();
            throw throwable;
        }
    }

    public Category createCategory(String name) {
        this.makeSpecialCategories();
        CategoryImpl newCategory = this.getCategory(name);
        if (newCategory == null) {
            newCategory = new CategoryImpl(this, name, 0, 0, new HashMap<String, String>());
            this.categories.put(name, newCategory);
            this.saveCategories();
            this.category_listeners.dispatch(1, newCategory);
            return this.categories.get(name);
        }
        return newCategory;
    }

    public void removeCategory(Category category) {
        if (this.categories.containsKey(category.getName())) {
            CategoryImpl old = this.categories.remove(category.getName());
            this.saveCategories();
            this.category_listeners.dispatch(2, category);
            if (old != null) {
                old.destroy();
            }
        }
    }

    public Category[] getCategories() {
        if (this.categories.size() > 0) {
            return this.categories.values().toArray(new Category[this.categories.size()]);
        }
        return new Category[0];
    }

    public CategoryImpl getCategory(String name) {
        return this.categories.get(name);
    }

    public Category getCategory(int type) {
        if (type == 1) {
            return catAll;
        }
        if (type == 2) {
            return catUncategorized;
        }
        return null;
    }

    private void makeSpecialCategories() {
        if (catAll == null) {
            catAll = new CategoryImpl(this, "Categories.all", 1, new HashMap<String, String>());
            this.categories.put("Categories.all", catAll);
        }
        if (catUncategorized == null) {
            catUncategorized = new CategoryImpl(this, "Categories.uncategorized", 2, new HashMap<String, String>());
            this.categories.put("Categories.uncategorized", catUncategorized);
        }
    }

    @Override
    public int[] getColorDefault() {
        return color_default;
    }

    @Override
    public List<Tag> getTags() {
        return new ArrayList<Tag>(this.categories.values());
    }

    private void checkConfig() {
        boolean gen_enabled = false;
        for (CategoryImpl cat : this.categories.values()) {
            if (!cat.getBooleanAttribute("at_rss_gen")) continue;
            gen_enabled = true;
            break;
        }
        if (gen_enabled) {
            RSSGeneratorPlugin.registerProvider(PROVIDER, this);
        } else {
            RSSGeneratorPlugin.unregisterProvider(PROVIDER);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        URL url = request2.getAbsoluteURL();
        String path = url.getPath();
        int pos = path.indexOf(63);
        if (pos != -1) {
            path = path.substring(0, pos);
        }
        path = path.substring(PROVIDER.length() + 1);
        XMLEscapeWriter pw = new XMLEscapeWriter(new PrintWriter(new OutputStreamWriter(response.getOutputStream(), "UTF-8")));
        pw.setEnabled(false);
        if (path.length() <= 1) {
            ArrayList<CategoryImpl> cats;
            response.setContentType("text/html; charset=UTF-8");
            pw.println("<HTML><HEAD><TITLE>Vuze Category Feeds</TITLE></HEAD><BODY>");
            TreeMap<String, String> lines = new TreeMap<String, String>();
            try {
                this.categories_mon.enter();
                cats = new ArrayList<CategoryImpl>(this.categories.values());
                Object var10_11 = null;
                this.categories_mon.exit();
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.categories_mon.exit();
                throw throwable;
            }
            for (CategoryImpl c : cats) {
                if (!c.getBooleanAttribute("at_rss_gen")) continue;
                String name = this.getDisplayName(c);
                String cat_url = "categories/" + URLEncoder.encode(c.getName(), "UTF-8");
                lines.put(name, "<LI><A href=\"" + cat_url + "\">" + name + "</A></LI>");
            }
            for (String line : lines.values()) {
                pw.println(line);
            }
            pw.println("</BODY></HTML>");
        } else {
            CategoryImpl cat;
            String cat_name = URLDecoder.decode(path.substring(1), "UTF-8");
            try {
                this.categories_mon.enter();
                cat = this.categories.get(cat_name);
                Object var14_20 = null;
                this.categories_mon.exit();
            }
            catch (Throwable throwable) {
                Object var14_21 = null;
                this.categories_mon.exit();
                throw throwable;
            }
            if (cat == null) {
                response.setReplyStatus(404);
                return true;
            }
            List<DownloadManager> dms = cat.getDownloadManagers(AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManagers());
            ArrayList<Download> downloads = new ArrayList<Download>(dms.size());
            long dl_marker = 0L;
            for (DownloadManager dm : dms) {
                TOTorrent torrent = dm.getTorrent();
                if (torrent == null || TorrentUtils.isReallyPrivate(torrent)) continue;
                dl_marker += dm.getDownloadState().getLongParameter("stats.download.added.time");
                downloads.add(PluginCoreUtils.wrap(dm));
            }
            String config_key = "cat.rss.config." + Base32.encode(cat.getName().getBytes("UTF-8"));
            long old_marker = COConfigurationManager.getLongParameter(config_key + ".marker", 0L);
            long last_modified = COConfigurationManager.getLongParameter(config_key + ".last_mod", 0L);
            long now = SystemTime.getCurrentTime();
            if (old_marker == dl_marker) {
                if (last_modified == 0L) {
                    last_modified = now;
                }
            } else {
                COConfigurationManager.setParameter(config_key + ".marker", dl_marker);
                last_modified = now;
            }
            if (last_modified == now) {
                COConfigurationManager.setParameter(config_key + ".last_mod", last_modified);
            }
            pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            pw.println("<rss version=\"2.0\" xmlns:vuze=\"http://www.vuze.com\">");
            pw.println("<channel>");
            pw.println("<title>" + this.escape(this.getDisplayName(cat)) + "</title>");
            Collections.sort(downloads, new Comparator<Download>(){

                @Override
                public int compare(Download d1, Download d2) {
                    long added1 = CategoryManagerImpl.this.getAddedTime(d1) / 1000L;
                    long added2 = CategoryManagerImpl.this.getAddedTime(d2) / 1000L;
                    return (int)(added2 - added1);
                }
            });
            pw.println("<pubDate>" + TimeFormatter.getHTTPDate(last_modified) + "</pubDate>");
            for (int i = 0; i < downloads.size(); ++i) {
                Download download = (Download)downloads.get(i);
                DownloadManager core_download = PluginCoreUtils.unwrap(download);
                Torrent torrent = download.getTorrent();
                byte[] hash = torrent.getHash();
                String hash_str = Base32.encode(hash);
                pw.println("<item>");
                pw.println("<title>" + this.escape(download.getName()) + "</title>");
                pw.println("<guid>" + hash_str + "</guid>");
                String magnet_url = this.escape(UrlUtils.getMagnetURI(download));
                pw.println("<link>" + magnet_url + "</link>");
                long added = core_download.getDownloadState().getLongParameter("stats.download.added.time");
                pw.println("<pubDate>" + TimeFormatter.getHTTPDate(added) + "</pubDate>");
                pw.println("<vuze:size>" + torrent.getSize() + "</vuze:size>");
                pw.println("<vuze:assethash>" + hash_str + "</vuze:assethash>");
                pw.println("<vuze:downloadurl>" + magnet_url + "</vuze:downloadurl>");
                DownloadScrapeResult scrape = download.getLastScrapeResult();
                if (scrape != null && scrape.getResponseType() == 1) {
                    pw.println("<vuze:seeds>" + scrape.getSeedCount() + "</vuze:seeds>");
                    pw.println("<vuze:peers>" + scrape.getNonSeedCount() + "</vuze:peers>");
                }
                pw.println("</item>");
            }
            pw.println("</channel>");
            pw.println("</rss>");
        }
        pw.flush();
        return true;
    }

    private String getDisplayName(CategoryImpl c) {
        if (c == catAll) {
            return MessageText.getString("Categories.all");
        }
        if (c == catUncategorized) {
            return MessageText.getString("Categories.uncategorized");
        }
        return c.getName();
    }

    protected long getAddedTime(Download download) {
        DownloadManager core_download = PluginCoreUtils.unwrap(download);
        return core_download.getDownloadState().getLongParameter("stats.download.added.time");
    }

    protected String escape(String str) {
        return XUXmlWriter.escapeXML(str);
    }

    static {
        catAll = null;
        catUncategorized = null;
        doneLoading = false;
        class_mon = new AEMonitor("CategoryManager:class");
    }
}

