/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.global.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.helpers.TorrentFolderWatcher;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.peermanager.control.PeerControlSchedulerFactory;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.TaggableLifecycleHandler;
import com.aelitis.azureus.core.tag.impl.TagDownloadWithState;
import com.aelitis.azureus.core.tag.impl.TagTypeBase;
import com.aelitis.azureus.core.tag.impl.TagTypeWithState;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerFactory;
import org.gudy.azureus2.core3.download.DownloadManagerInitialisationAdapter;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateFactory;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadWillBeRemovedListener;
import org.gudy.azureus2.core3.global.GlobalManagerEvent;
import org.gudy.azureus2.core3.global.GlobalManagerEventListener;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.global.GlobalMangerProgressListener;
import org.gudy.azureus2.core3.global.impl.GlobalManagerHostSupport;
import org.gudy.azureus2.core3.global.impl.GlobalManagerStatsImpl;
import org.gudy.azureus2.core3.global.impl.GlobalManagerStatsWriter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraper;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperClientResolver;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtilsListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcherWithException;
import org.gudy.azureus2.core3.util.NonDaemonTask;
import org.gudy.azureus2.core3.util.NonDaemonTaskRunner;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.dht.mainline.MainlineDHTProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalManagerImpl
extends DownloadManagerAdapter
implements GlobalManager,
AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final int LDT_MANAGER_ADDED = 1;
    private static final int LDT_MANAGER_REMOVED = 2;
    private static final int LDT_DESTROY_INITIATED = 3;
    private static final int LDT_DESTROYED = 4;
    private static final int LDT_SEEDING_ONLY = 5;
    private static final int LDT_EVENT = 6;
    private ListenerManager listeners_and_event_listeners = ListenerManager.createAsyncManager("GM:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            if (type == 6) {
                if (_listener instanceof GlobalManagerEventListener) {
                    ((GlobalManagerEventListener)_listener).eventOccurred((GlobalManagerEvent)value);
                }
            } else if (_listener instanceof GlobalManagerListener) {
                GlobalManagerListener target = (GlobalManagerListener)_listener;
                if (type == 1) {
                    target.downloadManagerAdded((DownloadManager)value);
                } else if (type == 2) {
                    target.downloadManagerRemoved((DownloadManager)value);
                } else if (type == 3) {
                    target.destroyInitiated();
                } else if (type == 4) {
                    target.destroyed();
                } else if (type == 5) {
                    boolean[] temp = (boolean[])value;
                    target.seedingStatusChanged(temp[0], temp[1]);
                }
            }
        }
    });
    private static final int LDT_MANAGER_WBR = 1;
    private ListenerManager removal_listeners = ListenerManager.createManager("GM:DLWBRMListenDispatcher", new ListenerManagerDispatcherWithException(){

        public void dispatchWithException(Object _listener, int type, Object value) throws GlobalManagerDownloadRemovalVetoException {
            GlobalManagerDownloadWillBeRemovedListener target = (GlobalManagerDownloadWillBeRemovedListener)_listener;
            DownloadManager dm = (DownloadManager)((Object[])value)[0];
            boolean remove_torrent = (Boolean)((Object[])value)[1];
            boolean remove_data = (Boolean)((Object[])value)[2];
            target.downloadWillBeRemoved(dm, remove_torrent, remove_data);
        }
    });
    private List<DownloadManager> managers_cow = new ArrayList<DownloadManager>();
    private AEMonitor managers_mon = new AEMonitor("GM:Managers");
    private Map manager_map = new HashMap();
    private GlobalMangerProgressListener progress_listener;
    private long lastListenerUpdate;
    private Checker checker;
    private GlobalManagerStatsImpl stats;
    private long last_swarm_stats_calc_time = 0L;
    private long last_swarm_stats = 0L;
    private boolean cripple_downloads_config;
    private TRTrackerScraper trackerScraper;
    private GlobalManagerStatsWriter stats_writer;
    private GlobalManagerHostSupport host_support;
    private Map<HashWrapper, Map> saved_download_manager_state = new HashMap<HashWrapper, Map>();
    private int next_seed_piece_recheck_index;
    private TorrentFolderWatcher torrent_folder_watcher;
    private ArrayList paused_list = new ArrayList();
    private final AEMonitor paused_list_mon = new AEMonitor("GlobalManager:PL");
    private volatile boolean isStopping;
    private volatile boolean destroyed;
    private volatile boolean needsSaving = false;
    private volatile long needsSavingCozStateChanged;
    private boolean seeding_only_mode = false;
    private boolean potentially_seeding_only_mode = false;
    private FrequencyLimitedDispatcher check_seeding_only_state_dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        public void runSupport() {
            GlobalManagerImpl.this.checkSeedingOnlyStateSupport();
        }
    }, 5000);
    private boolean force_start_non_seed_exists;
    private int nat_status = 0;
    private long nat_status_last_good = -1L;
    private boolean nat_status_probably_ok;
    private CopyOnWriteList dm_adapters = new CopyOnWriteList();
    DelayedEvent loadTorrentsDelay = null;
    boolean loadingComplete = false;
    AESemaphore loadingSem = new AESemaphore("Loading Torrents");
    AEMonitor addingDM_monitor = new AEMonitor("addingDM");
    List addingDMs = new ArrayList();
    private MainlineDHTProvider provider = null;
    private TimerEvent auto_resume_timer;
    private boolean auto_resume_disabled = COConfigurationManager.getBooleanParameter("Pause Downloads On Exit") && !COConfigurationManager.getBooleanParameter("Resume Downloads On Start");
    private TaggableLifecycleHandler taggable_life_manager = TagManagerFactory.getTagManager().registerTaggableResolver(this);

    public GlobalManagerImpl(AzureusCore core, GlobalMangerProgressListener listener, long existingTorrentLoadDelay) {
        this.progress_listener = listener;
        this.cripple_downloads_config = "1".equals(System.getProperty("azureus.disabledownloads"));
        AEDiagnostics.addEvidenceGenerator(this);
        this.stats = new GlobalManagerStatsImpl(this);
        try {
            this.stats_writer = new GlobalManagerStatsWriter(core, this.stats);
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Stats unavailable", e));
        }
        if (existingTorrentLoadDelay > 0L) {
            this.loadTorrentsDelay = new DelayedEvent("GM:tld", existingTorrentLoadDelay, new AERunnable(){

                public void runSupport() {
                    GlobalManagerImpl.this.loadExistingTorrentsNow(false);
                }
            });
        } else {
            this.loadDownloads();
        }
        if (this.progress_listener != null) {
            this.progress_listener.reportCurrentTask(MessageText.getString("splash.initializeGM"));
        }
        this.trackerScraper = TRTrackerScraperFactory.getSingleton();
        this.trackerScraper.setClientResolver(new TRTrackerScraperClientResolver(){

            public int getStatus(HashWrapper torrent_hash) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(torrent_hash);
                if (dm == null) {
                    return 1;
                }
                int dm_state = dm.getState();
                if (dm_state == 75) {
                    return 3;
                }
                if (dm_state == 50 || dm_state == 60) {
                    return 2;
                }
                return 4;
            }

            public boolean isNetworkEnabled(HashWrapper hash, URL url) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null) {
                    return false;
                }
                String nw = AENetworkClassifier.categoriseAddress(url.getHost());
                String[] networks = dm.getDownloadState().getNetworks();
                for (int i = 0; i < networks.length; ++i) {
                    if (networks[i] != nw) continue;
                    return true;
                }
                return false;
            }

            public String[] getEnabledNetworks(HashWrapper hash) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null) {
                    return null;
                }
                return dm.getDownloadState().getNetworks();
            }

            public int[] getCachedScrape(HashWrapper hash) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null) {
                    return null;
                }
                long cache = dm.getDownloadState().getLongAttribute("scrapecache");
                if (cache == -1L) {
                    return null;
                }
                int seeds = (int)(cache >> 32 & 0xFFFFFFL);
                int leechers = (int)(cache & 0xFFFFFFL);
                return new int[]{seeds, leechers};
            }

            public Object[] getExtensions(HashWrapper hash) {
                Character state;
                String ext;
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null) {
                    ext = "";
                    state = TRTrackerScraperClientResolver.FL_NONE;
                } else {
                    ext = dm.getDownloadState().getTrackerClientExtensions();
                    if (ext == null) {
                        ext = "";
                    }
                    boolean comp2 = dm.isDownloadComplete(false);
                    int dm_state = dm.getState();
                    state = dm_state == 100 || dm_state == 70 || dm_state == 65 && dm.getSubState() != 75 ? (comp2 ? TRTrackerScraperClientResolver.FL_COMPLETE_STOPPED : TRTrackerScraperClientResolver.FL_INCOMPLETE_STOPPED) : (dm_state == 50 || dm_state == 60 ? (comp2 ? TRTrackerScraperClientResolver.FL_COMPLETE_RUNNING : TRTrackerScraperClientResolver.FL_INCOMPLETE_RUNNING) : (comp2 ? TRTrackerScraperClientResolver.FL_COMPLETE_QUEUED : TRTrackerScraperClientResolver.FL_INCOMPLETE_QUEUED));
                }
                return new Object[]{ext, state};
            }

            public boolean redirectTrackerUrl(HashWrapper hash, URL old_url, URL new_url) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null || dm.getTorrent() == null) {
                    return false;
                }
                return TorrentUtils.replaceAnnounceURL(dm.getTorrent(), old_url, new_url);
            }
        });
        this.trackerScraper.addListener(new TRTrackerScraperListener(){

            public void scrapeReceived(TRTrackerScraperResponse response) {
                HashWrapper hash = response.getHash();
                DownloadManager manager = (DownloadManager)GlobalManagerImpl.this.manager_map.get(hash);
                if (manager != null) {
                    manager.setTrackerScrapeResponse(response);
                }
            }
        });
        try {
            this.host_support = new GlobalManagerHostSupport(this);
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Hosting unavailable", e));
        }
        this.checker = new Checker();
        this.checker.start();
        this.torrent_folder_watcher = new TorrentFolderWatcher(this);
        this.torrent_folder_watcher.start();
        TRTrackerUtils.addListener(new TRTrackerUtilsListener(){

            public void announceDetailsChanged() {
                Logger.log(new LogEvent(LOGID, "Announce details have changed, updating trackers"));
                List managers = GlobalManagerImpl.this.managers_cow;
                for (int i = 0; i < managers.size(); ++i) {
                    DownloadManager manager = (DownloadManager)managers.get(i);
                    manager.requestTrackerAnnounce(true);
                }
            }
        });
        TorrentUtils.addTorrentURLChangeListener(new TorrentUtils.TorrentAnnounceURLChangeListener(){

            public void changed() {
                Logger.log(new LogEvent(LOGID, "Announce URL details have changed, updating trackers"));
                List managers = GlobalManagerImpl.this.managers_cow;
                for (int i = 0; i < managers.size(); ++i) {
                    DownloadManager manager = (DownloadManager)managers.get(i);
                    TRTrackerAnnouncer client = manager.getTrackerClient();
                    if (client == null) continue;
                    client.resetTrackerUrl(false);
                }
            }
        });
        if (TagManagerFactory.getTagManager().isEnabled()) {
            new DownloadStateTagger(this);
        }
    }

    @Override
    public void loadExistingTorrentsNow(boolean async) {
        if (this.loadTorrentsDelay == null) {
            return;
        }
        this.loadTorrentsDelay = null;
        if (async) {
            AEThread thread = new AEThread("load torrents", true){

                public void runSupport() {
                    GlobalManagerImpl.this.loadDownloads();
                }
            };
            thread.setPriority(3);
            thread.start();
        } else {
            this.loadDownloads();
        }
    }

    @Override
    public DownloadManager addDownloadManager(String fileName, String savePath) {
        return this.addDownloadManager(fileName, null, savePath, 0, true);
    }

    @Override
    public DownloadManager addDownloadManager(String fileName, byte[] optionalHash, String savePath, int initialState, boolean persistent) {
        return this.addDownloadManager(fileName, optionalHash, savePath, initialState, persistent, false, null);
    }

    @Override
    public DownloadManager addDownloadManager(String torrent_file_name, byte[] optionalHash, String savePath, int initialState, boolean persistent, boolean for_seeding, DownloadManagerInitialisationAdapter _adapter) {
        return this.addDownloadManager(torrent_file_name, optionalHash, savePath, null, initialState, persistent, for_seeding, _adapter);
    }

    /*
     * Exception decompiling
     */
    @Override
    public DownloadManager addDownloadManager(String torrent_file_name, byte[] optionalHash, String savePath, String saveFile, int initialState, boolean persistent, boolean for_seeding, DownloadManagerInitialisationAdapter _adapter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void clearNonPersistentDownloadState(byte[] hash) {
        this.saved_download_manager_state.remove(new HashWrapper(hash));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DownloadManager addDownloadManager(DownloadManager download_manager, boolean save, boolean notifyListeners) {
        if (!this.isStopping) {
            block43: {
                this.loadExistingTorrentsNow(false);
                this.managers_mon.enter();
                int existing_index = this.managers_cow.indexOf(download_manager);
                if (existing_index == -1) break block43;
                DownloadManager existing = this.managers_cow.get(existing_index);
                download_manager.destroy(true);
                DownloadManager downloadManager = existing;
                Object var49_9 = null;
                this.managers_mon.exit();
                return downloadManager;
            }
            try {
                DownloadManagerStats dm_stats = download_manager.getStats();
                HashWrapper hashwrapper = null;
                try {
                    TOTorrent torrent = download_manager.getTorrent();
                    if (torrent != null) {
                        hashwrapper = torrent.getHashWrapper();
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                Map save_download_state = this.saved_download_manager_state.remove(hashwrapper);
                long saved_data_bytes_downloaded = 0L;
                long saved_data_bytes_uploaded = 0L;
                long saved_data_bytes_downloaded_fake = 0L;
                long saved_data_bytes_uploaded_fake = 0L;
                long saved_discarded = 0L;
                long saved_hashfails = 0L;
                long saved_SecondsDownloading = 0L;
                long saved_SecondsOnlySeeding = 0L;
                if (save_download_state != null) {
                    long ct;
                    Long creation_time;
                    Long already_allocated;
                    Long lSecondsOnlySeeding;
                    Long lSecondsDLing;
                    Category cat;
                    TOTorrent torrent;
                    int zz;
                    int maxUploads;
                    int maxDL = save_download_state.get("maxdl") == null ? 0 : ((Long)save_download_state.get("maxdl")).intValue();
                    int maxUL = save_download_state.get("maxul") == null ? 0 : ((Long)save_download_state.get("maxul")).intValue();
                    Long lDownloaded_fake = (Long)save_download_state.get("downloaded_fake");
                    Long lUploaded_fake = (Long)save_download_state.get("uploaded_fake");
                    Long lDownloaded = (Long)save_download_state.get("downloaded");
                    Long lUploaded = (Long)save_download_state.get("uploaded");
                    Long lCompleted = (Long)save_download_state.get("completed");
                    Long lDiscarded = (Long)save_download_state.get("discarded");
                    Long lHashFailsCount = (Long)save_download_state.get("hashfails");
                    Long lHashFailsBytes = (Long)save_download_state.get("hashfailbytes");
                    Long nbUploads = (Long)save_download_state.get("uploads");
                    if (nbUploads != null && (maxUploads = nbUploads.intValue()) != 4 && download_manager.getMaxUploads() == 4) {
                        download_manager.setMaxUploads(maxUploads);
                    }
                    dm_stats.setDownloadRateLimitBytesPerSecond(maxDL);
                    dm_stats.setUploadRateLimitBytesPerSecond(maxUL);
                    boolean[] tabFakeOption = new boolean[43];
                    int[] tabInt = new int[5];
                    String[] tabString = new String[1];
                    float[] tabFloat = new float[22];
                    boolean[] tabGeneralOption = new boolean[11];
                    for (zz = 0; zz < tabFakeOption.length; ++zz) {
                        tabFakeOption[zz] = ((Long)save_download_state.get("fake_option" + zz)).intValue() == 1;
                    }
                    for (zz = 0; zz < tabFloat.length; ++zz) {
                        tabFloat[zz] = (float)((Long)save_download_state.get("fake_float" + zz)).intValue() / 1000.0f;
                    }
                    for (zz = 0; zz < tabInt.length; ++zz) {
                        tabInt[zz] = ((Long)save_download_state.get("fake_int" + zz)).intValue();
                    }
                    for (zz = 0; zz < tabGeneralOption.length; ++zz) {
                        tabGeneralOption[zz] = ((Long)save_download_state.get("fake_general" + zz)).intValue() == 1;
                    }
                    download_manager.setFakeOption(tabFakeOption);
                    download_manager.setFakeFloatValue(tabFloat);
                    download_manager.setFakeIntValue(tabInt);
                    download_manager.setGeneralOption(tabGeneralOption);
                    if (lCompleted != null) {
                        dm_stats.setDownloadCompleted(lCompleted.intValue());
                    }
                    if (lDiscarded != null) {
                        saved_discarded = lDiscarded;
                    }
                    if (lHashFailsBytes != null) {
                        saved_hashfails = lHashFailsBytes;
                    } else if (lHashFailsCount != null && (torrent = download_manager.getTorrent()) != null) {
                        saved_hashfails = lHashFailsCount * torrent.getPieceLength();
                    }
                    Long lPosition = (Long)save_download_state.get("position");
                    String sCategory = null;
                    if (save_download_state.containsKey("category")) {
                        try {
                            sCategory = new String((byte[])save_download_state.get("category"), "UTF8");
                        }
                        catch (UnsupportedEncodingException e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    if (sCategory != null && (cat = CategoryManager.getCategory(sCategory)) != null) {
                        download_manager.getDownloadState().setCategory(cat);
                    }
                    download_manager.requestAssumedCompleteMode();
                    if (lDownloaded != null && lUploaded != null) {
                        boolean bCompleted = download_manager.isDownloadComplete(false);
                        long lUploadedValue = lUploaded;
                        long lDownloadedValue = lDownloaded;
                        if (bCompleted && lDownloadedValue == 0L) {
                            int dl_copies = COConfigurationManager.getIntParameter("StartStopManager_iAddForSeedingDLCopyCount");
                            lDownloadedValue = download_manager.getSize() * (long)dl_copies;
                            download_manager.getDownloadState().setFlag(1L, true);
                        }
                        saved_data_bytes_downloaded = lDownloadedValue;
                        saved_data_bytes_uploaded = lUploadedValue;
                    }
                    if (lDownloaded_fake != null && lUploaded_fake != null) {
                        long lDownloadedValue_fake;
                        long lUploadedValue_fake = lUploaded_fake;
                        saved_data_bytes_downloaded_fake = lDownloadedValue_fake = lDownloaded_fake.longValue();
                        saved_data_bytes_uploaded_fake = lUploadedValue_fake;
                    }
                    if (lPosition != null) {
                        download_manager.setPosition(lPosition.intValue());
                    }
                    if ((lSecondsDLing = (Long)save_download_state.get("secondsDownloading")) != null) {
                        saved_SecondsDownloading = lSecondsDLing;
                    }
                    if ((lSecondsOnlySeeding = (Long)save_download_state.get("secondsOnlySeeding")) != null) {
                        saved_SecondsOnlySeeding = lSecondsOnlySeeding;
                    }
                    if ((already_allocated = (Long)save_download_state.get("allocated")) != null && already_allocated.intValue() == 1) {
                        download_manager.setDataAlreadyAllocated(true);
                    }
                    if ((creation_time = (Long)save_download_state.get("creationTime")) != null && (ct = creation_time.longValue()) < SystemTime.getCurrentTime()) {
                        download_manager.setCreationTime(ct);
                    }
                } else if (dm_stats.getDownloadCompleted(false) == 1000) {
                    int dl_copies = COConfigurationManager.getIntParameter("StartStopManager_iAddForSeedingDLCopyCount");
                    saved_data_bytes_downloaded = download_manager.getSize() * (long)dl_copies;
                }
                dm_stats.restoreSessionTotals(saved_data_bytes_downloaded, saved_data_bytes_uploaded, saved_data_bytes_downloaded_fake, saved_data_bytes_uploaded_fake, saved_discarded, saved_hashfails, saved_SecondsDownloading, saved_SecondsOnlySeeding);
                boolean isCompleted = download_manager.isDownloadComplete(false);
                if (download_manager.getPosition() == -1) {
                    int endPosition = 0;
                    for (int i = 0; i < this.managers_cow.size(); ++i) {
                        DownloadManager dm = this.managers_cow.get(i);
                        boolean dmIsCompleted = dm.isDownloadComplete(false);
                        if (dmIsCompleted != isCompleted) continue;
                        ++endPosition;
                    }
                    download_manager.setPosition(endPosition + 1);
                }
                download_manager.requestAssumedCompleteMode();
                ArrayList<DownloadManager> new_download_managers = new ArrayList<DownloadManager>(this.managers_cow);
                new_download_managers.add(download_manager);
                this.managers_cow = new_download_managers;
                TOTorrent torrent = download_manager.getTorrent();
                if (torrent != null) {
                    try {
                        this.manager_map.put(new HashWrapper(torrent.getHash()), download_manager);
                    }
                    catch (TOTorrentException e) {
                        Debug.printStackTrace(e);
                    }
                }
                if (COConfigurationManager.getBooleanParameter("Set Completion Flag For Completed Downloads On Start") && download_manager.isDownloadComplete(true)) {
                    download_manager.getDownloadState().setFlag(8L, true);
                }
                if (notifyListeners) {
                    this.listeners_and_event_listeners.dispatch(1, download_manager);
                    this.taggable_life_manager.taggableCreated(download_manager);
                }
                download_manager.addListener(this);
                if (save_download_state != null) {
                    Long lStartStopLocked;
                    Long lForceStart = (Long)save_download_state.get("forceStart");
                    if (lForceStart == null && (lStartStopLocked = (Long)save_download_state.get("startStopLocked")) != null) {
                        lForceStart = lStartStopLocked;
                    }
                    if (lForceStart != null && lForceStart.intValue() == 1) {
                        download_manager.setForceStart(true);
                    }
                }
                Object var49_10 = null;
                this.managers_mon.exit();
            }
            catch (Throwable throwable) {
                Object var49_11 = null;
                this.managers_mon.exit();
                throw throwable;
            }
            if (save) {
                this.saveDownloads(false);
            }
            return download_manager;
        }
        Logger.log(new LogEvent(LOGID, 3, "Tried to add a DownloadManager after shutdown of GlobalManager."));
        return null;
    }

    @Override
    public List<DownloadManager> getDownloadManagers() {
        return this.managers_cow;
    }

    @Override
    public DownloadManager getDownloadManager(TOTorrent torrent) {
        if (torrent == null) {
            return null;
        }
        try {
            return this.getDownloadManager(torrent.getHashWrapper());
        }
        catch (TOTorrentException e) {
            return null;
        }
    }

    @Override
    public DownloadManager getDownloadManager(HashWrapper hw) {
        return (DownloadManager)this.manager_map.get(hw);
    }

    @Override
    public void canDownloadManagerBeRemoved(DownloadManager manager, boolean remove_torrent, boolean remove_data) throws GlobalManagerDownloadRemovalVetoException {
        try {
            this.removal_listeners.dispatchWithException(1, new Object[]{manager, new Boolean(remove_torrent), new Boolean(remove_data)});
        }
        catch (Throwable e) {
            if (e instanceof GlobalManagerDownloadRemovalVetoException) {
                throw (GlobalManagerDownloadRemovalVetoException)e;
            }
            GlobalManagerDownloadRemovalVetoException gmv = new GlobalManagerDownloadRemovalVetoException("Error running veto check");
            gmv.initCause(e);
            Debug.out(e);
            throw gmv;
        }
    }

    @Override
    public void removeDownloadManager(DownloadManager manager) throws GlobalManagerDownloadRemovalVetoException {
        this.removeDownloadManager(manager, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDownloadManager(DownloadManager manager, boolean remove_torrent, boolean remove_data) throws GlobalManagerDownloadRemovalVetoException {
        if (!this.managers_cow.contains(manager)) {
            return;
        }
        this.canDownloadManagerBeRemoved(manager, remove_torrent, remove_data);
        manager.stopIt(70, remove_torrent, remove_data, true);
        try {
            this.managers_mon.enter();
            ArrayList<DownloadManager> new_download_managers = new ArrayList<DownloadManager>(this.managers_cow);
            new_download_managers.remove(manager);
            this.managers_cow = new_download_managers;
            TOTorrent torrent = manager.getTorrent();
            if (torrent != null) {
                try {
                    this.manager_map.remove(new HashWrapper(torrent.getHash()));
                }
                catch (TOTorrentException e) {
                    Debug.printStackTrace(e);
                }
            }
            Object var8_7 = null;
            this.managers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.managers_mon.exit();
            throw throwable;
        }
        TOTorrent torrent = manager.getTorrent();
        if (torrent != null) {
            TorrentUtils.removeCreatedTorrent(torrent);
        }
        manager.destroy(false);
        this.fixUpDownloadManagerPositions();
        this.listeners_and_event_listeners.dispatch(2, manager);
        this.taggable_life_manager.taggableDestroyed(manager);
        manager.removeListener(this);
        this.saveDownloads(false);
        DownloadManagerState dms = manager.getDownloadState();
        if (dms.getCategory() != null) {
            dms.setCategory(null);
        }
        if (manager.getTorrent() != null) {
            this.trackerScraper.remove(manager.getTorrent());
        }
        if (this.host_support != null) {
            this.host_support.torrentRemoved(manager.getTorrentFileName(), manager.getTorrent());
        }
        dms.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopGlobalManager() {
        try {
            this.managers_mon.enter();
            if (this.isStopping) {
                Object var2_1 = null;
                this.managers_mon.exit();
                return;
            }
            this.isStopping = true;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.managers_mon.exit();
            throw throwable;
        }
        Object var2_2 = null;
        this.managers_mon.exit();
        this.stats.save();
        this.informDestroyInitiated();
        if (this.host_support != null) {
            this.host_support.destroy();
        }
        this.torrent_folder_watcher.destroy();
        try {
            NonDaemonTaskRunner.run(new NonDaemonTask(){

                public Object run() {
                    return null;
                }

                public String getName() {
                    return "Stopping global manager";
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        this.checker.stopIt();
        if (COConfigurationManager.getBooleanParameter("Pause Downloads On Exit")) {
            this.pauseDownloads(true);
            this.stopAllDownloads(true);
            this.saveDownloads(true);
        } else {
            this.saveDownloads(true);
            this.stopAllDownloads(true);
        }
        if (this.stats_writer != null) {
            this.stats_writer.destroy();
        }
        DownloadManagerStateFactory.saveGlobalStateCache();
        this.managers_cow = new ArrayList<DownloadManager>();
        this.manager_map.clear();
        this.informDestroyed();
    }

    @Override
    public void stopAllDownloads() {
        this.stopAllDownloads(false);
    }

    protected void stopAllDownloads(boolean for_close) {
        if (for_close && this.progress_listener != null) {
            this.progress_listener.reportCurrentTask(MessageText.getString("splash.unloadingTorrents"));
        }
        long lastListenerUpdate = 0L;
        List<DownloadManager> managers = this.sortForStop();
        int nbDownloads = managers.size();
        for (int i = 0; i < nbDownloads; ++i) {
            int state;
            DownloadManager manager = managers.get(i);
            long now = SystemTime.getCurrentTime();
            if (this.progress_listener != null && now - lastListenerUpdate > 100L) {
                lastListenerUpdate = now;
                int currentDownload = i + 1;
                this.progress_listener.reportPercent(100 * currentDownload / nbDownloads);
                this.progress_listener.reportCurrentTask(MessageText.getString("splash.unloadingTorrent") + " " + currentDownload + " " + MessageText.getString("splash.of") + " " + nbDownloads + " : " + manager.getTorrentFileName());
            }
            if ((state = manager.getState()) == 70 || state == 65) continue;
            manager.stopIt(for_close ? 71 : 70, false, false);
        }
    }

    @Override
    public void startAllDownloads() {
        for (DownloadManager manager : this.managers_cow) {
            if (manager.getState() != 70) continue;
            manager.stopIt(75, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pauseDownload(DownloadManager manager) {
        if (manager.getTorrent() == null) {
            return false;
        }
        int state = manager.getState();
        if (state != 70 && state != 100 && state != 65) {
            try {
                HashWrapper wrapper2 = manager.getTorrent().getHashWrapper();
                boolean forced = manager.isForceStart();
                try {
                    this.paused_list_mon.enter();
                    this.paused_list.add(new Object[]{wrapper2, new Boolean(forced)});
                    Object var6_6 = null;
                    this.paused_list_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    this.paused_list_mon.exit();
                    throw throwable;
                }
                manager.stopIt(70, false, false);
                return true;
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseDownloadsForPeriod(int seconds) {
        try {
            this.paused_list_mon.enter();
            if (this.auto_resume_timer != null) {
                this.auto_resume_timer.cancel();
            }
            this.auto_resume_timer = SimpleTimer.addEvent("GM:auto-resume", SystemTime.getOffsetTime(seconds * 1000), new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    GlobalManagerImpl.this.resumeDownloads();
                }
            });
            Object var3_2 = null;
            this.paused_list_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.paused_list_mon.exit();
            throw throwable;
        }
        this.pauseDownloads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPauseDownloadPeriodRemaining() {
        block3: {
            try {
                this.paused_list_mon.enter();
                if (this.auto_resume_timer == null) break block3;
                long rem = this.auto_resume_timer.getWhen() - SystemTime.getCurrentTime();
                int n = Math.max(0, (int)(rem / 1000L));
                Object var5_3 = null;
                this.paused_list_mon.exit();
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.paused_list_mon.exit();
                throw throwable;
            }
        }
        Object var5_4 = null;
        this.paused_list_mon.exit();
        return 0;
    }

    @Override
    public void pauseDownloads() {
        this.pauseDownloads(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pauseDownloads(boolean tag_only) {
        List<DownloadManager> managers = this.sortForStop();
        for (DownloadManager manager : managers) {
            int state;
            if (manager.getTorrent() == null || (state = manager.getState()) == 70 || state == 100 || state == 65) continue;
            try {
                Object var8_8;
                boolean forced = manager.isForceStart();
                try {
                    this.paused_list_mon.enter();
                    this.paused_list.add(new Object[]{manager.getTorrent().getHashWrapper(), new Boolean(forced)});
                    var8_8 = null;
                    this.paused_list_mon.exit();
                }
                catch (Throwable throwable) {
                    var8_8 = null;
                    this.paused_list_mon.exit();
                    throw throwable;
                }
                if (tag_only) continue;
                manager.stopIt(70, false, false);
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public boolean canPauseDownload(DownloadManager manager) {
        if (manager.getTorrent() == null) {
            return false;
        }
        int state = manager.getState();
        return state != 70 && state != 100 && state != 65;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isPaused(DownloadManager manager) {
        boolean bl;
        if (this.paused_list.size() == 0) {
            return false;
        }
        try {
            this.paused_list_mon.enter();
            for (int i = 0; i < this.paused_list.size(); ++i) {
                Object[] data = (Object[])this.paused_list.get(i);
                HashWrapper hash = (HashWrapper)data[0];
                DownloadManager this_manager = this.getDownloadManager(hash);
                if (this_manager != manager) continue;
                boolean bl2 = true;
                Object var8_7 = null;
                this.paused_list_mon.exit();
                return bl2;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.paused_list_mon.exit();
            throw throwable;
        }
        Object var8_8 = null;
        this.paused_list_mon.exit();
        return bl;
    }

    @Override
    public boolean canPauseDownloads() {
        for (DownloadManager manager : this.managers_cow) {
            if (!this.canPauseDownload(manager)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeDownload(DownloadManager manager) {
        boolean resume_ok = false;
        boolean force = false;
        try {
            this.paused_list_mon.enter();
            for (int i = 0; i < this.paused_list.size(); ++i) {
                Object[] data = (Object[])this.paused_list.get(i);
                HashWrapper hash = (HashWrapper)data[0];
                force = (Boolean)data[1];
                DownloadManager this_manager = this.getDownloadManager(hash);
                if (this_manager != manager) continue;
                resume_ok = true;
                this.paused_list.remove(i);
                break;
            }
            Object var9_8 = null;
            this.paused_list_mon.exit();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.paused_list_mon.exit();
            throw throwable;
        }
        if (resume_ok && manager.getState() == 70) {
            if (force) {
                manager.setForceStart(true);
            } else {
                manager.stopIt(75, false, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean resumingDownload(DownloadManager manager) {
        try {
            this.paused_list_mon.enter();
            int i = 0;
            while (true) {
                if (i >= this.paused_list.size()) {
                    Object var8_8 = null;
                    this.paused_list_mon.exit();
                    return false;
                }
                Object[] data = (Object[])this.paused_list.get(i);
                HashWrapper hash = (HashWrapper)data[0];
                DownloadManager this_manager = this.getDownloadManager(hash);
                if (this_manager == manager) {
                    this.paused_list.remove(i);
                    boolean bl = true;
                    Object var8_7 = null;
                    this.paused_list_mon.exit();
                    return bl;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.paused_list_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeDownloads() {
        this.auto_resume_disabled = false;
        try {
            this.paused_list_mon.enter();
            if (this.auto_resume_timer != null) {
                this.auto_resume_timer.cancel();
                this.auto_resume_timer = null;
            }
            for (int i = 0; i < this.paused_list.size(); ++i) {
                Object[] data = (Object[])this.paused_list.get(i);
                HashWrapper hash = (HashWrapper)data[0];
                boolean force = (Boolean)data[1];
                DownloadManager manager = this.getDownloadManager(hash);
                if (manager == null || manager.getState() != 70) continue;
                if (force) {
                    manager.setForceStart(true);
                    continue;
                }
                manager.stopIt(75, false, false);
            }
            this.paused_list.clear();
            Object var7_6 = null;
            this.paused_list_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.paused_list_mon.exit();
            throw throwable;
        }
    }

    @Override
    public boolean resumeDownloads(boolean is_auto_resume) {
        if (is_auto_resume && this.auto_resume_disabled) {
            return false;
        }
        this.resumeDownloads();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canResumeDownloads() {
        try {
            this.paused_list_mon.enter();
            int i = 0;
            while (true) {
                if (i >= this.paused_list.size()) {
                    Object var7_7 = null;
                    this.paused_list_mon.exit();
                    return false;
                }
                Object[] data = (Object[])this.paused_list.get(i);
                HashWrapper hash = (HashWrapper)data[0];
                DownloadManager manager = this.getDownloadManager(hash);
                if (manager != null && manager.getState() == 70) {
                    boolean bl = true;
                    Object var7_6 = null;
                    this.paused_list_mon.exit();
                    return bl;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.paused_list_mon.exit();
            throw throwable;
        }
    }

    private List<DownloadManager> sortForStop() {
        ArrayList<DownloadManager> managers = new ArrayList<DownloadManager>(this.managers_cow);
        Collections.sort(managers, new Comparator<DownloadManager>(){

            @Override
            public int compare(DownloadManager o1, DownloadManager o2) {
                int s1 = o1.getState();
                int s2 = o2.getState();
                if (s2 == 75) {
                    return 1;
                }
                if (s1 == 75) {
                    return -1;
                }
                return 0;
            }
        });
        return managers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDownloads() {
        try {
            if (this.cripple_downloads_config) {
                this.loadingComplete = true;
                this.loadingSem.releaseForever();
                Object var22_1 = null;
                this.taggable_life_manager.initialized(this.getResolvedTaggables());
                return;
            }
            try {
                DownloadManagerStateFactory.loadGlobalStateCache();
                int triggerOnCount = 2;
                ArrayList<DownloadManager> downloadsAdded = new ArrayList<DownloadManager>();
                this.lastListenerUpdate = 0L;
                try {
                    try {
                        int nbDownloads;
                        if (this.progress_listener != null) {
                            this.progress_listener.reportCurrentTask(MessageText.getString("splash.loadingTorrents"));
                        }
                        Map map = FileUtil.readResilientConfigFile("downloads.config");
                        boolean debug = Boolean.getBoolean("debug");
                        Iterator<Object> iter = null;
                        List downloads = (List)map.get("downloads");
                        if (downloads == null) {
                            iter = map.values().iterator();
                            nbDownloads = map.size();
                        } else {
                            iter = downloads.iterator();
                            nbDownloads = downloads.size();
                        }
                        int currentDownload = 0;
                        while (iter.hasNext()) {
                            Map mDownload = (Map)iter.next();
                            DownloadManager dm = this.loadDownload(mDownload, ++currentDownload, nbDownloads, this.progress_listener, debug);
                            if (dm == null) continue;
                            downloadsAdded.add(dm);
                            if (downloadsAdded.size() < triggerOnCount) continue;
                            triggerOnCount *= 2;
                            this.triggerAddListener(downloadsAdded);
                            downloadsAdded.clear();
                        }
                        COConfigurationManager.setParameter("Set Completion Flag For Completed Downloads On Start", false);
                        ArrayList pause_data = (ArrayList)map.get("pause_data");
                        if (pause_data != null) {
                            try {
                                this.paused_list_mon.enter();
                                for (int i = 0; i < pause_data.size(); ++i) {
                                    boolean force;
                                    byte[] key;
                                    Object pd = pause_data.get(i);
                                    if (pd instanceof byte[]) {
                                        key = (byte[])pause_data.get(i);
                                        force = false;
                                    } else {
                                        Map m = (Map)pd;
                                        key = (byte[])m.get("hash");
                                        force = ((Long)m.get("force")).intValue() == 1;
                                    }
                                    this.paused_list.add(new Object[]{new HashWrapper(key), new Boolean(force)});
                                }
                                Object var16_20 = null;
                                this.paused_list_mon.exit();
                            }
                            catch (Throwable throwable) {
                                Object var16_21 = null;
                                this.paused_list_mon.exit();
                                throw throwable;
                            }
                        }
                        this.fixUpDownloadManagerPositions();
                        Logger.log(new LogEvent(LOGID, "Loaded " + this.managers_cow.size() + " torrents"));
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        Object var18_24 = null;
                        this.loadingComplete = true;
                        this.triggerAddListener(downloadsAdded);
                        this.loadingSem.releaseForever();
                    }
                    Object var18_23 = null;
                    this.loadingComplete = true;
                    this.triggerAddListener(downloadsAdded);
                    this.loadingSem.releaseForever();
                }
                catch (Throwable throwable) {
                    Object var18_25 = null;
                    this.loadingComplete = true;
                    this.triggerAddListener(downloadsAdded);
                    this.loadingSem.releaseForever();
                    throw throwable;
                }
                Object var20_27 = null;
            }
            catch (Throwable throwable) {
                Object var20_28 = null;
                DownloadManagerStateFactory.discardGlobalStateCache();
                throw throwable;
            }
            DownloadManagerStateFactory.discardGlobalStateCache();
            {
            }
        }
        catch (Throwable throwable) {
            Object var22_3 = null;
            this.taggable_life_manager.initialized(this.getResolvedTaggables());
            throw throwable;
        }
        Object var22_2 = null;
        this.taggable_life_manager.initialized(this.getResolvedTaggables());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerAddListener(List downloadsToAdd) {
        try {
            this.managers_mon.enter();
            List listenersCopy = this.listeners_and_event_listeners.getListenersCopy();
            for (int j = 0; j < listenersCopy.size(); ++j) {
                Object listener = listenersCopy.get(j);
                if (!(listener instanceof GlobalManagerListener)) continue;
                GlobalManagerListener gmListener = (GlobalManagerListener)listener;
                for (int i = 0; i < downloadsToAdd.size(); ++i) {
                    DownloadManager dm = (DownloadManager)downloadsToAdd.get(i);
                    gmListener.downloadManagerAdded(dm);
                }
            }
            Object var9_8 = null;
            this.managers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.managers_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void saveState() {
        this.saveDownloads(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveDownloads(boolean immediate) {
        if (!immediate) {
            this.needsSaving = true;
            return;
        }
        if (!this.loadingComplete) {
            this.needsSaving = true;
            return;
        }
        this.needsSaving = false;
        this.needsSavingCozStateChanged = 0L;
        if (this.cripple_downloads_config) {
            return;
        }
        try {
            this.managers_mon.enter();
            Collections.sort(this.managers_cow, new Comparator(){

                public final int compare(Object a, Object b) {
                    return ((DownloadManager)a).getPosition() - ((DownloadManager)b).getPosition();
                }
            });
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Saving Download List (" + this.managers_cow.size() + " items)"));
            }
            HashMap map = new HashMap();
            ArrayList<Map> list = new ArrayList<Map>(this.managers_cow.size());
            for (int i = 0; i < this.managers_cow.size(); ++i) {
                DownloadManager dm = this.managers_cow.get(i);
                Map dmMap = this.exportDownloadStateToMapSupport(dm, true);
                list.add(dmMap);
            }
            map.put("downloads", list);
            try {
                this.paused_list_mon.enter();
                if (!this.paused_list.isEmpty()) {
                    ArrayList pause_data = new ArrayList();
                    for (int i = 0; i < this.paused_list.size(); ++i) {
                        Object[] data = (Object[])this.paused_list.get(i);
                        HashWrapper hash = (HashWrapper)data[0];
                        Boolean force = (Boolean)data[1];
                        HashMap<String, Object> m = new HashMap<String, Object>();
                        m.put("hash", hash.getHash());
                        m.put("force", new Long(force != false ? 1L : 0L));
                        pause_data.add(m);
                    }
                    map.put("pause_data", pause_data);
                }
                Object var11_12 = null;
                this.paused_list_mon.exit();
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                this.paused_list_mon.exit();
                throw throwable;
            }
            FileUtil.writeResilientConfigFile("downloads.config", map);
            Object var13_15 = null;
            this.managers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            this.managers_mon.exit();
            throw throwable;
        }
    }

    public DownloadManager loadDownload(Map mDownload, int currentDownload, int nbDownloads, GlobalMangerProgressListener progress_listener, boolean debug) {
        try {
            List file_priorities;
            DownloadManager dm;
            boolean has_ever_been_started;
            String torrent_save_file;
            String torrent_save_dir;
            byte[] torrent_save_dir_bytes;
            byte[] torrent_hash = (byte[])mDownload.get("torrent_hash");
            Long lPersistent = (Long)mDownload.get("persistent");
            boolean persistent = lPersistent == null || lPersistent == 1L;
            String fileName = new String((byte[])mDownload.get("torrent"), "UTF8");
            if (progress_listener != null && SystemTime.getCurrentTime() - this.lastListenerUpdate > 100L) {
                this.lastListenerUpdate = SystemTime.getCurrentTime();
                String shortFileName = fileName;
                try {
                    File f = new File(fileName);
                    shortFileName = f.getName();
                }
                catch (Exception e) {
                    // empty catch block
                }
                progress_listener.reportPercent(100 * currentDownload / nbDownloads);
                progress_listener.reportCurrentTask(MessageText.getString("splash.loadingTorrent") + " " + currentDownload + " " + MessageText.getString("splash.of") + " " + nbDownloads + " : " + shortFileName);
            }
            if ((torrent_save_dir_bytes = (byte[])mDownload.get("save_dir")) != null) {
                byte[] torrent_save_file_bytes = (byte[])mDownload.get("save_file");
                torrent_save_dir = new String(torrent_save_dir_bytes, "UTF8");
                torrent_save_file = torrent_save_file_bytes != null ? new String(torrent_save_file_bytes, "UTF8") : null;
            } else {
                byte[] savePathBytes = (byte[])mDownload.get("path");
                torrent_save_dir = new String(savePathBytes, "UTF8");
                torrent_save_file = null;
            }
            int state = 0;
            if (debug) {
                state = 70;
            } else if (mDownload.containsKey("state")) {
                state = ((Long)mDownload.get("state")).intValue();
                if (state != 70 && state != 75 && state != 0) {
                    state = 75;
                }
            } else {
                int stopped = ((Long)mDownload.get("stopped")).intValue();
                if (stopped == 1) {
                    state = 70;
                }
            }
            Long seconds_downloading = (Long)mDownload.get("secondsDownloading");
            boolean bl = has_ever_been_started = seconds_downloading != null && seconds_downloading > 0L;
            if (torrent_hash != null) {
                this.saved_download_manager_state.put(new HashWrapper(torrent_hash), mDownload);
            }
            if (persistent && this.addDownloadManager(dm = DownloadManagerFactory.create((GlobalManager)this, torrent_hash, fileName, torrent_save_dir, torrent_save_file, state, true, true, has_ever_been_started, file_priorities = (List)mDownload.get("file_priorities")), false, false) == dm) {
                return dm;
            }
        }
        catch (UnsupportedEncodingException e1) {
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Error while loading downloads.  One download may not have been added to the list.", e));
        }
        return null;
    }

    @Override
    public Map exportDownloadStateToMap(DownloadManager dm) {
        return this.exportDownloadStateToMapSupport(dm, false);
    }

    @Override
    public DownloadManager importDownloadStateFromMap(Map map) {
        DownloadManager dm = this.loadDownload(map, 1, 1, null, false);
        if (dm != null) {
            ArrayList<DownloadManager> dms = new ArrayList<DownloadManager>(1);
            dms.add(dm);
            this.triggerAddListener(dms);
        }
        return dm;
    }

    private Map exportDownloadStateToMapSupport(DownloadManager dm, boolean internal_export) {
        int zz;
        DownloadManagerStats dm_stats = dm.getStats();
        HashMap<String, Object> dmMap = new HashMap<String, Object>();
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null) {
            try {
                dmMap.put("torrent_hash", torrent.getHash());
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        File save_loc = dm.getAbsoluteSaveLocation();
        dmMap.put("persistent", new Long(dm.isPersistent() ? 1L : 0L));
        dmMap.put("torrent", dm.getTorrentFileName());
        dmMap.put("save_dir", save_loc.getParent());
        dmMap.put("save_file", save_loc.getName());
        dmMap.put("maxdl", new Long(dm_stats.getDownloadRateLimitBytesPerSecond()));
        dmMap.put("maxul", new Long(dm_stats.getUploadRateLimitBytesPerSecond()));
        boolean[] tabFakeOption = dm.getFakeOption();
        int[] tabInt = dm.getFakeIntValue();
        String[] tabString = dm.getFakeStringValue();
        float[] tabFloat = dm.getFakeFloatValue();
        boolean[] tabGeneralOption = dm.getGeneralOption();
        for (zz = 0; zz < tabFakeOption.length; ++zz) {
            dmMap.put("fake_option" + zz, new Long(tabFakeOption[zz] ? 1L : 0L));
        }
        for (zz = 0; zz < tabFloat.length; ++zz) {
            dmMap.put("fake_float" + zz, new Long((int)(tabFloat[zz] * 1000.0f)));
        }
        for (zz = 0; zz < tabInt.length; ++zz) {
            dmMap.put("fake_int" + zz, new Long(tabInt[zz]));
        }
        for (zz = 0; zz < tabString.length; ++zz) {
            dmMap.put("fake_string" + zz, tabString[zz]);
        }
        for (zz = 0; zz < tabGeneralOption.length; ++zz) {
            dmMap.put("fake_general" + zz, new Long(tabGeneralOption[zz] ? 1L : 0L));
        }
        int state = dm.getState();
        if (state == 100) {
            state = 70;
        } else if (dm.getAssumedComplete() && !dm.isForceStart() && state != 70) {
            state = 75;
        } else if (state != 70 && state != 75 && state != 0) {
            state = 0;
        }
        dmMap.put("state", new Long(state));
        if (internal_export) {
            dmMap.put("position", new Long(dm.getPosition()));
        }
        dmMap.put("downloaded", new Long(dm_stats.getTotalDataBytesReceived()));
        dmMap.put("uploaded", new Long(dm_stats.getTotalDataBytesSent()));
        dmMap.put("downloaded_fake", new Long(dm_stats.getTotalDataBytesReceivedFake()));
        dmMap.put("uploaded_fake", new Long(dm_stats.getTotalDataBytesSentFake()));
        dmMap.put("completed", new Long(dm_stats.getDownloadCompleted(true)));
        dmMap.put("discarded", new Long(dm_stats.getDiscarded()));
        dmMap.put("hashfailbytes", new Long(dm_stats.getHashFailBytes()));
        dmMap.put("forceStart", new Long(dm.isForceStart() && dm.getState() != 30 ? 1L : 0L));
        dmMap.put("secondsDownloading", new Long(dm_stats.getSecondsDownloading()));
        dmMap.put("secondsOnlySeeding", new Long(dm_stats.getSecondsOnlySeeding()));
        dmMap.put("uploads", new Long(dm.getMaxUploads()));
        dmMap.put("creationTime", new Long(dm.getCreationTime()));
        dm.saveDownload();
        List file_priorities = (List)dm.getData("file_priorities");
        if (file_priorities != null) {
            dmMap.put("file_priorities", file_priorities);
        }
        dmMap.put("allocated", new Long(dm.isDataAlreadyAllocated() ? 1L : 0L));
        return dmMap;
    }

    @Override
    public TRTrackerScraper getTrackerScraper() {
        return this.trackerScraper;
    }

    @Override
    public GlobalManagerStats getStats() {
        return this.stats;
    }

    @Override
    public boolean contains(DownloadManager manager) {
        if (this.managers_cow != null && manager != null) {
            return this.managers_cow.contains(manager);
        }
        return false;
    }

    @Override
    public int getIndexOf(DownloadManager manager) {
        if (this.managers_cow != null && manager != null) {
            return this.managers_cow.indexOf(manager);
        }
        return -1;
    }

    @Override
    public boolean isMoveableUp(DownloadManager manager) {
        if (manager.isDownloadComplete(false) && COConfigurationManager.getIntParameter("StartStopManager_iRankType") != 0 && COConfigurationManager.getBooleanParameter("StartStopManager_bAutoReposition")) {
            return false;
        }
        return manager.getPosition() > 1;
    }

    @Override
    public int downloadManagerCount(boolean bCompleted) {
        int numInGroup = 0;
        for (DownloadManager dm : this.managers_cow) {
            if (dm.isDownloadComplete(false) != bCompleted) continue;
            ++numInGroup;
        }
        return numInGroup;
    }

    @Override
    public boolean isMoveableDown(DownloadManager manager) {
        boolean isCompleted = manager.isDownloadComplete(false);
        if (isCompleted && COConfigurationManager.getIntParameter("StartStopManager_iRankType") != 0 && COConfigurationManager.getBooleanParameter("StartStopManager_bAutoReposition")) {
            return false;
        }
        return manager.getPosition() < this.downloadManagerCount(isCompleted);
    }

    @Override
    public void moveUp(DownloadManager manager) {
        this.moveTo(manager, manager.getPosition() - 1);
    }

    @Override
    public void moveDown(DownloadManager manager) {
        this.moveTo(manager, manager.getPosition() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTop(DownloadManager[] manager) {
        try {
            this.managers_mon.enter();
            int newPosition = 1;
            for (int i = 0; i < manager.length; ++i) {
                this.moveTo(manager[i], newPosition++);
            }
            Object var5_4 = null;
            this.managers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.managers_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveEnd(DownloadManager[] manager) {
        try {
            this.managers_mon.enter();
            int endPosComplete = 0;
            int endPosIncomplete = 0;
            for (int j = 0; j < this.managers_cow.size(); ++j) {
                DownloadManager dm = this.managers_cow.get(j);
                if (dm.isDownloadComplete(false)) {
                    ++endPosComplete;
                    continue;
                }
                ++endPosIncomplete;
            }
            for (int i = manager.length - 1; i >= 0; --i) {
                if (manager[i].isDownloadComplete(false) && endPosComplete > 0) {
                    this.moveTo(manager[i], endPosComplete--);
                    continue;
                }
                if (endPosIncomplete <= 0) continue;
                this.moveTo(manager[i], endPosIncomplete--);
            }
            Object var7_6 = null;
            this.managers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.managers_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTo(DownloadManager manager, int newPosition) {
        boolean curCompleted = manager.isDownloadComplete(false);
        if (newPosition < 1 || newPosition > this.downloadManagerCount(curCompleted)) {
            return;
        }
        try {
            this.managers_mon.enter();
            int curPosition = manager.getPosition();
            if (newPosition > curPosition) {
                int numToMove = newPosition - curPosition;
                for (int i = 0; i < this.managers_cow.size(); ++i) {
                    int dmPosition;
                    DownloadManager dm = this.managers_cow.get(i);
                    boolean dmCompleted = dm.isDownloadComplete(false);
                    if (dmCompleted != curCompleted || (dmPosition = dm.getPosition()) <= curPosition || dmPosition > newPosition) continue;
                    dm.setPosition(dmPosition - 1);
                    if (--numToMove <= 0) break;
                }
                manager.setPosition(newPosition);
            } else if (newPosition < curPosition && curPosition > 1) {
                int numToMove = curPosition - newPosition;
                for (int i = 0; i < this.managers_cow.size(); ++i) {
                    DownloadManager dm = this.managers_cow.get(i);
                    boolean dmCompleted = dm.isDownloadComplete(false);
                    int dmPosition = dm.getPosition();
                    if (dmCompleted != curCompleted || dmPosition < newPosition || dmPosition >= curPosition) continue;
                    dm.setPosition(dmPosition + 1);
                    if (--numToMove <= 0) break;
                }
                manager.setPosition(newPosition);
            }
            Object var11_15 = null;
            this.managers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            this.managers_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fixUpDownloadManagerPositions() {
        try {
            this.managers_mon.enter();
            int posComplete = 1;
            int posIncomplete = 1;
            Collections.sort(this.managers_cow, new Comparator(){

                public final int compare(Object a, Object b) {
                    int i = ((DownloadManager)a).getPosition() - ((DownloadManager)b).getPosition();
                    if (i != 0) {
                        return i;
                    }
                    if (((DownloadManager)a).isPersistent()) {
                        return 1;
                    }
                    if (((DownloadManager)b).isPersistent()) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (int i = 0; i < this.managers_cow.size(); ++i) {
                DownloadManager dm = this.managers_cow.get(i);
                if (dm.isDownloadComplete(false)) {
                    dm.setPosition(posComplete++);
                    continue;
                }
                dm.setPosition(posIncomplete++);
            }
            Object var6_5 = null;
            this.managers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.managers_mon.exit();
            throw throwable;
        }
    }

    @Override
    public long getResolverTaggableType() {
        return 2L;
    }

    @Override
    public Taggable resolveTaggable(String id) {
        if (id == null) {
            return null;
        }
        return this.getDownloadManager(new HashWrapper(Base32.decode(id)));
    }

    @Override
    public List<Taggable> getResolvedTaggables() {
        return new ArrayList<Taggable>(this.getDownloadManagers());
    }

    protected void informDestroyed() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.listeners_and_event_listeners.dispatch(4, null, true);
    }

    public void informDestroyInitiated() {
        this.listeners_and_event_listeners.dispatch(3, null, true);
    }

    @Override
    public void addListener(GlobalManagerListener listener) {
        this.addListener(listener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(GlobalManagerListener listener, boolean trigger) {
        if (this.isStopping) {
            listener.destroyed();
        } else {
            this.listeners_and_event_listeners.addListener(listener);
            if (!trigger) {
                return;
            }
            try {
                this.managers_mon.enter();
                List<DownloadManager> managers = this.managers_cow;
                for (int i = 0; i < managers.size(); ++i) {
                    listener.downloadManagerAdded(managers.get(i));
                }
                Object var6_5 = null;
                this.managers_mon.exit();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.managers_mon.exit();
                throw throwable;
            }
        }
    }

    @Override
    public void removeListener(GlobalManagerListener listener) {
        this.listeners_and_event_listeners.removeListener(listener);
    }

    @Override
    public void addEventListener(GlobalManagerEventListener listener) {
        this.listeners_and_event_listeners.addListener(listener);
    }

    @Override
    public void removeEventListener(GlobalManagerEventListener listener) {
        this.listeners_and_event_listeners.removeListener(listener);
    }

    @Override
    public void fireGlobalManagerEvent(final int type, final DownloadManager param) {
        this.listeners_and_event_listeners.dispatch(6, new GlobalManagerEvent(){

            public int getEventType() {
                return type;
            }

            public DownloadManager getDownload() {
                return param;
            }
        });
    }

    @Override
    public void addDownloadWillBeRemovedListener(GlobalManagerDownloadWillBeRemovedListener l) {
        this.removal_listeners.addListener(l);
    }

    @Override
    public void removeDownloadWillBeRemovedListener(GlobalManagerDownloadWillBeRemovedListener l) {
        this.removal_listeners.removeListener(l);
    }

    @Override
    public void stateChanged(DownloadManager manager, int new_state) {
        if (this.needsSavingCozStateChanged == 0L) {
            this.needsSavingCozStateChanged = SystemTime.getMonotonousTime();
        }
        PEPeerManager pm_manager = manager.getPeerManager();
        if (new_state == 50 && pm_manager != null && pm_manager.hasDownloadablePiece()) {
            this.setSeedingOnlyState(false, false);
        } else {
            this.checkSeedingOnlyState();
        }
        this.checkForceStart(manager.isForceStart() && new_state == 50);
    }

    protected void checkForceStart(boolean known_to_exist) {
        boolean exists;
        if (known_to_exist) {
            exists = true;
        } else {
            exists = false;
            if (this.force_start_non_seed_exists) {
                List<DownloadManager> managers = this.managers_cow;
                for (int i = 0; i < managers.size(); ++i) {
                    DownloadManager dm = managers.get(i);
                    if (!dm.isForceStart() || dm.getState() != 50) continue;
                    exists = true;
                    break;
                }
            }
        }
        if (exists != this.force_start_non_seed_exists) {
            this.force_start_non_seed_exists = exists;
            Logger.log(new LogEvent(LOGID, "Force start download " + (this.force_start_non_seed_exists ? "exists" : "doesn't exist") + ", modifying download weighting"));
            PeerControlSchedulerFactory.overrideWeightedPriorities(this.force_start_non_seed_exists);
        }
    }

    protected void checkSeedingOnlyState() {
        this.check_seeding_only_state_dispatcher.dispatch();
    }

    protected void checkSeedingOnlyStateSupport() {
        boolean seeding = false;
        boolean seeding_set = false;
        boolean potentially_seeding = false;
        List<DownloadManager> managers = this.managers_cow;
        for (int i = 0; i < managers.size(); ++i) {
            DownloadManager dm = managers.get(i);
            PEPeerManager pm = dm.getPeerManager();
            int state = dm.getState();
            if (dm.getDiskManager() == null || pm == null) {
                if (state != 75) continue;
                if (dm.isDownloadComplete(false)) {
                    potentially_seeding = true;
                    continue;
                }
                seeding = false;
                seeding_set = true;
                continue;
            }
            if (state == 50) {
                if (!pm.hasDownloadablePiece()) {
                    if (seeding_set) continue;
                    seeding = true;
                    continue;
                }
                seeding = false;
                potentially_seeding = false;
                break;
            }
            if (state != 60 || seeding_set) continue;
            seeding = true;
        }
        if (seeding) {
            potentially_seeding = true;
        }
        this.setSeedingOnlyState(seeding, potentially_seeding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSeedingOnlyState(boolean seeding, boolean potentially_seeding) {
        GlobalManagerImpl globalManagerImpl = this;
        synchronized (globalManagerImpl) {
            if (seeding != this.seeding_only_mode || potentially_seeding != this.potentially_seeding_only_mode) {
                this.seeding_only_mode = seeding;
                this.potentially_seeding_only_mode = potentially_seeding;
                this.listeners_and_event_listeners.dispatch(5, new boolean[]{this.seeding_only_mode, this.potentially_seeding_only_mode});
            }
        }
    }

    @Override
    public boolean isSeedingOnly() {
        return this.seeding_only_mode;
    }

    @Override
    public boolean isPotentiallySeedingOnly() {
        return this.potentially_seeding_only_mode;
    }

    public long getTotalSwarmsPeerRate(boolean downloading, boolean seeding) {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_swarm_stats_calc_time || now - this.last_swarm_stats_calc_time >= 1000L) {
            long total = 0L;
            List<DownloadManager> managers = this.managers_cow;
            for (int i = 0; i < managers.size(); ++i) {
                boolean is_seeding;
                DownloadManager manager = managers.get(i);
                boolean bl = is_seeding = manager.getState() == 60;
                if ((!downloading || is_seeding) && (!seeding || !is_seeding)) continue;
                total += manager.getStats().getTotalAveragePerPeer();
            }
            this.last_swarm_stats = total;
            this.last_swarm_stats_calc_time = now;
        }
        return this.last_swarm_stats;
    }

    protected void computeNATStatus() {
        int num_ok = 0;
        int num_probably_ok = 0;
        int num_bad = 0;
        for (DownloadManager manager : this.managers_cow) {
            int status = manager.getNATStatus();
            if (status == 1) {
                ++num_ok;
                continue;
            }
            if (status == 2) {
                ++num_probably_ok;
                continue;
            }
            if (status != 3) continue;
            ++num_bad;
        }
        long now = SystemTime.getMonotonousTime();
        if (num_ok > 0) {
            this.nat_status = 1;
            this.nat_status_last_good = now;
        } else if (this.nat_status_last_good != -1L && now - this.nat_status_last_good < 1800000L) {
            this.nat_status = 1;
        } else if (this.nat_status_last_good != -1L && SystemTime.getCurrentTime() - TCPNetworkManager.getSingleton().getLastIncomingNonLocalConnectionTime() < 1800000L) {
            this.nat_status = 1;
        } else if (num_probably_ok > 0 || this.nat_status_probably_ok) {
            this.nat_status = 2;
            this.nat_status_probably_ok = true;
        } else {
            this.nat_status = num_bad > 0 ? 3 : 0;
        }
    }

    @Override
    public int getNATStatus() {
        return this.nat_status;
    }

    protected void seedPieceRecheck() {
        DownloadManager manager;
        int i;
        List<DownloadManager> managers = this.managers_cow;
        if (this.next_seed_piece_recheck_index >= managers.size()) {
            this.next_seed_piece_recheck_index = 0;
        }
        for (i = this.next_seed_piece_recheck_index; i < managers.size(); ++i) {
            manager = managers.get(i);
            if (!this.seedPieceRecheck(manager)) continue;
            this.next_seed_piece_recheck_index = i + 1;
            if (this.next_seed_piece_recheck_index >= managers.size()) {
                this.next_seed_piece_recheck_index = 0;
            }
            return;
        }
        for (i = 0; i < this.next_seed_piece_recheck_index; ++i) {
            manager = managers.get(i);
            if (!this.seedPieceRecheck(manager)) continue;
            this.next_seed_piece_recheck_index = i + 1;
            if (this.next_seed_piece_recheck_index >= managers.size()) {
                this.next_seed_piece_recheck_index = 0;
            }
            return;
        }
    }

    protected boolean seedPieceRecheck(DownloadManager manager) {
        if (manager.getState() != 60) {
            return false;
        }
        return manager.seedPieceRecheck();
    }

    protected DownloadManagerInitialisationAdapter getDMAdapter(DownloadManagerInitialisationAdapter adapter) {
        List adapters = this.dm_adapters.getList();
        adapters = new ArrayList(adapters);
        if (adapter != null) {
            adapters.add(adapter);
        }
        ArrayList<DownloadManagerInitialisationAdapter> tag_assigners = new ArrayList<DownloadManagerInitialisationAdapter>();
        ArrayList<DownloadManagerInitialisationAdapter> tag_processors = new ArrayList<DownloadManagerInitialisationAdapter>();
        for (DownloadManagerInitialisationAdapter a : adapters) {
            int actions = a.getActions();
            if ((actions & 1) != 0) {
                tag_assigners.add(a);
            }
            if ((actions & 2) == 0) continue;
            tag_processors.add(a);
        }
        if (tag_assigners.size() > 0 && tag_processors.size() > 0) {
            for (DownloadManagerInitialisationAdapter a : tag_processors) {
                adapters.remove(a);
            }
            int pos = adapters.indexOf(tag_assigners.get(tag_assigners.size() - 1));
            for (DownloadManagerInitialisationAdapter a : tag_processors) {
                adapters.add(++pos, a);
            }
        }
        final List f_adapters = adapters;
        return new DownloadManagerInitialisationAdapter(){

            public int getActions() {
                return 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void initialised(DownloadManager manager, boolean for_seeding) {
                for (int i = 0; i < f_adapters.size(); ++i) {
                    try {
                        ((DownloadManagerInitialisationAdapter)f_adapters.get(i)).initialised(manager, for_seeding);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                if (Constants.isOSX) {
                    GlobalManagerImpl.this.fixLongFileName(manager);
                }
                if (COConfigurationManager.getBooleanParameter("Rename Incomplete Files")) {
                    DiskManagerFileInfo[] fileInfos;
                    String ext = COConfigurationManager.getStringParameter("Rename Incomplete Files Extension").trim();
                    DownloadManagerState state = manager.getDownloadState();
                    String existing_ext = state.getAttribute("incompfilesuffix");
                    if (ext.length() > 0 && existing_ext == null && (fileInfos = manager.getDiskManagerFileInfo()).length <= 2048) {
                        ext = FileUtil.convertOSSpecificChars(ext, false);
                        try {
                            state.suppressStateSave(true);
                            ArrayList<Integer> from_indexes = new ArrayList<Integer>();
                            ArrayList<File> from_links = new ArrayList<File>();
                            ArrayList<File> to_links = new ArrayList<File>();
                            for (int i = 0; i < fileInfos.length; ++i) {
                                DiskManagerFileInfo fileInfo2 = fileInfos[i];
                                File base_file = fileInfo2.getFile(false);
                                File existing_link = state.getFileLink(i, base_file);
                                if (existing_link == null && base_file.exists() || existing_link != null && existing_link.exists()) continue;
                                File new_link = existing_link == null ? new File(base_file.getParentFile(), base_file.getName() + ext) : new File(existing_link.getParentFile(), existing_link.getName() + ext);
                                from_indexes.add(i);
                                from_links.add(base_file);
                                to_links.add(new_link);
                            }
                            if (from_links.size() > 0) {
                                state.setFileLinks(from_indexes, from_links, to_links);
                            }
                            Object var16_17 = null;
                            state.setAttribute("incompfilesuffix", ext);
                            state.suppressStateSave(false);
                        }
                        catch (Throwable throwable) {
                            Object var16_18 = null;
                            state.setAttribute("incompfilesuffix", ext);
                            state.suppressStateSave(false);
                            throw throwable;
                        }
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixLongFileName(DownloadManager manager) {
        DiskManagerFileInfo[] fileInfos = manager.getDiskManagerFileInfo();
        DownloadManagerState state = manager.getDownloadState();
        try {
            state.suppressStateSave(true);
            block5: for (int i = 0; i < fileInfos.length; ++i) {
                DiskManagerFileInfo fileInfo2 = fileInfos[i];
                File base_file = fileInfo2.getFile(false);
                File existing_link = state.getFileLink(i, base_file);
                if (existing_link != null || base_file.exists()) continue;
                String name = base_file.getName();
                String ext = FileUtil.getExtension(name);
                int extLength = ext.length();
                int origLength = (name = name.substring(0, name.length() - extLength)).length();
                if (origLength <= 50) continue;
                File parentFile = base_file.getParentFile();
                parentFile.mkdirs();
                File newFile = null;
                boolean first = true;
                while (name.length() > 50) {
                    try {
                        boolean redo;
                        newFile = new File(parentFile, name + ext);
                        newFile.getCanonicalPath();
                        if (first) continue block5;
                        int fixNameID = 255;
                        block7: do {
                            redo = false;
                            for (int j = 0; j < i; ++j) {
                                DiskManagerFileInfo convertedFileInfo = fileInfos[j];
                                if (!newFile.equals(convertedFileInfo.getFile(true))) continue;
                                while (++fixNameID < 4095 && (newFile = new File(parentFile, (name = name.substring(0, name.length() - 3) + Integer.toHexString(fixNameID)) + ext)).equals(convertedFileInfo.getFile(true))) {
                                }
                                redo = fixNameID <= 4095;
                                continue block7;
                            }
                        } while (redo);
                        if (fixNameID > 4095) continue block5;
                        state.setFileLink(i, base_file, newFile);
                        continue block5;
                    }
                    catch (IOException e) {
                        first = false;
                        name = name.substring(0, name.length() - 1);
                    }
                    catch (Throwable t) {
                        Debug.out(t);
                    }
                }
            }
            Object var20_21 = null;
            state.suppressStateSave(false);
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            state.suppressStateSave(false);
            throw throwable;
        }
    }

    @Override
    public void addDownloadManagerInitialisationAdapter(DownloadManagerInitialisationAdapter adapter) {
        this.dm_adapters.add(adapter);
    }

    @Override
    public void removeDownloadManagerInitialisationAdapter(DownloadManagerInitialisationAdapter adapter) {
        this.dm_adapters.remove(adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println("Global Manager");
        try {
            writer.indent();
            this.managers_mon.enter();
            writer.println("  managers: " + this.managers_cow.size());
            for (int i = 0; i < this.managers_cow.size(); ++i) {
                Object var5_4;
                DownloadManager manager = this.managers_cow.get(i);
                try {
                    writer.indent();
                    manager.generateEvidence(writer);
                    var5_4 = null;
                    writer.exdent();
                    continue;
                }
                catch (Throwable throwable) {
                    var5_4 = null;
                    writer.exdent();
                    throw throwable;
                }
            }
            Object var7_6 = null;
            this.managers_mon.exit();
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.managers_mon.exit();
            writer.exdent();
            throw throwable;
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"C:\\temp\\downloads.config", "C:\\temp\\downloads-9-3-05.config", "C:\\temp\\merged.config"};
        } else if (args.length != 3) {
            System.out.println("Usage: newer_config_file older_config_file save_config_file");
            return;
        }
        try {
            Map map1 = FileUtil.readResilientFile(new File(args[0]));
            Map map2 = FileUtil.readResilientFile(new File(args[1]));
            List downloads1 = (List)map1.get("downloads");
            List downloads2 = (List)map2.get("downloads");
            HashSet<HashWrapper> torrents = new HashSet<HashWrapper>();
            for (Map m : downloads1) {
                byte[] hash = (byte[])m.get("torrent_hash");
                System.out.println("1:" + ByteFormatter.nicePrint(hash));
                torrents.add(new HashWrapper(hash));
            }
            ArrayList<Map> to_add = new ArrayList<Map>();
            for (Map m : downloads2) {
                byte[] hash = (byte[])m.get("torrent_hash");
                HashWrapper wrapper2 = new HashWrapper(hash);
                if (torrents.contains(wrapper2)) {
                    System.out.println("-:" + ByteFormatter.nicePrint(hash));
                    continue;
                }
                System.out.println("2:" + ByteFormatter.nicePrint(hash));
                to_add.add(m);
            }
            downloads1.addAll(to_add);
            System.out.println(to_add.size() + " copied from " + args[1] + " to " + args[2]);
            FileUtil.writeResilientFile(new File(args[2]), map1);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setMainlineDHTProvider(MainlineDHTProvider provider2) {
        this.provider = provider2;
    }

    @Override
    public MainlineDHTProvider getMainlineDHTProvider() {
        return this.provider;
    }

    @Override
    public void statsRequest(Map request2, Map reply) {
        AzureusCore core = AzureusCoreFactory.getSingleton();
        HashMap<String, Long> glob = new HashMap<String, Long>();
        reply.put("gm", glob);
        try {
            boolean bias_up;
            glob.put("u_rate", new Long(this.stats.getDataAndProtocolSendRate()));
            glob.put("d_rate", new Long(this.stats.getDataAndProtocolReceiveRate()));
            glob.put("d_lim", new Long(TransferSpeedValidator.getGlobalDownloadRateLimitBytesPerSecond()));
            boolean auto_up = TransferSpeedValidator.isAutoSpeedActive(this) && TransferSpeedValidator.isAutoUploadAvailable(core);
            glob.put("auto_up", new Long(auto_up ? COConfigurationManager.getLongParameter("Auto Upload Speed Version") : 0L));
            long up_lim = NetworkManager.getMaxUploadRateBPSNormal();
            boolean seeding_only = NetworkManager.isSeedingOnlyUploadRate();
            glob.put("so", new Long(seeding_only ? 1L : 0L));
            if (seeding_only) {
                up_lim = NetworkManager.getMaxUploadRateBPSSeedingOnly();
            }
            glob.put("u_lim", new Long(up_lim));
            SpeedManager sm = core.getSpeedManager();
            if (sm != null) {
                glob.put("u_cap", new Long(sm.getEstimatedUploadCapacityBytesPerSec().getBytesPerSec()));
                glob.put("d_cap", new Long(sm.getEstimatedDownloadCapacityBytesPerSec().getBytesPerSec()));
            }
            List<DownloadManager> dms = this.getDownloadManagers();
            int comp2 = 0;
            int incomp = 0;
            long comp_up = 0L;
            long incomp_up = 0L;
            long incomp_down = 0L;
            for (DownloadManager dm : dms) {
                int state = dm.getState();
                if (state != 60 && state != 50) continue;
                DownloadManagerStats stats2 = dm.getStats();
                if (dm.isDownloadComplete(false)) {
                    ++comp2;
                    comp_up += stats2.getProtocolSendRate() + stats2.getDataSendRate();
                    continue;
                }
                ++incomp;
                incomp_up += stats2.getProtocolSendRate() + stats2.getDataSendRate();
                incomp_down += stats2.getProtocolReceiveRate() + stats2.getDataReceiveRate();
            }
            glob.put("dm_i", new Long(incomp));
            glob.put("dm_c", new Long(comp2));
            glob.put("dm_i_u", new Long(incomp_up));
            glob.put("dm_i_d", new Long(incomp_down));
            glob.put("dm_c_u", new Long(comp_up));
            glob.put("nat", new Long(this.nat_status));
            boolean request_limiting = COConfigurationManager.getBooleanParameter("Use Request Limiting");
            glob.put("req_lim", new Long(request_limiting ? 1L : 0L));
            if (request_limiting) {
                glob.put("req_focus", new Long(COConfigurationManager.getBooleanParameter("Use Request Limiting Priorities") ? 1L : 0L));
            }
            glob.put("bias_up", new Long((bias_up = COConfigurationManager.getBooleanParameter("Bias Upload Enable")) ? 1L : 0L));
            if (bias_up) {
                glob.put("bias_slack", new Long(COConfigurationManager.getLongParameter("Bias Upload Slack KBs")));
                glob.put("bias_ulim", new Long(COConfigurationManager.getBooleanParameter("Bias Upload Handle No Limit") ? 1L : 0L));
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public class Checker
    extends AEThread {
        int loopFactor;
        private static final int waitTime = 10000;
        private int saveResumeLoopCount;
        private int initSaveResumeLoopCount;
        private int natCheckLoopCount;
        private int seedPieceCheckCount;
        private int oneMinuteThingCount;
        private AESemaphore run_sem;

        public Checker() {
            super("Global Status Checker");
            this.saveResumeLoopCount = 30;
            this.initSaveResumeLoopCount = 6;
            this.natCheckLoopCount = 3;
            this.seedPieceCheckCount = 3;
            this.oneMinuteThingCount = 6;
            this.run_sem = new AESemaphore("GM:Checker:run");
            this.loopFactor = 0;
            this.setPriority(1);
        }

        private void determineSaveResumeDataInterval() {
            int saveResumeInterval = COConfigurationManager.getIntParameter("Save Resume Interval", 5);
            if (saveResumeInterval >= 1 && saveResumeInterval <= 90) {
                this.saveResumeLoopCount = saveResumeInterval * 60000 / 10000;
            }
        }

        public void runSupport() {
            while (true) {
                block18: {
                    try {
                        ++this.loopFactor;
                        this.determineSaveResumeDataInterval();
                        if (this.loopFactor % this.saveResumeLoopCount == 0) {
                            GlobalManagerImpl.this.saveDownloads(true);
                        } else if (GlobalManagerImpl.this.loadingComplete && this.loopFactor > this.initSaveResumeLoopCount && GlobalManagerImpl.this.needsSavingCozStateChanged > 0L) {
                            int num_downloads = GlobalManagerImpl.this.managers_cow.size();
                            boolean do_save = false;
                            if (num_downloads < 10) {
                                do_save = true;
                            } else {
                                long now = SystemTime.getMonotonousTime();
                                long elapsed_secs = (now - GlobalManagerImpl.this.needsSavingCozStateChanged) / 1000L;
                                boolean bl = do_save = elapsed_secs > (long)num_downloads;
                            }
                            if (do_save) {
                                GlobalManagerImpl.this.saveDownloads(true);
                            }
                        }
                        if (this.loopFactor % this.natCheckLoopCount == 0) {
                            GlobalManagerImpl.this.computeNATStatus();
                            GlobalManagerImpl.this.checkSeedingOnlyState();
                            GlobalManagerImpl.this.checkForceStart(false);
                        }
                        if (this.loopFactor % this.seedPieceCheckCount == 0) {
                            GlobalManagerImpl.this.seedPieceRecheck();
                        }
                        if (this.loopFactor % this.saveResumeLoopCount == 0) {
                            for (DownloadManager manager : GlobalManagerImpl.this.managers_cow) {
                                manager.saveResumeData();
                            }
                        }
                        if (this.loopFactor % this.oneMinuteThingCount != 0) break block18;
                        try {
                            if (!HttpURLConnection.getFollowRedirects()) {
                                Debug.outNoStack("Something has set global 'follow redirects' to false!!!!");
                                HttpURLConnection.setFollowRedirects(true);
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                try {
                    this.run_sem.reserve(10000L);
                    if (!this.run_sem.isReleasedForever()) continue;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                    continue;
                }
                break;
            }
        }

        public void stopIt() {
            this.run_sem.releaseForever();
        }
    }

    private static class DownloadStateTagger
    extends TagTypeWithState
    implements DownloadManagerListener {
        private static final int[] color_default = new int[]{41, 140, 165};
        private Object main_tag_key = new Object();
        private Object comp_tag_key = new Object();
        private TagDownloadWithState tag_initialising;
        private TagDownloadWithState tag_downloading;
        private TagDownloadWithState tag_seeding;
        private TagDownloadWithState tag_queued_downloading;
        private TagDownloadWithState tag_queued_seeding;
        private TagDownloadWithState tag_stopped;
        private TagDownloadWithState tag_error;
        private TagDownloadWithState tag_active;
        private TagDownloadWithState tag_inactive;
        private TagDownloadWithState tag_complete;
        private TagDownloadWithState tag_incomplete;
        private TagDownloadWithState tag_paused;
        private int user_mode = -1;

        private DownloadStateTagger(GlobalManagerImpl _gm) {
            super(2, 63, "tag.type.ds");
            COConfigurationManager.addAndFireParameterListener("User Mode", new ParameterListener(){

                public void parameterChanged(String parameterName) {
                    int old_mode = DownloadStateTagger.this.user_mode;
                    DownloadStateTagger.this.user_mode = COConfigurationManager.getIntParameter("User Mode");
                    if (old_mode != -1) {
                        DownloadStateTagger.this.fireChanged();
                    }
                }
            });
            this.addTagType();
            this.tag_initialising = new MyTag(0, "tag.type.ds.init", false, false, false, 0);
            this.tag_downloading = new MyTag(1, "tag.type.ds.down", true, true, true, 3);
            this.tag_seeding = new MyTag(2, "tag.type.ds.seed", true, true, false, 3);
            this.tag_queued_downloading = new MyTag(3, "tag.type.ds.qford", false, false, false, 3);
            this.tag_queued_seeding = new MyTag(4, "tag.type.ds.qfors", false, false, false, 3);
            this.tag_stopped = new MyTag(5, "tag.type.ds.stop", false, false, false, 8);
            this.tag_error = new MyTag(6, "tag.type.ds.err", false, false, false, 0);
            this.tag_active = new MyTag(7, "tag.type.ds.act", true, false, false, 3);
            this.tag_paused = new MyTag(8, "tag.type.ds.pau", false, false, false, 4);
            this.tag_inactive = new MyTag(9, "tag.type.ds.inact", false, false, false, 11);
            this.tag_complete = new MyTag(10, "tag.type.ds.comp", true, true, false, 11);
            this.tag_incomplete = new MyTag(11, "tag.type.ds.incomp", true, true, true, 11);
            _gm.addListener(new GlobalManagerAdapter(){

                public void downloadManagerAdded(DownloadManager dm) {
                    dm.addListener(DownloadStateTagger.this, true);
                }

                public void downloadManagerRemoved(DownloadManager dm) {
                    dm.removeListener(DownloadStateTagger.this);
                    DownloadStateTagger.this.remove(dm);
                }
            });
            SimpleTimer.addPeriodicEvent("gm:ds", 10000L, new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    DownloadStateTagger.this.updateActive();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(DownloadManager manager, int state) {
            Boolean was_complete;
            Tag new_tag;
            if (manager.isDestroyed()) {
                this.remove(manager);
                return;
            }
            Tag old_tag = (Tag)manager.getUserData(this.main_tag_key);
            boolean complete = manager.isDownloadComplete(false);
            switch (state) {
                case 0: 
                case 5: 
                case 10: 
                case 20: 
                case 30: 
                case 40: {
                    if (old_tag == null) {
                        new_tag = this.tag_initialising;
                        break;
                    }
                    new_tag = old_tag;
                    break;
                }
                case 50: 
                case 55: {
                    new_tag = this.tag_downloading;
                    break;
                }
                case 60: {
                    new_tag = this.tag_seeding;
                    break;
                }
                case 65: 
                case 70: 
                case 71: {
                    new_tag = this.tag_stopped;
                    break;
                }
                case 75: {
                    if (complete) {
                        new_tag = this.tag_queued_seeding;
                        break;
                    }
                    new_tag = this.tag_queued_downloading;
                    break;
                }
                default: {
                    new_tag = this.tag_error;
                }
            }
            if (old_tag != new_tag) {
                if (old_tag != null) {
                    old_tag.removeTaggable(manager);
                }
                new_tag.addTaggable(manager);
                manager.setUserData(this.main_tag_key, new_tag);
                DownloadStateTagger downloadStateTagger = this;
                synchronized (downloadStateTagger) {
                    boolean was_inactive = this.tag_inactive.hasTaggable(manager);
                    if (new_tag != this.tag_seeding && new_tag != this.tag_downloading) {
                        this.tag_active.removeTaggable(manager);
                        if (!was_inactive) {
                            this.tag_inactive.addTaggable(manager);
                        }
                    } else {
                        boolean was_active = this.tag_active.hasTaggable(manager);
                        if (!was_active && !was_inactive) {
                            this.tag_inactive.addTaggable(manager);
                        }
                    }
                }
                if (new_tag == this.tag_stopped && manager.isPaused()) {
                    this.tag_paused.addTaggable(manager);
                } else if (old_tag == this.tag_stopped) {
                    this.tag_paused.removeTaggable(manager);
                }
            }
            if ((was_complete = (Boolean)manager.getUserData(this.comp_tag_key)) == null || was_complete != complete) {
                DownloadStateTagger downloadStateTagger = this;
                synchronized (downloadStateTagger) {
                    if (complete) {
                        if (!this.tag_complete.hasTaggable(manager)) {
                            this.tag_complete.addTaggable(manager);
                            this.tag_incomplete.removeTaggable(manager);
                        }
                    } else if (!this.tag_incomplete.hasTaggable(manager)) {
                        this.tag_incomplete.addTaggable(manager);
                        this.tag_complete.removeTaggable(manager);
                    }
                    manager.setUserData(this.comp_tag_key, complete);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateActive() {
            DownloadStateTagger downloadStateTagger = this;
            synchronized (downloadStateTagger) {
                HashSet<DownloadManager> active = new HashSet<DownloadManager>(this.tag_active.getTaggedDownloads());
                for (TagDownloadWithState tag : new TagDownloadWithState[]{this.tag_downloading, this.tag_seeding}) {
                    for (DownloadManager dm : tag.getTaggedDownloads()) {
                        DownloadManagerStats stats2 = dm.getStats();
                        boolean is_active = stats2.getDataReceiveRate() + stats2.getDataSendRate() > 0L && !dm.isDestroyed();
                        if (!is_active || active.remove(dm)) continue;
                        this.tag_active.addTaggable(dm);
                        this.tag_inactive.removeTaggable(dm);
                    }
                }
                for (DownloadManager dm : active) {
                    this.tag_active.removeTaggable(dm);
                    if (dm.isDestroyed()) continue;
                    this.tag_inactive.addTaggable(dm);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(DownloadManager manager) {
            Tag old_tag = (Tag)manager.getUserData(this.main_tag_key);
            if (old_tag != null) {
                old_tag.removeTaggable(manager);
            }
            DownloadStateTagger downloadStateTagger = this;
            synchronized (downloadStateTagger) {
                if (this.tag_active.hasTaggable(manager)) {
                    this.tag_active.removeTaggable(manager);
                } else {
                    this.tag_inactive.removeTaggable(manager);
                }
                if (this.tag_complete.hasTaggable(manager)) {
                    this.tag_complete.removeTaggable(manager);
                } else {
                    this.tag_incomplete.removeTaggable(manager);
                }
                if (this.tag_paused.hasTaggable(manager)) {
                    this.tag_paused.removeTaggable(manager);
                }
            }
        }

        public void downloadComplete(DownloadManager manager) {
        }

        public void completionChanged(DownloadManager manager, boolean bCompleted) {
            this.stateChanged(manager, manager.getState());
        }

        public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
        }

        public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
        }

        public int[] getColorDefault() {
            return color_default;
        }

        private class MyTag
        extends TagDownloadWithState {
            private MyTag(int tag_id, String name, boolean do_rates, boolean do_up, boolean do_down, int run_states) {
                super((TagTypeBase)DownloadStateTagger.this, tag_id, name, do_rates, do_up, do_down, run_states);
                this.addTag();
            }

            protected boolean getVisibleDefault() {
                int id = this.getTagID();
                if (id >= 7 && id <= 9) {
                    return DownloadStateTagger.this.user_mode > 0;
                }
                return false;
            }

            protected boolean getCanBePublicDefault() {
                return false;
            }
        }
    }
}

