/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl;

import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPieceWriteImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemTime;

public class PEPieceImpl
implements PEPiece {
    private static final LogIDs LOGID = LogIDs.PIECES;
    private final DiskManagerPiece dmPiece;
    private final PEPeerManager manager;
    private final int nbBlocks;
    private long creationTime = SystemTime.getCurrentTime();
    private final String[] requested;
    private boolean fully_requested;
    private final boolean[] downloaded;
    private boolean fully_downloaded;
    private long time_last_download;
    private final String[] writers;
    private List writes;
    private String reservedBy;
    private int speed;
    private int resumePriority;
    private Object real_time_data;
    protected static final AEMonitor class_mon = new AEMonitor("PEPiece:class");

    public PEPieceImpl(PEPeerManager _manager, DiskManagerPiece _dm_piece, int _pieceSpeed) {
        this.manager = _manager;
        this.dmPiece = _dm_piece;
        this.speed = _pieceSpeed;
        this.nbBlocks = this.dmPiece.getNbBlocks();
        this.requested = new String[this.nbBlocks];
        boolean[] written = this.dmPiece.getWritten();
        this.downloaded = written == null ? new boolean[this.nbBlocks] : (boolean[])written.clone();
        this.writers = new String[this.nbBlocks];
        this.writes = new ArrayList(0);
    }

    public DiskManagerPiece getDMPiece() {
        return this.dmPiece;
    }

    public long getCreationTime() {
        long now = SystemTime.getCurrentTime();
        if (now >= this.creationTime && this.creationTime > 0L) {
            return this.creationTime;
        }
        this.creationTime = now;
        return now;
    }

    public long getTimeSinceLastActivity() {
        long now = SystemTime.getCurrentTime();
        long lastWriteTime = this.getLastDownloadTime(now);
        if (lastWriteTime > 0L) {
            return now - lastWriteTime;
        }
        long lastCreateTime = this.creationTime;
        if (lastCreateTime > 0L && now >= lastCreateTime) {
            return now - lastCreateTime;
        }
        this.creationTime = now;
        return 0L;
    }

    public long getLastDownloadTime(long now) {
        if (this.time_last_download <= now) {
            return this.time_last_download;
        }
        this.time_last_download = now;
        return this.time_last_download;
    }

    public boolean isRequested(int blockNumber) {
        return this.requested[blockNumber] != null;
    }

    public boolean isDownloaded(int blockNumber) {
        return this.downloaded[blockNumber];
    }

    public void setDownloaded(int offset) {
        this.time_last_download = SystemTime.getCurrentTime();
        this.downloaded[offset / 16384] = true;
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i]) continue;
            return;
        }
        this.fully_downloaded = true;
        this.fully_requested = false;
    }

    public void clearDownloaded(int offset) {
        this.downloaded[offset / 16384] = false;
        this.fully_downloaded = false;
    }

    public boolean isDownloaded() {
        return this.fully_downloaded;
    }

    public boolean[] getDownloaded() {
        return this.downloaded;
    }

    public boolean hasUndownloadedBlock() {
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i]) continue;
            return true;
        }
        return false;
    }

    public void setWritten(PEPeer peer, int blockNumber) {
        this.writers[blockNumber] = peer.getIp();
        this.dmPiece.setWritten(blockNumber);
    }

    public void clearRequested(int blockNumber) {
        this.requested[blockNumber] = this.downloaded[blockNumber] ? this.writers[blockNumber] : null;
        this.fully_requested = false;
    }

    public boolean isRequested() {
        return this.fully_requested;
    }

    public void setRequested() {
        this.fully_requested = true;
    }

    public void checkRequests() {
        if (this.getTimeSinceLastActivity() < 30000L) {
            return;
        }
        int cleared = 0;
        for (int i = 0; i < this.nbBlocks; ++i) {
            String requester;
            if (this.downloaded[i] || this.dmPiece.isWritten(i) || (requester = this.requested[i]) == null || this.manager.requestExists(requester, this.getPieceNumber(), i * 16384, this.getBlockSize(i))) continue;
            this.clearRequested(i);
            ++cleared;
        }
        if (cleared > 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this.dmPiece.getManager().getTorrent(), LOGID, 1, "checkRequests(): piece #" + this.getPieceNumber() + " cleared " + cleared + " requests"));
            }
        } else if (this.fully_requested && this.getNbUnrequested() > 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this.dmPiece.getManager().getTorrent(), LOGID, 1, "checkRequests(): piece #" + this.getPieceNumber() + " reset fully requested"));
            }
            this.fully_requested = false;
        }
    }

    public boolean hasUnrequestedBlock() {
        boolean[] written = this.dmPiece.getWritten();
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i] || this.requested[i] != null || written != null && written[i]) continue;
            return true;
        }
        return false;
    }

    public int[] getAndMarkBlocks(PEPeer peer, int nbWanted, int[] request_hint, boolean reverse_order) {
        int block_index;
        int blocksFound;
        int i;
        String ip = peer.getIp();
        boolean[] written = this.dmPiece.getWritten();
        if (request_hint != null) {
            int block_index2;
            int blocksFound2;
            int i2;
            int hint_block_start = request_hint[1] / 16384;
            int hint_block_end = (request_hint[1] + request_hint[2] - 1) / 16384;
            if (reverse_order) {
                for (i2 = Math.min(this.nbBlocks - 1, hint_block_end); i2 >= hint_block_start; --i2) {
                    blocksFound2 = 0;
                    for (block_index2 = i2; !(blocksFound2 >= nbWanted || block_index2 >= this.nbBlocks || this.downloaded[block_index2] || this.requested[block_index2] != null || written != null && written[block_index2]); ++blocksFound2, --block_index2) {
                        this.requested[block_index2] = ip;
                    }
                    if (blocksFound2 <= 0) continue;
                    return new int[]{block_index2 + 1, blocksFound2};
                }
            } else {
                for (i2 = hint_block_start; i2 < this.nbBlocks && i2 <= hint_block_end; ++i2) {
                    blocksFound2 = 0;
                    for (block_index2 = i2; !(blocksFound2 >= nbWanted || block_index2 >= this.nbBlocks || this.downloaded[block_index2] || this.requested[block_index2] != null || written != null && written[block_index2]); ++blocksFound2, ++block_index2) {
                        this.requested[block_index2] = ip;
                    }
                    if (blocksFound2 <= 0) continue;
                    return new int[]{i2, blocksFound2};
                }
            }
        }
        if (reverse_order) {
            for (i = this.nbBlocks - 1; i >= 0; --i) {
                blocksFound = 0;
                for (block_index = i; !(blocksFound >= nbWanted || block_index < 0 || this.downloaded[block_index] || this.requested[block_index] != null || written != null && written[block_index]); ++blocksFound, --block_index) {
                    this.requested[block_index] = ip;
                }
                if (blocksFound <= 0) continue;
                return new int[]{block_index + 1, blocksFound};
            }
        } else {
            for (i = 0; i < this.nbBlocks; ++i) {
                blocksFound = 0;
                for (block_index = i; !(blocksFound >= nbWanted || block_index >= this.nbBlocks || this.downloaded[block_index] || this.requested[block_index] != null || written != null && written[block_index]); ++blocksFound, ++block_index) {
                    this.requested[block_index] = ip;
                }
                if (blocksFound <= 0) continue;
                return new int[]{i, blocksFound};
            }
        }
        return new int[]{-1, 0};
    }

    public void getAndMarkBlock(PEPeer peer, int index) {
        this.requested[index] = peer.getIp();
        if (this.getNbUnrequested() <= 0) {
            this.setRequested();
        }
    }

    public int getNbRequests() {
        int result = 0;
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i] || this.requested[i] == null) continue;
            ++result;
        }
        return result;
    }

    public int getNbUnrequested() {
        int result = 0;
        boolean[] written = this.dmPiece.getWritten();
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i] || this.requested[i] != null || written != null && written[i]) continue;
            ++result;
        }
        return result;
    }

    public boolean setRequested(PEPeer peer, int blockNumber) {
        if (!this.downloaded[blockNumber]) {
            this.requested[blockNumber] = peer.getIp();
            return true;
        }
        return false;
    }

    public boolean isRequestable() {
        return this.dmPiece.isDownloadable() && !this.fully_downloaded && !this.fully_requested;
    }

    public int getBlockSize(int blockNumber) {
        int length;
        if (blockNumber == this.nbBlocks - 1 && (length = this.dmPiece.getLength()) % 16384 != 0) {
            return length % 16384;
        }
        return 16384;
    }

    public int getBlockNumber(int offset) {
        return offset / 16384;
    }

    public int getNbBlocks() {
        return this.nbBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPieceWrites() {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPieceWrites(int blockNumber) {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
            Object var4_3 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            PEPieceWriteImpl write = (PEPieceWriteImpl)iter.next();
            if (write.getBlockNumber() == blockNumber) continue;
            iter.remove();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPieceWrites(PEPeer peer) {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
            Object var4_3 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            PEPieceWriteImpl write = (PEPieceWriteImpl)iter.next();
            if (peer != null && peer.getIp().equals(write.getSender())) continue;
            iter.remove();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPieceWrites(String ip) {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
            Object var4_3 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            PEPieceWriteImpl write = (PEPieceWriteImpl)iter.next();
            if (write.getSender().equals(ip)) continue;
            iter.remove();
        }
        return result;
    }

    public void reset() {
        this.dmPiece.reset();
        for (int i = 0; i < this.nbBlocks; ++i) {
            this.requested[i] = null;
            this.downloaded[i] = false;
            this.writers[i] = null;
        }
        this.fully_downloaded = false;
        this.time_last_download = 0L;
        this.reservedBy = null;
        this.real_time_data = null;
    }

    public Object getRealTimeData() {
        return this.real_time_data;
    }

    public void setRealTimeData(Object o) {
        this.real_time_data = o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWrite(PEPieceWriteImpl write) {
        try {
            class_mon.enter();
            this.writes.add(write);
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public void addWrite(int blockNumber, String sender, byte[] hash, boolean correct) {
        this.addWrite(new PEPieceWriteImpl(blockNumber, sender, hash, correct));
    }

    public String[] getWriters() {
        return this.writers;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int newSpeed) {
        this.speed = newSpeed;
    }

    public void setLastRequestedPeerSpeed(int peerSpeed) {
        if (peerSpeed > this.speed) {
            ++this.speed;
        }
    }

    public PEPeerManager getManager() {
        return this.manager;
    }

    public void setReservedBy(String peer) {
        this.reservedBy = peer;
    }

    public String getReservedBy() {
        return this.reservedBy;
    }

    public void reDownloadBlock(int blockNumber) {
        this.downloaded[blockNumber] = false;
        this.requested[blockNumber] = null;
        this.fully_downloaded = false;
        this.writers[blockNumber] = null;
        this.dmPiece.reDownloadBlock(blockNumber);
    }

    public void reDownloadBlocks(String address) {
        for (int i = 0; i < this.writers.length; ++i) {
            String writer = this.writers[i];
            if (writer == null || !writer.equals(address)) continue;
            this.reDownloadBlock(i);
        }
    }

    public void setResumePriority(int p) {
        this.resumePriority = p;
    }

    public int getResumePriority() {
        return this.resumePriority;
    }

    public int getAvailability() {
        return this.manager.getAvailability(this.dmPiece.getPieceNumber());
    }

    public int getNbWritten() {
        return this.dmPiece.getNbWritten();
    }

    public boolean[] getWritten() {
        return this.dmPiece.getWritten();
    }

    public boolean isWritten() {
        return this.dmPiece.isWritten();
    }

    public boolean isWritten(int block) {
        return this.dmPiece.isWritten(block);
    }

    public int getPieceNumber() {
        return this.dmPiece.getPieceNumber();
    }

    public int getLength() {
        return this.dmPiece.getLength();
    }

    public void setRequestable() {
        this.fully_downloaded = false;
        this.fully_requested = false;
        this.dmPiece.setDownloadable();
    }

    public String getString() {
        String text = "";
        PiecePicker pp = this.manager.getPiecePicker();
        text = text + (this.isRequestable() ? "reqable," : "");
        text = text + "req=" + this.getNbRequests() + ",";
        text = text + (this.isRequested() ? "reqstd," : "");
        text = text + (this.isDownloaded() ? "downed," : "");
        text = text + (this.getReservedBy() != null ? "resrv," : "");
        text = text + "speed=" + this.getSpeed() + ",";
        if ((text = text + (pp == null ? "pri=" + this.getResumePriority() : pp.getPieceString(this.dmPiece.getPieceNumber()))).endsWith(",")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }
}

