/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.control;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import com.aelitis.azureus.core.peermanager.control.PeerControlInstance;
import com.aelitis.azureus.core.peermanager.control.PeerControlScheduler;
import com.aelitis.azureus.core.peermanager.control.PeerControlSchedulerFactory;
import com.aelitis.azureus.core.peermanager.nat.PeerNATInitiator;
import com.aelitis.azureus.core.peermanager.nat.PeerNATTraversalAdapter;
import com.aelitis.azureus.core.peermanager.nat.PeerNATTraverser;
import com.aelitis.azureus.core.peermanager.peerdb.PeerDatabase;
import com.aelitis.azureus.core.peermanager.peerdb.PeerDatabaseFactory;
import com.aelitis.azureus.core.peermanager.peerdb.PeerExchangerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItemFactory;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePickerFactory;
import com.aelitis.azureus.core.peermanager.unchoker.Unchoker;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerFactory;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadHelper;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadSlotManager;
import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.core.tracker.TrackerPeerSourceAdapter;
import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.math.BigDecimal;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.IPFilterListener;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManager;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerManagerStatsImpl;
import org.gudy.azureus2.core3.peer.impl.PEPeerStatsImpl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransportFactory;
import org.gudy.azureus2.core3.peer.impl.PEPieceImpl;
import org.gudy.azureus2.core3.peer.impl.PEPieceWriteImpl;
import org.gudy.azureus2.core3.peer.impl.control.SuperSeedPeer;
import org.gudy.azureus2.core3.peer.impl.control.SuperSeedPiece;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.BrokenMd5Hasher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.network.OutgoingMessageQueue;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEPeerControlImpl
extends LogRelation
implements PEPeerControl,
DiskManagerWriteRequestListener,
PeerControlInstance,
PeerNATInitiator,
DiskManagerCheckRequestListener,
IPFilterListener {
    private long sentPrec = 0L;
    private long receivedPrec = 0L;
    private long remainingPrec = 8L;
    private long sent = 0L;
    private long received = 0L;
    private long remaining = 8L;
    private long sentReal = 0L;
    private long receivedReal = 0L;
    private long remainingReal = 8L;
    private final long NOREPORT = 0L;
    private long timeStartedBugFixFake;
    private String lastFakeOption = "";
    private boolean[] tabOption;
    int[] tabInt;
    float[] tabFloat;
    boolean[] tabGeneralOption;
    long sentNEW = 0L;
    boolean firstRun = true;
    private static final LogIDs LOGID = LogIDs.PEER;
    private static final boolean TEST_PERIODIC_SEEDING_SCAN_FAIL_HANDLING = false;
    private static final int WARNINGS_LIMIT = 2;
    private static final int CHECK_REASON_DOWNLOADED = 1;
    private static final int CHECK_REASON_COMPLETE = 2;
    private static final int CHECK_REASON_SCAN = 3;
    private static final int CHECK_REASON_SEEDING_CHECK = 4;
    private static final int CHECK_REASON_BAD_PIECE_CHECK = 5;
    private static final int SEED_CHECK_WAIT_MARKER = 65526;
    private static boolean disconnect_seeds_when_seeding;
    private static boolean enable_seeding_piece_rechecks;
    private static int stalled_piece_timeout;
    private static boolean fast_unchoke_new_peers;
    private static float ban_peer_discard_ratio;
    private static int ban_peer_discard_min_kb;
    private static boolean udp_fallback_for_failed_connection;
    private static boolean udp_fallback_for_dropped_connection;
    private static boolean udp_probe_enabled;
    private static boolean hide_a_piece;
    private static boolean prefer_udp_default;
    private static IpFilter ip_filter;
    private volatile boolean is_running = false;
    private volatile boolean is_destroyed = false;
    private volatile ArrayList<PEPeer> peer_transports_cow = new ArrayList();
    private final AEMonitor peer_transports_mon = new AEMonitor("PEPeerControl:PT");
    protected final PEPeerManagerAdapter adapter;
    private final DiskManager disk_mgr;
    private final DiskManagerPiece[] dm_pieces;
    private final boolean is_private_torrent;
    private PEPeerManager.StatsReceiver stats_receiver;
    private final PiecePicker piecePicker;
    private long lastNeededUndonePieceChange;
    private boolean seeding_mode;
    private boolean restart_initiated;
    private final int _nbPieces;
    private PEPieceImpl[] pePieces;
    private int nbPiecesActive;
    private int nbPeersSnubbed;
    private PeerIdentityDataID _hash;
    private final byte[] _myPeerId;
    private PEPeerManagerStatsImpl _stats;
    private int stats_tick_count;
    private int _seeds;
    private int _peers;
    private int _remotesTCPNoLan;
    private int _remotesUDPNoLan;
    private int _remotesUTPNoLan;
    private int _tcpPendingConnections;
    private int _tcpConnectingConnections;
    private long last_remote_time;
    private long _timeStarted;
    private long _timeStarted_mono;
    private long _timeStartedSeeding = -1L;
    private long _timeStartedSeeding_mono = -1L;
    private long _timeFinished;
    private Average _averageReceptionSpeed;
    private long mainloop_loop_count;
    private static final int MAINLOOP_ONE_SECOND_INTERVAL;
    private static final int MAINLOOP_FIVE_SECOND_INTERVAL;
    private static final int MAINLOOP_TEN_SECOND_INTERVAL;
    private static final int MAINLOOP_TWENTY_SECOND_INTERVAL;
    private static final int MAINLOOP_THIRTY_SECOND_INTERVAL;
    private static final int MAINLOOP_SIXTY_SECOND_INTERVAL;
    private static final int MAINLOOP_TEN_MINUTE_INTERVAL;
    private volatile ArrayList<PEPeerManagerListener> peer_manager_listeners_cow = new ArrayList();
    private final List<Object[]> piece_check_result_list = new ArrayList<Object[]>();
    private final AEMonitor piece_check_result_list_mon = new AEMonitor("PEPeerControl:PCRL");
    private boolean superSeedMode;
    private int superSeedModeCurrentPiece;
    private int superSeedModeNumberOfAnnounces;
    private SuperSeedPiece[] superSeedPieces;
    private int hidden_piece;
    private final AEMonitor this_mon = new AEMonitor("PEPeerControl");
    private long ip_filter_last_update_time;
    private Map<Object, Object> user_data;
    private Unchoker unchoker;
    private List<Object[]> external_rate_limiters_cow;
    private int bytes_queued_for_upload;
    private int connections_with_queued_data;
    private int connections_with_queued_data_blocked;
    private int connections_unchoked;
    private List<PEPeer> sweepList = Collections.emptyList();
    private int nextPEXSweepIndex = 0;
    private final UploadHelper upload_helper = new UploadHelper(){

        @Override
        public int getPriority() {
            return 4;
        }

        @Override
        public ArrayList<PEPeer> getAllPeers() {
            return PEPeerControlImpl.this.peer_transports_cow;
        }

        @Override
        public boolean isSeeding() {
            return PEPeerControlImpl.this.seeding_mode;
        }
    };
    private PeerDatabase peer_database = PeerDatabaseFactory.createPeerDatabase();
    private int bad_piece_reported = -1;
    private int next_rescan_piece = -1;
    private long rescan_piece_time = -1L;
    private long last_eta;
    private long last_eta_smoothed;
    private long last_eta_calculation;
    private static final int MAX_UDP_CONNECTIONS = 16;
    private static final int PENDING_NAT_TRAVERSAL_MAX = 32;
    private static final int MAX_UDP_TRAVERSAL_COUNT = 3;
    private static final String PEER_NAT_TRAVERSE_DONE_KEY;
    private Map<String, PEPeerTransport> pending_nat_traversals = new LinkedHashMap<String, PEPeerTransport>(32, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, PEPeerTransport> eldest) {
            return this.size() > 32;
        }
    };
    private int udp_traversal_count;
    private static final int UDP_RECONNECT_MAX = 16;
    private Map<String, PEPeerTransport> udp_reconnects = new LinkedHashMap<String, PEPeerTransport>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, PEPeerTransport> eldest) {
            return this.size() > 16;
        }
    };
    private static final int UDP_RECONNECT_MIN_MILLIS = 10000;
    private long last_udp_reconnect;
    private boolean prefer_udp;
    private static final int PREFER_UDP_BLOOM_SIZE = 10000;
    private volatile BloomFilter prefer_udp_bloom;
    private final LimitedRateGroup upload_limited_rate_group = new LimitedRateGroup(){

        public String getName() {
            return "per_dl_up: " + PEPeerControlImpl.this.getDisplayName();
        }

        public int getRateLimitBytesPerSecond() {
            return PEPeerControlImpl.this.adapter.getUploadRateLimitBytesPerSecond();
        }

        public void updateBytesUsed(int used) {
        }
    };
    private final LimitedRateGroup download_limited_rate_group = new LimitedRateGroup(){

        public String getName() {
            return "per_dl_down: " + PEPeerControlImpl.this.getDisplayName();
        }

        public int getRateLimitBytesPerSecond() {
            return PEPeerControlImpl.this.adapter.getDownloadRateLimitBytesPerSecond();
        }

        public void updateBytesUsed(int used) {
        }
    };
    private final int partition_id;
    private final boolean is_metadata_download;
    private int metadata_infodict_size;
    private DiskManager.GettingThere finish_in_progress;
    private long last_seed_disconnect_time;
    private BloomFilter naughty_fast_extension_bloom = BloomFilterFactory.createRotating(BloomFilterFactory.createAddRemove4Bit(2000), 2);
    private static final BigDecimal ONE_HOUNDRED;
    private static final int FE_EVENT_LIMIT = 5;
    private int optimisticDisconnectCount = 0;

    public PEPeerControlImpl(byte[] _peer_id, PEPeerManagerAdapter _adapter, DiskManager _diskManager, int _partition_id) {
        this._myPeerId = _peer_id;
        this.adapter = _adapter;
        this.disk_mgr = _diskManager;
        this.partition_id = _partition_id;
        boolean is_private = false;
        try {
            is_private = this.disk_mgr.getTorrent().getPrivate();
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        this.is_private_torrent = is_private;
        this.is_metadata_download = this.adapter.isMetadataDownload();
        if (!this.is_metadata_download) {
            this.metadata_infodict_size = this.adapter.getTorrentInfoDictSize();
        }
        this._nbPieces = this.disk_mgr.getNbPieces();
        this.dm_pieces = this.disk_mgr.getPieces();
        this.pePieces = new PEPieceImpl[this._nbPieces];
        this.hidden_piece = hide_a_piece ? (int)(Math.abs(this.adapter.getRandomSeed()) % (long)this._nbPieces) : -1;
        this.piecePicker = PiecePickerFactory.create(this);
        ip_filter.addListener(this);
    }

    @Override
    public void refreshSystem(boolean end) {
        this.tabOption = this.adapter.getDownload_manager().getFakeOption();
        this.tabInt = this.adapter.getDownload_manager().getFakeIntValue();
        this.tabFloat = this.adapter.getDownload_manager().getFakeFloatValue();
        this.tabGeneralOption = this.adapter.getDownload_manager().getGeneralOption();
        if (this.tabGeneralOption[6]) {
            Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "Start: -> ending flag:" + end));
        }
        long lastSentReal = this.sentReal;
        long lastReceivedReal = this.receivedReal;
        this.sentReal = this.getStats().getTotalDataBytesSent();
        long verified = this.getStats().getTotalDataBytesReceived() - (this.getStats().getTotalDiscarded() + this.getStats().getTotalHashFailBytes());
        this.receivedReal = verified >= 0L ? verified : 0L;
        this.remainingReal = this.getRemaining();
        boolean ratioTool = this.tabOption[31];
        boolean fakeOffFakeAddedToReal = this.tabOption[0];
        boolean enableFake = this.tabOption[1];
        if (!ratioTool) {
            this.adapter.getDownload_manager().getDiskManagerFileInfoSet().ratioToolRecoverFileStates();
        }
        if (ratioTool) {
            boolean startSlow;
            boolean stopPeers;
            this.adapter.getDownload_manager().getDiskManagerFileInfoSet().ratioToolSetComplete();
            if (!this.tabOption[31]) {
                this.adapter.getDownload_manager().setForceStart(true);
            }
            long fileSize = this.getDiskManager().getTotalLength();
            long totalSentFake = this.adapter.getDownload_manager().getStats().getTotalDataBytesSentFake();
            long totalReceivedFake = this.adapter.getDownload_manager().getStats().getTotalDataBytesReceivedFake();
            this.sentPrec = this.sent;
            this.receivedPrec = this.received;
            long doneAdjustment = new BigDecimal(fileSize).multiply(new BigDecimal(this.tabFloat[18])).divide(ONE_HOUNDRED).longValue();
            this.remaining = fileSize - totalReceivedFake - doneAdjustment;
            if (this.remaining < 0L) {
                this.remaining = 0L;
            }
            boolean stopUpload = this.tabOption[35];
            long stopUploadValue = -1L;
            if (stopUpload) {
                stopUploadValue = (long)(this.tabFloat[19] * 1024.0f * 1024.0f);
                stopUpload = stopUploadValue <= totalSentFake;
            }
            boolean stopDownload = this.tabOption[36];
            long stopDownloadValue = -1L;
            if (stopDownload) {
                stopDownloadValue = (long)(this.tabFloat[20] * 1024.0f * 1024.0f);
                boolean bl = stopDownload = stopDownloadValue <= totalReceivedFake;
            }
            if (stopPeers = this.tabOption[37]) {
                TRTrackerScraperResponse scrape;
                int peers = this.getNbPeers();
                if (peers == 0 && (scrape = this.adapter.getDownload_manager().getTrackerScrapeResponse()) != null) {
                    peers = scrape.getPeers();
                }
                boolean bl = stopPeers = this.tabInt[4] > peers;
            }
            if (startSlow = this.tabOption[39]) {
                boolean bl = startSlow = (long)((float)fileSize - (float)fileSize * this.tabFloat[21] / 100.0f) <= this.remaining;
            }
            if (this.tabOption[33] && !stopUpload && !startSlow && !stopPeers) {
                long snt = (long)(PEPeerControlImpl.unEntierAuHasardEntre(this.tabFloat[14], this.tabFloat[15]) * 1024.0f);
                long totalSnt = snt + totalSentFake;
                if (this.tabOption[38]) {
                    snt = (long)((double)snt * ((double)totalReceivedFake / (double)fileSize));
                }
                if (this.tabOption[35] && totalSnt > stopUploadValue) {
                    snt -= totalSnt - stopUploadValue;
                }
                this.sent += snt;
            }
            if (this.tabOption[34] && this.remaining > 0L && !stopDownload) {
                long rcv = (long)(PEPeerControlImpl.unEntierAuHasardEntre(this.tabFloat[16], this.tabFloat[17]) * 1024.0f);
                long totalRcv = rcv + totalReceivedFake + doneAdjustment;
                if (totalRcv > fileSize) {
                    rcv -= totalRcv - fileSize;
                }
                if (this.tabOption[36] && totalRcv > stopDownloadValue) {
                    rcv -= totalRcv - stopDownloadValue;
                }
                this.received += rcv;
            }
            if (this.remaining == 0L && !this.tabOption[42] && this.tabFloat[18] != 100.0f) {
                this.tabOption[41] = true;
                this.tabOption[42] = true;
                this.checkFinished(false);
            }
            this.dataBytesSentFake(this.sent - this.sentPrec);
            this.dataBytesReceivedFake(this.received - this.receivedPrec);
        } else if (enableFake) {
            boolean downloadReduc = this.tabOption[2];
            boolean downloadReducAlone = this.tabOption[3];
            boolean downloadReducMix = this.tabOption[4];
            boolean noReport = this.tabOption[5];
            boolean fakeUploadRatio = this.tabOption[8];
            boolean fakeUploadSpeedRatio = this.tabOption[10];
            boolean fakeUploadMultiplier = this.tabOption[11];
            boolean fakeSeeding = this.tabOption[13];
            boolean ghostLeech = this.tabOption[25];
            this.sentPrec = this.sent;
            this.receivedPrec = this.received;
            this.remainingPrec = this.remaining;
            if (downloadReduc && downloadReducAlone || downloadReducMix && !noReport && !fakeUploadRatio && !fakeUploadMultiplier && !fakeSeeding && !fakeUploadSpeedRatio && !ghostLeech) {
                this.sent = this.sentReal;
                this.downloadManipulation();
                this.lastFakeOption = "Download Reduction Alone";
            } else if (noReport) {
                boolean noReportSeed = this.tabOption[6];
                boolean noReportCustom = this.tabOption[23];
                boolean noReportAuto = this.tabOption[24];
                this.sentPrec = 0L;
                this.sent = 0L;
                this.received = 0L;
                if (noReportSeed) {
                    this.remaining = 0L;
                    this.lastFakeOption = "No ReportSeed";
                } else if (noReportCustom) {
                    float customDone = this.tabFloat[13];
                    float fileSize = this.getDiskManager().getTotalLength();
                    this.remaining = (long)(fileSize - fileSize * customDone / 100.0f);
                    this.lastFakeOption = "No ReportCustom";
                } else if (noReportAuto) {
                    this.remaining = this.remainingReal;
                    this.lastFakeOption = "No ReportAuto";
                } else {
                    long fileSize;
                    this.remaining = fileSize = this.getDiskManager().getTotalLength();
                    this.lastFakeOption = "No ReportLeech";
                }
            } else if (ghostLeech) {
                boolean ghostLeechReport;
                boolean bl = ghostLeechReport = this.tabOption[28] && !this.tabOption[29];
                if (ghostLeechReport) {
                    this.sent = this.sentReal;
                    this.received = this.receivedReal;
                    this.remaining = this.remainingReal;
                    this.lastFakeOption = "ghostLeechReport";
                } else {
                    this.sentPrec = 0L;
                    this.sent = 0L;
                    this.received = 0L;
                    this.remaining = this.getDiskManager().getTotalLength();
                    this.lastFakeOption = "ghostLeechNoReport";
                }
            } else if (fakeUploadRatio) {
                float fakeUploadRatioValue = this.tabFloat[0];
                float fakeUploadRatioValueMax = this.tabFloat[1];
                float value = PEPeerControlImpl.unEntierAuHasardEntre(fakeUploadRatioValue, fakeUploadRatioValueMax);
                boolean fakeUploadRMContinue = this.tabOption[9];
                boolean fakeUpRMIntelligent = this.tabOption[18];
                long fileSize = this.getDiskManager().getTotalLength();
                String strTemp = "";
                if (downloadReduc && downloadReducMix) {
                    this.downloadManipulation();
                    strTemp = "Fake Upload Ratio Mode + Download Reduction Mix";
                } else {
                    this.received = this.receivedReal;
                    this.remaining = this.remainingReal;
                    strTemp = "Fake Upload Ratio Mode";
                }
                double pourcent = 1.0;
                long totalFakeReceived = this.adapter.getDownload_manager().getStats().getTotalDataBytesReceivedFake();
                if (fakeUpRMIntelligent && (pourcent = (double)totalFakeReceived * 1.0 / (double)fileSize * 1.0) <= 0.0) {
                    pourcent = 1.0;
                }
                this.sent += (long)((double)((float)(this.received - this.receivedPrec) * value) * pourcent);
                if (this.received > 0L) {
                    double fakeRatioCourant = (double)this.adapter.getDownload_manager().getStats().getShareRatioFake() / 1000.0;
                    if (fakeUpRMIntelligent) {
                        value = (float)((double)value * pourcent);
                        if (this.tabGeneralOption[6]) {
                            Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "value *= pourcent ==> " + value + " *= " + pourcent));
                        }
                    }
                    if (fakeRatioCourant < (double)value) {
                        if (this.tabGeneralOption[6]) {
                            Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "(normal)correction upload : " + fakeRatioCourant + "<" + value));
                        }
                        double correctionRatio = (double)value - fakeRatioCourant;
                        long correction = (long)(correctionRatio * (double)totalFakeReceived);
                        if (this.tabGeneralOption[6]) {
                            Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "(correction)" + correction + "=(fRatio)" + fakeRatioCourant + "*(totalFakeReceived)" + totalFakeReceived));
                        }
                        this.sent += correction;
                    }
                }
                if (fakeUploadRMContinue && this._timeStartedSeeding != -1L) {
                    this.sent += this.sentReal - lastSentReal;
                }
                this.checkNumberOfPeersAndTotalSent(strTemp, end);
            } else if (fakeUploadSpeedRatio) {
                float fakeUploadSpeedRatioRValue = this.tabFloat[2];
                float fakeUploadSpeedRatioRValueMax = this.tabFloat[3];
                float fakeUploadSpeedRatioSValue = 0.0f;
                float fakeUploadSpeedRatioSValueMax = 0.0f;
                float sValue = 0.0f;
                long fileSize = this.getDiskManager().getTotalLength();
                boolean swarmSpeed = this.tabOption[19];
                float swarmSpeedValue = (float)this.adapter.getDownload_manager().getStats().getTotalAveragePerPeer() / 1000.0f;
                boolean isRatio = this.tabOption[16];
                double rValue = PEPeerControlImpl.unEntierAuHasardEntre(fakeUploadSpeedRatioRValue, fakeUploadSpeedRatioRValueMax);
                long fakeSent = 0L;
                float pourcentRealDone = (float)this.adapter.getDownload_manager().getStats().getDownloadCompleted(false) / 10.0f;
                boolean startFakePourcentReached = this.tabOption[22];
                float pourcentValue = this.tabFloat[9];
                boolean showAsSeed = this.tabOption[12];
                boolean stopIfSwarmDrops = this.tabOption[30];
                if (startFakePourcentReached && pourcentValue >= pourcentRealDone || stopIfSwarmDrops && swarmSpeedValue <= 1.0f) {
                    this.sent += this.sentReal - lastSentReal;
                } else {
                    if (this.tabGeneralOption[6]) {
                        Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "_timeStartedSeeding = " + this._timeStartedSeeding + " when seeding : should be dif than -1 ! and : have you dled something? (option that will probably be removed or changed : receivedReal > 0? : " + this.receivedReal + " > 0 ?"));
                    }
                    if (this.receivedReal > 0L || this._timeStartedSeeding != -1L) {
                        boolean fakeUpSRIntelligent = this.tabOption[21];
                        double pourcent = 1.0;
                        long totalFakeReceived = this.adapter.getDownload_manager().getStats().getTotalDataBytesReceivedFake();
                        if (fakeUpSRIntelligent && (pourcent = (double)totalFakeReceived * 1.0 / (double)fileSize * 1.0) <= 0.0) {
                            pourcent = 1.0;
                        }
                        boolean fakeUploadAdd = this.tabOption[17];
                        if (this.tabGeneralOption[6]) {
                            Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "pourcent = totalFakeReceived*1.0/fileSize*1.0   ==> " + pourcent + " = " + totalFakeReceived + "*1.0/" + fileSize + "*1.0"));
                        }
                        if (fakeUploadAdd) {
                            fakeSent += this.sentReal - lastSentReal;
                        }
                        double fakeRatioCourant = (double)this.adapter.getDownload_manager().getStats().getShareRatioFake() / 1000.0;
                        if (this.tabGeneralOption[6]) {
                            Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "!isRatio || (isRatio && fakeRatioCourant <= rValue) : " + !isRatio + " || (" + isRatio + " && " + fakeRatioCourant + " <= " + rValue + ")"));
                        }
                        if (!isRatio || isRatio && fakeRatioCourant <= rValue) {
                            fakeUploadSpeedRatioSValue = this.tabFloat[4];
                            fakeUploadSpeedRatioSValueMax = this.tabFloat[5];
                        } else {
                            fakeUploadSpeedRatioSValue = this.tabFloat[11];
                            fakeUploadSpeedRatioSValueMax = this.tabFloat[12];
                        }
                        sValue = swarmSpeed ? (swarmSpeedValue <= fakeUploadSpeedRatioSValueMax ? swarmSpeedValue : fakeUploadSpeedRatioSValueMax) : PEPeerControlImpl.unEntierAuHasardEntre(fakeUploadSpeedRatioSValue, fakeUploadSpeedRatioSValueMax);
                        fakeSent += (long)((double)(1024.0f * sValue) * pourcent);
                        if (this.tabGeneralOption[6]) {
                            Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "fakeSent = ((1024*sValue*pourcent)+(sentReal-lastSentReal))  ==> " + fakeSent + " = ((1024 * " + sValue + " * " + pourcent + " )+( " + this.sentReal + "-" + lastSentReal + ") ===> sent += fakeSent => " + this.sent + " += " + fakeSent));
                        }
                        this.sent += fakeSent;
                    } else {
                        this.sent = 0L;
                    }
                }
                if (downloadReduc && downloadReducMix) {
                    this.checkNumberOfPeersAndTotalSent("Fake Upload Speed Mode++ + Download ReducMix", end);
                    this.downloadManipulation();
                } else if (showAsSeed) {
                    this.checkNumberOfPeersAndTotalSent("Fake Upload Speed Mode++ + Show As Seed", end);
                    this.received = 0L;
                    this.remaining = 0L;
                } else {
                    this.checkNumberOfPeersAndTotalSent("Fake Upload Speed Mode++", end);
                    this.received = this.receivedReal;
                    this.remaining = this.remainingReal;
                }
            } else if (fakeUploadMultiplier) {
                boolean showAsSeed = this.tabOption[12];
                float fakeUploadMultiplierValue = this.tabFloat[6];
                float fakeUploadMultiplierValueMax = this.tabFloat[7];
                float value = PEPeerControlImpl.unEntierAuHasardEntre(fakeUploadMultiplierValue, fakeUploadMultiplierValueMax);
                this.sent += (long)((float)(this.sentReal - lastSentReal) * value);
                if (showAsSeed) {
                    this.checkNumberOfPeersAndTotalSent("Fake Upload upload Multiplier + Show As Seed", end);
                    this.received = 0L;
                    this.remaining = 0L;
                } else if (downloadReduc && downloadReducMix) {
                    this.checkNumberOfPeersAndTotalSent("Fake Upload upload Multiplier + Download Reduc Mix", end);
                    this.downloadManipulation();
                } else {
                    this.checkNumberOfPeersAndTotalSent("Fake Upload upload Multiplier", end);
                    this.received = this.receivedReal;
                    this.remaining = this.remainingReal;
                }
            } else {
                this.sent = this.sentReal;
                this.received = this.receivedReal;
                this.remaining = this.remainingReal;
                this.lastFakeOption = "None (When enable system is activated and no fake ON)";
            }
            this.dataBytesSentFake(this.sent - this.sentPrec);
            if (this.tabGeneralOption[6]) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "(sent-sentPrec) = length  <==>  (" + this.sent + "-" + this.sentPrec + ") = " + (this.sent - this.sentPrec)));
            }
            if (this.tabGeneralOption[6]) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "getSentFake() : " + this.getSentFake()));
            }
        } else if (fakeOffFakeAddedToReal && !enableFake) {
            this.sent = this.sentReal + this.sentPrec;
            this.received = this.receivedReal;
            this.remaining = this.remainingReal;
            this.lastFakeOption = "FakeOff FakePast+Real";
            this.dataBytesSentFake(this.sent - this.sentPrec);
            if (this.tabGeneralOption[6]) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "(sent-sentPrec) = length  <==>  (" + this.sent + "-" + this.sentPrec + ") = " + (this.sent - this.sentPrec)));
            }
            if (this.tabGeneralOption[6]) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "getSentFake() : " + this.getSentFake()));
            }
        } else {
            this.sent = this.sentReal;
            this.received = this.receivedReal;
            this.remaining = this.remainingReal;
            this.lastFakeOption = "None";
        }
        if (this.tabGeneralOption[6]) {
            Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "Stats : sent = " + this.sent + "  received " + this.received + "  remaining " + this.remaining));
        }
        if (this.tabGeneralOption[6]) {
            Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "END : Fake Option used : " + this.lastFakeOption));
        }
    }

    private void downloadManipulation() {
        int downloadReducValue = this.tabInt[0];
        long fileSize = this.getDiskManager().getTotalLength();
        long completedAmount = fileSize - this.getDiskManager().getRemaining();
        this.received = this.receivedReal * (long)downloadReducValue / 100L;
        this.remaining = fileSize - completedAmount * (long)downloadReducValue / 100L;
        if (this.received > fileSize) {
            this.received = fileSize;
        }
        if (this.remaining < 0L) {
            this.remaining = 0L;
        }
    }

    private void checkNumberOfPeersAndTotalSent(String currentFakeOption, boolean finishing) {
        int fakePeerValue = this.tabInt[1];
        int peerSeedRatioValue = this.tabInt[2];
        if ((this.firstRun || this.lastFakeOption.equals(currentFakeOption)) && !finishing) {
            int peers;
            if (this.tabGeneralOption[10] && this.adapter.getDownload_manager().getTrackerScrapeResponse().getPeers() != -1) {
                peers = this.adapter.getDownload_manager().getTrackerScrapeResponse().getPeers();
                if (this.tabGeneralOption[6]) {
                    Logger.log(new LogEvent((Object)this.disk_mgr.getTorrent(), LogIDs.PLUGIN, 0, "adapter.dm.TrackerScrapeResponse().Peers(): " + this.adapter.getDownload_manager().getTrackerScrapeResponse().getPeers() + " - option to take swarm peer : " + this.tabGeneralOption[10]));
                }
            } else {
                peers = this.getNbPeers() - this.peer_database.getDiscoveredPeerCount();
                if (this.tabGeneralOption[6]) {
                    Logger.log(new LogEvent((Object)this.disk_mgr.getTorrent(), LogIDs.PLUGIN, 0, "peers = getNbPeers()-peer_database.getDiscoveredPeerCount(): " + peers + " = " + this.getNbPeers() + "-" + this.peer_database.getDiscoveredPeerCount()));
                }
            }
            if (this.tabGeneralOption[6]) {
                Logger.log(new LogEvent((Object)this.disk_mgr.getTorrent(), LogIDs.PLUGIN, 0, "(sent < sentPrec || peers < fakePeerValue) ==> (" + this.sent + " < " + this.sentPrec + " || " + peers + " < " + fakePeerValue + ")   FakeOption = " + this.lastFakeOption));
            }
            if (this.sent < this.sentPrec || peers < fakePeerValue) {
                this.sent = this.sentPrec;
                if (this.tabGeneralOption[6]) {
                    Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "This fake doesn't fit the conditions so we'll report the last good fake"));
                }
                return;
            }
            if (this.tabGeneralOption[6]) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "( getNbSeeds()>0 ) ===> " + this.getNbSeeds() + ">0 )"));
            }
            if (this.getNbSeeds() > 0) {
                int var = (int)((double)peers / (double)this.getNbSeeds() * 100.0);
                if (this.tabGeneralOption[6]) {
                    Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "var = (int)((double)peers/((double)getNbSeeds())*100.0) ) ===> " + peers + "/" + this.getNbSeeds() + " = " + var));
                }
                if (this.tabGeneralOption[6]) {
                    Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "var <= peerSeedRatioValue ==> " + var + " <= " + peerSeedRatioValue));
                }
                if (var < peerSeedRatioValue) {
                    this.sent = this.sentPrec;
                    if (this.tabGeneralOption[6]) {
                        Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LogIDs.PLUGIN, "This fake doesn't fit the conditions so we'll report the last good fake"));
                    }
                }
            }
        }
        this.lastFakeOption = currentFakeOption;
        this.firstRun = false;
    }

    public long getSentFakePrec() {
        return this.sentPrec;
    }

    public long getReceivedFakePrec() {
        return this.receivedPrec;
    }

    public long getRemainingFakePrec() {
        return this.remainingPrec;
    }

    @Override
    public long getSentFake() {
        return this.sent;
    }

    @Override
    public long getReceivedFake() {
        return this.received;
    }

    @Override
    public long getRemainingFake() {
        return this.remaining;
    }

    @Override
    public void setRemainingFake(long remaining) {
        this.remaining = remaining;
    }

    @Override
    public void dataBytesSentFake(long length) {
        if (length > 0L) {
            this.adapter.getDownload_manager().getStats().dataBytesSentFake(length);
        }
    }

    public void dataBytesReceivedFake(long length) {
        if (length > 0L) {
            this.adapter.getDownload_manager().getStats().dataBytesReceivedFake(length);
        }
    }

    public long getElapsedTimeFake() {
        return (SystemTime.getCurrentTime() - this.timeStartedBugFixFake) / 1000L;
    }

    public static float unEntierAuHasardEntre(float min, float max) {
        double nombreReel = Math.random();
        float resultat = (float)(nombreReel * (double)(max - min) + (double)min);
        return resultat;
    }

    @Override
    public void start() {
        try {
            this._hash = PeerIdentityManager.createDataID(this.disk_mgr.getTorrent().getHash());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            this._hash = PeerIdentityManager.createDataID(new byte[20]);
        }
        for (int i = 0; i < this._nbPieces; ++i) {
            DiskManagerPiece dmPiece = this.dm_pieces[i];
            if (dmPiece.isDone() || dmPiece.getNbWritten() <= 0) continue;
            this.addPiece(new PEPieceImpl(this, dmPiece, 0), i, true, null);
        }
        this.peer_transports_cow = new ArrayList();
        this.mainloop_loop_count = 0L;
        this._averageReceptionSpeed = Average.getInstance(1000, 30);
        this._stats = new PEPeerManagerStatsImpl(this);
        this.superSeedMode = COConfigurationManager.getBooleanParameter("Use Super Seeding") && this.getRemaining() == 0L;
        this.superSeedModeCurrentPiece = 0;
        if (this.superSeedMode) {
            this.initialiseSuperSeedMode();
        }
        this.checkFinished(true);
        UploadSlotManager.getSingleton().registerHelper(this.upload_helper);
        this.lastNeededUndonePieceChange = Long.MIN_VALUE;
        this._timeStarted = SystemTime.getCurrentTime();
        this._timeStarted_mono = SystemTime.getMonotonousTime();
        this.is_running = true;
        PeerManagerRegistration reg = this.adapter.getPeerManagerRegistration();
        if (reg != null) {
            reg.activate(this);
        }
        PeerNATTraverser.getSingleton().register(this);
        PeerControlSchedulerFactory.getSingleton(this.partition_id).register(this);
    }

    @Override
    public void stopAll() {
        this.is_running = false;
        UploadSlotManager.getSingleton().deregisterHelper(this.upload_helper);
        PeerControlSchedulerFactory.getSingleton(this.partition_id).unregister(this);
        PeerNATTraverser.getSingleton().unregister(this);
        PeerManagerRegistration reg = this.adapter.getPeerManagerRegistration();
        if (reg != null) {
            reg.deactivate();
        }
        this.closeAndRemoveAllPeers("download stopped", false);
        for (int i = 0; i < this._nbPieces; ++i) {
            if (this.pePieces[i] == null) continue;
            this.removePiece(this.pePieces[i], i);
        }
        ip_filter.removeListener(this);
        this.piecePicker.destroy();
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        for (int i = 0; i < peer_manager_listeners.size(); ++i) {
            peer_manager_listeners.get(i).destroyed();
        }
        this.sweepList = Collections.emptyList();
        this.pending_nat_traversals.clear();
        this.udp_reconnects.clear();
        this.is_destroyed = true;
    }

    @Override
    public int getPartitionID() {
        return this.partition_id;
    }

    @Override
    public boolean isDestroyed() {
        return this.is_destroyed;
    }

    @Override
    public DiskManager getDiskManager() {
        return this.disk_mgr;
    }

    @Override
    public PiecePicker getPiecePicker() {
        return this.piecePicker;
    }

    @Override
    public PEPeerManagerAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public String getDisplayName() {
        return this.adapter.getDisplayName();
    }

    @Override
    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public void schedule() {
        if (this.finish_in_progress != null) {
            if (this.finish_in_progress.hasGotThere()) {
                this.finish_in_progress = null;
            } else {
                return;
            }
        }
        try {
            if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL == 0L) {
                this.refreshSystem(false);
            }
            this.updateStats();
            this.updateTrackerAnnounceInterval();
            this.doConnectionChecks();
            this.processPieceChecks();
            if (this.finish_in_progress != null) {
                return;
            }
            if (!this.seeding_mode) {
                this.checkCompletedPieces();
            } else {
                boolean isRatio = this.adapter.getDownload_manager().getFakeOption(16);
                if (isRatio) {
                    this.adapter.getDownload_manager().stopTorrentAndMore(isRatio);
                }
                if (this.adapter.getDownload_manager().getGeneralOption(8)) {
                    this.adapter.getDownload_manager().stopAfterXHours();
                }
            }
            this.checkBadPieces();
            this.checkInterested();
            this.piecePicker.updateAvailability();
            this.checkCompletionState();
            if (this.finish_in_progress != null) {
                return;
            }
            this.checkSeeds();
            if (!this.seeding_mode) {
                this.checkRequests();
                this.piecePicker.allocateRequests();
                this.checkRescan();
                this.checkSpeedAndReserved();
                this.check99PercentBug();
            }
            this.updatePeersInSuperSeedMode();
            this.doUnchokes();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        ++this.mainloop_loop_count;
    }

    private void analyseTrackerResponse(TRTrackerAnnouncerResponse tracker_response) {
        Map extensions;
        TRTrackerAnnouncerResponsePeer[] peers = tracker_response.getPeers();
        if (peers != null) {
            this.addPeersFromTracker(tracker_response.getPeers());
        }
        if ((extensions = tracker_response.getExtensions()) != null) {
            this.addExtendedPeersFromTracker(extensions);
        }
    }

    @Override
    public void processTrackerResponse(TRTrackerAnnouncerResponse response) {
        if (this.is_running) {
            this.analyseTrackerResponse(response);
        }
    }

    private void addExtendedPeersFromTracker(Map extensions) {
        Map protocols = (Map)extensions.get("protocols");
        if (protocols != null) {
            System.out.println("PEPeerControl: tracker response contained protocol extensions");
            for (String protocol_name : protocols.keySet()) {
                Map protocol = (Map)protocols.get(protocol_name);
                List transports = PEPeerTransportFactory.createExtendedTransports(this, protocol_name, protocol);
                for (int i = 0; i < transports.size(); ++i) {
                    PEPeer transport = (PEPeer)transports.get(i);
                    this.addPeer(transport);
                }
            }
        }
    }

    @Override
    public List<PEPeer> getPeers() {
        return this.peer_transports_cow;
    }

    @Override
    public List<PEPeer> getPeers(String address) {
        ArrayList<PEPeer> result = new ArrayList<PEPeer>();
        for (PEPeerTransport pEPeerTransport : this.peer_transports_cow) {
            if (!pEPeerTransport.getIp().equals(address)) continue;
            result.add(pEPeerTransport);
        }
        return result;
    }

    @Override
    public int getPendingPeerCount() {
        return this.peer_database.getDiscoveredPeerCount();
    }

    @Override
    public PeerDescriptor[] getPendingPeers() {
        return this.peer_database.getDiscoveredPeers();
    }

    @Override
    public PeerDescriptor[] getPendingPeers(String address) {
        return this.peer_database.getDiscoveredPeers(address);
    }

    @Override
    public void addPeer(PEPeer _transport) {
        if (!(_transport instanceof PEPeerTransport)) {
            throw new RuntimeException("invalid class");
        }
        PEPeerTransport transport = (PEPeerTransport)_transport;
        if (!ip_filter.isInRange(transport.getIp(), this.getDisplayName(), this.getTorrentHash())) {
            ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
            if (!peer_transports.contains(transport)) {
                this.addToPeerTransports(transport);
                transport.start();
            } else {
                Debug.out("addPeer():: peer_transports.contains(transport): SHOULD NEVER HAPPEN !");
                transport.closeConnection("already connected");
            }
        } else {
            transport.closeConnection("IP address blocked by filters");
        }
    }

    protected byte[] getTorrentHash() {
        try {
            return this.disk_mgr.getTorrent().getHash();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public void removePeer(PEPeer _transport) {
        this.removePeer(_transport, "remove peer");
    }

    @Override
    public void removePeer(PEPeer _transport, String reason) {
        if (!(_transport instanceof PEPeerTransport)) {
            throw new RuntimeException("invalid class");
        }
        PEPeerTransport transport = (PEPeerTransport)_transport;
        this.closeAndRemovePeer(transport, reason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndRemovePeer(PEPeerTransport peer, String reason, boolean log_if_not_found) {
        boolean removed = false;
        try {
            this.peer_transports_mon.enter();
            if (this.peer_transports_cow.contains(peer)) {
                ArrayList<PEPeer> new_peer_transports = new ArrayList<PEPeer>(this.peer_transports_cow);
                new_peer_transports.remove(peer);
                this.peer_transports_cow = new_peer_transports;
                removed = true;
            }
            Object var7_6 = null;
            this.peer_transports_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.peer_transports_mon.exit();
            throw throwable;
        }
        if (removed) {
            peer.closeConnection(reason);
            this.peerRemoved(peer);
        } else if (log_if_not_found) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndRemoveAllPeers(String reason, boolean reconnect) {
        PEPeerTransport peer;
        int i;
        ArrayList<PEPeer> peer_transports;
        try {
            this.peer_transports_mon.enter();
            peer_transports = this.peer_transports_cow;
            this.peer_transports_cow = new ArrayList(0);
            Object var5_4 = null;
            this.peer_transports_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.peer_transports_mon.exit();
            throw throwable;
        }
        for (i = 0; i < peer_transports.size(); ++i) {
            peer = (PEPeerTransport)peer_transports.get(i);
            try {
                peer.closeConnection(reason);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            try {
                this.peerRemoved(peer);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (reconnect) {
            for (i = 0; i < peer_transports.size(); ++i) {
                peer = (PEPeerTransport)peer_transports.get(i);
                PEPeerTransport reconnected_peer = peer.reconnect(false, false);
            }
        }
    }

    @Override
    public void addPeer(String ip_address, int tcp_port, int udp_port, boolean use_crypto, Map user_data) {
        byte type = use_crypto ? (byte)1 : 0;
        PeerItem peer_item = PeerItemFactory.createPeerItem(ip_address, tcp_port, PeerItem.convertSourceID("Plugin"), type, udp_port, (byte)1, 0);
        byte crypto_level = 1;
        if (!this.isAlreadyConnected(peer_item)) {
            boolean udp_ok;
            boolean tcp_ok = TCPNetworkManager.TCP_OUTGOING_ENABLED && tcp_port > 0;
            boolean bl = udp_ok = UDPNetworkManager.UDP_OUTGOING_ENABLED && udp_port > 0;
            String fail_reason = tcp_ok && (!this.prefer_udp && !prefer_udp_default || !udp_ok) ? this.makeNewOutgoingConnection("Plugin", ip_address, tcp_port, udp_port, true, use_crypto, crypto_level, user_data) : (udp_ok ? this.makeNewOutgoingConnection("Plugin", ip_address, tcp_port, udp_port, false, use_crypto, crypto_level, user_data) : "No usable protocol");
            if (fail_reason != null) {
                Debug.out("Injected peer " + ip_address + ":" + tcp_port + " was not added - " + fail_reason);
            }
        }
    }

    @Override
    public void peerDiscovered(String peer_source, String ip_address, int tcp_port, int udp_port, boolean use_crypto) {
        if (this.peer_database != null) {
            ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
            for (int x = 0; x < peer_transports.size(); ++x) {
                boolean same_allowed;
                PEPeer transport = peer_transports.get(x);
                if (!ip_address.equals(transport.getIp())) continue;
                boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || transport.getIp().equals("127.0.0.1");
                if (same_allowed && tcp_port != transport.getPort()) continue;
                return;
            }
            byte type = use_crypto ? (byte)1 : 0;
            PeerItem item = PeerItemFactory.createPeerItem(ip_address, tcp_port, PeerItem.convertSourceID(peer_source), type, udp_port, (byte)1, 0);
            this.peerDiscovered(null, item);
            this.peer_database.addDiscoveredPeer(item);
        }
    }

    private void addPeersFromTracker(TRTrackerAnnouncerResponsePeer[] peers) {
        for (int i = 0; i < peers.length; ++i) {
            int http_port;
            TRTrackerAnnouncerResponsePeer peer = peers[i];
            ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
            boolean already_connected = false;
            for (int x = 0; x < peer_transports.size(); ++x) {
                boolean same_allowed;
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(x);
                if (!peer.getAddress().equals(transport.getIp())) continue;
                boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || transport.getIp().equals("127.0.0.1");
                if (same_allowed && peer.getPort() != transport.getPort()) continue;
                already_connected = true;
                break;
            }
            if (already_connected) continue;
            if (this.peer_database != null) {
                byte type = peer.getProtocol() == 2 ? (byte)1 : 0;
                byte crypto_level = peer.getAZVersion() < 3 ? (byte)1 : 2;
                PeerItem item = PeerItemFactory.createPeerItem(peer.getAddress(), peer.getPort(), PeerItem.convertSourceID(peer.getSource()), type, peer.getUDPPort(), crypto_level, peer.getUploadSpeed());
                this.peerDiscovered(null, item);
                this.peer_database.addDiscoveredPeer(item);
            }
            if ((http_port = peer.getHTTPPort()) == 0 || this.seeding_mode) continue;
            this.adapter.addHTTPSeed(peer.getAddress(), http_port);
        }
    }

    private String makeNewOutgoingConnection(String peer_source, String address, int tcp_port, int udp_port, boolean use_tcp, boolean require_crypto, byte crypto_level, Map user_data) {
        boolean same_allowed;
        Boolean pc;
        if (ip_filter.isInRange(address, this.getDisplayName(), this.getTorrentHash())) {
            return "IPFilter block";
        }
        String net_cat = AENetworkClassifier.categoriseAddress(address);
        if (!this.adapter.isNetworkEnabled(net_cat)) {
            return "Network '" + net_cat + "' is not enabled";
        }
        int needed = this.getMaxNewConnectionsAllowed();
        boolean is_priority_connection = false;
        if (user_data != null && (pc = (Boolean)user_data.get(Peer.PR_PRIORITY_CONNECTION)) != null && pc.booleanValue()) {
            is_priority_connection = true;
        }
        if (!(needed != 0 || peer_source == "Plugin" && this.doOptimisticDisconnect(AddressUtils.isLANLocalAddress(address) != 2, is_priority_connection))) {
            return "Too many connections";
        }
        boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || address.equals("127.0.0.1");
        if (!same_allowed && PeerIdentityManager.containsIPAddress(this._hash, address)) {
            return "Already connected to IP";
        }
        if (PeerUtils.ignorePeerPort(tcp_port)) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Skipping connect with " + address + ":" + tcp_port + " as peer port is in ignore list."));
            }
            return "TCP port '" + tcp_port + "' is in ignore list";
        }
        PEPeerTransport real = PEPeerTransportFactory.createTransport(this, peer_source, address, tcp_port, udp_port, use_tcp, require_crypto, crypto_level, user_data);
        this.addToPeerTransports(real);
        return null;
    }

    private void checkCompletedPieces() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        for (int i = 0; i < this._nbPieces; ++i) {
            DiskManagerPiece dmPiece = this.dm_pieces[i];
            if (!dmPiece.isNeedsCheck()) continue;
            dmPiece.setChecking();
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(i, new Integer(1));
            req.setAdHoc(false);
            this.disk_mgr.enqueueCheckRequest(req, this);
        }
    }

    private boolean checkEmptyPiece(int pieceNumber) {
        if (this.piecePicker.isInEndGameMode()) {
            return false;
        }
        PEPieceImpl pePiece = this.pePieces[pieceNumber];
        DiskManagerPiece dmPiece = this.dm_pieces[pieceNumber];
        if (pePiece == null || pePiece.isRequested()) {
            return false;
        }
        if (dmPiece.getNbWritten() > 0 || pePiece.getNbUnrequested() < pePiece.getNbBlocks() || pePiece.getReservedBy() != null) {
            return false;
        }
        pePiece.reset();
        this.removePiece(pePiece, pieceNumber);
        return true;
    }

    private void checkSpeedAndReserved() {
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL != 0L) {
            return;
        }
        int nbPieces = this._nbPieces;
        PEPieceImpl[] pieces = this.pePieces;
        for (int i = 0; i < nbPieces; ++i) {
            this.checkEmptyPiece(i);
            PEPieceImpl pePiece = pieces[i];
            if (pePiece == null) continue;
            long timeSinceActivity = pePiece.getTimeSinceLastActivity() / 1000L;
            int pieceSpeed = pePiece.getSpeed();
            if (pieceSpeed > 0 && (double)(timeSinceActivity * (long)pieceSpeed) * 0.25 > 16.0) {
                if (pePiece.getNbUnrequested() > 2) {
                    pePiece.setSpeed(pieceSpeed - 1);
                } else {
                    pePiece.setSpeed(0);
                }
            }
            if (timeSinceActivity <= 120L) continue;
            pePiece.setSpeed(0);
            String reservingPeer = pePiece.getReservedBy();
            if (reservingPeer != null) {
                PEPeerTransport pt = this.getTransportFromAddress(reservingPeer);
                if (this.needsMD5CheckOnCompletion(i)) {
                    this.badPeerDetected(reservingPeer, i);
                } else if (pt != null) {
                    this.closeAndRemovePeer(pt, "Reserved piece data timeout; 120 seconds", true);
                }
                pePiece.setReservedBy(null);
            }
            if (!this.piecePicker.isInEndGameMode()) {
                pePiece.checkRequests();
            }
            this.checkEmptyPiece(i);
        }
    }

    private void check99PercentBug() {
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L) {
            int hp_avail;
            long now = SystemTime.getCurrentTime();
            for (int i = 0; i < this.pePieces.length; ++i) {
                DiskManagerPiece dm_piece;
                PEPieceImpl pe_piece = this.pePieces[i];
                if (pe_piece == null || (dm_piece = this.dm_pieces[i]).isDone() || !pe_piece.isDownloaded() || now - pe_piece.getLastDownloadTime(now) <= (long)stalled_piece_timeout || this.disk_mgr.hasOutstandingWriteRequestForPiece(i) || this.disk_mgr.hasOutstandingReadRequestForPiece(i) || this.disk_mgr.hasOutstandingCheckRequestForPiece(i)) continue;
                Debug.out("Fully downloaded piece stalled pending write, resetting p_piece " + i);
                pe_piece.reset();
            }
            if (this.hidden_piece >= 0 && (hp_avail = this.piecePicker.getAvailability(this.hidden_piece)) < (this.dm_pieces[this.hidden_piece].isDone() ? 2 : 1)) {
                int[] avails = this.piecePicker.getAvailability();
                int num = 0;
                for (int i = 0; i < avails.length; ++i) {
                    if (avails[i] <= 0 || this.dm_pieces[i].isDone() || this.pePieces[i] != null) continue;
                    ++num;
                }
                if (num > 0) {
                    num = RandomUtils.nextInt(num);
                    int backup = -1;
                    for (int i = 0; i < avails.length; ++i) {
                        if (avails[i] <= 0 || this.dm_pieces[i].isDone() || this.pePieces[i] != null) continue;
                        if (backup == -1) {
                            backup = i;
                        }
                        if (num == 0) {
                            this.hidden_piece = i;
                            backup = -1;
                            break;
                        }
                        --num;
                    }
                    if (backup != -1) {
                        this.hidden_piece = backup;
                    }
                }
            }
        }
    }

    private void checkInterested() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        if (this.lastNeededUndonePieceChange >= this.piecePicker.getNeededUndonePieceChange()) {
            return;
        }
        this.lastNeededUndonePieceChange = this.piecePicker.getNeededUndonePieceChange();
        ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
        int cntPeersSnubbed = 0;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            peer.checkInterested();
            if (!peer.isSnubbed()) continue;
            ++cntPeersSnubbed;
        }
        this.setNbPeersSnubbed(cntPeersSnubbed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPieceChecks() {
        if (this.piece_check_result_list.size() > 0) {
            ArrayList<Object[]> pieces;
            try {
                this.piece_check_result_list_mon.enter();
                pieces = new ArrayList<Object[]>(this.piece_check_result_list);
                this.piece_check_result_list.clear();
                Object var3_2 = null;
                this.piece_check_result_list_mon.exit();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.piece_check_result_list_mon.exit();
                throw throwable;
            }
            for (Object[] data : pieces) {
                this.processPieceCheckResult((DiskManagerCheckRequest)data[0], (Integer)data[1]);
            }
        }
    }

    private void checkBadPieces() {
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L && this.bad_piece_reported != -1) {
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(this.bad_piece_reported, new Integer(5));
            req.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Rescanning reported-bad piece " + this.bad_piece_reported));
            }
            this.bad_piece_reported = -1;
            try {
                this.disk_mgr.enqueueCheckRequest(req, this);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private void checkRescan() {
        long piece_size;
        long millis_per_piece;
        if (this.rescan_piece_time == 0L) {
            return;
        }
        if (this.next_rescan_piece == -1) {
            if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL == 0L && this.adapter.isPeriodicRescanEnabled()) {
                this.next_rescan_piece = 0;
            }
        } else if (this.mainloop_loop_count % (long)MAINLOOP_TEN_MINUTE_INTERVAL == 0L && !this.adapter.isPeriodicRescanEnabled()) {
            this.next_rescan_piece = -1;
        }
        if (this.next_rescan_piece == -1) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        if (this.rescan_piece_time > now) {
            this.rescan_piece_time = now;
        }
        if (now - this.rescan_piece_time < (millis_per_piece = (piece_size = (long)this.disk_mgr.getPieceLength()) / 250L)) {
            return;
        }
        while (this.next_rescan_piece != -1) {
            int this_piece = this.next_rescan_piece++;
            if (this.next_rescan_piece == this._nbPieces) {
                this.next_rescan_piece = -1;
            }
            if (this.pePieces[this_piece] != null || this.dm_pieces[this_piece].isDone() || !this.dm_pieces[this_piece].isNeeded()) continue;
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(this_piece, new Integer(3));
            req.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Rescanning piece " + this_piece));
            }
            this.rescan_piece_time = 0L;
            try {
                this.disk_mgr.enqueueCheckRequest(req, this);
            }
            catch (Throwable e) {
                this.rescan_piece_time = now;
                Debug.printStackTrace(e);
            }
            break;
        }
    }

    @Override
    public void badPieceReported(PEPeerTransport originator, int piece_number) {
        Debug.outNoStack(this.getDisplayName() + ": bad piece #" + piece_number + " reported by " + originator.getIp());
        if (piece_number < 0 || piece_number >= this._nbPieces) {
            return;
        }
        this.bad_piece_reported = piece_number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFastExtensionPermitted(PEPeerTransport originator) {
        try {
            byte[] key = originator.getIp().getBytes("ISO-8859-1");
            BloomFilter bloomFilter = this.naughty_fast_extension_bloom;
            synchronized (bloomFilter) {
                int events = this.naughty_fast_extension_bloom.add(key);
                if (events < 5) {
                    return true;
                }
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Fast extension disabled for " + originator.getIp() + " due to repeat connections"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportBadFastExtensionUse(PEPeerTransport originator) {
        try {
            byte[] key = originator.getIp().getBytes("ISO-8859-1");
            BloomFilter bloomFilter = this.naughty_fast_extension_bloom;
            synchronized (bloomFilter) {
                if (this.naughty_fast_extension_bloom.add(key) == 5) {
                    Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Fast extension disabled for " + originator.getIp() + " due to repeat requests for the same pieces"));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setStatsReceiver(PEPeerManager.StatsReceiver receiver) {
        this.stats_receiver = receiver;
    }

    @Override
    public void statsRequest(PEPeerTransport originator, Map request2) {
        HashMap reply = new HashMap();
        this.adapter.statsRequest(originator, request2, reply);
        if (reply.size() > 0) {
            originator.sendStatsReply(reply);
        }
    }

    @Override
    public void statsReply(PEPeerTransport originator, Map reply) {
        PEPeerManager.StatsReceiver receiver = this.stats_receiver;
        if (receiver != null) {
            receiver.receiveStats(originator, reply);
        }
    }

    private void checkFinished(boolean start_of_day) {
        boolean all_pieces_done;
        boolean ratioToolComplete = this.adapter.getDownload_manager().getFakeOption(31) && this.adapter.getDownload_manager().getFakeOption(41);
        boolean bl = all_pieces_done = this.disk_mgr.getRemainingExcludingDND() == 0L || ratioToolComplete;
        if (all_pieces_done) {
            boolean checkPieces;
            this.refreshSystem(true);
            this.seeding_mode = true;
            this.prefer_udp_bloom = null;
            this.piecePicker.clearEndGameChunks();
            if (!start_of_day) {
                this.adapter.setStateFinishing();
            }
            this._timeFinished = SystemTime.getCurrentTime();
            ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
                pc.setSnubbed(false);
            }
            this.setNbPeersSnubbed(0);
            boolean bl2 = checkPieces = COConfigurationManager.getBooleanParameter("Check Pieces on Completion") && !ratioToolComplete;
            if (checkPieces && !start_of_day) {
                DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(-1, new Integer(2));
                this.disk_mgr.enqueueCompleteRecheckRequest(req, this);
            }
            this._timeStartedSeeding = SystemTime.getCurrentTime();
            this._timeStartedSeeding_mono = SystemTime.getMonotonousTime();
            try {
                this.disk_mgr.saveResumeData(false);
            }
            catch (Throwable e) {
                Debug.out("Failed to save resume data", e);
            }
            this.adapter.setStateSeeding(start_of_day);
            final AESemaphore waiting_it = new AESemaphore("PEC:DE");
            new AEThread2("PEC:DE"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        PEPeerControlImpl.this.disk_mgr.downloadEnded(new DiskManager.OperationStatus(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void gonnaTakeAWhile(DiskManager.GettingThere gt) {
                                boolean async_set = false;
                                PEPeerControlImpl pEPeerControlImpl = PEPeerControlImpl.this;
                                synchronized (pEPeerControlImpl) {
                                    if (PEPeerControlImpl.this.finish_in_progress == null) {
                                        PEPeerControlImpl.this.finish_in_progress = gt;
                                        async_set = true;
                                    }
                                }
                                if (async_set) {
                                    waiting_it.release();
                                }
                            }
                        });
                        Object var2_1 = null;
                        waiting_it.release();
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        waiting_it.release();
                        throw throwable;
                    }
                }
            }.start();
            waiting_it.reserve();
        } else {
            this.seeding_mode = false;
        }
    }

    protected void checkCompletionState() {
        boolean dm_done;
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        boolean bl = dm_done = this.disk_mgr.getRemainingExcludingDND() == 0L;
        if (this.seeding_mode) {
            if (!dm_done) {
                this.seeding_mode = false;
                this._timeStartedSeeding = -1L;
                this._timeStartedSeeding_mono = -1L;
                this._timeFinished = 0L;
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Turning off seeding mode for PEPeerManager"));
            }
        } else if (dm_done) {
            this.checkFinished(false);
            if (this.seeding_mode) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Turning on seeding mode for PEPeerManager"));
            }
        }
    }

    private void checkRequests() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
        for (int i = peer_transports.size() - 1; i >= 0; --i) {
            int j;
            List expired;
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc.getPeerState() != 30 || (expired = pc.getExpiredRequests()) == null || expired.size() <= 0) continue;
            boolean isSeed = pc.isSeed();
            long timeSinceGoodData = pc.getTimeSinceGoodDataReceived();
            if (timeSinceGoodData < 0L || timeSinceGoodData > 60000L) {
                pc.setSnubbed(true);
            }
            DiskManagerReadRequest request2 = (DiskManagerReadRequest)expired.get(0);
            long timeSinceData = pc.getTimeSinceLastDataMessageReceived();
            boolean noData = timeSinceData < 0L || timeSinceData > (long)(1000 * (isSeed ? 120 : 60));
            long timeSinceOldestRequest = now - request2.getTimeCreated(now);
            int n = j = timeSinceOldestRequest > 120000L && noData ? 0 : 1;
            while (j < expired.size()) {
                request2 = (DiskManagerReadRequest)expired.get(j);
                pc.sendCancel(request2);
                int pieceNumber = request2.getPieceNumber();
                PEPieceImpl pe_piece = this.pePieces[pieceNumber];
                if (pe_piece != null) {
                    pe_piece.clearRequested(request2.getOffset() / 16384);
                }
                if (!this.piecePicker.isInEndGameMode()) {
                    this.checkEmptyPiece(pieceNumber);
                }
                ++j;
            }
        }
    }

    private void updateTrackerAnnounceInterval() {
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL != 0L) {
            return;
        }
        int WANT_LIMIT = 100;
        int num_wanted = this.getMaxNewConnectionsAllowed();
        boolean has_remote = this.adapter.isNATHealthy();
        if (has_remote) {
            num_wanted = (int)((double)num_wanted / 1.5);
        }
        if (num_wanted < 0 || num_wanted > 100) {
            num_wanted = 100;
        }
        int current_connection_count = PeerIdentityManager.getIdentityCount(this._hash);
        TRTrackerScraperResponse tsr = this.adapter.getTrackerScrapeResponse();
        if (tsr != null && tsr.isValid()) {
            int swarm_size;
            int num_seeds = tsr.getSeeds();
            int num_peers = tsr.getPeers();
            if (this.seeding_mode) {
                float ratio = (float)num_peers / (float)(num_seeds + num_peers);
                swarm_size = (int)((float)num_peers * ratio);
            } else {
                swarm_size = num_peers + num_seeds;
            }
            if (swarm_size < num_wanted) {
                num_wanted = swarm_size;
            }
        }
        if (num_wanted < 1) {
            this.adapter.setTrackerRefreshDelayOverrides(100);
            return;
        }
        if (current_connection_count == 0) {
            current_connection_count = 1;
        }
        int current_percent = current_connection_count * 100 / (current_connection_count + num_wanted);
        this.adapter.setTrackerRefreshDelayOverrides(current_percent);
    }

    @Override
    public boolean hasDownloadablePiece() {
        return this.piecePicker.hasDownloadablePiece();
    }

    @Override
    public int getBytesQueuedForUpload() {
        return this.bytes_queued_for_upload;
    }

    @Override
    public int getNbPeersWithUploadQueued() {
        return this.connections_with_queued_data;
    }

    @Override
    public int getNbPeersWithUploadBlocked() {
        return this.connections_with_queued_data_blocked;
    }

    @Override
    public int getNbPeersUnchoked() {
        return this.connections_unchoked;
    }

    @Override
    public int[] getAvailability() {
        return this.piecePicker.getAvailability();
    }

    @Override
    public float getMinAvailability() {
        return this.piecePicker.getMinAvailability();
    }

    @Override
    public float getMinAvailability(int file_index) {
        return this.piecePicker.getMinAvailability(file_index);
    }

    @Override
    public long getBytesUnavailable() {
        return this.piecePicker.getBytesUnavailable();
    }

    @Override
    public float getAvgAvail() {
        return this.piecePicker.getAvgAvail();
    }

    @Override
    public long getAvailWentBadTime() {
        long went_bad = this.piecePicker.getAvailWentBadTime();
        if ((double)this.piecePicker.getMinAvailability() < 1.0 && this.last_seed_disconnect_time > went_bad - 5000L) {
            went_bad = this.last_seed_disconnect_time;
        }
        return went_bad;
    }

    @Override
    public void addPeerTransport(PEPeerTransport transport) {
        if (!ip_filter.isInRange(transport.getIp(), this.getDisplayName(), this.getTorrentHash())) {
            ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
            if (!peer_transports.contains(transport)) {
                this.addToPeerTransports(transport);
            } else {
                Debug.out("addPeerTransport():: peer_transports.contains(transport): SHOULD NEVER HAPPEN !");
                transport.closeConnection("already connected");
            }
        } else {
            transport.closeConnection("IP address blocked by filters");
        }
    }

    private void doUnchokes() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        int max_to_unchoke = this.adapter.getMaxUploads();
        ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
        if (this.seeding_mode) {
            if (this.unchoker == null || !this.unchoker.isSeedingUnchoker()) {
                this.unchoker = UnchokerFactory.getSingleton().getUnchoker(true);
            }
        } else if (this.unchoker == null || this.unchoker.isSeedingUnchoker()) {
            this.unchoker = UnchokerFactory.getSingleton().getUnchoker(false);
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_TEN_SECOND_INTERVAL == 0L) {
            boolean do_high_latency_peers;
            boolean refresh = this.mainloop_loop_count % (long)MAINLOOP_THIRTY_SECOND_INTERVAL == 0L;
            boolean bl = do_high_latency_peers = this.mainloop_loop_count % (long)MAINLOOP_TWENTY_SECOND_INTERVAL == 0L;
            if (do_high_latency_peers) {
                boolean ok = false;
                for (String net : AENetworkClassifier.AT_NON_PUBLIC) {
                    if (!this.adapter.isNetworkEnabled(net)) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    do_high_latency_peers = false;
                }
            }
            this.unchoker.calculateUnchokes(max_to_unchoke, peer_transports, refresh, this.adapter.hasPriorityConnection(), do_high_latency_peers);
            ArrayList<PEPeer> chokes = this.unchoker.getChokes();
            ArrayList<PEPeer> unchokes = this.unchoker.getUnchokes();
            this.addFastUnchokes(unchokes);
            UnchokerUtil.performChokes(chokes, unchokes);
        } else if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL == 0L) {
            ArrayList<PEPeer> unchokes = this.unchoker.getImmediateUnchokes(max_to_unchoke, peer_transports);
            this.addFastUnchokes(unchokes);
            UnchokerUtil.performChokes(null, unchokes);
        }
    }

    private void addFastUnchokes(ArrayList peers_to_unchoke) {
        for (PEPeerTransport pEPeerTransport : this.peer_transports_cow) {
            if (pEPeerTransport.getConnectionState() != 4 || !UnchokerUtil.isUnchokable(pEPeerTransport, true) || peers_to_unchoke.contains(pEPeerTransport)) continue;
            if (pEPeerTransport.isLANLocal()) {
                peers_to_unchoke.add(pEPeerTransport);
                continue;
            }
            if (!fast_unchoke_new_peers || pEPeerTransport.getData("fast_unchoke_done") != null) continue;
            pEPeerTransport.setData("fast_unchoke_done", "");
            peers_to_unchoke.add(pEPeerTransport);
        }
    }

    private void sendHave(int pieceNumber) {
        ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            pc.sendHave(pieceNumber);
        }
    }

    private void checkSeeds() {
        int i;
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        if (!disconnect_seeds_when_seeding) {
            return;
        }
        ArrayList<PEPeerTransport> to_close = null;
        ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
        for (i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc == null || pc.getPeerState() != 30 || (!this.isSeeding() || !pc.isSeed()) && !pc.isRelativeSeed()) continue;
            if (to_close == null) {
                to_close = new ArrayList<PEPeerTransport>();
            }
            to_close.add(pc);
        }
        if (to_close != null) {
            for (i = 0; i < to_close.size(); ++i) {
                this.closeAndRemovePeer((PEPeerTransport)to_close.get(i), "disconnect other seed when seeding", false);
            }
        }
    }

    private void updateStats() {
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL != 0L) {
            return;
        }
        ++this.stats_tick_count;
        ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
        int new_pending_tcp_connections = 0;
        int new_connecting_tcp_connections = 0;
        int new_seeds = 0;
        int new_peers = 0;
        int new_tcp_incoming = 0;
        int new_udp_incoming = 0;
        int new_utp_incoming = 0;
        int bytes_queued = 0;
        int con_queued = 0;
        int con_blocked = 0;
        int con_unchoked = 0;
        for (PEPeerTransport pEPeerTransport : peer_transports) {
            if (pEPeerTransport.getPeerState() == 30) {
                Connection connection;
                if (!pEPeerTransport.isChokedByMe()) {
                    ++con_unchoked;
                }
                if ((connection = pEPeerTransport.getPluginConnection()) != null) {
                    OutgoingMessageQueue mq = connection.getOutgoingMessageQueue();
                    int q = mq.getDataQueuedBytes() + mq.getProtocolQueuedBytes();
                    bytes_queued += q;
                    if (q > 0) {
                        ++con_queued;
                        if (mq.isBlocked()) {
                            ++con_blocked;
                        }
                    }
                }
                if (pEPeerTransport.isSeed()) {
                    ++new_seeds;
                } else {
                    ++new_peers;
                }
                if (!pEPeerTransport.isIncoming() || pEPeerTransport.isLANLocal()) continue;
                if (pEPeerTransport.isTCP()) {
                    ++new_tcp_incoming;
                    continue;
                }
                String protocol = pEPeerTransport.getProtocol();
                if (protocol.equals("UDP")) {
                    ++new_udp_incoming;
                    continue;
                }
                ++new_utp_incoming;
                continue;
            }
            if (!pEPeerTransport.isTCP()) continue;
            int c_state = pEPeerTransport.getConnectionState();
            if (c_state == 0) {
                ++new_pending_tcp_connections;
                continue;
            }
            if (c_state != 1) continue;
            ++new_connecting_tcp_connections;
        }
        this._seeds = new_seeds;
        this._peers = new_peers;
        this._remotesTCPNoLan = new_tcp_incoming;
        this._remotesUDPNoLan = new_udp_incoming;
        this._remotesUTPNoLan = new_utp_incoming;
        this._tcpPendingConnections = new_pending_tcp_connections;
        this._tcpConnectingConnections = new_connecting_tcp_connections;
        this.bytes_queued_for_upload = bytes_queued;
        this.connections_with_queued_data = con_queued;
        this.connections_with_queued_data_blocked = con_blocked;
        this.connections_unchoked = con_unchoked;
        this._stats.update(this.stats_tick_count);
    }

    @Override
    public void requestCanceled(DiskManagerReadRequest request2) {
        int pieceNumber = request2.getPieceNumber();
        PEPieceImpl pe_piece = this.pePieces[pieceNumber];
        if (pe_piece != null) {
            pe_piece.clearRequested(request2.getOffset() / 16384);
        }
    }

    public PEPeerControl getControl() {
        return this;
    }

    @Override
    public byte[][] getSecrets(int crypto_level) {
        return this.adapter.getSecrets(crypto_level);
    }

    @Override
    public byte[] getHash() {
        return this._hash.getDataID();
    }

    @Override
    public PeerIdentityDataID getPeerIdentityDataID() {
        return this._hash;
    }

    @Override
    public byte[] getPeerId() {
        return this._myPeerId;
    }

    @Override
    public long getRemaining() {
        return this.disk_mgr.getRemaining();
    }

    @Override
    public void discarded(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.discarded(peer, length);
            if (ban_peer_discard_ratio > 0.0f && !this.piecePicker.isInEndGameMode() && !this.piecePicker.hasEndGameModeBeenAbandoned()) {
                long discarded;
                long received = peer.getStats().getTotalDataBytesReceived();
                long non_discarded = received - (discarded = peer.getStats().getTotalBytesDiscarded());
                if (non_discarded < 0L) {
                    non_discarded = 0L;
                }
                if (discarded >= (long)ban_peer_discard_min_kb * 1024L && (non_discarded == 0L || (float)discarded / (float)non_discarded >= ban_peer_discard_ratio)) {
                    this.badPeerDetected(peer.getIp(), -1);
                }
            }
        }
    }

    @Override
    public void dataBytesReceived(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.dataBytesReceived(peer, length);
            this._averageReceptionSpeed.addValue(length);
        }
    }

    @Override
    public void protocolBytesReceived(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.protocolBytesReceived(peer, length);
        }
    }

    @Override
    public void dataBytesSent(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.dataBytesSent(peer, length);
        }
    }

    @Override
    public void protocolBytesSent(PEPeer peer, int length) {
        if (length > 0) {
            this._stats.protocolBytesSent(peer, length);
        }
    }

    @Override
    public void writeCompleted(DiskManagerWriteRequest request2) {
        int pieceNumber = request2.getPieceNumber();
        DiskManagerPiece dm_piece = this.dm_pieces[pieceNumber];
        if (!dm_piece.isDone()) {
            PEPieceImpl pePiece = this.pePieces[pieceNumber];
            if (pePiece != null) {
                pePiece.setWritten((PEPeer)request2.getUserData(), request2.getOffset() / 16384);
            } else {
                dm_piece.setWritten(request2.getOffset() / 16384);
            }
        }
    }

    @Override
    public void writeFailed(DiskManagerWriteRequest request2, Throwable cause) {
    }

    @Override
    public void writeBlock(int pieceNumber, int offset, DirectByteBuffer data, PEPeer sender, boolean cancel) {
        DiskManagerPiece dmPiece = this.dm_pieces[pieceNumber];
        int blockNumber = offset / 16384;
        if (dmPiece.isWritten(blockNumber)) {
            data.returnToPool();
            return;
        }
        PEPieceImpl pe_piece = this.pePieces[pieceNumber];
        if (pe_piece != null) {
            pe_piece.setDownloaded(offset);
        }
        DiskManagerWriteRequest request2 = this.disk_mgr.createWriteRequest(pieceNumber, offset, data, sender);
        this.disk_mgr.enqueueWriteRequest(request2, this);
        if (this.piecePicker.isInEndGameMode()) {
            this.piecePicker.removeFromEndGameModeChunks(pieceNumber, offset);
        }
        if (cancel || this.piecePicker.isInEndGameMode()) {
            ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport connection = (PEPeerTransport)peer_transports.get(i);
                DiskManagerReadRequest dmr = this.disk_mgr.createReadRequest(pieceNumber, offset, dmPiece.getBlockSize(blockNumber));
                connection.sendCancel(dmr);
            }
        }
    }

    @Override
    public boolean isWritten(int piece_number, int offset) {
        return this.dm_pieces[piece_number].isWritten(offset / 16384);
    }

    @Override
    public boolean validateReadRequest(PEPeerTransport originator, int pieceNumber, int offset, int length) {
        if (this.disk_mgr.checkBlockConsistencyForRead(originator.getClient() + ": " + originator.getIp(), true, pieceNumber, offset, length)) {
            DiskManagerPiece dm_piece;
            int read_count;
            if (enable_seeding_piece_rechecks && this.isSeeding() && (read_count = (dm_piece = this.dm_pieces[pieceNumber]).getReadCount() & 0xFFFF) < 65525) {
                dm_piece.setReadCount((short)(++read_count));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean validateHintRequest(PEPeerTransport originator, int pieceNumber, int offset, int length) {
        return this.disk_mgr.checkBlockConsistencyForHint(originator.getClient() + ": " + originator.getIp(), pieceNumber, offset, length);
    }

    @Override
    public boolean validatePieceReply(PEPeerTransport originator, int pieceNumber, int offset, DirectByteBuffer data) {
        return this.disk_mgr.checkBlockConsistencyForWrite(originator.getClient() + ": " + originator.getIp(), pieceNumber, offset, data);
    }

    @Override
    public int getAvailability(int pieceNumber) {
        return this.piecePicker.getAvailability(pieceNumber);
    }

    @Override
    public void havePiece(int pieceNumber, int pieceLength, PEPeer pcOrigin) {
        int availability;
        this.piecePicker.addHavePiece(pcOrigin, pieceNumber);
        this._stats.haveNewPiece(pieceLength);
        if (this.superSeedMode) {
            this.superSeedPieces[pieceNumber].peerHasPiece(pcOrigin);
            if (pieceNumber == pcOrigin.getUniqueAnnounce()) {
                pcOrigin.setUniqueAnnounce(-1);
                --this.superSeedModeNumberOfAnnounces;
            }
        }
        if ((availability = this.piecePicker.getAvailability(pieceNumber) - 1) < 4) {
            if (this.dm_pieces[pieceNumber].isDone()) {
                --availability;
            }
            if (availability <= 0) {
                return;
            }
            ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
            for (int i = peer_transports.size() - 1; i >= 0; --i) {
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
                if (pc == pcOrigin || pc.getPeerState() != 30 || !pc.isPieceAvailable(pieceNumber)) continue;
                ((PEPeerStatsImpl)pc.getStats()).statisticalSentPiece(pieceLength / availability);
            }
        }
    }

    @Override
    public int getPieceLength(int pieceNumber) {
        return this.disk_mgr.getPieceLength(pieceNumber);
    }

    @Override
    public int getNbPeers() {
        return this._peers;
    }

    @Override
    public int getNbSeeds() {
        return this._seeds;
    }

    @Override
    public int getNbRemoteTCPConnections() {
        return this._remotesTCPNoLan;
    }

    @Override
    public int getNbRemoteUDPConnections() {
        return this._remotesUDPNoLan;
    }

    @Override
    public int getNbRemoteUTPConnections() {
        return this._remotesUTPNoLan;
    }

    @Override
    public long getLastRemoteConnectionTime() {
        return this.last_remote_time;
    }

    @Override
    public PEPeerManagerStats getStats() {
        return this._stats;
    }

    @Override
    public int getNbPeersStalledPendingLoad() {
        int res = 0;
        for (PEPeerTransport pEPeerTransport : this.peer_transports_cow) {
            if (!pEPeerTransport.isStalledPendingLoad()) continue;
            ++res;
        }
        return res;
    }

    @Override
    public long getETA(boolean smoothed) {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_eta_calculation || now - this.last_eta_calculation > 900L) {
            long smooth_result;
            long jagged_result;
            long dataRemaining = this.disk_mgr.getRemainingExcludingDND();
            if (dataRemaining > 0L) {
                int writtenNotChecked = 0;
                for (int i = 0; i < this._nbPieces; ++i) {
                    if (!this.dm_pieces[i].isInteresting()) continue;
                    writtenNotChecked += this.dm_pieces[i].getNbWritten() * 16384;
                }
                if ((dataRemaining -= (long)writtenNotChecked) < 0L) {
                    dataRemaining = 0L;
                }
            }
            if (dataRemaining == 0L) {
                long timeElapsed = (this._timeFinished - this._timeStarted) / 1000L;
                jagged_result = timeElapsed > 1L ? timeElapsed * -1L : 0L;
                smooth_result = jagged_result;
            } else {
                long lETA;
                long averageSpeed = this._averageReceptionSpeed.getAverage();
                long l = lETA = averageSpeed == 0L ? 1827387392L : dataRemaining / averageSpeed;
                if (lETA == 0L) {
                    lETA = 1L;
                }
                jagged_result = lETA;
                averageSpeed = this._stats.getSmoothedDataReceiveRate();
                long l2 = lETA = averageSpeed == 0L ? 1827387392L : dataRemaining / averageSpeed;
                if (lETA == 0L) {
                    lETA = 1L;
                }
                smooth_result = lETA;
            }
            this.last_eta = jagged_result;
            this.last_eta_smoothed = smooth_result;
            this.last_eta_calculation = now;
        }
        return smoothed ? this.last_eta_smoothed : this.last_eta;
    }

    @Override
    public boolean isRTA() {
        return this.piecePicker.getRTAProviders().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addToPeerTransports(PEPeerTransport peer) {
        long connect_time;
        List<Object[]> limiters;
        boolean added;
        block10: {
            block9: {
                added = false;
                try {
                    this.peer_transports_mon.enter();
                    if (peer.getPeerState() == 50) {
                        Object var6_3 = null;
                        this.peer_transports_mon.exit();
                        return;
                    }
                    if (this.peer_transports_cow.contains(peer)) {
                        Debug.out("Transport added twice");
                        break block9;
                    }
                    if (this.is_running) {
                        ArrayList<PEPeer> new_peer_transports = new ArrayList<PEPeer>(this.peer_transports_cow.size() + 1);
                        new_peer_transports.addAll(this.peer_transports_cow);
                        new_peer_transports.add(peer);
                        this.peer_transports_cow = new_peer_transports;
                        added = true;
                    }
                    limiters = this.external_rate_limiters_cow;
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.peer_transports_mon.exit();
                    throw throwable;
                }
            }
            Object var6_4 = null;
            this.peer_transports_mon.exit();
            return;
        }
        Object var6_5 = null;
        this.peer_transports_mon.exit();
        if (!added) {
            peer.closeConnection("PeerTransport added when manager not running");
            return;
        }
        boolean incoming = peer.isIncoming();
        this._stats.haveNewConnection(incoming);
        if (incoming && (connect_time = SystemTime.getCurrentTime()) > this.last_remote_time) {
            this.last_remote_time = connect_time;
        }
        if (limiters != null) {
            for (int i = 0; i < limiters.size(); ++i) {
                Object[] entry = limiters.get(i);
                peer.addRateLimiter((LimitedRateGroup)entry[0], (Boolean)entry[1]);
            }
        }
        this.peerAdded(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRateLimiter(LimitedRateGroup group, boolean upload) {
        ArrayList<PEPeer> transports;
        try {
            this.peer_transports_mon.enter();
            ArrayList<Object[]> new_limiters = new ArrayList<Object[]>(this.external_rate_limiters_cow == null ? 1 : this.external_rate_limiters_cow.size() + 1);
            if (this.external_rate_limiters_cow != null) {
                new_limiters.addAll(this.external_rate_limiters_cow);
            }
            new_limiters.add(new Object[]{group, new Boolean(upload)});
            this.external_rate_limiters_cow = new_limiters;
            transports = this.peer_transports_cow;
            Object var6_6 = null;
            this.peer_transports_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.peer_transports_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < transports.size(); ++i) {
            ((PEPeer)transports.get(i)).addRateLimiter(group, upload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRateLimiter(LimitedRateGroup group, boolean upload) {
        ArrayList<PEPeer> transports;
        try {
            this.peer_transports_mon.enter();
            if (this.external_rate_limiters_cow != null) {
                ArrayList<Object[]> new_limiters = new ArrayList<Object[]>(this.external_rate_limiters_cow.size() - 1);
                for (int i = 0; i < this.external_rate_limiters_cow.size(); ++i) {
                    Object[] entry = this.external_rate_limiters_cow.get(i);
                    if (entry[0] == group) continue;
                    new_limiters.add(entry);
                }
                this.external_rate_limiters_cow = new_limiters.size() == 0 ? null : new_limiters;
            }
            transports = this.peer_transports_cow;
            Object var8_8 = null;
            this.peer_transports_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.peer_transports_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < transports.size(); ++i) {
            ((PEPeerTransport)transports.get(i)).removeRateLimiter(group, upload);
        }
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return this.adapter.getUploadRateLimitBytesPerSecond();
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return this.adapter.getDownloadRateLimitBytesPerSecond();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void peerConnectionClosed(PEPeerTransport peer, boolean connect_failed, boolean network_failed) {
        boolean connection_found = false;
        boolean tcpReconnect = false;
        boolean ipv6reconnect = false;
        try {
            boolean canTryIpv6;
            this.peer_transports_mon.enter();
            int udpPort = peer.getUDPListenPort();
            boolean canTryUDP = UDPNetworkManager.UDP_OUTGOING_ENABLED && peer.getUDPListenPort() > 0;
            boolean bl = canTryIpv6 = NetworkAdmin.getSingleton().hasIPV6Potential(true) && peer.getAlternativeIPv6() != null;
            if (this.is_running) {
                PeerItem peer_item = peer.getPeerItemIdentity();
                PeerItem self_item = this.peer_database.getSelfPeer();
                if (self_item == null || !self_item.equals(peer_item)) {
                    boolean wasIPv6;
                    String ip = peer.getIp();
                    try {
                        wasIPv6 = AddressUtils.getByName(ip) instanceof Inet6Address;
                    }
                    catch (UnknownHostException e) {
                        wasIPv6 = false;
                        canTryIpv6 = false;
                    }
                    String key = ip + ":" + udpPort;
                    if (peer.isTCP()) {
                        if (connect_failed) {
                            if (canTryUDP && udp_fallback_for_failed_connection) {
                                this.pending_nat_traversals.put(key, peer);
                            } else if (canTryIpv6 && !wasIPv6) {
                                tcpReconnect = true;
                                ipv6reconnect = true;
                            }
                        } else if (canTryUDP && udp_fallback_for_dropped_connection && network_failed && this.seeding_mode && peer.isInterested() && !peer.isSeed() && !peer.isRelativeSeed() && peer.getStats().getEstimatedSecondsToCompletion() > 60L && FeatureAvailability.isUDPPeerReconnectEnabled()) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)peer, LOGID, 1, "Unexpected stream closure detected, attempting recovery"));
                            }
                            this.udp_reconnects.put(key, peer);
                        } else if (network_failed && peer.isSafeForReconnect() && (!this.seeding_mode || !peer.isSeed() && !peer.isRelativeSeed() && peer.getStats().getEstimatedSecondsToCompletion() >= 60L) && this.getMaxConnections() > 0 && this.getMaxNewConnectionsAllowed() > this.getMaxConnections() / 3 && FeatureAvailability.isGeneralPeerReconnectEnabled()) {
                            tcpReconnect = true;
                        }
                    } else if (connect_failed && udp_fallback_for_failed_connection && peer.getData(PEER_NAT_TRAVERSE_DONE_KEY) == null) {
                        this.pending_nat_traversals.put(key, peer);
                    }
                }
            }
            if (this.peer_transports_cow.contains(peer)) {
                ArrayList<PEPeer> new_peer_transports = new ArrayList<PEPeer>(this.peer_transports_cow);
                new_peer_transports.remove(peer);
                this.peer_transports_cow = new_peer_transports;
                connection_found = true;
            }
            Object var16_16 = null;
            this.peer_transports_mon.exit();
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            this.peer_transports_mon.exit();
            throw throwable;
        }
        if (connection_found) {
            if (peer.getPeerState() != 50) {
                System.out.println("peer.getPeerState() != PEPeer.DISCONNECTED: " + peer.getPeerState());
            }
            this.peerRemoved(peer);
        }
        if (tcpReconnect) {
            peer.reconnect(false, ipv6reconnect);
        }
    }

    @Override
    public void peerAdded(PEPeer pc) {
        this.adapter.addPeer(pc);
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        for (int i = 0; i < peer_manager_listeners.size(); ++i) {
            peer_manager_listeners.get(i).peerAdded(this, pc);
        }
    }

    @Override
    public void peerRemoved(PEPeer pc) {
        int[] reserved_pieces;
        int piece;
        int udp;
        if (this.is_running && !this.seeding_mode && (this.prefer_udp || prefer_udp_default) && (udp = pc.getUDPListenPort()) != 0 && udp == pc.getTCPListenPort()) {
            BloomFilter filter2 = this.prefer_udp_bloom;
            if (filter2 == null) {
                filter2 = this.prefer_udp_bloom = BloomFilterFactory.createAddOnly(10000);
            }
            if (filter2.getEntryCount() < 1000) {
                filter2.add(pc.getIp().getBytes());
            }
        }
        if ((piece = pc.getUniqueAnnounce()) != -1 && this.superSeedMode) {
            --this.superSeedModeNumberOfAnnounces;
            this.superSeedPieces[piece].peerLeft();
        }
        if ((reserved_pieces = pc.getReservedPieceNumbers()) != null) {
            for (int reserved_piece : reserved_pieces) {
                String reserved_by;
                PEPieceImpl pe_piece = this.pePieces[reserved_piece];
                if (pe_piece == null || (reserved_by = pe_piece.getReservedBy()) == null || !reserved_by.equals(pc.getIp())) continue;
                pe_piece.setReservedBy(null);
            }
        }
        if (pc.isSeed()) {
            this.last_seed_disconnect_time = SystemTime.getCurrentTime();
        }
        this.adapter.removePeer(pc);
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        for (int i = 0; i < peer_manager_listeners.size(); ++i) {
            peer_manager_listeners.get(i).peerRemoved(this, pc);
        }
    }

    @Override
    public void addPiece(PEPiece piece, int pieceNumber, PEPeer for_peer) {
        this.addPiece(piece, pieceNumber, false, for_peer);
    }

    protected void addPiece(PEPiece piece, int pieceNumber, boolean force_add, PEPeer for_peer) {
        if (piece == null || this.pePieces[pieceNumber] != null) {
            Debug.out("piece state inconsistent");
        }
        this.pePieces[pieceNumber] = (PEPieceImpl)piece;
        ++this.nbPiecesActive;
        if (this.is_running || force_add) {
            this.adapter.addPiece(piece);
        }
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        for (int i = 0; i < peer_manager_listeners.size(); ++i) {
            try {
                peer_manager_listeners.get(i).pieceAdded(this, piece, for_peer);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void removePiece(PEPiece pePiece, int pieceNumber) {
        if (pePiece != null) {
            this.adapter.removePiece(pePiece);
        } else {
            pePiece = this.pePieces[pieceNumber];
        }
        if (this.pePieces[pieceNumber] != null) {
            this.pePieces[pieceNumber] = null;
            --this.nbPiecesActive;
        }
        if (pePiece == null) {
            return;
        }
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        for (int i = 0; i < peer_manager_listeners.size(); ++i) {
            try {
                peer_manager_listeners.get(i).pieceRemoved(this, pePiece);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public int getNbActivePieces() {
        return this.nbPiecesActive;
    }

    @Override
    public String getElapsedTime() {
        return TimeFormatter.format((SystemTime.getCurrentTime() - this._timeStarted) / 1000L);
    }

    @Override
    public long getTimeStarted(boolean mono) {
        return mono ? this._timeStarted_mono : this._timeStarted;
    }

    @Override
    public long getTimeStartedSeeding(boolean mono) {
        return mono ? this._timeStartedSeeding_mono : this._timeStartedSeeding;
    }

    private byte[] computeMd5Hash(DirectByteBuffer buffer) {
        BrokenMd5Hasher md5 = new BrokenMd5Hasher();
        md5.reset();
        int position = buffer.position((byte)8);
        md5.update(buffer.getBuffer((byte)8));
        buffer.position((byte)8, position);
        ByteBuffer md5Result = ByteBuffer.allocate(16);
        md5Result.position(0);
        md5.finalDigest(md5Result);
        byte[] result = new byte[16];
        md5Result.position(0);
        for (int i = 0; i < result.length; ++i) {
            result[i] = md5Result.get();
        }
        return result;
    }

    private void MD5CheckPiece(PEPiece piece, boolean correct) {
        String[] writers = piece.getWriters();
        int offset = 0;
        for (int i = 0; i < writers.length; ++i) {
            DirectByteBuffer buffer;
            int length = piece.getBlockSize(i);
            String peer = writers[i];
            if (peer != null && (buffer = this.disk_mgr.readBlock(piece.getPieceNumber(), offset, length)) != null) {
                byte[] hash = this.computeMd5Hash(buffer);
                buffer.returnToPool();
                buffer = null;
                piece.addWrite(i, peer, hash, correct);
            }
            offset += length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(passed ? 1 : 0)});
            Object var4_3 = null;
            this.piece_check_result_list_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.piece_check_result_list_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkCancelled(DiskManagerCheckRequest request2) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(2)});
            Object var3_2 = null;
            this.piece_check_result_list_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.piece_check_result_list_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{request2, new Integer(0)});
            Object var4_3 = null;
            this.piece_check_result_list_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.piece_check_result_list_mon.exit();
            throw throwable;
        }
    }

    @Override
    public boolean needsMD5CheckOnCompletion(int pieceNumber) {
        PEPieceImpl piece = this.pePieces[pieceNumber];
        if (piece == null) {
            return false;
        }
        return piece.getPieceWrites().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPieceCheckResult(DiskManagerCheckRequest request2, int outcome) {
        int check_type;
        block38: {
            block37: {
                block35: {
                    block36: {
                        check_type = (Integer)request2.getUserData();
                        try {
                            int pieceNumber = request2.getPieceNumber();
                            if (check_type == 2) {
                                if (outcome == 0) {
                                    Debug.out(this.getDisplayName() + ": Piece #" + pieceNumber + " failed final re-check. Re-downloading...");
                                    if (!this.restart_initiated) {
                                        this.restart_initiated = true;
                                        this.adapter.restartDownload(true);
                                    }
                                }
                                Object var18_5 = null;
                                if (check_type != 3) break block35;
                                break block36;
                            }
                            if (check_type == 4 || check_type == 5) {
                                if (outcome != 0) break block37;
                                if (check_type == 4) {
                                    Debug.out(this.getDisplayName() + "Piece #" + pieceNumber + " failed recheck while seeding. Re-downloading...");
                                } else {
                                    Debug.out(this.getDisplayName() + "Piece #" + pieceNumber + " failed recheck after being reported as bad. Re-downloading...");
                                }
                                Logger.log(new LogAlert((Object)this, true, 3, "Download '" + this.getDisplayName() + "': piece " + pieceNumber + " has been corrupted, re-downloading"));
                                if (!this.restart_initiated) {
                                    this.restart_initiated = true;
                                    this.adapter.restartDownload(true);
                                }
                                break block37;
                            }
                            PEPieceImpl pePiece = this.pePieces[pieceNumber];
                            if (outcome == 1 || this.is_metadata_download) {
                                try {
                                    if (pePiece != null) {
                                        List list;
                                        if (this.needsMD5CheckOnCompletion(pieceNumber)) {
                                            this.MD5CheckPiece(pePiece, true);
                                        }
                                        if ((list = pePiece.getPieceWrites()).size() > 0) {
                                            for (int i = 0; i < pePiece.getNbBlocks(); ++i) {
                                                List listPerBlock = pePiece.getPieceWrites(i);
                                                byte[] correctHash = null;
                                                for (PEPieceWriteImpl write : listPerBlock) {
                                                    if (!write.isCorrect()) continue;
                                                    correctHash = write.getHash();
                                                }
                                                if (correctHash == null) continue;
                                                for (PEPieceWriteImpl write : listPerBlock) {
                                                    if (Arrays.equals(write.getHash(), correctHash)) continue;
                                                    this.badPeerDetected(write.getSender(), pieceNumber);
                                                }
                                            }
                                        }
                                    }
                                    Object var13_26 = null;
                                    this.removePiece(pePiece, pieceNumber);
                                    this.sendHave(pieceNumber);
                                    break block38;
                                }
                                catch (Throwable throwable) {
                                    Object var13_27 = null;
                                    this.removePiece(pePiece, pieceNumber);
                                    this.sendHave(pieceNumber);
                                    throw throwable;
                                }
                            }
                            if (outcome != 0) break block38;
                            if (pePiece != null) {
                                try {
                                    this.MD5CheckPiece(pePiece, false);
                                    String[] writers = pePiece.getWriters();
                                    ArrayList<String> uniqueWriters = new ArrayList<String>();
                                    int[] writesPerWriter = new int[writers.length];
                                    for (int i = 0; i < writers.length; ++i) {
                                        String writer = writers[i];
                                        if (writer == null) continue;
                                        int writerId = uniqueWriters.indexOf(writer);
                                        if (writerId == -1) {
                                            uniqueWriters.add(writer);
                                            writerId = uniqueWriters.size() - 1;
                                        }
                                        int n = writerId;
                                        writesPerWriter[n] = writesPerWriter[n] + 1;
                                    }
                                    int nbWriters = uniqueWriters.size();
                                    if (nbWriters == 1) {
                                        String bad_ip = (String)uniqueWriters.get(0);
                                        PEPeerTransport bad_peer = this.getTransportFromAddress(bad_ip);
                                        if (bad_peer != null) {
                                            bad_peer.sendBadPiece(pieceNumber);
                                        }
                                        this.badPeerDetected(bad_ip, pieceNumber);
                                        pePiece.reset();
                                    } else if (nbWriters > 1) {
                                        int i;
                                        int maxWrites = 0;
                                        String bestWriter = null;
                                        PEPeer bestWriter_transport = null;
                                        for (i = 0; i < uniqueWriters.size(); ++i) {
                                            String writer;
                                            PEPeerTransport pt;
                                            int writes = writesPerWriter[i];
                                            if (writes <= maxWrites || (pt = this.getTransportFromAddress(writer = (String)uniqueWriters.get(i))) == null || pt.getReservedPieceNumbers() != null || ip_filter.isInRange(writer, this.getDisplayName(), this.getTorrentHash())) continue;
                                            bestWriter = writer;
                                            maxWrites = writes;
                                            bestWriter_transport = pt;
                                        }
                                        if (bestWriter != null) {
                                            pePiece.setReservedBy(bestWriter);
                                            bestWriter_transport.addReservedPieceNumber(pePiece.getPieceNumber());
                                            pePiece.setRequestable();
                                            for (i = 0; i < pePiece.getNbBlocks(); ++i) {
                                                if (writers[i] != null && writers[i].equals(bestWriter)) continue;
                                                pePiece.reDownloadBlock(i);
                                            }
                                        } else {
                                            pePiece.reset();
                                        }
                                    } else {
                                        pePiece.reset();
                                    }
                                    this.piecePicker.addEndGameChunks(pePiece);
                                    this._stats.hashFailed(pePiece.getLength());
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                    pePiece.reset();
                                }
                                break block38;
                            }
                            Debug.out(this.getDisplayName() + "Piece #" + pieceNumber + " failed check and no active piece, resetting...");
                            this.dm_pieces[pieceNumber].reset();
                            break block38;
                        }
                        catch (Throwable throwable) {
                            Object var18_8 = null;
                            if (check_type == 3) {
                                this.rescan_piece_time = SystemTime.getCurrentTime();
                            }
                            if (this.seeding_mode) throw throwable;
                            this.checkFinished(false);
                            throw throwable;
                        }
                    }
                    this.rescan_piece_time = SystemTime.getCurrentTime();
                }
                if (this.seeding_mode) return;
                this.checkFinished(false);
                return;
            }
            Object var18_6 = null;
            if (check_type == 3) {
                this.rescan_piece_time = SystemTime.getCurrentTime();
            }
            if (this.seeding_mode) return;
            this.checkFinished(false);
            return;
        }
        Object var18_7 = null;
        if (check_type == 3) {
            this.rescan_piece_time = SystemTime.getCurrentTime();
        }
        if (this.seeding_mode) return;
        this.checkFinished(false);
    }

    private void badPeerDetected(String ip, int piece_number) {
        int ps;
        boolean hash_fail = piece_number >= 0;
        PEPeerTransport peer = this.getTransportFromAddress(ip);
        if (hash_fail && peer != null) {
            Iterator<PEPeerManagerListener> it = this.peer_manager_listeners_cow.iterator();
            while (it.hasNext()) {
                try {
                    it.next().peerSentBadData(this, peer, piece_number);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        IpFilterManager filter_manager = IpFilterManagerFactory.getSingleton();
        int nbWarnings = filter_manager.getBadIps().addWarningForIp(ip);
        boolean disconnect_peer = false;
        if (nbWarnings > 2) {
            if (COConfigurationManager.getBooleanParameter("Ip Filter Enable Banning")) {
                if (ip_filter.ban(ip, this.getDisplayName(), false)) {
                    this.checkForBannedConnections();
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)peer, LOGID, 3, ip + " : has been banned and won't be able " + "to connect until you restart azureus"));
                }
                disconnect_peer = true;
            }
        } else if (!hash_fail) {
            disconnect_peer = true;
        }
        if (disconnect_peer && peer != null && (ps = peer.getPeerState()) != 40 && ps != 50) {
            this.closeAndRemovePeer(peer, "has sent too many " + (hash_fail ? "bad pieces" : "discarded blocks") + ", " + 2 + " max.", true);
        }
    }

    @Override
    public PEPiece[] getPieces() {
        return this.pePieces;
    }

    @Override
    public PEPiece getPiece(int pieceNumber) {
        return this.pePieces[pieceNumber];
    }

    @Override
    public PEPeerStats createPeerStats(PEPeer owner) {
        return new PEPeerStatsImpl(owner);
    }

    @Override
    public DiskManagerReadRequest createDiskManagerRequest(int pieceNumber, int offset, int length) {
        return this.disk_mgr.createReadRequest(pieceNumber, offset, length);
    }

    @Override
    public boolean requestExists(String peer_ip, int piece_number, int offset, int length) {
        ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
        DiskManagerReadRequest request2 = null;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
            if (!conn.getIp().equals(peer_ip)) continue;
            if (request2 == null) {
                request2 = this.createDiskManagerRequest(piece_number, offset, length);
            }
            if (conn.getRequestIndex(request2) == -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean seedPieceRecheck() {
        DiskManagerPiece dm_piece;
        if (!enable_seeding_piece_rechecks && !this.isSeeding()) {
            return false;
        }
        int max_reads = 0;
        int max_reads_index = 0;
        for (int i = 0; i < this.dm_pieces.length; ++i) {
            DiskManagerPiece dm_piece2 = this.dm_pieces[i];
            if (!dm_piece2.isDone()) continue;
            int num = dm_piece2.getReadCount() & 0xFFFF;
            if (num > 65526) {
                if (--num == 65526) {
                    num = 0;
                }
                dm_piece2.setReadCount((short)num);
                continue;
            }
            if (num <= max_reads) continue;
            max_reads = num;
            max_reads_index = i;
        }
        if (max_reads > 0 && max_reads >= (dm_piece = this.dm_pieces[max_reads_index]).getNbBlocks() * 3) {
            DiskManagerCheckRequest req = this.disk_mgr.createCheckRequest(max_reads_index, new Integer(4));
            req.setAdHoc(true);
            req.setLowPriority(true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.disk_mgr.getTorrent(), LOGID, "Rechecking piece " + max_reads_index + " while seeding as most active"));
            }
            this.disk_mgr.enqueueCheckRequest(req, this);
            dm_piece.setReadCount((short)-1);
            for (int i = 0; i < this.dm_pieces.length; ++i) {
                int num;
                if (i == max_reads_index || (num = this.dm_pieces[i].getReadCount() & 0xFFFF) >= 65526) continue;
                this.dm_pieces[i].setReadCount((short)0);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(PEPeerManagerListener l) {
        try {
            this.this_mon.enter();
            ArrayList<PEPeerManagerListener> peer_manager_listeners = new ArrayList<PEPeerManagerListener>(this.peer_manager_listeners_cow.size() + 1);
            peer_manager_listeners.addAll(this.peer_manager_listeners_cow);
            peer_manager_listeners.add(l);
            this.peer_manager_listeners_cow = peer_manager_listeners;
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(PEPeerManagerListener l) {
        try {
            this.this_mon.enter();
            ArrayList<PEPeerManagerListener> peer_manager_listeners = new ArrayList<PEPeerManagerListener>(this.peer_manager_listeners_cow);
            peer_manager_listeners.remove(l);
            this.peer_manager_listeners_cow = peer_manager_listeners;
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    private void checkForBannedConnections() {
        if (ip_filter.isEnabled()) {
            int i;
            ArrayList<PEPeerTransport> to_close = null;
            ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
            String name = this.getDisplayName();
            byte[] hash = this.getTorrentHash();
            for (i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
                if (!ip_filter.isInRange(conn.getIp(), name, hash)) continue;
                if (to_close == null) {
                    to_close = new ArrayList<PEPeerTransport>();
                }
                to_close.add(conn);
            }
            if (to_close != null) {
                for (i = 0; i < to_close.size(); ++i) {
                    this.closeAndRemovePeer((PEPeerTransport)to_close.get(i), "IPFilter banned IP address", true);
                }
            }
        }
    }

    @Override
    public boolean isSeeding() {
        return this.seeding_mode;
    }

    @Override
    public boolean isMetadataDownload() {
        return this.is_metadata_download;
    }

    @Override
    public int getTorrentInfoDictSize() {
        return this.metadata_infodict_size;
    }

    @Override
    public void setTorrentInfoDictSize(int size) {
        this.metadata_infodict_size = size;
    }

    @Override
    public boolean isInEndGameMode() {
        return this.piecePicker.isInEndGameMode();
    }

    @Override
    public boolean isSuperSeedMode() {
        return this.superSeedMode;
    }

    @Override
    public boolean canToggleSuperSeedMode() {
        if (this.superSeedMode) {
            return true;
        }
        return this.superSeedPieces == null && this.getRemaining() == 0L;
    }

    @Override
    public void setSuperSeedMode(boolean _superSeedMode) {
        if (_superSeedMode == this.superSeedMode) {
            return;
        }
        boolean kick_peers = false;
        if (_superSeedMode) {
            if (this.superSeedPieces == null && this.getRemaining() == 0L) {
                this.superSeedMode = true;
                this.initialiseSuperSeedMode();
                kick_peers = true;
            }
        } else {
            this.superSeedMode = false;
            kick_peers = true;
        }
        if (kick_peers) {
            ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
                this.closeAndRemovePeer(conn, "Turning on super-seeding", false);
            }
        }
    }

    private void initialiseSuperSeedMode() {
        this.superSeedPieces = new SuperSeedPiece[this._nbPieces];
        for (int i = 0; i < this._nbPieces; ++i) {
            this.superSeedPieces[i] = new SuperSeedPiece(this, i);
        }
    }

    private void updatePeersInSuperSeedMode() {
        if (!this.superSeedMode) {
            return;
        }
        for (int i = 0; i < this.superSeedPieces.length; ++i) {
            this.superSeedPieces[i].updateTime();
        }
        int nbUnchoke = this.adapter.getMaxUploads();
        if (this.superSeedModeNumberOfAnnounces >= 2 * nbUnchoke) {
            return;
        }
        PEPeer selectedPeer = null;
        ArrayList<SuperSeedPeer> sortedPeers = null;
        ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
        sortedPeers = new ArrayList<SuperSeedPeer>(peer_transports.size());
        Iterator<PEPeer> iter = peer_transports.iterator();
        while (iter.hasNext()) {
            sortedPeers.add(new SuperSeedPeer(iter.next()));
        }
        Collections.sort(sortedPeers);
        iter = sortedPeers.iterator();
        while (iter.hasNext()) {
            PEPeer peer = ((SuperSeedPeer)((Object)iter.next())).peer;
            if (peer.getUniqueAnnounce() != -1 || peer.getPeerState() != 30) continue;
            selectedPeer = peer;
            break;
        }
        if (selectedPeer == null || selectedPeer.getPeerState() >= 40) {
            return;
        }
        if (selectedPeer.getUploadHint() == 0) {
            selectedPeer.setUploadHint(31536000);
        }
        boolean found = false;
        SuperSeedPiece piece = null;
        boolean loopdone = false;
        while (!found) {
            piece = this.superSeedPieces[this.superSeedModeCurrentPiece];
            if (piece.getLevel() > 0) {
                piece = null;
                ++this.superSeedModeCurrentPiece;
                if (this.superSeedModeCurrentPiece < this._nbPieces) continue;
                this.superSeedModeCurrentPiece = 0;
                if (loopdone) {
                    this.superSeedMode = false;
                    this.closeAndRemoveAllPeers("quiting SuperSeed mode", true);
                    return;
                }
                loopdone = true;
                continue;
            }
            found = true;
        }
        if (piece == null) {
            return;
        }
        if (selectedPeer.isPieceAvailable(piece.getPieceNumber())) {
            return;
        }
        selectedPeer.setUniqueAnnounce(piece.getPieceNumber());
        ++this.superSeedModeNumberOfAnnounces;
        piece.pieceRevealedToPeer();
        ((PEPeerTransport)selectedPeer).sendHave(piece.getPieceNumber());
    }

    @Override
    public void updateSuperSeedPiece(PEPeer peer, int pieceNumber) {
        if (!this.superSeedMode) {
            return;
        }
        this.superSeedPieces[pieceNumber].peerHasPiece(null);
        if (peer.getUniqueAnnounce() == pieceNumber) {
            peer.setUniqueAnnounce(-1);
            --this.superSeedModeNumberOfAnnounces;
        }
    }

    @Override
    public boolean isPrivateTorrent() {
        return this.is_private_torrent;
    }

    @Override
    public boolean isExtendedMessagingEnabled() {
        return this.adapter.isExtendedMessagingEnabled();
    }

    @Override
    public boolean isPeerExchangeEnabled() {
        return this.adapter.isPeerExchangeEnabled();
    }

    @Override
    public LimitedRateGroup getUploadLimitedRateGroup() {
        return this.upload_limited_rate_group;
    }

    @Override
    public LimitedRateGroup getDownloadLimitedRateGroup() {
        return this.download_limited_rate_group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(String key) {
        block3: {
            try {
                this.this_mon.enter();
                if (this.user_data != null) break block3;
                Object var2_2 = null;
                Object var4_4 = null;
                this.this_mon.exit();
                return var2_2;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        Object object = this.user_data.get(key);
        Object var4_5 = null;
        this.this_mon.exit();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(String key, Object value) {
        try {
            this.this_mon.enter();
            if (this.user_data == null) {
                this.user_data = new HashMap<Object, Object>();
            }
            if (value == null) {
                if (this.user_data.containsKey(key)) {
                    this.user_data.remove(key);
                }
            } else {
                this.user_data.put(key, value);
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    @Override
    public int getConnectTimeout(int ct_def) {
        int max;
        int lower_limit;
        if (ct_def <= 0) {
            return ct_def;
        }
        if (this.seeding_mode) {
            return ct_def;
        }
        int max_sim_con = TCPConnectionManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS;
        if (max_sim_con >= 50) {
            return ct_def;
        }
        int connected = this._seeds + this._peers;
        int connecting = this._tcpConnectingConnections;
        int queued = this._tcpPendingConnections;
        int not_yet_connected = this.peer_database.getDiscoveredPeerCount();
        int potential = connecting + queued + not_yet_connected;
        if (potential <= (lower_limit = (max = this.getMaxConnections()) / 4) || max == lower_limit) {
            return ct_def;
        }
        int MIN_CT = 7500;
        if (potential >= max) {
            return 7500;
        }
        int pos = potential - lower_limit;
        int scale = max - lower_limit;
        int res = 7500 + (ct_def - 7500) * (scale - pos) / scale;
        return res;
    }

    private void doConnectionChecks() {
        int goal;
        long last_update;
        ArrayList<PEPeer> peer_transports;
        if (this.mainloop_loop_count % (long)MAINLOOP_ONE_SECOND_INTERVAL == 0L) {
            int allowed;
            int to_disconnect;
            peer_transports = this.peer_transports_cow;
            int num_waiting_establishments = 0;
            int udp_connections = 0;
            for (int i = 0; i < peer_transports.size(); ++i) {
                int state;
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(i);
                if (!this.tabGeneralOption[3] && !transport.isNoUploadUserSet()) {
                    transport.setNoUpload(false);
                }
                if ((state = transport.getConnectionState()) == 0 || state == 1) {
                    ++num_waiting_establishments;
                }
                if (transport.isTCP()) continue;
                ++udp_connections;
            }
            int allowed_seeds = this.getMaxSeedConnections();
            if (allowed_seeds > 0 && (to_disconnect = this._seeds - allowed_seeds) > 0) {
                for (int i = peer_transports.size() - 1; i >= 0 && to_disconnect > 0; --i) {
                    PEPeerTransport transport = (PEPeerTransport)peer_transports.get(i);
                    if (!transport.isSeed()) continue;
                    this.closeAndRemovePeer(transport, "Too many seeds", false);
                    --to_disconnect;
                }
            }
            if ((allowed = this.getMaxNewConnectionsAllowed()) < 0 || allowed > 1000) {
                allowed = 1000;
            }
            if (this.adapter.isNATHealthy()) {
                int free = this.getMaxConnections() / 20;
                allowed -= free;
            }
            if (allowed > 0) {
                PeerItem item;
                int wanted = TCPConnectionManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS - num_waiting_establishments;
                if (wanted > allowed) {
                    num_waiting_establishments += wanted - allowed;
                }
                int remaining = allowed;
                int tcp_remaining = TCPNetworkManager.getSingleton().getConnectDisconnectManager().getMaxOutboundPermitted();
                int udp_remaining = UDPNetworkManager.getSingleton().getConnectionManager().getMaxOutboundPermitted();
                while (num_waiting_establishments < TCPConnectionManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS && (tcp_remaining > 0 || udp_remaining > 0) && this.is_running && (item = this.peer_database.getNextOptimisticConnectPeer()) != null && this.is_running) {
                    boolean udp_ok;
                    boolean prefer_udp_overall;
                    PeerItem self = this.peer_database.getSelfPeer();
                    if (self != null && self.equals(item) || this.isAlreadyConnected(item)) continue;
                    String source = PeerItem.convertSourceString(item.getSource());
                    boolean use_crypto = item.getHandshakeType() == 1;
                    int tcp_port = item.getTCPPort();
                    int udp_port = item.getUDPPort();
                    if (udp_port == 0 && udp_probe_enabled) {
                        udp_port = tcp_port;
                    }
                    boolean bl = prefer_udp_overall = this.prefer_udp || prefer_udp_default;
                    if (prefer_udp_overall && udp_port == 0) {
                        byte[] address = item.getIP().getBytes();
                        BloomFilter bloom = this.prefer_udp_bloom;
                        if (bloom != null && bloom.contains(address)) {
                            udp_port = tcp_port;
                        }
                    }
                    boolean tcp_ok = TCPNetworkManager.TCP_OUTGOING_ENABLED && tcp_port > 0 && tcp_remaining > 0;
                    boolean bl2 = udp_ok = UDPNetworkManager.UDP_OUTGOING_ENABLED && udp_port > 0 && udp_remaining > 0;
                    if (!(!tcp_ok || prefer_udp_overall && udp_ok)) {
                        if (this.makeNewOutgoingConnection(source, item.getAddressString(), tcp_port, udp_port, true, use_crypto, item.getCryptoLevel(), null) != null) continue;
                        --tcp_remaining;
                        ++num_waiting_establishments;
                        --remaining;
                        continue;
                    }
                    if (!udp_ok || this.makeNewOutgoingConnection(source, item.getAddressString(), tcp_port, udp_port, false, use_crypto, item.getCryptoLevel(), null) != null) continue;
                    --udp_remaining;
                    ++num_waiting_establishments;
                    --remaining;
                }
                if (UDPNetworkManager.UDP_OUTGOING_ENABLED && remaining > 0 && udp_remaining > 0 && udp_connections < 16) {
                    this.doUDPConnectionChecks(remaining);
                }
            }
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_FIVE_SECOND_INTERVAL == 0L) {
            peer_transports = this.peer_transports_cow;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(i);
                if (transport.doTimeoutChecks()) continue;
                transport.doKeepAliveCheck();
                transport.doPerformanceTuningCheck();
            }
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_TEN_SECOND_INTERVAL == 0L && (last_update = ip_filter.getLastUpdateTime()) != this.ip_filter_last_update_time) {
            this.ip_filter_last_update_time = last_update;
            this.checkForBannedConnections();
        }
        if (this.mainloop_loop_count % (long)MAINLOOP_THIRTY_SECOND_INTERVAL == 0L) {
            this.optimisticDisconnectCount = 0;
            if (this.getMaxNewConnectionsAllowed() == 0) {
                this.doOptimisticDisconnect(false, false);
            }
        }
        float percentage = ((float)(this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL) + 1.0f) / (1.0f * (float)MAINLOOP_SIXTY_SECOND_INTERVAL);
        if (this.mainloop_loop_count % (long)MAINLOOP_SIXTY_SECOND_INTERVAL == 0L) {
            goal = 0;
            this.sweepList = this.peer_transports_cow;
        } else {
            goal = (int)Math.floor(percentage * (float)this.sweepList.size());
        }
        for (int i = this.nextPEXSweepIndex; i < goal && i < this.sweepList.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)this.sweepList.get(i);
            peer.updatePeerExchange();
        }
        this.nextPEXSweepIndex = goal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doUDPConnectionChecks(int number) {
        ArrayList<PEPeerTransport> new_connections = null;
        try {
            this.peer_transports_mon.enter();
            long now = SystemTime.getCurrentTime();
            if (this.udp_reconnects.size() > 0 && now - this.last_udp_reconnect >= 10000L) {
                this.last_udp_reconnect = now;
                Iterator<PEPeerTransport> it = this.udp_reconnects.values().iterator();
                PEPeerTransport peer = it.next();
                it.remove();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)this, LOGID, 0, "Reconnecting to previous failed peer " + peer.getPeerItemIdentity().getAddressString()));
                }
                if (new_connections == null) {
                    new_connections = new ArrayList<PEPeerTransport>();
                }
                new_connections.add(peer);
                if (--number <= 0) {
                    Object var12_8 = null;
                    this.peer_transports_mon.exit();
                    if (new_connections == null) return;
                    for (int i = 0; i < new_connections.size(); ++i) {
                        PEPeerTransport peer_item = (PEPeerTransport)new_connections.get(i);
                        peer_item.reconnect(true, false);
                    }
                    return;
                }
            }
            if (this.pending_nat_traversals.size() == 0) {
                Object var12_9 = null;
                this.peer_transports_mon.exit();
                if (new_connections == null) return;
                for (int i = 0; i < new_connections.size(); ++i) {
                    PEPeerTransport peer_item = (PEPeerTransport)new_connections.get(i);
                    peer_item.reconnect(true, false);
                }
                return;
            }
            int max = 3;
            if (this.seeding_mode) {
                max = this._peers > 8 ? 0 : 1;
            } else if (this._seeds > 8) {
                max = 0;
            } else if (this._seeds > 4) {
                max = 1;
            }
            int avail = max - this.udp_traversal_count;
            int to_do = Math.min(number, avail);
            Iterator<PEPeerTransport> it = this.pending_nat_traversals.values().iterator();
            while (to_do > 0 && it.hasNext()) {
                final PEPeerTransport peer = it.next();
                it.remove();
                String peer_ip = peer.getPeerItemIdentity().getAddressString();
                if (AENetworkClassifier.categoriseAddress(peer_ip) != "Public") continue;
                --to_do;
                PeerNATTraverser.getSingleton().create(this, new InetSocketAddress(peer_ip, peer.getPeerItemIdentity().getUDPPort()), new PeerNATTraversalAdapter(){
                    private boolean done;

                    public void success(InetSocketAddress target) {
                        this.complete();
                        PEPeerTransport newTransport = peer.reconnect(true, false);
                        if (newTransport != null) {
                            newTransport.setData(PEER_NAT_TRAVERSE_DONE_KEY, "");
                        }
                    }

                    public void failed() {
                        this.complete();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void complete() {
                        try {
                            PEPeerControlImpl.this.peer_transports_mon.enter();
                            if (!this.done) {
                                this.done = true;
                                PEPeerControlImpl.this.udp_traversal_count--;
                            }
                            Object var2_1 = null;
                            PEPeerControlImpl.this.peer_transports_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            PEPeerControlImpl.this.peer_transports_mon.exit();
                            throw throwable;
                        }
                    }
                });
                ++this.udp_traversal_count;
            }
            Object var12_10 = null;
            this.peer_transports_mon.exit();
            if (new_connections == null) return;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            this.peer_transports_mon.exit();
            if (new_connections == null) throw throwable;
            for (int i = 0; i < new_connections.size(); ++i) {
                PEPeerTransport peer_item = (PEPeerTransport)new_connections.get(i);
                peer_item.reconnect(true, false);
            }
            throw throwable;
        }
        for (int i = 0; i < new_connections.size(); ++i) {
            PEPeerTransport peer_item = (PEPeerTransport)new_connections.get(i);
            peer_item.reconnect(true, false);
        }
        return;
    }

    @Override
    public boolean doOptimisticDisconnect(boolean pending_lan_local_peer, boolean force) {
        long medianConnectionTime;
        ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
        PEPeerTransport max_transport = null;
        PEPeerTransport max_seed_transport = null;
        PEPeerTransport max_non_lan_transport = null;
        long max_time = 0L;
        long max_seed_time = 0L;
        long max_non_lan_time = 0L;
        ArrayList<Long> activeConnectionTimes = new ArrayList<Long>(peer_transports.size());
        int lan_peer_count = 0;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            if (peer.getConnectionState() != 4) continue;
            long timeSinceConnection = peer.getTimeSinceConnectionEstablished();
            long timeSinceSentData = peer.getTimeSinceLastDataMessageSent();
            activeConnectionTimes.add(timeSinceConnection);
            long peerTestTime = 0L;
            if (this.seeding_mode) {
                if (timeSinceSentData != -1L) {
                    peerTestTime = timeSinceSentData;
                }
            } else {
                long timeSinceGoodData = peer.getTimeSinceGoodDataReceived();
                peerTestTime = timeSinceGoodData == -1L ? (peerTestTime += timeSinceConnection) : (peerTestTime += timeSinceGoodData);
                if (!peer.isInteresting()) {
                    peerTestTime = !peer.isInterested() ? (peerTestTime += timeSinceConnection + timeSinceSentData) : (peerTestTime += timeSinceConnection - timeSinceSentData);
                    peerTestTime *= 2L;
                }
                peerTestTime += peer.getSnubbedTime();
            }
            if (!peer.isIncoming()) {
                peerTestTime *= 2L;
            }
            if (peer.isLANLocal()) {
                ++lan_peer_count;
            } else if (peerTestTime > max_non_lan_time) {
                max_non_lan_time = peerTestTime;
                max_non_lan_transport = peer;
            }
            if (!this.seeding_mode) {
                PEPeerStats pestats;
                peerTestTime += peer.getSnubbedTime();
                if (peer.getSnubbedTime() > 120L) {
                    peerTestTime = (long)((double)peerTestTime * 1.5);
                }
                if ((pestats = peer.getStats()).getTotalDataBytesReceived() + pestats.getTotalDataBytesSent() > 524288L) {
                    boolean goodPeer = true;
                    if (peer.isSnubbed() && pestats.getTotalDataBytesReceived() < pestats.getTotalDataBytesSent()) {
                        peerTestTime = (long)((double)peerTestTime * 1.5);
                        goodPeer = false;
                    }
                    if (pestats.getTotalDataBytesSent() > pestats.getTotalDataBytesReceived() * 10L) {
                        peerTestTime *= 2L;
                        goodPeer = false;
                    }
                    if (pestats.getTotalDataBytesReceived() > 0L && pestats.getTotalBytesDiscarded() > 0L) {
                        peerTestTime = (long)((double)peerTestTime * (1.0 + (double)pestats.getTotalBytesDiscarded() / (double)pestats.getTotalDataBytesReceived()));
                    }
                    if (goodPeer) {
                        peerTestTime = (long)((double)peerTestTime * 0.7);
                    }
                }
            }
            if (peerTestTime > max_time) {
                max_time = peerTestTime;
                max_transport = peer;
            }
            if (!peer.isSeed() && !peer.isRelativeSeed() || peerTestTime <= max_seed_time) continue;
            max_seed_time = peerTestTime;
            max_seed_transport = peer;
        }
        if (activeConnectionTimes.size() > 0) {
            Collections.sort(activeConnectionTimes);
            medianConnectionTime = (Long)activeConnectionTimes.get(activeConnectionTimes.size() / 2);
        } else {
            medianConnectionTime = 0L;
        }
        int maxOptimistics = Math.max(this.getMaxConnections() / 30, 2);
        if (!pending_lan_local_peer && !force && this.optimisticDisconnectCount >= maxOptimistics && medianConnectionTime < 300000L) {
            return false;
        }
        if (max_transport != null) {
            int LAN_PEER_MAX = 4;
            if (max_transport.isLANLocal() && lan_peer_count < 4 && max_non_lan_transport != null) {
                max_transport = max_non_lan_transport;
                max_time = max_non_lan_time;
            }
            if (this.getMaxSeedConnections() > 0 && max_seed_transport != null && max_time > 300000L) {
                this.closeAndRemovePeer(max_seed_transport, "timed out by doOptimisticDisconnect()", true);
                ++this.optimisticDisconnectCount;
                return true;
            }
            if (max_transport != null && max_time > 300000L) {
                this.closeAndRemovePeer(max_transport, "timed out by doOptimisticDisconnect()", true);
                ++this.optimisticDisconnectCount;
                return true;
            }
            if (pending_lan_local_peer && lan_peer_count < 4) {
                this.closeAndRemovePeer(max_transport, "making space for LAN peer in doOptimisticDisconnect()", true);
                ++this.optimisticDisconnectCount;
                return true;
            }
            if (force) {
                this.closeAndRemovePeer(max_transport, "force removal of worst peer in doOptimisticDisconnect()", true);
                return true;
            }
        } else if (force && peer_transports.size() > 0) {
            PEPeerTransport pt = (PEPeerTransport)peer_transports.get(new Random().nextInt(peer_transports.size()));
            this.closeAndRemovePeer(pt, "force removal of random peer in doOptimisticDisconnect()", true);
            return true;
        }
        return false;
    }

    @Override
    public PeerExchangerItem createPeerExchangeConnection(final PEPeerTransport base_peer) {
        if (base_peer.getTCPListenPort() > 0) {
            PeerItem peer = PeerItemFactory.createPeerItem(base_peer.getIp(), base_peer.getTCPListenPort(), (byte)2, base_peer.getPeerItemIdentity().getHandshakeType(), base_peer.getUDPListenPort(), (byte)1, 0);
            return this.peer_database.registerPeerConnection(peer, new PeerExchangerItem.Helper(){

                public boolean isSeed() {
                    return base_peer.isSeed();
                }
            });
        }
        return null;
    }

    private boolean isAlreadyConnected(PeerItem peer_id) {
        ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)peer_transports.get(i);
            if (!peer.getPeerItemIdentity().equals(peer_id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void peerVerifiedAsSelf(PEPeerTransport self) {
        if (self.getTCPListenPort() > 0) {
            PeerItem peer = PeerItemFactory.createPeerItem(self.getIp(), self.getTCPListenPort(), PeerItem.convertSourceID(self.getPeerSource()), self.getPeerItemIdentity().getHandshakeType(), self.getUDPListenPort(), (byte)2, 0);
            this.peer_database.setSelfPeer(peer);
        }
    }

    @Override
    public void IPFilterEnabledChanged(boolean is_enabled) {
        if (is_enabled) {
            this.checkForBannedConnections();
        }
    }

    @Override
    public boolean canIPBeBanned(String ip) {
        return true;
    }

    @Override
    public boolean canIPBeBlocked(String ip, byte[] torrent_hash) {
        return true;
    }

    @Override
    public void IPBlockedListChanged(IpFilter filter2) {
        Iterator<PEPeer> it = this.peer_transports_cow.iterator();
        String name = this.getDisplayName();
        byte[] hash = this.getTorrentHash();
        while (it.hasNext()) {
            try {
                PEPeerTransport peer = (PEPeerTransport)it.next();
                if (!filter2.isInRange(peer.getIp(), name, hash)) continue;
                peer.closeConnection("IP address blocked by filters");
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void IPBanned(BannedIp ip) {
        for (int i = 0; i < this._nbPieces; ++i) {
            if (this.pePieces[i] == null) continue;
            this.pePieces[i].reDownloadBlocks(ip.getIp());
        }
    }

    @Override
    public long getHiddenBytes() {
        if (this.hidden_piece < 0) {
            return 0L;
        }
        return this.dm_pieces[this.hidden_piece].getLength();
    }

    @Override
    public int getHiddenPiece() {
        return this.hidden_piece;
    }

    @Override
    public int getUploadPriority() {
        return this.adapter.getUploadPriority();
    }

    @Override
    public int getAverageCompletionInThousandNotation() {
        ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
        if (peer_transports != null) {
            long total = this.disk_mgr.getTotalLength();
            int my_completion = total == 0L ? 1000 : (int)(1000L * (total - this.disk_mgr.getRemainingExcludingDND()) / total);
            int sum = my_completion == 1000 ? 0 : my_completion;
            int num = my_completion == 1000 ? 0 : 1;
            for (int i = 0; i < peer_transports.size(); ++i) {
                PEPeer peer = peer_transports.get(i);
                if (peer.getPeerState() != 30 || peer.isSeed()) continue;
                ++num;
                sum += peer.getPercentDoneInThousandNotation();
            }
            return num > 0 ? sum / num : 0;
        }
        return -1;
    }

    @Override
    public int getMaxConnections() {
        return this.adapter.getMaxConnections();
    }

    public int getMaxSeedConnections() {
        return this.adapter.getMaxSeedConnections();
    }

    @Override
    public int getMaxNewConnectionsAllowed() {
        int dl_max = this.getMaxConnections();
        int allowed_peers = PeerUtils.numNewConnectionsAllowed(this.getPeerIdentityDataID(), dl_max);
        return allowed_peers;
    }

    @Override
    public int getSchedulePriority() {
        return this.isSeeding() ? Integer.MAX_VALUE : this.adapter.getPosition();
    }

    @Override
    public boolean hasPotentialConnections() {
        return this.pending_nat_traversals.size() + this.peer_database.getDiscoveredPeerCount() > 0;
    }

    @Override
    public String getRelationText() {
        return this.adapter.getLogRelation().getRelationText();
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return this.adapter.getLogRelation().getQueryableInterfaces();
    }

    @Override
    public PEPeerTransport getTransportFromIdentity(byte[] peer_id) {
        ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
            if (!Arrays.equals(peer_id, conn.getId())) continue;
            return conn;
        }
        return null;
    }

    @Override
    public PEPeerTransport getTransportFromAddress(String peer) {
        ArrayList<PEPeer> peer_transports = this.peer_transports_cow;
        for (int i = 0; i < peer_transports.size(); ++i) {
            PEPeerTransport pt = (PEPeerTransport)peer_transports.get(i);
            if (!peer.equals(pt.getIp())) continue;
            return pt;
        }
        return null;
    }

    @Override
    public void incNbPeersSnubbed() {
        ++this.nbPeersSnubbed;
    }

    @Override
    public void decNbPeersSnubbed() {
        --this.nbPeersSnubbed;
    }

    @Override
    public void setNbPeersSnubbed(int n) {
        this.nbPeersSnubbed = n;
    }

    @Override
    public int getNbPeersSnubbed() {
        return this.nbPeersSnubbed;
    }

    @Override
    public boolean getPreferUDP() {
        return this.prefer_udp;
    }

    @Override
    public void setPreferUDP(boolean prefer) {
        this.prefer_udp = prefer;
    }

    @Override
    public boolean isPeerSourceEnabled(String peer_source) {
        return this.adapter.isPeerSourceEnabled(peer_source);
    }

    @Override
    public boolean isNetworkEnabled(String net) {
        return this.adapter.isNetworkEnabled(net);
    }

    @Override
    public void peerDiscovered(PEPeerTransport finder, PeerItem pi) {
        ArrayList<PEPeerManagerListener> peer_manager_listeners = this.peer_manager_listeners_cow;
        for (int i = 0; i < peer_manager_listeners.size(); ++i) {
            try {
                peer_manager_listeners.get(i).peerDiscovered(this, pi, finder);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public TrackerPeerSource getTrackerPeerSource() {
        return new TrackerPeerSourceAdapter(){

            public int getType() {
                return 5;
            }

            public int getStatus() {
                return PEPeerControlImpl.this.isPeerExchangeEnabled() ? 5 : 1;
            }

            public String getName() {
                return MessageText.getString("tps.pex.details", new String[]{String.valueOf(PEPeerControlImpl.this.peer_transports_cow.size()), String.valueOf(PEPeerControlImpl.this.peer_database.getExchangedPeerCount()), String.valueOf(PEPeerControlImpl.this.peer_database.getDiscoveredPeerCount())});
            }

            public int getPeers() {
                return PEPeerControlImpl.this.isPeerExchangeEnabled() ? PEPeerControlImpl.this.peer_database.getExchangedPeersUsed() : -1;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void generateEvidence(IndentWriter writer) {
        writer.println("PeerManager: seeding=" + this.seeding_mode);
        writer.println("    udp_fb=" + this.pending_nat_traversals.size() + ",udp_tc=" + this.udp_traversal_count + ",pd=[" + this.peer_database.getString() + "]");
        String pending_udp = "";
        try {
            this.peer_transports_mon.enter();
            for (PEPeerTransport peer : this.pending_nat_traversals.values()) {
                pending_udp = pending_udp + (pending_udp.length() == 0 ? "" : ",") + peer.getPeerItemIdentity().getAddressString() + ":" + peer.getPeerItemIdentity().getUDPPort();
            }
            Object var6_5 = null;
            this.peer_transports_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.peer_transports_mon.exit();
            throw throwable;
        }
        if (pending_udp.length() > 0) {
            writer.println("    pending_udp=" + pending_udp);
        }
        List traversals = PeerNATTraverser.getSingleton().getTraversals(this);
        String active_udp = "";
        for (InetSocketAddress inetSocketAddress : traversals) {
            active_udp = active_udp + (active_udp.length() == 0 ? "" : ",") + AddressUtils.getHostAddress(inetSocketAddress) + ":" + inetSocketAddress.getPort();
        }
        if (active_udp.length() > 0) {
            writer.println("    active_udp=" + active_udp);
        }
        if (!this.seeding_mode) {
            void var6_10;
            int i;
            int num;
            String str;
            writer.println("  Active Pieces");
            boolean bl = false;
            try {
                writer.indent();
                str = "";
                num = 0;
                for (i = 0; i < this.pePieces.length; ++i) {
                    PEPieceImpl piece = this.pePieces[i];
                    if (piece == null) continue;
                    ++var6_10;
                    str = str + (str.length() == 0 ? "" : ",") + "#" + i + " " + this.dm_pieces[i].getString() + ": " + piece.getString();
                    if (++num != 20) continue;
                    writer.println(str);
                    str = "";
                    num = 0;
                }
                if (num > 0) {
                    writer.println(str);
                }
                Object var12_18 = null;
                writer.exdent();
            }
            catch (Throwable throwable) {
                Object var12_19 = null;
                writer.exdent();
                throw throwable;
            }
            if (var6_10 == false) {
                writer.println("  Inactive Pieces (excluding done/skipped)");
                try {
                    writer.indent();
                    str = "";
                    num = 0;
                    for (i = 0; i < this.dm_pieces.length; ++i) {
                        DiskManagerPiece dm_piece = this.dm_pieces[i];
                        if (!dm_piece.isInteresting()) continue;
                        str = str + (str.length() == 0 ? "" : ",") + "#" + i + " " + this.dm_pieces[i].getString();
                        if (++num != 20) continue;
                        writer.println(str);
                        str = "";
                        num = 0;
                    }
                    if (num > 0) {
                        writer.println(str);
                    }
                    Object var14_21 = null;
                    writer.exdent();
                }
                catch (Throwable throwable) {
                    Object var14_22 = null;
                    writer.exdent();
                    throw throwable;
                }
            }
            this.piecePicker.generateEvidence(writer);
        }
        try {
            this.peer_transports_mon.enter();
            writer.println("Peers: total = " + this.peer_transports_cow.size());
            writer.indent();
            try {
                writer.indent();
                for (PEPeerTransport pEPeerTransport : this.peer_transports_cow) {
                    pEPeerTransport.generateEvidence(writer);
                }
                Object var16_24 = null;
                writer.exdent();
            }
            catch (Throwable throwable) {
                Object var16_25 = null;
                writer.exdent();
                throw throwable;
            }
            Object var18_27 = null;
            this.peer_transports_mon.exit();
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var18_28 = null;
            this.peer_transports_mon.exit();
            writer.exdent();
            throw throwable;
        }
        this.disk_mgr.generateEvidence(writer);
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Disconnect Seed", "Seeding Piece Check Recheck Enable", "peercontrol.stalled.piece.write.timeout", "Peer.Fast.Initial.Unchoke.Enabled", "Ip Filter Ban Discard Ratio", "Ip Filter Ban Discard Min KB", "peercontrol.udp.fallback.connect.fail", "peercontrol.udp.fallback.connect.drop", "peercontrol.udp.probe.enable", "peercontrol.hide.piece", "peercontrol.hide.piece.ds", "peercontrol.prefer.udp"}, new ParameterListener(){

            public void parameterChanged(String name) {
                disconnect_seeds_when_seeding = COConfigurationManager.getBooleanParameter("Disconnect Seed");
                enable_seeding_piece_rechecks = COConfigurationManager.getBooleanParameter("Seeding Piece Check Recheck Enable");
                stalled_piece_timeout = COConfigurationManager.getIntParameter("peercontrol.stalled.piece.write.timeout", 60000);
                fast_unchoke_new_peers = COConfigurationManager.getBooleanParameter("Peer.Fast.Initial.Unchoke.Enabled");
                ban_peer_discard_ratio = COConfigurationManager.getFloatParameter("Ip Filter Ban Discard Ratio");
                ban_peer_discard_min_kb = COConfigurationManager.getIntParameter("Ip Filter Ban Discard Min KB");
                udp_fallback_for_failed_connection = COConfigurationManager.getBooleanParameter("peercontrol.udp.fallback.connect.fail");
                udp_fallback_for_dropped_connection = COConfigurationManager.getBooleanParameter("peercontrol.udp.fallback.connect.drop");
                udp_probe_enabled = COConfigurationManager.getBooleanParameter("peercontrol.udp.probe.enable");
                hide_a_piece = COConfigurationManager.getBooleanParameter("peercontrol.hide.piece");
                boolean hide_a_piece_ds = COConfigurationManager.getBooleanParameter("peercontrol.hide.piece.ds");
                if (hide_a_piece && !hide_a_piece_ds) {
                    disconnect_seeds_when_seeding = false;
                }
                prefer_udp_default = COConfigurationManager.getBooleanParameter("peercontrol.prefer.udp");
            }
        });
        ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
        MAINLOOP_ONE_SECOND_INTERVAL = 1000 / PeerControlScheduler.SCHEDULE_PERIOD_MILLIS;
        MAINLOOP_FIVE_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 5;
        MAINLOOP_TEN_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 10;
        MAINLOOP_TWENTY_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 20;
        MAINLOOP_THIRTY_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 30;
        MAINLOOP_SIXTY_SECOND_INTERVAL = MAINLOOP_ONE_SECOND_INTERVAL * 60;
        MAINLOOP_TEN_MINUTE_INTERVAL = MAINLOOP_SIXTY_SECOND_INTERVAL * 10;
        PEER_NAT_TRAVERSE_DONE_KEY = PEPeerControlImpl.class.getName() + "::nat_trav_done";
        ONE_HOUNDRED = new BigDecimal(100);
    }
}

