/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.util;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import ghostfucker.spoof.PerfectSpoof;
import ghostfucker.spoof.client.PSClient;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.CRC32C;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.utils.LocationProvider;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class PeerUtils {
    private static final PSClient psClient = PerfectSpoof.getClient();
    private static final String CONFIG_MAX_CONN_PER_TORRENT = "Max.Peer.Connections.Per.Torrent";
    private static final String CONFIG_MAX_CONN_TOTAL = "Max.Peer.Connections.Total";
    public static int MAX_CONNECTIONS_PER_TORRENT;
    public static int MAX_CONNECTIONS_TOTAL;
    private static final NetworkAdmin network_admin;
    private static volatile long na_last_ip4_time;
    private static volatile long na_last_ip6_time;
    private static volatile byte[] na_last_ip4;
    private static volatile byte[] na_last_ip6;
    private static int na_tcp_port;
    private static Set<Integer> ignore_peer_ports;
    static final String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static volatile LocationProvider country_provider;
    private static long country_provider_last_check;
    private static Object country_key;

    public static int getPeerPriority(String address, int port) {
        if (network_admin == null) {
            return 0;
        }
        try {
            InetAddress ia = HostNameToIPResolver.syncResolve(address);
            if (ia != null) {
                return PeerUtils.getPeerPriority(ia, port);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    public static int getPeerPriority(InetAddress address, int peer_port) {
        return PeerUtils.getPeerPriority(address.getAddress(), peer_port);
    }

    public static int getPeerPriority(byte[] peer_address, short peer_port) {
        return PeerUtils.getPeerPriority(peer_address, peer_port & 0xFFFF);
    }

    public static int getPeerPriority(byte[] peer_address, int peer_port) {
        if (network_admin == null) {
            return 0;
        }
        if (peer_address == null) {
            return 0;
        }
        byte[] my_address = null;
        long now = SystemTime.getMonotonousTime();
        if (peer_address.length == 4) {
            if (na_last_ip4 != null && now - na_last_ip4_time < 120000L) {
                my_address = na_last_ip4;
            } else if (na_last_ip4_time == 0L || now - na_last_ip4_time > 10000L) {
                byte[] iab;
                na_last_ip4_time = now;
                InetAddress ia = network_admin.getDefaultPublicAddress(true);
                if (ia != null && (iab = ia.getAddress()) != null) {
                    na_last_ip4 = my_address = ia.getAddress();
                }
            }
            if (my_address == null) {
                my_address = na_last_ip4;
            }
        } else if (peer_address.length == 16) {
            if (na_last_ip6 != null && now - na_last_ip6_time < 120000L) {
                my_address = na_last_ip6;
            } else if (na_last_ip6_time == 0L || now - na_last_ip6_time > 10000L) {
                byte[] iab;
                na_last_ip6_time = now;
                InetAddress ia = network_admin.getDefaultPublicAddressV6(true);
                if (ia != null && (iab = ia.getAddress()) != null) {
                    my_address = ia.getAddress();
                    na_last_ip6 = my_address;
                }
            }
            if (my_address == null) {
                my_address = na_last_ip6;
            }
        } else {
            return 0;
        }
        if (my_address != null && my_address.length == peer_address.length) {
            return PeerUtils.getPeerPriority(my_address, na_tcp_port, peer_address, peer_port);
        }
        return 0;
    }

    private static int getPeerPriority(byte[] a1, int port1, byte[] a2, int port2) {
        byte[] a1_masked = new byte[a1.length];
        byte[] a2_masked = new byte[a2.length];
        int x = a1_masked.length == 4 ? 1 : 5;
        boolean same = true;
        int order = 0;
        for (int i = 0; i < a1_masked.length; ++i) {
            byte a1_byte = a1[i];
            byte a2_byte = a2[i];
            if (i < x || same) {
                a1_masked[i] = a1_byte;
                a2_masked[i] = a2_byte;
            } else {
                a1_masked[i] = (byte)(a1_byte & 0x55);
                a2_masked[i] = (byte)(a2_byte & 0x55);
            }
            if (i >= x && same) {
                boolean bl = same = a1_byte == a2_byte;
            }
            if (order != 0) continue;
            order = (a1_masked[i] & 0xFF) - (a2_masked[i] & 0xFF);
        }
        if (same) {
            a1_masked = new byte[]{(byte)(port1 >> 8), (byte)port1};
            a2_masked = new byte[]{(byte)(port2 >> 8), (byte)port2};
            order = port1 - port2;
        }
        CRC32C crc32 = new CRC32C();
        if (order < 0) {
            crc32.updateWord(a1_masked, true);
            crc32.updateWord(a2_masked, true);
        } else {
            crc32.updateWord(a2_masked, true);
            crc32.updateWord(a1_masked, true);
        }
        long res = crc32.getValue();
        return (int)res;
    }

    public static int numNewConnectionsAllowed(PeerIdentityDataID data_id, int specific_max) {
        int allowed;
        int curConnPerTorrent = PeerIdentityManager.getIdentityCount(data_id);
        int curConnTotal = PeerIdentityManager.getTotalIdentityCount();
        int PER_TORRENT_LIMIT = specific_max;
        int perTorrentAllowed = -1;
        if (PER_TORRENT_LIMIT != 0) {
            int allowed2 = PER_TORRENT_LIMIT - curConnPerTorrent;
            if (allowed2 < 0) {
                allowed2 = 0;
            }
            perTorrentAllowed = allowed2;
        }
        int totalAllowed = -1;
        if (MAX_CONNECTIONS_TOTAL != 0) {
            allowed = MAX_CONNECTIONS_TOTAL - curConnTotal;
            if (allowed < 0) {
                allowed = 0;
            }
            totalAllowed = allowed;
        }
        allowed = -1;
        if (perTorrentAllowed > -1 && totalAllowed > -1) {
            allowed = Math.min(perTorrentAllowed, totalAllowed);
        } else if (perTorrentAllowed == -1 || totalAllowed == -1) {
            allowed = Math.max(perTorrentAllowed, totalAllowed);
        }
        return allowed;
    }

    private static void readIgnorePeerPorts() {
        String[] ports;
        String str = COConfigurationManager.getStringParameter("Ignore.peer.ports").trim();
        ignore_peer_ports.clear();
        if (str.length() > 0 && (ports = str.split("\\;")) != null && ports.length > 0) {
            for (int i = 0; i < ports.length; ++i) {
                String port = ports[i];
                int spreadPos = port.indexOf(45);
                if (spreadPos > 0 && spreadPos < port.length() - 1) {
                    try {
                        int iMin = Integer.parseInt(port.substring(0, spreadPos).trim());
                        int iMax = Integer.parseInt(port.substring(spreadPos + 1).trim());
                        iMin = Math.max(0, iMin);
                        iMax = Math.min(65535, iMax);
                        for (int j = iMin; j <= iMax; ++j) {
                            ignore_peer_ports.add(j);
                        }
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.out("Invalid ignore-port entry: " + port);
                        continue;
                    }
                }
                try {
                    ignore_peer_ports.add(Integer.parseInt(port.trim()));
                    continue;
                }
                catch (Throwable e) {
                    Debug.out("Invalid ignore-port entry: " + port);
                }
            }
        }
    }

    public static boolean ignorePeerPort(int port) {
        return ignore_peer_ports.contains(port);
    }

    public static byte[] createPeerID() {
        if (!PerfectSpoof.isActive) {
            int i;
            byte[] peerId = new byte[20];
            byte[] version = Constants.VERSION_ID;
            for (i = 0; i < 8; ++i) {
                peerId[i] = version[i];
            }
            for (i = 8; i < 20; ++i) {
                int pos = (int)(Math.random() * (double)chars.length());
                peerId[i] = (byte)chars.charAt(pos);
            }
            return peerId;
        }
        return psClient.getPeerId();
    }

    public static byte[] createWebSeedPeerID() {
        if (!PerfectSpoof.isActive) {
            byte[] peerId = new byte[20];
            peerId[0] = 45;
            peerId[1] = 87;
            peerId[2] = 83;
            for (int i = 3; i < 20; ++i) {
                int pos = (int)(Math.random() * (double)chars.length());
                peerId[i] = (byte)chars.charAt(pos);
            }
            return peerId;
        }
        return psClient.getPeerId();
    }

    private static LocationProvider getCountryProvider() {
        if (country_provider != null && country_provider.isDestroyed()) {
            country_provider = null;
            country_provider_last_check = 0L;
        }
        if (country_provider == null) {
            long now = SystemTime.getMonotonousTime();
            if (country_provider_last_check == 0L || now - country_provider_last_check > 20000L) {
                country_provider_last_check = now;
                List<LocationProvider> providers = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getUtilities().getLocationProviders();
                for (LocationProvider provider2 : providers) {
                    if (!provider2.hasCapabilities(3L)) continue;
                    country_provider = provider2;
                }
            }
        }
        return country_provider;
    }

    public static String[] getCountryDetails(Peer peer) {
        return PeerUtils.getCountryDetails(PluginCoreUtils.unwrap(peer));
    }

    public static String[] getCountryDetails(PEPeer peer) {
        LocationProvider lp;
        if (peer == null) {
            return null;
        }
        String[] details = (String[])peer.getUserData(country_key);
        if (details == null && (lp = PeerUtils.getCountryProvider()) != null) {
            try {
                String ip = peer.getIp();
                if (HostNameToIPResolver.isDNSName(ip)) {
                    InetAddress peer_address = HostNameToIPResolver.syncResolve(ip);
                    String code = lp.getISO3166CodeForIP(peer_address);
                    String name = lp.getCountryNameForIP(peer_address, Locale.getDefault());
                    details = code != null && name != null ? new String[]{code, name} : new String[]{};
                } else {
                    String cat = AENetworkClassifier.categoriseAddress(ip);
                    details = cat != "Public" ? new String[]{cat, cat} : new String[]{};
                }
                peer.setUserData(country_key, details);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return details;
    }

    static {
        COConfigurationManager.addParameterListener(CONFIG_MAX_CONN_PER_TORRENT, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MAX_CONNECTIONS_PER_TORRENT = COConfigurationManager.getIntParameter(PeerUtils.CONFIG_MAX_CONN_PER_TORRENT);
            }
        });
        MAX_CONNECTIONS_PER_TORRENT = COConfigurationManager.getIntParameter(CONFIG_MAX_CONN_PER_TORRENT);
        COConfigurationManager.addParameterListener(CONFIG_MAX_CONN_TOTAL, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MAX_CONNECTIONS_TOTAL = COConfigurationManager.getIntParameter(PeerUtils.CONFIG_MAX_CONN_TOTAL);
            }
        });
        MAX_CONNECTIONS_TOTAL = COConfigurationManager.getIntParameter(CONFIG_MAX_CONN_TOTAL);
        NetworkAdmin temp = null;
        try {
            temp = NetworkAdmin.getSingleton();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        network_admin = temp;
        COConfigurationManager.addAndFireParameterListener("TCP.Listen.Port", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                na_tcp_port = COConfigurationManager.getIntParameter(parameterName);
            }
        });
        ignore_peer_ports = new HashSet<Integer>();
        COConfigurationManager.addParameterListener("Ignore.peer.ports", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                PeerUtils.readIgnorePeerPorts();
            }
        });
        PeerUtils.readIgnorePeerPorts();
        country_key = new Object();
    }
}

