/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.security.impl;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.Permission;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SECertificateListener;
import org.gudy.azureus2.core3.security.SEKeyDetails;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.impl.SESecurityManagerBC;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.RandomUtils;

public class SESecurityManagerImpl {
    private static final LogIDs LOGID = LogIDs.NET;
    protected static SESecurityManagerImpl singleton = new SESecurityManagerImpl();
    protected static String KEYSTORE_TYPE;
    private static boolean auto_install_certs;
    protected String keystore_name;
    protected String truststore_name;
    protected List certificate_listeners = new ArrayList();
    protected CopyOnWriteList password_listeners = new CopyOnWriteList();
    private static ThreadLocal tls;
    protected Map password_handlers = new HashMap();
    protected Map certificate_handlers = new HashMap();
    protected boolean exit_vm_permitted = false;
    private AzureusSecurityManager my_sec_man;
    protected AEMonitor this_mon = new AEMonitor("SESecurityManager");
    private boolean initialized = false;
    private List stoppable_threads = new ArrayList();

    public static SESecurityManagerImpl getSingleton() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() {
        SESecurityManagerImpl sESecurityManagerImpl = this;
        synchronized (sESecurityManagerImpl) {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
        }
        this.keystore_name = FileUtil.getUserFile(".keystore").getAbsolutePath();
        this.truststore_name = FileUtil.getUserFile(".certs").getAbsolutePath();
        System.setProperty("javax.net.ssl.trustStore", this.truststore_name);
        System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
        this.installAuthenticator();
        String[] providers = new String[]{"com.sun.net.ssl.internal.ssl.Provider", "org.metastatic.jessie.provider.Jessie", "org.bouncycastle.jce.provider.BouncyCastleProvider"};
        String provider2 = null;
        for (int i = 0; i < providers.length; ++i) {
            try {
                Class.forName(providers[i]).newInstance();
                provider2 = providers[i];
                break;
            }
            catch (Throwable e) {
                continue;
            }
        }
        if (provider2 == null) {
            Debug.out("No SSL provider available");
        }
        try {
            SESecurityManagerBC.initialise();
        }
        catch (Throwable e) {
            Debug.out(e);
            Logger.log(new LogEvent(LOGID, 3, "Bouncy Castle not available"));
        }
        this.installSecurityManager();
        this.ensureStoreExists(this.keystore_name);
        this.ensureStoreExists(this.truststore_name);
        this.initEmptyTrustStore();
    }

    private void initEmptyTrustStore() {
        try {
            File cacerts;
            File target = new File(this.truststore_name);
            if (target.exists() && target.length() > 2048L) {
                return;
            }
            KeyStore keystore = this.getTrustStore();
            if (keystore.size() == 0 && (cacerts = new File(new File(new File(System.getProperty("java.home"), "lib"), "security"), "cacerts")).exists()) {
                FileUtil.copyFile(cacerts, target);
                try {
                    this.getTrustStore();
                }
                catch (Throwable e) {
                    target.delete();
                    this.ensureStoreExists(this.truststore_name);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean resetTrustStore(boolean test_only) {
        File cacerts = new File(new File(new File(System.getProperty("java.home"), "lib"), "security"), "cacerts");
        if (!cacerts.exists()) {
            return false;
        }
        if (test_only) {
            return true;
        }
        File target = new File(this.truststore_name);
        if (target.exists() && !target.delete()) {
            Debug.out("Failed to delete " + target);
            return false;
        }
        if (!FileUtil.copyFile(cacerts, target)) {
            Debug.out("Failed to copy file from " + cacerts + " to " + target);
            return false;
        }
        try {
            this.getTrustStore();
        }
        catch (Throwable e) {
            Debug.out(e);
            target.delete();
            this.ensureStoreExists(this.truststore_name);
            return false;
        }
        return true;
    }

    public String getKeystoreName() {
        return this.keystore_name;
    }

    public String getKeystorePassword() {
        return "changeit";
    }

    protected void installSecurityManager() {
        if (!Constants.isAndroid) {
            String prop = System.getProperty("azureus.security.manager.install", "1");
            if (prop.equals("0")) {
                Debug.outNoStack("Not installing security manager - disabled by system property");
                return;
            }
            try {
                SecurityManager old_sec_man = System.getSecurityManager();
                this.my_sec_man = new AzureusSecurityManager(old_sec_man);
                System.setSecurityManager(this.my_sec_man);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread(Thread t) {
        List list;
        List list2 = this.stoppable_threads;
        synchronized (list2) {
            this.stoppable_threads.add(Thread.currentThread());
        }
        try {
            t.stop();
            Object var5_4 = null;
            list = this.stoppable_threads;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            List list3 = this.stoppable_threads;
            synchronized (list3) {
                this.stoppable_threads.remove(Thread.currentThread());
            }
            throw throwable;
        }
        synchronized (list) {
            this.stoppable_threads.remove(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitVM(int status) {
        try {
            this.exit_vm_permitted = true;
            try {
                System.exit(status);
            }
            catch (Throwable throwable) {
            }
            Object var4_3 = null;
            this.exit_vm_permitted = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.exit_vm_permitted = false;
            throw throwable;
        }
    }

    public void installAuthenticator() {
        Authenticator.setDefault(new Authenticator(){
            protected AEMonitor auth_mon = new AEMonitor("SESecurityManager:auth");

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected PasswordAuthentication getPasswordAuthentication() {
                try {
                    PasswordAuthentication res;
                    this.auth_mon.enter();
                    PasswordAuthentication passwordAuthentication = res = SESecurityManagerImpl.this.getAuthentication(this.getRequestingPrompt(), this.getRequestingProtocol(), this.getRequestingHost(), this.getRequestingPort());
                    Object var4_3 = null;
                    this.auth_mon.exit();
                    return passwordAuthentication;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.auth_mon.exit();
                    throw throwable;
                }
            }
        });
    }

    public PasswordAuthentication getAuthentication(String realm, String protocol, String host, int port) {
        if (protocol.toLowerCase().startsWith("socks")) {
            String socks_user = COConfigurationManager.getStringParameter("Proxy.Username").trim();
            String socks_pw = COConfigurationManager.getStringParameter("Proxy.Password").trim();
            if (socks_user.equalsIgnoreCase("<none>")) {
                return new PasswordAuthentication("", "".toCharArray());
            }
            if (socks_user.length() == 0) {
                Logger.log(new LogAlert(false, 1, "Socks server is requesting authentication, please setup user and password in config"));
            }
            return new PasswordAuthentication(socks_user, socks_pw.toCharArray());
        }
        try {
            URL tracker_url = new URL(protocol + "://" + host + ":" + port + "/");
            return this.getPasswordAuthentication(realm, tracker_url);
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected boolean checkKeyStoreHasEntry() {
        File f = new File(this.keystore_name);
        if (!f.exists()) {
            Logger.logTextResource(new LogAlert(false, 3, "Security.keystore.empty"), new String[]{this.keystore_name});
            return false;
        }
        try {
            KeyStore key_store = this.loadKeyStore();
            Enumeration<String> enumx = key_store.aliases();
            if (!enumx.hasMoreElements()) {
                Logger.logTextResource(new LogAlert(false, 3, "Security.keystore.empty"), new String[]{this.keystore_name});
                return false;
            }
        }
        catch (Throwable e) {
            Logger.logTextResource(new LogAlert(false, 3, "Security.keystore.corrupt"), new String[]{this.keystore_name});
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean ensureStoreExists(String name) {
        boolean bl;
        try {
            try {
                this.this_mon.enter();
                KeyStore keystore = KeyStore.getInstance(KEYSTORE_TYPE);
                if (!new File(name).exists()) {
                    block8: {
                        keystore.load(null, null);
                        FileOutputStream out = null;
                        try {
                            out = new FileOutputStream(name);
                            keystore.store(out, "changeit".toCharArray());
                            Object var5_7 = null;
                            if (out == null) break block8;
                        }
                        catch (Throwable throwable) {
                            Object var5_8 = null;
                            if (out == null) throw throwable;
                            out.close();
                            throw throwable;
                        }
                        out.close();
                    }
                    boolean bl2 = true;
                    Object var7_11 = null;
                    this.this_mon.exit();
                    return bl2;
                }
                bl = false;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                boolean bl3 = false;
                Object var7_13 = null;
                this.this_mon.exit();
                return bl3;
            }
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            this.this_mon.exit();
            throw throwable;
        }
        Object var7_12 = null;
        this.this_mon.exit();
        return bl;
    }

    public KeyStore getKeyStore() throws Exception {
        return this.loadKeyStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KeyStore getTrustStore() throws Exception {
        KeyStore keystore = KeyStore.getInstance(KEYSTORE_TYPE);
        if (!new File(this.truststore_name).exists()) {
            keystore.load(null, null);
            return keystore;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.truststore_name);
            keystore.load(in, "changeit".toCharArray());
            Object var4_3 = null;
            if (in == null) return keystore;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
        return keystore;
    }

    protected KeyStore loadKeyStore() throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        return this.loadKeyStore(keyManagerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected KeyStore loadKeyStore(KeyManagerFactory keyManagerFactory) throws Exception {
        KeyStore key_store;
        block5: {
            key_store = KeyStore.getInstance(KEYSTORE_TYPE);
            if (!new File(this.keystore_name).exists()) {
                key_store.load(null, null);
            } else {
                FileInputStream kis = null;
                try {
                    kis = new FileInputStream(this.keystore_name);
                    key_store.load(kis, "changeit".toCharArray());
                    Object var5_4 = null;
                    if (kis == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (kis != null) {
                        ((InputStream)kis).close();
                    }
                    throw throwable;
                }
                ((InputStream)kis).close();
            }
        }
        keyManagerFactory.init(key_store, "changeit".toCharArray());
        return key_store;
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() throws Exception {
        if (!this.checkKeyStoreHasEntry()) {
            return null;
        }
        SSLContext context2 = SSLContext.getInstance("SSL");
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        this.loadKeyStore(keyManagerFactory);
        context2.init(keyManagerFactory.getKeyManagers(), null, RandomUtils.SECURE_RANDOM);
        SSLServerSocketFactory factory = context2.getServerSocketFactory();
        return factory;
    }

    public SEKeyDetails getKeyDetails(String alias) throws Exception {
        KeyStore key_store = this.loadKeyStore();
        final Key key = key_store.getKey(alias, "changeit".toCharArray());
        if (key == null) {
            return null;
        }
        Certificate[] chain = key_store.getCertificateChain(alias);
        final X509Certificate[] res = new X509Certificate[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            if (!(chain[i] instanceof X509Certificate)) {
                throw new Exception("Certificate chain must be comprised of X509Certificate entries");
            }
            res[i] = (X509Certificate)chain[i];
        }
        return new SEKeyDetails(){

            public Key getKey() {
                return key;
            }

            public X509Certificate[] getCertificateChain() {
                return res;
            }
        };
    }

    public Certificate createSelfSignedCertificate(String alias, String cert_dn, int strength) throws Exception {
        return SESecurityManagerBC.createSelfSignedCertificate(this, alias, cert_dn, strength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrustManagerFactory getTrustManagerFactory() {
        try {
            this.this_mon.enter();
            KeyStore keystore = this.getTrustStore();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keystore);
            TrustManagerFactory trustManagerFactory = tmf;
            Object var5_6 = null;
            this.this_mon.exit();
            return trustManagerFactory;
        }
        catch (Throwable e) {
            try {
                Debug.out(e);
                TrustManagerFactory trustManagerFactory = null;
                Object var5_7 = null;
                this.this_mon.exit();
                return trustManagerFactory;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLSocketFactory getSSLSocketFactory() {
        try {
            SSLSocketFactory factory;
            this.this_mon.enter();
            KeyStore keystore = this.getTrustStore();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keystore);
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, tmf.getTrustManagers(), null);
            SSLSocketFactory sSLSocketFactory = factory = ctx.getSocketFactory();
            Object var7_8 = null;
            this.this_mon.exit();
            return sSLSocketFactory;
        }
        catch (Throwable e) {
            try {
                Debug.printStackTrace(e);
                SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                Object var7_9 = null;
                this.this_mon.exit();
                return sSLSocketFactory;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public SSLSocketFactory installServerCertificates(URL https_url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 12[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public SSLSocketFactory installServerCertificates(String alias, String host, int port) {
        SSLSocketFactory sSLSocketFactory;
        Socket socket;
        block17: {
            try {
                X509Certificate x509_cert;
                Certificate[] serverCerts;
                block15: {
                    SSLSocketFactory sSLSocketFactory2;
                    block16: {
                        this.this_mon.enter();
                        socket = null;
                        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                            public X509Certificate[] getAcceptedIssuers() {
                                return null;
                            }

                            public void checkClientTrusted(X509Certificate[] certs, String authType) {
                            }

                            public void checkServerTrusted(X509Certificate[] certs, String authType) {
                            }
                        }};
                        SSLContext sc = SSLContext.getInstance("SSL");
                        sc.init(null, trustAllCerts, RandomUtils.SECURE_RANDOM);
                        SSLSocketFactory factory = sc.getSocketFactory();
                        socket = (SSLSocket)factory.createSocket(host, port);
                        ((SSLSocket)socket).startHandshake();
                        serverCerts = ((SSLSocket)socket).getSession().getPeerCertificates();
                        if (serverCerts.length != 0) break block15;
                        sSLSocketFactory2 = null;
                        Object var13_12 = null;
                        if (socket == null) break block16;
                        try {
                            socket.close();
                        }
                        catch (Throwable e2) {
                            Debug.printStackTrace(e2);
                        }
                    }
                    Object var16_20 = null;
                    this.this_mon.exit();
                    return sSLSocketFactory2;
                }
                Certificate cert = serverCerts[0];
                if (cert instanceof X509Certificate) {
                    x509_cert = (X509Certificate)cert;
                } else {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    x509_cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
                }
                sSLSocketFactory = this.addCertToTrustStore(alias, x509_cert, false);
                Object var13_13 = null;
                if (socket == null) break block17;
                try {
                    socket.close();
                }
                catch (Throwable e2) {
                    Debug.printStackTrace(e2);
                }
            }
            catch (Throwable throwable) {
                Object var16_23 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        Object var16_21 = null;
        this.this_mon.exit();
        {
            return sSLSocketFactory;
            catch (Throwable e) {
                SSLSocketFactory sSLSocketFactory3;
                block18: {
                    try {
                        Debug.printStackTrace(e);
                        sSLSocketFactory3 = null;
                        Object var13_14 = null;
                        if (socket == null) break block18;
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        if (socket != null) {
                            try {
                                socket.close();
                            }
                            catch (Throwable e2) {
                                Debug.printStackTrace(e2);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        socket.close();
                    }
                    catch (Throwable e2) {
                        Debug.printStackTrace(e2);
                    }
                }
                Object var16_22 = null;
                this.this_mon.exit();
                return sSLSocketFactory3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addCertToKeyStore(String alias, Key public_key, Certificate[] certChain) throws Exception {
        try {
            block8: {
                this.this_mon.enter();
                KeyStore key_store = this.loadKeyStore();
                if (key_store.containsAlias(alias)) {
                    key_store.deleteEntry(alias);
                }
                key_store.setKeyEntry(alias, public_key, "changeit".toCharArray(), certChain);
                FileOutputStream out = null;
                try {
                    try {
                        out = new FileOutputStream(this.keystore_name);
                        key_store.store(out, "changeit".toCharArray());
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        Object var8_7 = null;
                        if (out != null) {
                            out.close();
                        }
                        break block8;
                    }
                    Object var8_6 = null;
                    if (out == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
                out.close();
            }
            Object var10_11 = null;
            this.this_mon.exit();
            return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SSLSocketFactory addCertToTrustStore(String alias, Certificate cert, boolean update_https_factory) throws Exception {
        try {
            KeyStore keystore;
            block7: {
                this.this_mon.enter();
                keystore = this.getTrustStore();
                if (cert != null) {
                    if (keystore.containsAlias(alias)) {
                        keystore.deleteEntry(alias);
                    }
                    keystore.setCertificateEntry(alias, cert);
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(this.truststore_name);
                        keystore.store(out, "changeit".toCharArray());
                        Object var7_6 = null;
                        if (out == null) break block7;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        if (out == null) throw throwable;
                        out.close();
                        throw throwable;
                    }
                    out.close();
                }
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keystore);
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, tmf.getTrustManagers(), null);
            SSLSocketFactory factory = ctx.getSocketFactory();
            if (update_https_factory) {
                HttpsURLConnection.setDefaultSSLSocketFactory(factory);
            }
            SSLSocketFactory sSLSocketFactory = factory;
            Object var10_11 = null;
            this.this_mon.exit();
            return sSLSocketFactory;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public PasswordAuthentication getPasswordAuthentication(String realm, URL tracker) {
        SEPasswordListener thread_listener = (SEPasswordListener)tls.get();
        if (thread_listener != null) {
            return thread_listener.getAuthentication(realm, tracker);
        }
        Object[] handler = (Object[])this.password_handlers.get(tracker.toString());
        if (handler != null) {
            try {
                return ((SEPasswordListener)handler[0]).getAuthentication(realm, (URL)handler[1]);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        Iterator it = this.password_listeners.iterator();
        while (it.hasNext()) {
            try {
                PasswordAuthentication res = ((SEPasswordListener)it.next()).getAuthentication(realm, tracker);
                if (res == null) continue;
                return res;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public void setPasswordAuthenticationOutcome(String realm, URL tracker, boolean success) {
        SEPasswordListener thread_listener = (SEPasswordListener)tls.get();
        if (thread_listener != null) {
            thread_listener.setAuthenticationOutcome(realm, tracker, success);
        }
        Iterator it = this.password_listeners.iterator();
        while (it.hasNext()) {
            ((SEPasswordListener)it.next()).setAuthenticationOutcome(realm, tracker, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPasswordListener(SEPasswordListener l) {
        try {
            this.this_mon.enter();
            this.password_listeners.add(l);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePasswordListener(SEPasswordListener l) {
        try {
            this.this_mon.enter();
            this.password_listeners.remove(l);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void clearPasswords() {
        SEPasswordListener thread_listener = (SEPasswordListener)tls.get();
        if (thread_listener != null) {
            thread_listener.clearPasswords();
        }
        Iterator it = this.password_listeners.iterator();
        while (it.hasNext()) {
            try {
                ((SEPasswordListener)it.next()).clearPasswords();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void setThreadPasswordHandler(SEPasswordListener l) {
        tls.set(l);
    }

    public void unsetThreadPasswordHandler() {
        tls.set(null);
    }

    public void setPasswordHandler(URL url, SEPasswordListener l) {
        String url_s = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + "/";
        if (l == null) {
            this.password_handlers.remove(url_s);
        } else {
            this.password_handlers.put(url_s, new Object[]{l, url});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCertificateListener(SECertificateListener l) {
        try {
            this.this_mon.enter();
            this.certificate_listeners.add(l);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void setCertificateHandler(URL url, SECertificateListener l) {
        String url_s = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + "/";
        if (l == null) {
            this.certificate_handlers.remove(url_s);
        } else {
            this.certificate_handlers.put(url_s, new Object[]{l, url});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCertificateListener(SECertificateListener l) {
        try {
            this.this_mon.enter();
            this.certificate_listeners.remove(l);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public Class[] getClassContext() {
        if (this.my_sec_man == null) {
            return new Class[0];
        }
        return this.my_sec_man.getClassContext();
    }

    public static void main(String[] args) {
        SESecurityManagerImpl man = SESecurityManagerImpl.getSingleton();
        man.initialise();
        try {
            man.createSelfSignedCertificate("SomeAlias", "CN=fred,OU=wap,O=wip,L=here,ST=there,C=GB", 1000);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    static {
        String[] types = new String[]{"JKS", "GKR", "BKS"};
        for (int i = 0; i < types.length; ++i) {
            try {
                KeyStore.getInstance(types[i]);
                KEYSTORE_TYPE = types[i];
                break;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        if (KEYSTORE_TYPE == null) {
            KEYSTORE_TYPE = "JKS";
        }
        Logger.log(new LogEvent(LOGID, "Keystore type is " + KEYSTORE_TYPE));
        COConfigurationManager.addAndFireParameterListener("security.cert.auto.install", new ParameterListener(){

            public void parameterChanged(String parameter_name) {
                auto_install_certs = COConfigurationManager.getBooleanParameter(parameter_name);
            }
        });
        tls = new ThreadLocal(){

            public Object initialValue() {
                return null;
            }
        };
    }

    private final class AzureusSecurityManager
    extends SecurityManager {
        private SecurityManager old_sec_man;

        private AzureusSecurityManager(SecurityManager _old_sec_man) {
            this.old_sec_man = _old_sec_man;
        }

        public void checkAccept(String host, int port) {
        }

        public void checkRead(String file) {
        }

        public void checkWrite(String file) {
        }

        public void checkConnect(String host, int port) {
        }

        public void checkExit(int status) {
            String prop;
            if (this.old_sec_man != null) {
                this.old_sec_man.checkExit(status);
            }
            if (!SESecurityManagerImpl.this.exit_vm_permitted && (prop = System.getProperty("azureus.security.manager.permitexit", "0")).equals("0")) {
                throw new SecurityException("VM exit operation prohibited");
            }
        }

        public void checkPermission(Permission perm) {
            this.checkPermission(perm, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkPermission(Permission perm, Object context2) {
            if (perm instanceof RuntimePermission) {
                String name = perm.getName();
                if (name.equals("stopThread")) {
                    List list = SESecurityManagerImpl.this.stoppable_threads;
                    synchronized (list) {
                        if (SESecurityManagerImpl.this.stoppable_threads.contains(Thread.currentThread())) {
                            return;
                        }
                    }
                    throw new SecurityException("Thread.stop operation prohibited");
                }
                if (name.equals("setSecurityManager")) {
                    throw new SecurityException("Permission Denied");
                }
            }
            if (this.old_sec_man != null) {
                if (context2 == null) {
                    this.old_sec_man.checkPermission(perm);
                } else {
                    this.old_sec_man.checkPermission(perm, context2);
                }
            }
        }

        public Class[] getClassContext() {
            Class<?>[] res = super.getClassContext();
            if (res.length <= 3) {
                return new Class[0];
            }
            Class[] trimmed = new Class[res.length - 3];
            System.arraycopy(res, 3, trimmed, 0, trimmed.length);
            return trimmed;
        }
    }
}

