/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.stats.transfer.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.average.Average;
import com.aelitis.azureus.core.util.average.AverageFactory;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.stats.transfer.LongTermStats;
import org.gudy.azureus2.core3.stats.transfer.LongTermStatsListener;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.stats.transfer.impl.OverallStatsImpl;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;

public class LongTermStatsImpl
implements LongTermStats {
    private static final int VERSION = 1;
    private static final long MIN_IN_MILLIS = 60000L;
    private static final long DAY_IN_MILLIS = 86400000L;
    public static final int RT_SESSION_START = 1;
    public static final int RT_SESSION_STATS = 2;
    public static final int RT_SESSION_END = 3;
    private AzureusCore core;
    private GlobalManagerStats gm_stats;
    private DHT[] dhts;
    private final int STAT_ENTRY_COUNT = 6;
    private long st_p_sent;
    private long st_d_sent;
    private long st_p_received;
    private long st_d_received;
    private long st_dht_sent;
    private long st_dht_received;
    private long ss_p_sent;
    private long ss_d_sent;
    private long ss_p_received;
    private long ss_d_received;
    private long ss_dht_sent;
    private long ss_dht_received;
    private long[] line_stats_prev = new long[6];
    private Average[] stat_averages = new Average[6];
    private boolean active;
    private boolean closing;
    private TimerEventPeriodic event;
    private PrintWriter writer;
    private String writer_rel_file;
    private DayCache day_cache;
    private final int MONTH_CACHE_MAX = 3;
    private Map<String, MonthCache> month_cache_map;
    private static SimpleDateFormat debug_utc_format = new SimpleDateFormat("yyyy,MM,dd:HH:mm");
    private static SimpleDateFormat utc_date_format = new SimpleDateFormat("yyyy,MM,dd");
    private final File stats_dir;
    private long session_total;
    private CopyOnWriteList<Object[]> listeners;
    private AsyncDispatcher dispatcher;
    private int start_of_week;
    private int start_of_month;

    private LongTermStatsImpl(File _stats_dir) {
        for (int i = 0; i < 6; ++i) {
            this.stat_averages[i] = AverageFactory.MovingImmediateAverage(3);
        }
        this.MONTH_CACHE_MAX = 3;
        this.month_cache_map = new LinkedHashMap<String, MonthCache>(3, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, MonthCache> eldest) {
                return this.size() > 3;
            }
        };
        this.listeners = new CopyOnWriteList();
        this.dispatcher = new AsyncDispatcher("lts", 5000);
        this.start_of_week = -1;
        this.start_of_month = -1;
        this.stats_dir = _stats_dir;
    }

    public LongTermStatsImpl(AzureusCore _core, GlobalManagerStats _gm_stats) {
        for (int i = 0; i < 6; ++i) {
            this.stat_averages[i] = AverageFactory.MovingImmediateAverage(3);
        }
        this.MONTH_CACHE_MAX = 3;
        this.month_cache_map = new /* invalid duplicate definition of identical inner class */;
        this.listeners = new CopyOnWriteList();
        this.dispatcher = new AsyncDispatcher("lts", 5000);
        this.start_of_week = -1;
        this.start_of_month = -1;
        this.core = _core;
        this.gm_stats = _gm_stats;
        this.stats_dir = FileUtil.getUserFile("stats");
        COConfigurationManager.addParameterListener("long.term.stats.enable", new ParameterListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void parameterChanged(String name) {
                boolean enabled = COConfigurationManager.getBooleanParameter(name);
                LongTermStatsImpl longTermStatsImpl = LongTermStatsImpl.this;
                synchronized (longTermStatsImpl) {
                    if (enabled) {
                        if (!LongTermStatsImpl.this.active) {
                            LongTermStatsImpl.this.sessionStart();
                        }
                    } else if (LongTermStatsImpl.this.active) {
                        LongTermStatsImpl.this.sessionEnd();
                    }
                }
            }
        });
        _core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentCreated(AzureusCore core, AzureusCoreComponent component) {
                if (component instanceof GlobalManager) {
                    LongTermStatsImpl longTermStatsImpl = LongTermStatsImpl.this;
                    synchronized (longTermStatsImpl) {
                        LongTermStatsImpl.this.sessionStart();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stopped(AzureusCore core) {
                LongTermStatsImpl longTermStatsImpl = LongTermStatsImpl.this;
                synchronized (longTermStatsImpl) {
                    LongTermStatsImpl.this.closing = true;
                    if (LongTermStatsImpl.this.active) {
                        LongTermStatsImpl.this.sessionEnd();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        LongTermStatsImpl longTermStatsImpl = this;
        synchronized (longTermStatsImpl) {
            return this.active;
        }
    }

    private DHT[] getDHTs() {
        if (this.dhts == null) {
            try {
                PluginManager pm = this.core.getPluginManager();
                if (pm.isInitialized()) {
                    PluginInterface dht_pi = pm.getPluginInterfaceByClass(DHTPlugin.class);
                    if (dht_pi == null) {
                        this.dhts = new DHT[0];
                    } else {
                        DHTPlugin plugin = (DHTPlugin)dht_pi.getPlugin();
                        if (!plugin.isInitialising()) {
                            this.dhts = plugin.isEnabled() ? ((DHTPlugin)dht_pi.getPlugin()).getDHTs() : new DHT[0];
                        }
                    }
                }
            }
            catch (Throwable e) {
                this.dhts = new DHT[0];
            }
        }
        return this.dhts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sessionStart() {
        OverallStatsImpl stats2 = (OverallStatsImpl)StatsFactory.getStats();
        LongTermStatsImpl longTermStatsImpl = this;
        synchronized (longTermStatsImpl) {
            DHT[] dhts;
            if (this.closing) {
                return;
            }
            boolean enabled = COConfigurationManager.getBooleanParameter("long.term.stats.enable");
            if (this.active || !enabled) {
                return;
            }
            this.active = true;
            long[] snap = stats2.getLastSnapshot();
            this.ss_d_received = this.gm_stats.getTotalDataBytesReceived();
            this.ss_p_received = this.gm_stats.getTotalProtocolBytesReceived();
            this.ss_d_sent = this.gm_stats.getTotalDataBytesSent();
            this.ss_p_sent = this.gm_stats.getTotalProtocolBytesSent();
            this.ss_dht_sent = 0L;
            this.ss_dht_received = 0L;
            if (this.core.isStarted() && (dhts = this.getDHTs()) != null) {
                for (DHT dht : dhts) {
                    DHTTransportStats dht_stats = dht.getTransport().getStats();
                    this.ss_dht_sent += dht_stats.getBytesSent();
                    this.ss_dht_received += dht_stats.getBytesReceived();
                }
            }
            this.st_p_sent = snap[0] + (this.ss_p_sent - snap[6]);
            this.st_d_sent = snap[1] + (this.ss_d_sent - snap[7]);
            this.st_p_received = snap[2] + (this.ss_p_received - snap[8]);
            this.st_d_received = snap[3] + (this.ss_d_received - snap[9]);
            this.st_dht_sent = snap[4] + (this.ss_dht_sent - snap[10]);
            this.st_dht_received = snap[5] + (this.ss_dht_received - snap[11]);
            this.write(1, new long[]{this.st_p_sent, this.st_d_sent, this.st_p_received, this.st_d_received, this.st_dht_sent, this.st_dht_received});
            if (this.event == null) {
                this.event = SimpleTimer.addPeriodicEvent("LongTermStats", 60000L, new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        LongTermStatsImpl.this.updateStats();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sessionEnd() {
        LongTermStatsImpl longTermStatsImpl = this;
        synchronized (longTermStatsImpl) {
            if (!this.active) {
                return;
            }
            this.updateStats(3);
            this.active = false;
            if (this.event != null) {
                this.event.cancel();
                this.event = null;
            }
        }
    }

    private void updateStats() {
        this.updateStats(2);
    }

    private void updateStats(int record_type) {
        long current_d_received = this.gm_stats.getTotalDataBytesReceived();
        long current_p_received = this.gm_stats.getTotalProtocolBytesReceived();
        long current_d_sent = this.gm_stats.getTotalDataBytesSent();
        long current_p_sent = this.gm_stats.getTotalProtocolBytesSent();
        long current_dht_sent = 0L;
        long current_dht_received = 0L;
        DHT[] dhts = this.getDHTs();
        if (dhts != null) {
            for (DHT dht : dhts) {
                DHTTransportStats dht_stats = dht.getTransport().getStats();
                current_dht_sent += dht_stats.getBytesSent();
                current_dht_received += dht_stats.getBytesReceived();
            }
        }
        this.write(record_type, new long[]{current_p_sent - this.ss_p_sent, current_d_sent - this.ss_d_sent, current_p_received - this.ss_p_received, current_d_received - this.ss_d_received, current_dht_sent - this.ss_dht_sent, current_dht_received - this.ss_dht_received});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void write(int record_type, long[] line_stats) {
        block29: {
            LongTermStatsImpl longTermStatsImpl = this;
            synchronized (longTermStatsImpl) {
                block30: {
                    try {
                        Object var20_22;
                        block28: {
                            try {
                                long now = SystemTime.getCurrentTime();
                                long now_mins = now / 60000L;
                                String[] bits = utc_date_format.format(new Date(now)).split(",");
                                String year = bits[0];
                                String month = bits[1];
                                String day = bits[2];
                                String current_rel_file = year + File.separator + month + File.separator + day + ".dat";
                                String stats_str = "";
                                if (record_type == 1) {
                                    for (int i = 0; i < line_stats.length; ++i) {
                                        stats_str = stats_str + "," + line_stats[i];
                                        this.line_stats_prev[i] = 0L;
                                    }
                                    this.day_cache = null;
                                } else {
                                    long diff;
                                    long[] diffs = new long[6];
                                    for (int i = 0; i < line_stats.length; this.session_total += diff, ++i) {
                                        diff = line_stats[i] - this.line_stats_prev[i];
                                        diffs[i] = diff;
                                        stats_str = stats_str + "," + diff;
                                        this.line_stats_prev[i] = line_stats[i];
                                        this.stat_averages[i].update(diff);
                                    }
                                    if (this.day_cache != null && this.day_cache.isForDay(year, month, day)) {
                                        this.day_cache.addRecord(now_mins, diffs);
                                    }
                                }
                                String line = record_type != 2 ? (record_type == 1 ? "s," : "e,") + 1 + "," + now_mins + stats_str : stats_str.substring(1);
                                if (this.writer == null || !this.writer_rel_file.equals(current_rel_file)) {
                                    if (this.writer != null) {
                                        if (record_type != 1) {
                                            this.writer.println(line);
                                        }
                                        this.writer.close();
                                        if (this.writer.checkError()) {
                                            this.writer = null;
                                            throw new IOException("Write faled");
                                        }
                                        this.writer = null;
                                    }
                                    if (record_type != 3) {
                                        File file = new File(this.stats_dir, current_rel_file);
                                        file.getParentFile().mkdirs();
                                        this.writer = new PrintWriter(new FileWriter(file, true));
                                        this.writer_rel_file = current_rel_file;
                                        if (record_type == 1) {
                                            this.writer.println(line);
                                            break block28;
                                        } else {
                                            this.st_p_sent += line_stats[0];
                                            this.st_d_sent += line_stats[1];
                                            this.st_p_received += line_stats[2];
                                            this.st_d_received += line_stats[3];
                                            this.st_dht_sent += line_stats[4];
                                            this.st_dht_received += line_stats[5];
                                            this.ss_p_sent += line_stats[0];
                                            this.ss_d_sent += line_stats[1];
                                            this.ss_p_received += line_stats[2];
                                            this.ss_d_received += line_stats[3];
                                            this.ss_dht_sent += line_stats[4];
                                            this.ss_dht_received += line_stats[5];
                                            stats_str = "";
                                            long[] st_stats = new long[]{this.st_p_sent, this.st_d_sent, this.st_p_received, this.st_d_received, this.st_dht_sent, this.st_dht_received};
                                            for (int i = 0; i < st_stats.length; ++i) {
                                                stats_str = stats_str + "," + st_stats[i];
                                                this.line_stats_prev[i] = 0L;
                                            }
                                            line = "s,1," + now_mins + stats_str;
                                            this.writer.println(line);
                                        }
                                    }
                                    break block28;
                                }
                                this.writer.println(line);
                            }
                            catch (Throwable e) {
                                Debug.out("Failed to write long term stats", e);
                                var20_22 = null;
                                if (this.writer == null) break block29;
                                if (record_type == 3) {
                                    this.writer.close();
                                }
                                if (this.writer.checkError()) {
                                    Debug.out("Failed to write long term stats");
                                    this.writer.close();
                                    this.writer = null;
                                    break block29;
                                }
                                if (record_type == 3) {
                                    this.writer = null;
                                }
                                break block29;
                            }
                        }
                        var20_22 = null;
                        if (this.writer == null) break block29;
                        if (record_type == 3) {
                            this.writer.close();
                        }
                        if (!this.writer.checkError()) break block30;
                    }
                    catch (Throwable throwable) {
                        Object var20_23 = null;
                        if (this.writer == null) throw throwable;
                        if (record_type == 3) {
                            this.writer.close();
                        }
                        if (this.writer.checkError()) {
                            Debug.out("Failed to write long term stats");
                            this.writer.close();
                            this.writer = null;
                            throw throwable;
                        }
                        if (record_type != 3) throw throwable;
                        this.writer = null;
                        throw throwable;
                    }
                    Debug.out("Failed to write long term stats");
                    this.writer.close();
                    this.writer = null;
                    break block29;
                }
                if (record_type == 3) {
                    this.writer = null;
                }
            }
        }
        if (record_type == 3) return;
        final ArrayList<LongTermStatsListener> to_fire = new ArrayList<LongTermStatsListener>();
        Iterator<Object[]> iterator = this.listeners.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                if (to_fire.size() <= 0) return;
                this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        for (LongTermStatsListener l : to_fire) {
                            try {
                                l.updated(LongTermStatsImpl.this);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                });
                return;
            }
            Object[] entry = iterator.next();
            long diff = this.session_total - (Long)entry[2];
            if (diff < (Long)entry[1]) continue;
            entry[2] = this.session_total;
            to_fire.add((LongTermStatsListener)entry[0]);
        }
    }

    private static String getString(long[] stats2) {
        String str = "";
        for (long s : stats2) {
            str = str + (str.length() == 0 ? "" : ", ") + s;
        }
        return str;
    }

    private MonthCache getMonthCache(String year, String month) {
        String key = year + "_" + month;
        MonthCache cache = this.month_cache_map.get(key);
        if (cache == null) {
            cache = new MonthCache(year, month);
            this.month_cache_map.put(key, cache);
        }
        return cache;
    }

    public long[] getTotalUsageInPeriod(Date start_date, Date end_date) {
        return this.getTotalUsageInPeriod(start_date, end_date, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long[] getTotalUsageInPeriod(Date start_date, Date end_date, LongTermStats.RecordAccepter accepter) {
        boolean enable_caching = accepter == null;
        LongTermStatsImpl longTermStatsImpl = this;
        synchronized (longTermStatsImpl) {
            long end_day;
            long start_day;
            long[] result = new long[6];
            long start_millis = start_date.getTime();
            long end_millis = end_date.getTime();
            long now = SystemTime.getCurrentTime();
            long now_day = now / 86400000L * 86400000L;
            if (end_millis > now) {
                end_millis = now;
            }
            if ((start_day = start_millis / 86400000L * 86400000L) > (end_day = end_millis / 86400000L * 86400000L)) {
                return result;
            }
            long start_offset = start_millis - start_day;
            boolean offset_cachable = (start_offset /= 60000L) % 60L == 0L;
            System.out.println("start=" + debug_utc_format.format(start_date) + ", end=" + debug_utc_format.format(end_date) + ", offset=" + start_offset);
            MonthCache month_cache = null;
            for (long this_day = start_day; this_day <= end_day; this_day += 86400000L) {
                BufferedReader lnr;
                block41: {
                    String line;
                    String current_rel_file;
                    File stats_file;
                    boolean can_cache;
                    long cache_offset;
                    String[] bits = utc_date_format.format(new Date(this_day)).split(",");
                    String year_str = bits[0];
                    String month_str = bits[1];
                    String day_str = bits[2];
                    int year = Integer.parseInt(year_str);
                    int month = Integer.parseInt(month_str);
                    int day = Integer.parseInt(day_str);
                    long l = cache_offset = this_day == start_day ? start_offset : 0L;
                    if (enable_caching) {
                        long[] cached_totals;
                        if (month_cache == null || !month_cache.isForMonth(year_str, month_str)) {
                            if (month_cache != null && month_cache.isDirty()) {
                                month_cache.save();
                            }
                            month_cache = this.getMonthCache(year_str, month_str);
                        }
                        boolean bl = can_cache = this_day != now_day && (this_day > start_day || this_day == start_day && offset_cachable) && this_day < end_day;
                        if (can_cache) {
                            cached_totals = month_cache.getTotals(day, cache_offset);
                            if (cached_totals != null) {
                                for (int i = 0; i < cached_totals.length; ++i) {
                                    int n = i;
                                    result[n] = result[n] + cached_totals[i];
                                }
                                continue;
                            }
                        } else if (this_day == now_day && this.day_cache != null) {
                            if (this.day_cache.isForDay(year_str, month_str, day_str)) {
                                cached_totals = this.day_cache.getTotals(cache_offset);
                                if (cached_totals != null) {
                                    for (int i = 0; i < cached_totals.length; ++i) {
                                        int n = i;
                                        result[n] = result[n] + cached_totals[i];
                                    }
                                    continue;
                                }
                            } else {
                                this.day_cache = null;
                            }
                        }
                    } else {
                        can_cache = false;
                    }
                    if (!(stats_file = new File(this.stats_dir, current_rel_file = bits[0] + File.separator + bits[1] + File.separator + bits[2] + ".dat")).exists()) {
                        if (!can_cache) continue;
                        month_cache.setTotals(day, cache_offset, new long[0]);
                        continue;
                    }
                    lnr = null;
                    System.out.println("Reading " + stats_file);
                    lnr = new LineNumberReader(new FileReader(stats_file));
                    long file_start_time = 0L;
                    long[] file_totals = null;
                    long[] file_result_totals = new long[6];
                    long[] session_start_stats = null;
                    long session_start_time = 0L;
                    long session_time = 0L;
                    while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                        int i;
                        String[] fields = line.split(",");
                        if (fields.length < 6) continue;
                        String first_field = fields[0];
                        if (first_field.equals("s")) {
                            session_start_time = Long.parseLong(fields[2]) * 60000L;
                            if (file_totals == null) {
                                file_totals = new long[6];
                                file_start_time = session_start_time;
                            }
                            session_time = session_start_time;
                            session_start_stats = new long[6];
                            for (int i2 = 3; i2 < 9; ++i2) {
                                session_start_stats[i2 - 3] = Long.parseLong(fields[i2]);
                            }
                            continue;
                        }
                        if (session_start_time <= 0L) continue;
                        session_time += 60000L;
                        int field_offset = 0;
                        if (first_field.equals("e")) {
                            field_offset = 3;
                        }
                        long[] line_stats = new long[6];
                        for (i = 0; i < 6; ++i) {
                            line_stats[i] = Long.parseLong(fields[i + field_offset]);
                            int n = i;
                            file_totals[n] = file_totals[n] + line_stats[i];
                        }
                        if (session_time < start_millis || session_time > end_millis || accepter != null && !accepter.acceptRecord(session_time)) continue;
                        for (i = 0; i < 6; ++i) {
                            int n = i;
                            result[n] = result[n] + line_stats[i];
                            int n2 = i;
                            file_result_totals[n2] = file_result_totals[n2] + line_stats[i];
                        }
                    }
                    if (file_totals == null) {
                        file_totals = new long[]{};
                    }
                    System.out.println("File total: start=" + debug_utc_format.format(file_start_time) + ", end=" + debug_utc_format.format(session_time) + " - " + LongTermStatsImpl.getString(file_totals));
                    if (can_cache) {
                        month_cache.setTotals(day, cache_offset, file_result_totals);
                        if (cache_offset != 0L) {
                            month_cache.setTotals(day, 0L, file_totals);
                        }
                        break block41;
                    }
                    if (!enable_caching || this_day != now_day) break block41;
                    if (this.day_cache == null) {
                        System.out.println("Creating day cache");
                        this.day_cache = new DayCache(year_str, month_str, day_str);
                    }
                    this.day_cache.setTotals(cache_offset, file_result_totals);
                    if (cache_offset == 0L) break block41;
                    this.day_cache.setTotals(0L, file_totals);
                }
                Object var54_44 = null;
                if (lnr == null) continue;
                try {
                    lnr.close();
                }
                catch (Throwable e2) {}
                continue;
                {
                    catch (Throwable e) {
                        Debug.out(e);
                        var54_44 = null;
                        if (lnr == null) continue;
                        try {
                            lnr.close();
                        }
                        catch (Throwable e2) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var54_44 = null;
                    if (lnr != null) {
                        try {
                            lnr.close();
                        }
                        catch (Throwable e2) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            if (enable_caching && month_cache != null && month_cache.isDirty()) {
                month_cache.save();
            }
            System.out.println("    -> " + LongTermStatsImpl.getString(result));
            return result;
        }
    }

    public long[] getTotalUsageInPeriod(int period_type) {
        return this.getTotalUsageInPeriod(period_type, null);
    }

    public long[] getTotalUsageInPeriod(int period_type, LongTermStats.RecordAccepter accepter) {
        if (this.start_of_week == -1) {
            COConfigurationManager.addAndFireParameterListeners(new String[]{"long.term.stats.weekstart", "long.term.stats.monthstart"}, new ParameterListener(){

                public void parameterChanged(String name) {
                    LongTermStatsImpl.this.start_of_week = COConfigurationManager.getIntParameter("long.term.stats.weekstart");
                    LongTermStatsImpl.this.start_of_month = COConfigurationManager.getIntParameter("long.term.stats.monthstart");
                }
            });
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(SystemTime.getCurrentTime());
        calendar.set(14, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        long top_time = calendar.getTimeInMillis() + 86400000L - 1L;
        if (period_type != 1) {
            if (period_type == 2) {
                int day_of_week = calendar.get(7);
                if (day_of_week != this.start_of_week) {
                    if (day_of_week > this.start_of_week) {
                        ((Calendar)calendar).add(7, -(day_of_week - this.start_of_week));
                    } else {
                        ((Calendar)calendar).add(7, -(7 - (this.start_of_week - day_of_week)));
                    }
                }
            } else if (this.start_of_month == 1) {
                calendar.set(5, 1);
            } else {
                int day_of_month = calendar.get(5);
                if (day_of_month != this.start_of_month) {
                    if (day_of_month > this.start_of_month) {
                        calendar.set(5, this.start_of_month);
                    } else {
                        ((Calendar)calendar).add(2, -1);
                        calendar.set(5, this.start_of_month);
                    }
                }
            }
        }
        long bottom_time = calendar.getTimeInMillis();
        return this.getTotalUsageInPeriod(new Date(bottom_time), new Date(top_time), accepter);
    }

    public long[] getCurrentRateBytesPerSecond() {
        long[] result = new long[6];
        for (int i = 0; i < 6; ++i) {
            result[i] = (long)(this.stat_averages[i].getAverage() / 60.0);
        }
        return result;
    }

    public void addListener(long min_delta_bytes, final LongTermStatsListener listener) {
        this.listeners.add(new Object[]{listener, min_delta_bytes, this.session_total});
        this.dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                listener.updated(LongTermStatsImpl.this);
            }
        });
    }

    public void removeListener(LongTermStatsListener listener) {
        for (Object[] entry : this.listeners) {
            if (entry[0] != listener) continue;
            this.listeners.remove(entry);
            break;
        }
    }

    public static void main(String[] args) {
        try {
            LongTermStatsImpl impl = new LongTermStatsImpl(new File("C:\\Test\\plus2\\stats"));
            SimpleDateFormat local_format = new SimpleDateFormat("yyyy,MM,dd");
            Date start_date = local_format.parse("2013,07,10");
            Date end_date = local_format.parse("2013,07,16");
            long[] usage = impl.getTotalUsageInPeriod(start_date, end_date, new LongTermStats.RecordAccepter(){

                public boolean acceptRecord(long timestamp) {
                    System.out.println(new Date(timestamp));
                    return false;
                }
            });
            System.out.println(LongTermStatsImpl.getString(usage));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        debug_utc_format.setTimeZone(TimeZone.getTimeZone("UTC"));
        utc_date_format.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private class DayCache {
        private String year;
        private String month;
        private String day;
        private Map<Long, long[]> contents = new HashMap<Long, long[]>();

        private DayCache(String _year, String _month, String _day) {
            this.year = _year;
            this.month = _month;
            this.day = _day;
        }

        private boolean isForDay(String _year, String _month, String _day) {
            return this.year.equals(_year) && this.month.equals(_month) && this.day.equals(_day);
        }

        private void addRecord(long offset, long[] stats2) {
            for (Map.Entry<Long, long[]> entry : this.contents.entrySet()) {
                if (offset < entry.getKey()) continue;
                long[] old = entry.getValue();
                for (int i = 0; i < old.length; ++i) {
                    int n = i;
                    old[n] = old[n] + stats2[i];
                }
            }
        }

        private long[] getTotals(long offset) {
            return this.contents.get(offset);
        }

        private void setTotals(long offset, long[] value) {
            this.contents.put(offset, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MonthCache {
        private String year;
        private String month;
        private boolean dirty;
        private Map<String, List<Long>> contents;

        private MonthCache(String _year, String _month) {
            this.year = _year;
            this.month = _month;
        }

        private File getCacheFile() {
            return new File(LongTermStatsImpl.this.stats_dir, this.year + File.separator + this.month + File.separator + "cache.dat");
        }

        private boolean isForMonth(String _year, String _month) {
            return this.year.equals(_year) && this.month.equals(_month);
        }

        private Map<String, List<Long>> getContents() {
            if (this.contents == null) {
                File file = this.getCacheFile();
                if (file.exists()) {
                    System.out.println("Reading cache: " + file);
                    this.contents = FileUtil.readResilientFile(file);
                } else {
                    this.contents = new HashMap<String, List<Long>>();
                }
            }
            return this.contents;
        }

        private long[] getTotals(int day) {
            List<Long> records = this.getContents().get(String.valueOf(day));
            if (records != null) {
                long[] result = new long[6];
                if (records.size() == 6) {
                    for (int i = 0; i < 6; ++i) {
                        result[i] = records.get(i);
                    }
                }
                return result;
            }
            return null;
        }

        private long[] getTotals(int day, long start_offset) {
            if (start_offset == 0L) {
                return this.getTotals(day);
            }
            List<Long> records = this.getContents().get(day + "." + start_offset);
            if (records != null) {
                long[] result = new long[6];
                if (records.size() == 6) {
                    for (int i = 0; i < 6; ++i) {
                        result[i] = records.get(i);
                    }
                }
                return result;
            }
            return null;
        }

        private void setTotals(int day, long[] totals) {
            ArrayList<Long> records = new ArrayList<Long>();
            long[] lArray = totals;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long l = lArray[i];
                records.add(l);
            }
            this.getContents().put(String.valueOf(day), records);
            this.dirty = true;
        }

        private void setTotals(int day, long start_offset, long[] totals) {
            if (start_offset == 0L) {
                this.setTotals(day, totals);
            } else {
                ArrayList<Long> records = new ArrayList<Long>();
                long[] lArray = totals;
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long l = lArray[i];
                    records.add(l);
                }
                this.getContents().put(day + "." + start_offset, records);
                this.dirty = true;
            }
        }

        private boolean isDirty() {
            return this.dirty;
        }

        private void save() {
            File file = this.getCacheFile();
            file.getParentFile().mkdirs();
            System.out.println("Writing cache: " + file);
            FileUtil.writeResilientFile(file, this.contents);
            this.dirty = false;
        }
    }
}

