/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import java.net.URL;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraper;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperClientResolver;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTScraperImpl;
import org.gudy.azureus2.core3.tracker.client.impl.dht.TRTrackerDHTScraperImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;

public class TRTrackerScraperImpl
implements TRTrackerScraper {
    private static TRTrackerScraperImpl singleton;
    private static AEMonitor class_mon;
    private TRTrackerBTScraperImpl bt_scraper;
    private TRTrackerDHTScraperImpl dht_scraper;
    private TRTrackerScraperClientResolver client_resolver;
    private static final int LDT_SCRAPE_RECEIVED = 1;
    private ListenerManager listeners = ListenerManager.createManager("TrackerScraper:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            TRTrackerScraperListener listener = (TRTrackerScraperListener)_listener;
            listener.scrapeReceived((TRTrackerScraperResponse)value);
        }
    });
    private boolean disableScrape = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TRTrackerScraperImpl create() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TRTrackerScraperImpl();
            }
            TRTrackerScraperImpl tRTrackerScraperImpl = singleton;
            Object var2_1 = null;
            class_mon.exit();
            return tRTrackerScraperImpl;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected TRTrackerScraperImpl() {
        this.bt_scraper = TRTrackerBTScraperImpl.create(this);
        this.dht_scraper = TRTrackerDHTScraperImpl.create(this);
    }

    public TRTrackerScraperResponse scrape(TOTorrent torrent) {
        return this.scrape(torrent, false);
    }

    public TRTrackerScraperResponse scrape(TOTorrent torrent, URL target_url) {
        return this.scrape(torrent, target_url, false);
    }

    public TRTrackerScraperResponse scrape(TOTorrent torrent, boolean force) {
        return this.scrape(torrent, null, force);
    }

    public void setScrape(TOTorrent torrent, URL target_url, DownloadScrapeResult result) {
        if (torrent != null) {
            if (target_url == null && TorrentUtils.isDecentralised(torrent) || TorrentUtils.isDecentralised(target_url)) {
                this.dht_scraper.setScrape(torrent, target_url, result);
            } else {
                this.bt_scraper.setScrape(torrent, target_url, result);
            }
        }
    }

    public TRTrackerScraperResponse scrape(TOTorrent torrent, URL target_url, boolean force) {
        if (torrent == null) {
            return null;
        }
        if (target_url == null && TorrentUtils.isDecentralised(torrent) || TorrentUtils.isDecentralised(target_url)) {
            return this.dht_scraper.scrape(torrent, target_url, force);
        }
        return this.bt_scraper.scrape(torrent, target_url, force);
    }

    public TRTrackerScraperResponse peekScrape(TOTorrent torrent, URL target_url) {
        if (torrent == null) {
            return null;
        }
        if (target_url == null && TorrentUtils.isDecentralised(torrent) || TorrentUtils.isDecentralised(target_url)) {
            return this.dht_scraper.peekScrape(torrent, target_url);
        }
        return this.bt_scraper.peekScrape(torrent, target_url);
    }

    public TRTrackerScraperResponse scrape(TRTrackerAnnouncer tracker_client) {
        TOTorrent torrent = tracker_client.getTorrent();
        if (TorrentUtils.isDecentralised(torrent)) {
            return this.dht_scraper.scrape(tracker_client);
        }
        return this.bt_scraper.scrape(tracker_client);
    }

    public void remove(TOTorrent torrent) {
        if (TorrentUtils.isDecentralised(torrent)) {
            this.dht_scraper.remove(torrent);
        } else {
            this.bt_scraper.remove(torrent);
        }
    }

    public void scrapeReceived(TRTrackerScraperResponse response) {
        this.listeners.dispatch(1, response);
    }

    public void setClientResolver(TRTrackerScraperClientResolver resolver) {
        this.client_resolver = resolver;
    }

    public TRTrackerScraperClientResolver getClientResolver() {
        return this.client_resolver;
    }

    public boolean isTorrentDownloading(HashWrapper hash) {
        if (this.client_resolver == null) {
            return false;
        }
        int state = this.client_resolver.getStatus(hash);
        return state == 2;
    }

    public boolean isTorrentRunning(HashWrapper hash) {
        if (this.client_resolver == null) {
            return false;
        }
        int state = this.client_resolver.getStatus(hash);
        return state == 2 || state == 3;
    }

    public boolean isNetworkEnabled(HashWrapper hash, URL url) {
        if (this.client_resolver == null) {
            return false;
        }
        return this.client_resolver.isNetworkEnabled(hash, url);
    }

    public String[] getEnabledNetworks(HashWrapper hash) {
        if (this.client_resolver == null) {
            return null;
        }
        return this.client_resolver.getEnabledNetworks(hash);
    }

    public Object[] getExtensions(HashWrapper hash) {
        if (this.client_resolver == null) {
            return null;
        }
        return this.client_resolver.getExtensions(hash);
    }

    public boolean redirectTrackerUrl(HashWrapper hash, URL old_url, URL new_url) {
        return this.client_resolver.redirectTrackerUrl(hash, old_url, new_url);
    }

    public void addListener(TRTrackerScraperListener l) {
        this.listeners.addListener(l);
    }

    public void removeListener(TRTrackerScraperListener l) {
        this.listeners.removeListener(l);
    }

    public void setDisableScrape(boolean disableScrape) {
        this.disableScrape = disableScrape;
    }

    public boolean getDisableScrape() {
        return this.disableScrape;
    }

    static {
        class_mon = new AEMonitor("TRTrackerScraper");
    }
}

