/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.util.AENetworkClassifierListener;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;

public class AENetworkClassifier {
    public static final String AT_PUBLIC = "Public";
    public static final String AT_I2P = "I2P";
    public static final String AT_TOR = "Tor";
    public static final String[] AT_NETWORKS = new String[]{"Public", "I2P", "Tor"};
    public static final String[] AT_NON_PUBLIC = new String[]{"I2P", "Tor"};
    private static List listeners = new ArrayList();

    public static String categoriseAddress(String str) {
        if (str == null) {
            return AT_PUBLIC;
        }
        int last_dot = str.lastIndexOf(46);
        if (last_dot == -1) {
            return AT_PUBLIC;
        }
        String dom = str.substring(last_dot + 1).toLowerCase(Locale.US);
        if (dom.equals("i2p")) {
            return AT_I2P;
        }
        if (dom.equals("onion")) {
            return AT_TOR;
        }
        return AT_PUBLIC;
    }

    public static String internalise(String str) {
        if (str == null) {
            return null;
        }
        for (String net : AT_NETWORKS) {
            if (!str.equalsIgnoreCase(net)) continue;
            return net;
        }
        return null;
    }

    public static String categoriseAddress(InetSocketAddress isa) {
        return AENetworkClassifier.categoriseAddress(AddressUtils.getHostAddress(isa));
    }

    public static String[] getNetworks(TOTorrent torrent, String display_name) {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(torrent.getAnnounceURL());
        TOTorrentAnnounceURLSet[] sets = torrent.getAnnounceURLGroup().getAnnounceURLSets();
        for (int i = 0; i < sets.length; ++i) {
            URL[] u = sets[i].getAnnounceURLs();
            for (int j = 0; j < u.length; ++j) {
                urls.add(u[j]);
            }
        }
        ArrayList<String> available_networks = new ArrayList<String>();
        for (int i = 0; i < urls.size(); ++i) {
            URL u = (URL)urls.get(i);
            String network = AENetworkClassifier.categoriseAddress(u.getHost());
            if (available_networks.contains(network)) continue;
            available_networks.add(network);
        }
        if (available_networks.size() == 1 && available_networks.get(0) == AT_PUBLIC) {
            return new String[]{AT_PUBLIC};
        }
        boolean prompt = COConfigurationManager.getBooleanParameter("Network Selection Prompt");
        ArrayList<String> res = new ArrayList<String>();
        if (prompt && listeners.size() > 0) {
            String[] t_nets = new String[available_networks.size()];
            available_networks.toArray(t_nets);
            for (int i = 0; i < listeners.size(); ++i) {
                try {
                    String[] selected = ((AENetworkClassifierListener)listeners.get(i)).selectNetworks(display_name, t_nets);
                    if (selected == null) continue;
                    for (int j = 0; j < selected.length; ++j) {
                        res.add(selected[j]);
                    }
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        } else {
            for (int i = 0; i < available_networks.size(); ++i) {
                if (!COConfigurationManager.getBooleanParameter("Network Selection Default." + available_networks.get(i))) continue;
                res.add((String)available_networks.get(i));
            }
        }
        String[] x = new String[res.size()];
        res.toArray(x);
        return x;
    }

    public static void addListener(AENetworkClassifierListener l) {
        listeners.add(l);
    }

    public static void removeListener(AENetworkClassifierListener l) {
        listeners.remove(l);
    }
}

