/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.util.JSONUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gudy.azureus2.core3.util.BEncodableObject;
import org.gudy.azureus2.core3.util.ByteEncodedKeyHashMap;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BEncoder {
    private static final int BUFFER_DOUBLE_LIMIT = 262144;
    private static final byte[] MINUS_1_BYTES = "-1".getBytes();
    private static volatile int non_ascii_logs;
    private byte[] current_buffer = new byte[256];
    private int current_buffer_pos = 0;
    private byte[][] old_buffers;
    private byte[] int_buffer = new byte[12];
    private boolean url_encode;
    static final byte[] digits;
    static final byte[] DigitTens;
    static final byte[] DigitOnes;

    public static byte[] encode(Map object) throws IOException {
        return BEncoder.encode(object, false);
    }

    public static byte[] encode(Map object, boolean url_encode) throws IOException {
        BEncoder encoder = new BEncoder(url_encode);
        encoder.encodeObject(object);
        return encoder.toByteArray();
    }

    private BEncoder(boolean _url_encode) {
        this.url_encode = _url_encode;
    }

    private boolean encodeObject(Object object) throws IOException {
        if (object instanceof BEncodableObject) {
            object = ((BEncodableObject)object).toBencodeObject();
        }
        if (object instanceof String || object instanceof Float || object instanceof Double) {
            String tempString = object instanceof String ? (String)object : String.valueOf(object);
            boolean simple = true;
            int char_count = tempString.length();
            byte[] encoded = new byte[char_count];
            for (int i = 0; i < char_count; ++i) {
                char c = tempString.charAt(i);
                if (c >= '\u0080') {
                    simple = false;
                    break;
                }
                encoded[i] = (byte)c;
            }
            if (simple) {
                this.writeInt(char_count);
                this.writeChar(':');
                this.writeBytes(encoded);
            } else {
                ByteBuffer bb = Constants.DEFAULT_CHARSET.encode(tempString);
                this.writeInt(bb.limit());
                this.writeChar(':');
                this.writeByteBuffer(bb);
            }
        } else if (object instanceof Map) {
            Map tempMap = (Map)object;
            TreeMap tempTree = null;
            boolean byte_keys = object instanceof ByteEncodedKeyHashMap;
            this.writeChar('d');
            tempTree = tempMap instanceof TreeMap ? (TreeMap)tempMap : new TreeMap(tempMap);
            for (Map.Entry entry : tempTree.entrySet()) {
                Object o_key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                if (o_key instanceof byte[]) {
                    this.encodeObject(o_key);
                    if (this.encodeObject(value)) continue;
                    this.encodeObject("");
                    continue;
                }
                if (o_key instanceof String) {
                    String key = (String)o_key;
                    if (byte_keys) {
                        try {
                            this.encodeObject(Constants.BYTE_CHARSET.encode(key));
                            if (this.encodeObject(value)) continue;
                            this.encodeObject("");
                            continue;
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new IOException("BEncoder: unsupport encoding: " + e.getMessage());
                        }
                    }
                    if (Constants.IS_CVS_VERSION) {
                        char[] chars;
                        for (char c : chars = key.toCharArray()) {
                            if (c < '\u0080') continue;
                            if (non_ascii_logs >= 50) break;
                            ++non_ascii_logs;
                            Debug.out("Non-ASCII key: " + key);
                            break;
                        }
                    }
                    this.encodeObject(key);
                    if (this.encodeObject(value)) continue;
                    this.encodeObject("");
                    continue;
                }
                Debug.out("Attempt to encode an unsupported map key type: " + object.getClass() + ";value=" + object);
            }
            this.writeChar('e');
        } else if (object instanceof List) {
            List tempList = (List)object;
            this.writeChar('l');
            for (int i = 0; i < tempList.size(); ++i) {
                this.encodeObject(tempList.get(i));
            }
            this.writeChar('e');
        } else if (object instanceof Long) {
            Long tempLong = (Long)object;
            this.writeChar('i');
            this.writeLong(tempLong);
            this.writeChar('e');
        } else if (object instanceof byte[]) {
            byte[] tempByteArray = (byte[])object;
            this.writeInt(tempByteArray.length);
            this.writeChar(':');
            if (this.url_encode) {
                this.writeBytes(URLEncoder.encode(new String(tempByteArray, "ISO-8859-1"), "ISO-8859-1").getBytes());
            } else {
                this.writeBytes(tempByteArray);
            }
        } else if (object instanceof Integer) {
            Integer tempInteger = (Integer)object;
            this.writeChar('i');
            this.writeInt(tempInteger);
            this.writeChar('e');
        } else if (object instanceof Byte) {
            byte temp = (Byte)object;
            this.writeChar('i');
            this.writeInt(temp & 0xFF);
            this.writeChar('e');
        } else if (object instanceof ByteBuffer) {
            ByteBuffer bb = (ByteBuffer)object;
            this.writeInt(bb.limit());
            this.writeChar(':');
            this.writeByteBuffer(bb);
        } else {
            if (object == null) {
                Debug.out("Attempt to encode a null value: sofar=" + this.getEncodedSoFar());
                return false;
            }
            Debug.out("Attempt to encode an unsupported entry type: " + object.getClass() + ";value=" + object);
            return false;
        }
        return true;
    }

    private void writeChar(char c) {
        int rem = this.current_buffer.length - this.current_buffer_pos;
        if (rem > 0) {
            this.current_buffer[this.current_buffer_pos++] = (byte)c;
        } else {
            int next_buffer_size = this.current_buffer.length < 262144 ? this.current_buffer.length << 1 : this.current_buffer.length + 262144;
            byte[] new_buffer = new byte[next_buffer_size];
            new_buffer[0] = (byte)c;
            if (this.old_buffers == null) {
                this.old_buffers = new byte[][]{this.current_buffer};
            } else {
                byte[][] new_old_buffers = new byte[this.old_buffers.length + 1][];
                System.arraycopy(this.old_buffers, 0, new_old_buffers, 0, this.old_buffers.length);
                new_old_buffers[this.old_buffers.length] = this.current_buffer;
                this.old_buffers = new_old_buffers;
            }
            this.current_buffer = new_buffer;
            this.current_buffer_pos = 1;
        }
    }

    private void writeInt(int i) {
        if (i == -1) {
            this.writeBytes(MINUS_1_BYTES);
            return;
        }
        int start = this.intToBytes(i);
        this.writeBytes(this.int_buffer, start, 12 - start);
    }

    private void writeLong(long l) {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            this.writeInt((int)l);
        } else {
            this.writeBytes(Long.toString(l).getBytes());
        }
    }

    private void writeBytes(byte[] bytes) {
        this.writeBytes(bytes, 0, bytes.length);
    }

    private void writeBytes(byte[] bytes, int offset, int length) {
        int rem = this.current_buffer.length - this.current_buffer_pos;
        if (rem >= length) {
            System.arraycopy(bytes, offset, this.current_buffer, this.current_buffer_pos, length);
            this.current_buffer_pos += length;
        } else {
            if (rem > 0) {
                System.arraycopy(bytes, offset, this.current_buffer, this.current_buffer_pos, rem);
                length -= rem;
            }
            int next_buffer_size = this.current_buffer.length < 262144 ? this.current_buffer.length << 1 : this.current_buffer.length + 262144;
            byte[] new_buffer = new byte[Math.max(next_buffer_size, length + 512)];
            System.arraycopy(bytes, offset + rem, new_buffer, 0, length);
            if (this.old_buffers == null) {
                this.old_buffers = new byte[][]{this.current_buffer};
            } else {
                byte[][] new_old_buffers = new byte[this.old_buffers.length + 1][];
                System.arraycopy(this.old_buffers, 0, new_old_buffers, 0, this.old_buffers.length);
                new_old_buffers[this.old_buffers.length] = this.current_buffer;
                this.old_buffers = new_old_buffers;
            }
            this.current_buffer = new_buffer;
            this.current_buffer_pos = length;
        }
    }

    private void writeByteBuffer(ByteBuffer bb) {
        this.writeBytes(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
    }

    private String getEncodedSoFar() {
        return new String(this.toByteArray());
    }

    private byte[] toByteArray() {
        if (this.old_buffers == null) {
            byte[] res = new byte[this.current_buffer_pos];
            System.arraycopy(this.current_buffer, 0, res, 0, this.current_buffer_pos);
            return res;
        }
        int total = this.current_buffer_pos;
        for (int i = 0; i < this.old_buffers.length; ++i) {
            total += this.old_buffers[i].length;
        }
        byte[] res = new byte[total];
        int pos = 0;
        for (int i = 0; i < this.old_buffers.length; ++i) {
            byte[] buffer = this.old_buffers[i];
            int len = buffer.length;
            System.arraycopy(buffer, 0, res, pos, len);
            pos += len;
        }
        System.arraycopy(this.current_buffer, 0, res, pos, this.current_buffer_pos);
        return res;
    }

    private static Object normaliseObject(Object o) {
        if (o instanceof Integer) {
            o = new Long(((Integer)o).longValue());
        } else if (o instanceof Boolean) {
            o = new Long((Boolean)o != false ? 1L : 0L);
        } else if (o instanceof Float) {
            o = String.valueOf((Float)o);
        } else if (o instanceof Double) {
            o = String.valueOf((Double)o);
        } else if (o instanceof byte[]) {
            try {
                o = new String((byte[])o, "UTF-8");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return o;
    }

    public static boolean isEncodable(Object toCheck) {
        if (toCheck instanceof Integer || toCheck instanceof Long || toCheck instanceof Boolean || toCheck instanceof Float || toCheck instanceof byte[] || toCheck instanceof String || toCheck instanceof BEncodableObject) {
            return true;
        }
        if (toCheck instanceof Map) {
            for (Map.Entry entry : ((Map)toCheck).keySet()) {
                Object key = entry.getKey();
                if ((key instanceof String || key instanceof byte[]) && BEncoder.isEncodable(entry.getValue())) continue;
                return false;
            }
            return true;
        }
        if (toCheck instanceof List) {
            Iterator it = ((List)toCheck).iterator();
            while (it.hasNext()) {
                if (BEncoder.isEncodable(it.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean objectsAreIdentical(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (!(o1.getClass() == o2.getClass() || o1 instanceof Map && o2 instanceof Map || o1 instanceof List && o2 instanceof List)) {
            o1 = BEncoder.normaliseObject(o1);
            o2 = BEncoder.normaliseObject(o2);
            if (o1.getClass() != o2.getClass()) {
                Debug.out("Failed to normalise classes " + o1.getClass() + "/" + o2.getClass());
                return false;
            }
        }
        if (o1 instanceof Long || o1 instanceof String) {
            return o1.equals(o2);
        }
        if (o1 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof List) {
            return BEncoder.listsAreIdentical((List)o1, (List)o2);
        }
        if (o1 instanceof Map) {
            return BEncoder.mapsAreIdentical((Map)o1, (Map)o2);
        }
        if (o1 instanceof Integer || o1 instanceof Boolean || o1 instanceof Float || o1 instanceof ByteBuffer) {
            return o1.equals(o2);
        }
        Debug.out("Invalid type: " + o1);
        return false;
    }

    public static boolean listsAreIdentical(List list1, List list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (BEncoder.objectsAreIdentical(list1.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean mapsAreIdentical(Map map1, Map map2) {
        if (map1 == null && map2 == null) {
            return true;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry entry : map1.entrySet()) {
            Object v2;
            Object key = entry.getKey();
            Object v1 = entry.getValue();
            if (BEncoder.objectsAreIdentical(v1, v2 = map2.get(key))) continue;
            return false;
        }
        return true;
    }

    public static Map cloneMap(Map map) {
        if (map == null) {
            return null;
        }
        TreeMap res = new TreeMap();
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key instanceof byte[]) {
                key = ((byte[])key).clone();
            }
            res.put(key, BEncoder.clone(value));
        }
        return res;
    }

    public static List cloneList(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<Object> res = new ArrayList<Object>(list.size());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            res.add(BEncoder.clone(it.next()));
        }
        return res;
    }

    public static Object clone(Object obj) {
        if (obj instanceof List) {
            return BEncoder.cloneList((List)obj);
        }
        if (obj instanceof Map) {
            return BEncoder.cloneMap((Map)obj);
        }
        if (obj instanceof byte[]) {
            return ((byte[])obj).clone();
        }
        return obj;
    }

    public static StringBuffer encodeToXML(Map map, boolean simple) {
        XMLEncoder writer = new XMLEncoder();
        return writer.encode(map, simple);
    }

    private static Object encodeToJSONGeneric(Object obj) {
        if (obj instanceof Map) {
            return BEncoder.encodeToJSONObject((Map)obj);
        }
        if (obj instanceof List) {
            return BEncoder.encodeToJSONArray((List)obj);
        }
        return BEncoder.normaliseObject(obj);
    }

    public static JSONArray encodeToJSONArray(List b_list) {
        JSONArray j_list = new JSONArray();
        for (Object o : b_list) {
            j_list.add(BEncoder.encodeToJSONGeneric(o));
        }
        return j_list;
    }

    public static JSONObject encodeToJSONObject(Map<Object, Object> b_map) {
        JSONObject j_map = new JSONObject();
        for (Map.Entry<Object, Object> entry : b_map.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            j_map.put((String)key, BEncoder.encodeToJSONGeneric(val));
        }
        return j_map;
    }

    public static String encodeToJSON(Map b_map) {
        JSONObject j_map = BEncoder.encodeToJSONObject(b_map);
        return JSONUtils.encodeToJSON(j_map);
    }

    private int intToBytes(int i) {
        int r;
        int q;
        int charPos = 12;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            this.int_buffer[--charPos] = DigitOnes[r];
            this.int_buffer[--charPos] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            this.int_buffer[--charPos] = digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            this.int_buffer[--charPos] = sign;
        }
        return charPos;
    }

    public static void main(String[] args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("a", new Float(1.2));
        map.put("b", true);
        map.put("c", "fred".getBytes());
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("boo", "meep");
        map.put("m", m2);
        ArrayList<String> l = new ArrayList<String>();
        l.add("foo");
        map.put("l", l);
        System.out.println(BEncoder.encodeToJSON(map));
    }

    static {
        digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
        DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
        DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    }

    protected static class XMLEncoder
    extends XUXmlWriter {
        protected XMLEncoder() {
        }

        protected StringBuffer encode(Map map, boolean simple) {
            StringWriter writer = new StringWriter(1024);
            this.setOutputWriter(writer);
            this.setGenericSimple(simple);
            this.writeGeneric(map);
            this.flushOutputStream();
            return writer.getBuffer();
        }
    }
}

