/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.protocol.vuze;

import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VuzeURLConnection
extends HttpURLConnection {
    private URL url;
    private int response_code = 200;
    private String response_msg = "OK";
    private InputStream input_stream;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();

    VuzeURLConnection(URL u) {
        super(u);
        this.url = u;
    }

    @Override
    public void connect() throws IOException {
        String str = this.url.toExternalForm();
        int pos = str.indexOf("=");
        str = str.substring(pos + 1);
        byte[] bytes = str.getBytes("ISO-8859-1");
        VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(bytes);
        if (vf == null) {
            throw new IOException("Invalid vuze file");
        }
        this.input_stream = new ByteArrayInputStream(bytes);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.headers;
    }

    @Override
    public String getHeaderField(String name) {
        List<String> values = this.headers.get(name);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(values.size() - 1);
    }

    public void setHeaderField(String name, String value) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.input_stream == null) {
            this.connect();
        }
        return this.input_stream;
    }

    public void setResponse(int _code, String _msg) {
        this.response_code = _code;
        this.response_msg = _msg;
    }

    @Override
    public int getResponseCode() {
        return this.response_code;
    }

    @Override
    public String getResponseMessage() {
        return this.response_msg;
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    @Override
    public void disconnect() {
    }
}

