/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerDescriptor;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerEvent;
import org.gudy.azureus2.plugins.peers.PeerManagerListener;
import org.gudy.azureus2.plugins.peers.PeerManagerListener2;
import org.gudy.azureus2.plugins.peers.PeerManagerStats;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.plugins.peers.Piece;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerForeignDelegate;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerStatsImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerStatsImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class PeerManagerImpl
implements PeerManager {
    private static final String PEPEER_DATA_KEY = PeerManagerImpl.class.getName();
    protected PEPeerManager manager;
    protected static AEMonitor pm_map_mon = new AEMonitor("PeerManager:Map");
    private Map foreign_map = new HashMap();
    private Map<PeerManagerListener, PEPeerManagerListener> listener_map1 = new HashMap<PeerManagerListener, PEPeerManagerListener>();
    private Map<PeerManagerListener2, CoreListener> listener_map2 = new HashMap<PeerManagerListener2, CoreListener>();
    protected AEMonitor this_mon = new AEMonitor("PeerManager");
    private final DiskManagerPiece[] dm_pieces;
    private final PEPiece[] pe_pieces;
    private pieceFacade[] piece_facades;
    private boolean destroyed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PeerManagerImpl getPeerManager(PEPeerManager _manager) {
        try {
            pm_map_mon.enter();
            PeerManagerImpl res = (PeerManagerImpl)_manager.getData("PluginPeerManager");
            if (res == null) {
                res = new PeerManagerImpl(_manager);
                _manager.setData("PluginPeerManager", res);
            }
            PeerManagerImpl peerManagerImpl = res;
            Object var4_3 = null;
            pm_map_mon.exit();
            return peerManagerImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            pm_map_mon.exit();
            throw throwable;
        }
    }

    protected PeerManagerImpl(PEPeerManager _manager) {
        this.manager = _manager;
        this.dm_pieces = _manager.getDiskManager().getPieces();
        this.pe_pieces = _manager.getPieces();
        this.manager.addListener(new PEPeerManagerListener(){

            public void peerAdded(PEPeerManager manager, PEPeer peer) {
            }

            public void peerRemoved(PEPeerManager manager, PEPeer peer) {
                PeerImpl dele = PeerManagerImpl.getPeerForPEPeer(peer);
                if (dele != null) {
                    dele.closed();
                }
            }

            public void peerDiscovered(PEPeerManager manager, PeerItem peer, PEPeer finder) {
            }

            public void peerSentBadData(PEPeerManager manager, PEPeer peer, int pieceNumber) {
            }

            public void pieceAdded(PEPeerManager manager, PEPiece piece, PEPeer for_peer) {
            }

            public void pieceRemoved(PEPeerManager manager, PEPiece piece) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void destroyed() {
                Map map = PeerManagerImpl.this.foreign_map;
                synchronized (map) {
                    PeerManagerImpl.this.destroyed = true;
                    Iterator it = PeerManagerImpl.this.foreign_map.values().iterator();
                    while (it.hasNext()) {
                        try {
                            ((PeerForeignDelegate)it.next()).stop();
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }
        });
    }

    public PEPeerManager getDelegate() {
        return this.manager;
    }

    public DiskManager getDiskManager() {
        return new DiskManagerImpl(this.manager.getDiskManager());
    }

    public PeerManagerStats getStats() {
        return new PeerManagerStatsImpl(this.manager);
    }

    public boolean isSeeding() {
        return this.manager.getDiskManager().getRemainingExcludingDND() == 0L;
    }

    public boolean isSuperSeeding() {
        return this.manager.isSuperSeedMode();
    }

    public Download getDownload() throws DownloadException {
        return DownloadManagerImpl.getDownloadStatic(this.manager.getDiskManager().getTorrent());
    }

    public Piece[] getPieces() {
        if (this.piece_facades == null) {
            pieceFacade[] pf = new pieceFacade[this.manager.getDiskManager().getNbPieces()];
            for (int i = 0; i < pf.length; ++i) {
                pf[i] = new pieceFacade(i);
            }
            this.piece_facades = pf;
        }
        return this.piece_facades;
    }

    public PeerStats createPeerStats(Peer peer) {
        PEPeer delegate = this.mapForeignPeer(peer);
        return new PeerStatsImpl(this, peer, this.manager.createPeerStats(delegate));
    }

    public void requestComplete(PeerReadRequest request2, PooledByteBuffer data, Peer sender) {
        this.manager.writeBlock(request2.getPieceNumber(), request2.getOffset(), ((PooledByteBufferImpl)data).getBuffer(), this.mapForeignPeer(sender), false);
        PeerForeignDelegate delegate = this.lookupForeignPeer(sender);
        if (delegate != null) {
            delegate.dataReceived();
        }
    }

    public void requestCancelled(PeerReadRequest request2, Peer sender) {
        this.manager.requestCanceled((DiskManagerReadRequest)request2);
    }

    protected int getPartitionID() {
        return this.manager.getPartitionID();
    }

    public void addPeer(Peer peer) {
        this.manager.addPeer(this.mapForeignPeer(peer));
    }

    public void removePeer(Peer peer) {
        this.manager.removePeer(this.mapForeignPeer(peer));
    }

    protected void removePeer(Peer peer, String reason) {
        this.manager.removePeer(this.mapForeignPeer(peer), reason);
    }

    public void addPeer(String ip_address, int tcp_port) {
        this.addPeer(ip_address, tcp_port, 0, NetworkManager.getCryptoRequired(0));
    }

    public void addPeer(String ip_address, int tcp_port, boolean use_crypto) {
        this.addPeer(ip_address, tcp_port, 0, use_crypto);
    }

    public void addPeer(String ip_address, int tcp_port, int udp_port, boolean use_crypto) {
        this.addPeer(ip_address, tcp_port, udp_port, use_crypto, (Map)null);
    }

    public void addPeer(String ip_address, int tcp_port, int udp_port, boolean use_crypto, Map user_data) {
        this.checkIfPrivate();
        if (this.pluginPeerSourceEnabled()) {
            this.manager.addPeer(ip_address, tcp_port, udp_port, use_crypto, user_data);
        }
    }

    public void peerDiscovered(String peer_source, String ip_address, int tcp_port, int udp_port, boolean use_crypto) {
        this.checkIfPrivate();
        if (this.manager.isPeerSourceEnabled(peer_source)) {
            this.manager.peerDiscovered(peer_source, ip_address, tcp_port, udp_port, use_crypto);
        }
    }

    protected boolean pluginPeerSourceEnabled() {
        if (this.manager.isPeerSourceEnabled("Plugin")) {
            return true;
        }
        Debug.out("Plugin peer source disabled for " + this.manager.getDisplayName());
        return false;
    }

    protected void checkIfPrivate() {
        Download dl;
        try {
            dl = this.getDownload();
        }
        catch (Throwable e) {
            return;
        }
        Torrent t = dl.getTorrent();
        if (t != null && TorrentUtils.isReallyPrivate(PluginCoreUtils.unwrap(t))) {
            throw new RuntimeException("Torrent is private, peer addition not permitted");
        }
    }

    public Peer[] getPeers() {
        List<PEPeer> l = this.manager.getPeers();
        Peer[] res = new Peer[l.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = PeerManagerImpl.getPeerForPEPeer(l.get(i));
        }
        return res;
    }

    public Peer[] getPeers(String address) {
        List<PEPeer> l = this.manager.getPeers(address);
        Peer[] res = new Peer[l.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = PeerManagerImpl.getPeerForPEPeer(l.get(i));
        }
        return res;
    }

    public PeerDescriptor[] getPendingPeers() {
        return this.manager.getPendingPeers();
    }

    public PeerDescriptor[] getPendingPeers(String address) {
        return this.manager.getPendingPeers(address);
    }

    public long getTimeSinceConnectionEstablished(Peer peer) {
        if (peer instanceof PeerImpl) {
            return ((PeerImpl)peer).getDelegate().getTimeSinceConnectionEstablished();
        }
        PeerForeignDelegate delegate = this.lookupForeignPeer(peer);
        if (delegate != null) {
            return delegate.getTimeSinceConnectionEstablished();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PEPeer mapForeignPeer(Peer _foreign) {
        if (_foreign instanceof PeerImpl) {
            return ((PeerImpl)_foreign).getDelegate();
        }
        Map map = this.foreign_map;
        synchronized (map) {
            PEPeer local = (PEPeer)this.foreign_map.get(_foreign);
            if (local == null) {
                if (this.destroyed) {
                    Debug.out("Peer added to destroyed peer manager");
                    return null;
                }
                local = new PeerForeignDelegate(this, _foreign);
                _foreign.setUserData(PeerManagerImpl.class, local);
                this.foreign_map.put(_foreign, local);
            }
            return local;
        }
    }

    protected PeerForeignDelegate lookupForeignPeer(Peer _foreign) {
        return (PeerForeignDelegate)_foreign.getUserData(PeerManagerImpl.class);
    }

    public List mapForeignPeers(Peer[] _foreigns) {
        ArrayList<PEPeer> res = new ArrayList<PEPeer>();
        for (int i = 0; i < _foreigns.length; ++i) {
            PEPeer local = this.mapForeignPeer(_foreigns[i]);
            if (res.contains(local)) continue;
            res.add(local);
        }
        return res;
    }

    public static PeerImpl getPeerForPEPeer(PEPeer pe_peer) {
        PeerImpl peer = (PeerImpl)pe_peer.getData(PEPEER_DATA_KEY);
        if (peer == null) {
            peer = new PeerImpl(pe_peer);
            pe_peer.setData(PEPEER_DATA_KEY, peer);
        }
        return peer;
    }

    public int getUploadRateLimitBytesPerSecond() {
        return this.manager.getUploadRateLimitBytesPerSecond();
    }

    public int getDownloadRateLimitBytesPerSecond() {
        return this.manager.getDownloadRateLimitBytesPerSecond();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(final PeerManagerListener l) {
        try {
            this.this_mon.enter();
            final HashMap peer_map = new HashMap();
            PEPeerManagerListener core_listener = new PEPeerManagerListener(){

                public void peerAdded(PEPeerManager manager, PEPeer peer) {
                    PeerImpl pi = PeerManagerImpl.getPeerForPEPeer(peer);
                    peer_map.put(peer, pi);
                    l.peerAdded(PeerManagerImpl.this, pi);
                }

                public void peerRemoved(PEPeerManager manager, PEPeer peer) {
                    PeerImpl pi = (PeerImpl)peer_map.remove(peer);
                    if (pi != null) {
                        l.peerRemoved(PeerManagerImpl.this, pi);
                    }
                }

                public void peerDiscovered(PEPeerManager manager, PeerItem peer, PEPeer finder) {
                }

                public void pieceAdded(PEPeerManager manager, PEPiece piece, PEPeer for_peer) {
                }

                public void pieceRemoved(PEPeerManager manager, PEPiece piece) {
                }

                public void peerSentBadData(PEPeerManager manager, PEPeer peer, int pieceNumber) {
                }

                public void destroyed() {
                }
            };
            this.listener_map1.put(l, core_listener);
            this.manager.addListener(core_listener);
            Object var5_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PeerManagerListener l) {
        try {
            this.this_mon.enter();
            PEPeerManagerListener core_listener = this.listener_map1.remove(l);
            if (core_listener != null) {
                this.manager.removeListener(core_listener);
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PeerManagerListener2 l) {
        try {
            this.this_mon.enter();
            CoreListener core_listener = new CoreListener(l);
            this.listener_map2.put(l, core_listener);
            this.manager.addListener(core_listener);
            this.manager.getDiskManager().addListener(core_listener);
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PeerManagerListener2 l) {
        try {
            this.this_mon.enter();
            CoreListener core_listener = this.listener_map2.remove(l);
            if (core_listener != null) {
                this.manager.removeListener(core_listener);
                this.manager.getDiskManager().removeListener(core_listener);
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    private class CoreListener
    implements PEPeerManagerListener,
    DiskManagerListener {
        private PeerManagerListener2 listener;
        private Map<PEPeer, Peer> peer_map = new HashMap<PEPeer, Peer>();

        private CoreListener(PeerManagerListener2 _listener) {
            this.listener = _listener;
        }

        public void peerAdded(PEPeerManager manager, PEPeer peer) {
            PeerImpl pi = PeerManagerImpl.getPeerForPEPeer(peer);
            this.peer_map.put(peer, pi);
            this.fireEvent(1, pi, null, null);
        }

        public void peerRemoved(PEPeerManager manager, PEPeer peer) {
            PeerImpl pi = (PeerImpl)this.peer_map.remove(peer);
            if (pi != null) {
                this.fireEvent(2, pi, null, null);
            }
        }

        public void peerDiscovered(PEPeerManager manager, PeerItem peer_item, PEPeer finder) {
            PeerImpl pi;
            if (finder != null) {
                pi = PeerManagerImpl.getPeerForPEPeer(finder);
                this.peer_map.put(finder, pi);
            } else {
                pi = null;
            }
            this.fireEvent(3, pi, peer_item, null);
        }

        public void pieceAdded(PEPeerManager manager, PEPiece piece, PEPeer for_peer) {
            PeerImpl pi = for_peer == null ? null : PeerManagerImpl.getPeerForPEPeer(for_peer);
            this.fireEvent(5, pi, null, new pieceFacade(piece.getPieceNumber()));
        }

        public void pieceRemoved(PEPeerManager manager, PEPiece piece) {
            this.fireEvent(6, null, null, new pieceFacade(piece.getPieceNumber()));
        }

        public void peerSentBadData(PEPeerManager manager, PEPeer peer, int pieceNumber) {
            PeerImpl pi = PeerManagerImpl.getPeerForPEPeer(peer);
            this.peer_map.put(peer, pi);
            this.fireEvent(4, pi, null, new Integer(pieceNumber));
        }

        public void stateChanged(int oldState, int newState) {
        }

        public void filePriorityChanged(DiskManagerFileInfo file) {
        }

        public void pieceDoneChanged(DiskManagerPiece piece) {
            this.fireEvent(7, null, null, new pieceFacade(piece.getPieceNumber()));
        }

        public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
        }

        protected void fireEvent(final int type, final Peer peer, final PeerItem peer_item, final Object data) {
            this.listener.eventOccurred(new PeerManagerEvent(){

                public PeerManager getPeerManager() {
                    return PeerManagerImpl.this;
                }

                public int getType() {
                    return type;
                }

                public Peer getPeer() {
                    return peer;
                }

                public PeerDescriptor getPeerDescriptor() {
                    return peer_item;
                }

                public Object getData() {
                    return data;
                }
            });
        }

        public void destroyed() {
        }
    }

    protected class pieceFacade
    implements Piece {
        private final int index;

        protected pieceFacade(int _index) {
            this.index = _index;
        }

        public int getIndex() {
            return this.index;
        }

        public int getLength() {
            return PeerManagerImpl.this.dm_pieces[this.index].getLength();
        }

        public boolean isDone() {
            return PeerManagerImpl.this.dm_pieces[this.index].isDone();
        }

        public boolean isNeeded() {
            return PeerManagerImpl.this.dm_pieces[this.index].isNeeded();
        }

        public boolean isDownloading() {
            return PeerManagerImpl.this.pe_pieces[this.index] != null;
        }

        public boolean isFullyAllocatable() {
            if (PeerManagerImpl.this.pe_pieces[this.index] != null) {
                return false;
            }
            return PeerManagerImpl.this.dm_pieces[this.index].isInteresting();
        }

        public int getAllocatableRequestCount() {
            PEPiece pe_piece = PeerManagerImpl.this.pe_pieces[this.index];
            if (pe_piece != null) {
                return pe_piece.getNbUnrequested();
            }
            if (PeerManagerImpl.this.dm_pieces[this.index].isInteresting()) {
                return PeerManagerImpl.this.dm_pieces[this.index].getNbBlocks();
            }
            return 0;
        }

        public Peer getReservedFor() {
            List<PEPeer> peers;
            String ip;
            PEPiece piece = PeerManagerImpl.this.pe_pieces[this.index];
            if (piece != null && (ip = piece.getReservedBy()) != null && (peers = PeerManagerImpl.this.manager.getPeers(ip)).size() > 0) {
                return PeerManagerImpl.getPeerForPEPeer(peers.get(0));
            }
            return null;
        }

        public void setReservedFor(Peer peer) {
            PEPiece piece = PeerManagerImpl.this.pe_pieces[this.index];
            PEPeer mapped_peer = PeerManagerImpl.this.mapForeignPeer(peer);
            if (piece != null && mapped_peer != null) {
                piece.setReservedBy(peer.getIp());
                mapped_peer.addReservedPieceNumber(this.index);
            }
        }
    }
}

