/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import java.util.ArrayList;
import java.util.Arrays;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentAttributeEvent;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.pluginsimpl.local.torrent.BaseTorrentAttributeImpl;

public class TorrentAttributeCategoryImpl
extends BaseTorrentAttributeImpl {
    protected TorrentAttributeCategoryImpl() {
        CategoryManager.addCategoryManagerListener(new CategoryManagerListener(){

            public void categoryAdded(final Category category) {
                TorrentAttributeEvent ev = new TorrentAttributeEvent(){

                    public int getType() {
                        return 1;
                    }

                    public TorrentAttribute getAttribute() {
                        return TorrentAttributeCategoryImpl.this;
                    }

                    public Object getData() {
                        return category.getName();
                    }
                };
                TorrentAttributeCategoryImpl.this.notifyListeners(ev);
            }

            public void categoryChanged(Category category) {
            }

            public void categoryRemoved(final Category category) {
                TorrentAttributeEvent ev = new TorrentAttributeEvent(){

                    public int getType() {
                        return 2;
                    }

                    public TorrentAttribute getAttribute() {
                        return TorrentAttributeCategoryImpl.this;
                    }

                    public Object getData() {
                        return category.getName();
                    }
                };
                TorrentAttributeCategoryImpl.this.notifyListeners(ev);
            }
        });
    }

    public String getName() {
        return "Category";
    }

    public String[] getDefinedValues() {
        Category[] categories = CategoryManager.getCategories();
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < categories.length; ++i) {
            Category cat = categories[i];
            if (cat.getType() != 0) continue;
            v.add(cat.getName());
        }
        String[] res = new String[v.size()];
        v.toArray(res);
        Arrays.sort(res, StaticUtilities.getFormatters().getAlphanumericComparator(true));
        return res;
    }

    public void addDefinedValue(String name) {
        CategoryManager.createCategory(name);
    }

    public void removeDefinedValue(String name) {
        Category cat = CategoryManager.getCategory(name);
        if (cat != null) {
            CategoryManager.removeCategory(cat);
        }
    }
}

