/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser;

import com.aelitis.azureus.core.util.UncloseableInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.Entities;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser.SimpleXMLParserDocumentNodeImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SimpleXMLParserDocumentImpl
implements SimpleXMLParserDocument {
    private static DocumentBuilderFactory dbf_singleton;
    private URL source_url;
    private Document document;
    private SimpleXMLParserDocumentNodeImpl root_node;

    public SimpleXMLParserDocumentImpl(File file) throws SimpleXMLParserDocumentException {
        try {
            this.create(new FileInputStream(file));
        }
        catch (Throwable e) {
            throw new SimpleXMLParserDocumentException(e);
        }
    }

    public SimpleXMLParserDocumentImpl(String data) throws SimpleXMLParserDocumentException {
        try {
            this.create(new ByteArrayInputStream(data.getBytes("UTF8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public SimpleXMLParserDocumentImpl(InputStream _input_stream) throws SimpleXMLParserDocumentException {
        this(null, _input_stream);
    }

    public SimpleXMLParserDocumentImpl(URL _source_url, InputStream _input_stream) throws SimpleXMLParserDocumentException {
        this.source_url = _source_url;
        this.create(_input_stream);
    }

    protected static synchronized DocumentBuilderFactory getDBF() {
        if (dbf_singleton == null) {
            dbf_singleton = DocumentBuilderFactory.newInstance();
            dbf_singleton.setNamespaceAware(true);
            dbf_singleton.setValidating(false);
            dbf_singleton.setIgnoringComments(true);
            dbf_singleton.setIgnoringElementContentWhitespace(true);
            dbf_singleton.setCoalescing(true);
            dbf_singleton.setExpandEntityReferences(true);
        }
        return dbf_singleton;
    }

    /*
     * Loose catch block
     */
    private void create(InputStream _input_stream) throws SimpleXMLParserDocumentException {
        block13: {
            if (!_input_stream.markSupported()) {
                _input_stream = new BufferedInputStream(_input_stream);
            }
            _input_stream.mark(102400);
            UncloseableInputStream uc_is = new UncloseableInputStream(_input_stream);
            this.createSupport(uc_is);
            Object var7_3 = null;
            try {
                _input_stream.close();
            }
            catch (Throwable e2) {}
            break block13;
            {
                catch (SimpleXMLParserDocumentException e) {
                    String msg = Debug.getNestedExceptionMessage(e);
                    if (msg.contains("entity") && msg.contains("was referenced") || msg.contains("entity reference")) {
                        _input_stream.reset();
                        this.createSupport(new EntityFudger(_input_stream));
                        Object var7_4 = null;
                        try {
                            _input_stream.close();
                        }
                        catch (Throwable e2) {
                            // empty catch block
                        }
                        return;
                        catch (Throwable f) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                try {
                    _input_stream.close();
                }
                catch (Throwable e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void createSupport(InputStream input_stream) throws SimpleXMLParserDocumentException {
        try {
            DocumentBuilderFactory dbf = SimpleXMLParserDocumentImpl.getDBF();
            DocumentBuilder db = dbf.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter(System.err);
            MyErrorHandler error_handler = new MyErrorHandler(new PrintWriter((Writer)errorWriter, true));
            db.setErrorHandler(error_handler);
            db.setEntityResolver(new EntityResolver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public InputSource resolveEntity(String publicId, String systemId) {
                    try {
                        url = new URL(systemId);
                        if (SimpleXMLParserDocumentImpl.access$000(SimpleXMLParserDocumentImpl.this) != null && (net = AENetworkClassifier.categoriseAddress(SimpleXMLParserDocumentImpl.access$000(SimpleXMLParserDocumentImpl.this).getHost())) != "Public" && AENetworkClassifier.categoriseAddress(url.getHost()) != net) {
                            return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                        }
                        host = url.getHost();
                        InetAddress.getByName(host);
                        is = null;
                        try {
                            try {
                                con = url.openConnection();
                                con.setConnectTimeout(15000);
                                con.setReadTimeout(15000);
                                is = con.getInputStream();
                                buffer = new byte[32];
                                for (pos = 0; pos < buffer.length && (len = is.read(buffer, pos, buffer.length - pos)) > 0; pos += len) {
                                }
                                str = new String(buffer, "UTF-8").trim().toLowerCase(Locale.US);
                                if (!str.contains("<?xml")) {
                                    buffer = new byte[32000];
                                    for (pos = 0; pos < buffer.length && (len = is.read(buffer, pos, buffer.length - pos)) > 0; pos += len) {
                                    }
                                    if ((str = str + new String(buffer, "UTF-8").trim().toLowerCase(Locale.US)).contains("<html") && str.contains("<head")) {
                                        throw new Exception("Bad DTD");
                                    }
                                }
                                var12_16 = null;
                                if (is == null) return null;
                            }
                            catch (Throwable e) {
                                var7_11 = new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                                var12_17 = null;
                                if (is == null) return var7_11;
                                try {
                                    is.close();
                                    return var7_11;
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                                return var7_11;
                            }
                        }
                        catch (Throwable var11_22) {
                            var12_18 = null;
                            if (is == null) throw var11_22;
                            ** try [egrp 3[TRYBLOCK] [4 : 374->382)] { 
lbl44:
                            // 1 sources

                            is.close();
                            throw var11_22;
lbl46:
                            // 1 sources

                            catch (Throwable e) {
                                // empty catch block
                            }
                            throw var11_22;
                        }
                        try {}
                        catch (Throwable e) {}
                        is.close();
                        return null;
                        return null;
                    }
                    catch (UnknownHostException e) {
                        return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                    }
                    catch (Throwable e) {
                        return null;
                    }
                }
            });
            this.document = db.parse(input_stream);
            SimpleXMLParserDocumentNodeImpl[] root_nodes = this.parseNode(this.document, false);
            int root_node_count = 0;
            for (int i = 0; i < root_nodes.length; ++i) {
                SimpleXMLParserDocumentNodeImpl node = root_nodes[i];
                if (node.getNode().getNodeType() == 7) continue;
                this.root_node = node;
                ++root_node_count;
            }
            if (root_node_count != 1) {
                throw new SimpleXMLParserDocumentException("invalid document - " + root_nodes.length + " root elements");
            }
        }
        catch (Throwable e) {
            throw new SimpleXMLParserDocumentException(e);
        }
    }

    public String getName() {
        return this.root_node.getName();
    }

    public String getFullName() {
        return this.root_node.getFullName();
    }

    public String getNameSpaceURI() {
        return this.root_node.getNameSpaceURI();
    }

    public String getValue() {
        return this.root_node.getValue();
    }

    public SimpleXMLParserDocumentNode[] getChildren() {
        return this.root_node.getChildren();
    }

    public SimpleXMLParserDocumentNode getChild(String name) {
        return this.root_node.getChild(name);
    }

    public SimpleXMLParserDocumentAttribute[] getAttributes() {
        return this.root_node.getAttributes();
    }

    public SimpleXMLParserDocumentAttribute getAttribute(String name) {
        return this.root_node.getAttribute(name);
    }

    public void print() {
        PrintWriter pw = new PrintWriter(System.out);
        this.print(pw);
        pw.flush();
    }

    public void print(PrintWriter pw) {
        this.root_node.print(pw, "");
    }

    protected SimpleXMLParserDocumentNodeImpl[] parseNode(Node node, boolean skip_this_node) {
        short type = node.getNodeType();
        if (!(type != 1 && type != 7 || skip_this_node)) {
            return new SimpleXMLParserDocumentNodeImpl[]{new SimpleXMLParserDocumentNodeImpl(this, node)};
        }
        Vector<SimpleXMLParserDocumentNodeImpl> v = new Vector<SimpleXMLParserDocumentNodeImpl>();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            SimpleXMLParserDocumentNodeImpl[] kids = this.parseNode(child, false);
            for (int i = 0; i < kids.length; ++i) {
                v.addElement(kids[i]);
            }
        }
        Object[] res = new SimpleXMLParserDocumentNodeImpl[v.size()];
        v.copyInto(res);
        return res;
    }

    static /* synthetic */ URL access$000(SimpleXMLParserDocumentImpl x0) {
        return x0.source_url;
    }

    private static class EntityFudger
    extends InputStream {
        private InputStream is;
        char[] buffer = new char[16];
        int buffer_pos = 0;
        char[] insertion = new char[16];
        int insertion_pos = 0;
        int insertion_len = 0;

        public EntityFudger(InputStream _is) {
            this.is = _is;
        }

        public int read() throws IOException {
            int b;
            if (this.insertion_len > 0) {
                int result = this.insertion[this.insertion_pos++] & 0xFF;
                if (this.insertion_pos == this.insertion_len) {
                    this.insertion_pos = 0;
                    this.insertion_len = 0;
                }
                return result;
            }
            while (true) {
                if ((b = this.is.read()) < 0) {
                    if (this.buffer_pos == 0) {
                        return b;
                    }
                    if (this.buffer_pos == 1) {
                        this.buffer_pos = 0;
                        return this.buffer[0] & 0xFF;
                    }
                    System.arraycopy(this.buffer, 1, this.insertion, 0, this.buffer_pos - 1);
                    this.insertion_len = this.buffer_pos - 1;
                    this.insertion_pos = 0;
                    this.buffer_pos = 0;
                    return this.buffer[0] & 0xFF;
                }
                if (this.buffer_pos == 0) {
                    if (b == 38) {
                        this.buffer[this.buffer_pos++] = (char)b;
                        continue;
                    }
                    return b;
                }
                if (this.buffer_pos == this.buffer.length - 1) {
                    this.buffer[this.buffer_pos++] = (char)b;
                    System.arraycopy(this.buffer, 0, this.insertion, 0, this.buffer_pos);
                    this.buffer_pos = 0;
                    this.insertion_pos = 0;
                    this.insertion_len = this.buffer_pos;
                    return this.insertion[this.insertion_pos++];
                }
                if (b == 59) {
                    int num;
                    this.buffer[this.buffer_pos++] = (char)b;
                    String ref = new String(this.buffer, 1, this.buffer_pos - 2).toLowerCase(Locale.US);
                    String replacement = ref.equals("amp") || ref.equals("lt") || ref.equals("gt") || ref.equals("quot") || ref.equals("apos") || ref.startsWith("#") ? new String(this.buffer, 0, this.buffer_pos) : ((num = Entities.HTML40.entityValue(ref)) != -1 ? "&#" + num + ";" : new String(this.buffer, 0, this.buffer_pos));
                    char[] chars = replacement.toCharArray();
                    System.arraycopy(chars, 0, this.insertion, 0, chars.length);
                    this.buffer_pos = 0;
                    this.insertion_pos = 0;
                    this.insertion_len = chars.length;
                    return this.insertion[this.insertion_pos++];
                }
                this.buffer[this.buffer_pos++] = (char)b;
                char c = (char)b;
                if (!Character.isLetterOrDigit(c)) break;
            }
            if (this.buffer_pos == 2 && this.buffer[0] == '&') {
                char[] chars = "&amp;".toCharArray();
                System.arraycopy(chars, 0, this.insertion, 0, chars.length);
                this.buffer_pos = 0;
                this.insertion_pos = 0;
                this.insertion_len = chars.length;
                this.insertion[this.insertion_len++] = (char)b;
                return this.insertion[this.insertion_pos++];
            }
            System.arraycopy(this.buffer, 0, this.insertion, 0, this.buffer_pos);
            this.buffer_pos = 0;
            this.insertion_pos = 0;
            this.insertion_len = this.buffer_pos;
            return this.insertion[this.insertion_pos++];
        }

        public void close() throws IOException {
            this.is.close();
        }

        public long skip(long n) throws IOException {
            int rem;
            if (this.insertion_len > 0) {
                rem = this.insertion_len - this.insertion_pos;
                System.arraycopy(this.insertion, this.insertion_pos, this.buffer, 0, rem);
                this.insertion_pos = 0;
                this.insertion_len = 0;
                this.buffer_pos = rem;
            }
            if (n <= (long)this.buffer_pos) {
                rem = this.buffer_pos - (int)n;
                System.arraycopy(this.buffer, (int)n, this.insertion, 0, rem);
                this.insertion_pos = 0;
                this.insertion_len = rem;
                return n;
            }
            int to_skip = this.buffer_pos;
            this.buffer_pos = 0;
            return this.is.skip(n - (long)to_skip) + (long)to_skip;
        }

        public int available() throws IOException {
            return this.buffer_pos + this.is.available();
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler(PrintWriter out) {
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) throws SAXException {
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message, spe);
        }
    }
}

