/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.common;

import java.util.HashMap;
import java.util.Hashtable;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.ui.common.util.LegacyHashtable;

public class ExternalUIConst {
    public static Hashtable parameterlegacy = null;
    private static boolean defaultsNotRegistered = true;

    public static void registerDefaults() {
        HashMap<String, Object> def = new HashMap<String, Object>();
        if (defaultsNotRegistered) {
            defaultsNotRegistered = false;
            def.put("Server_sName", "Azureus2 WebInterface");
            def.put("Server_sBindIP", "");
            def.put("Server_iPort", new Long(8088L));
            def.put("Server_iTimeout", new Long(10L));
            def.put("Server_sTemplate_Directory", SystemProperties.getUserPath() + "template");
            def.put("Server_iMaxHTTPConnections", new Long(5L));
            def.put("Server_iRefresh", new Long(20L));
            def.put("Server_sAllowStatic", "127.0.0.1");
            def.put("Server_sAllowDynamic", "");
            def.put("Server_iRecheckDynamic", new Long(30L));
            def.put("Server_bNoJavaScript", new Long(0L));
            def.put("Server_sAccessHost", "torrent");
            def.put("Server_bProxyEnableCookies", new Long(1L));
            def.put("Server_bProxyBlockURLs", new Long(0L));
            def.put("Server_bProxyFilterHTTP", new Long(0L));
            def.put("Server_sProxyUserAgent", "Mozilla/4.0 (compatible; MSIE 4.0; WindowsNT 5.0)");
            def.put("Server_bUseDownstreamProxy", new Long(0L));
            def.put("Server_sDownstreamProxyHost", "127.0.0.1");
            def.put("Server_iDownstreamProxyPort", new Long(0L));
            def.put("Server_bProxyGrabTorrents", new Long(1L));
            def.put("Server_sProxySuccessRedirect", "torrents");
            def.put("Server_bLogFile", new Long(0L));
            def.put("Server_sLogFile", SystemProperties.getUserPath() + "webinterface.log");
            def.put("Server_iLogLevelWebinterface", new Long(20000L));
            def.put("Server_iLogLevelCore", new Long(20000L));
            def.put("Server_iLogCount", new Long(200L));
            COConfigurationManager.registerExternalDefaults(def);
        }
    }

    static {
        parameterlegacy = new LegacyHashtable();
        parameterlegacy.put("max_up", "Max Upload Speed KBs");
        parameterlegacy.put("max_down", "Max Download Speed KBs");
        parameterlegacy.put("General_sDefaultSave_Directory", "Default save path");
        parameterlegacy.put("Core_sOverrideIP", "Override Ip");
        parameterlegacy.put("Core_iTCPListenPort", "TCP.Listen.Port");
        parameterlegacy.put("Core_iMaxActiveTorrents", "max active torrents");
        parameterlegacy.put("Core_iMaxDownloads", "max downloads");
        parameterlegacy.put("Core_iMaxUploads", "Max Uploads");
        parameterlegacy.put("Core_iMaxUploadSpeed", "Max Upload Speed KBs");
        parameterlegacy.put("Core_bUseResume", "Use Resume");
        parameterlegacy.put("Core_iSaveResumeInterval", "Save Resume Interval");
        parameterlegacy.put("Core_bIncrementalAllocate", "Enable incremental file creation");
        parameterlegacy.put("Core_bCheckPiecesOnCompletion", "Check Pieces on Completion");
        parameterlegacy.put("Core_fSeedingShareStop", "Stop Ratio");
        parameterlegacy.put("StartStopManager_bIgnoreRatioPeers", "Stop Peers Ratio");
        parameterlegacy.put("Core_iSeedingRatioStart", "Start Peers Ratio");
        parameterlegacy.put("Core_bDisconnectSeed", "Disconnect Seed");
        parameterlegacy.put("Core_bSwitchPriority", "Switch Priority");
        parameterlegacy.put("Core_bSlowConnect", "Slow Connect");
        parameterlegacy.put("Core_sPriorityExtensions", "priorityExtensions");
        parameterlegacy.put("Core_bPriorityExtensionsIgnoreCase", "priorityExtensionsIgnoreCase");
        parameterlegacy.put("Core_bIpFilterEnabled", "Ip Filter Enabled");
        parameterlegacy.put("Core_bIpFilterAllow", "Ip Filter Allow");
        parameterlegacy.put("Core_bAllowSameIPPeers", "Allow Same IP Peers");
        parameterlegacy.put("Core_bUseSuperSeeding", "Use Super Seeding");
        parameterlegacy.put("Core_iMaxPeerConnectionsPerTorrent", "Max.Peer.Connections.Per.Torrent");
        parameterlegacy.put("Core_iMaxPeerConnectionsTotal", "Max.Peer.Connections.Total");
        parameterlegacy.put("SWT_bUseCustomTab", "useCustomTab");
        parameterlegacy.put("SWT_iGUIRefresh", "GUI Refresh");
        parameterlegacy.put("SWT_iGraphicsUpdate", "Graphics Update");
        parameterlegacy.put("SWT_iReOrderDelay", "ReOrder Delay");
        parameterlegacy.put("SWT_bSendVersionInfo", "Send Version Info");
        parameterlegacy.put("SWT_bShowDownloadBasket", "Show Download Basket");
        parameterlegacy.put("SWT_bAlwaysRefreshMyTorrents", "config.style.refreshMT");
        parameterlegacy.put("SWT_bOpenDetails", "Open Details");
        parameterlegacy.put("SWT_bProgressBarColorOverride", "Colors.progressBar.override");
        parameterlegacy.put("Plugin_sConfig_Directory", "Plugin.config.directory");
        parameterlegacy.put("Plugin_bConfigEnable", "Plugin.config.enable");
        parameterlegacy.put("Plugin_iConfigIntlist", "Plugin.config.intlist");
        parameterlegacy.put("Plugin_sConfigLogfile", "Plugin.config.logfile");
        parameterlegacy.put("Plugin_sConfigNick", "Plugin.config.nick");
        parameterlegacy.put("Plugin_iConfigPortBlue", "Plugin.config.port.blue");
        parameterlegacy.put("Plugin_iConfigPortGreen", "Plugin.config.port.green");
        parameterlegacy.put("Plugin_iConfigPortRed", "Plugin.config.port.red");
        parameterlegacy.put("Plugin_iConfigPort", "Plugin.config.port");
        parameterlegacy.put("Plugin_sConfigStringlist", "Plugin.config.stringlist");
        parameterlegacy.put("Logger_bEnable", "Logging Enable");
        parameterlegacy.put("Logger_sDir_Directory", "Logging Dir");
        parameterlegacy.put("Logger_iMaxSize", "Logging Max Size");
        parameterlegacy.put("Tracker_Password_Enable", "Tracker Password Enable Web");
        parameterlegacy.put("Tracker_UserName", "Tracker Username");
        parameterlegacy.put("Tracker_Password", "Tracker Password");
        int[] logComponents = new int[]{0, 1, 2, 4};
        for (int i = 0; i < logComponents.length; ++i) {
            for (int j = 0; j <= 3; ++j) {
                parameterlegacy.put("Logger_bLog" + logComponents[i] + "-" + j, "bLog" + logComponents[i] + "-" + j);
            }
        }
    }
}

