/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.util.HashMap;
import java.util.List;
import org.gudy.azureus2.core3.util.AERunStateHandler;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.IConsoleCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunState
extends IConsoleCommand {
    public RunState() {
        super("runstate", "rs");
    }

    @Override
    public String getCommandDescriptions() {
        return "runstate\t\trs\tShows and modified the current Vuze run-state.";
    }

    @Override
    public void execute(String commandName, ConsoleInput ci, List<String> args) {
        ci.out.println("Current run state:");
        long mode = AERunStateHandler.getResourceMode();
        HashMap<String, Long> mode_map = new HashMap<String, Long>();
        mode_map.put("all", -1L);
        for (int i = 0; i < AERunStateHandler.RS_MODES.length; ++i) {
            String[] bits;
            String mode_name = AERunStateHandler.RS_MODE_NAMES[i];
            long mode_value = AERunStateHandler.RS_MODES[i];
            for (String bit : bits = mode_name.split(":")) {
                mode_map.put(bit.trim().toLowerCase(), mode_value);
            }
        }
        boolean bad = false;
        for (String arg : args) {
            String[] bits = arg.split("=");
            if (bits.length != 2) {
                bad = true;
                break;
            }
            Long this_mode = (Long)mode_map.get(bits[0].toLowerCase());
            if (this_mode == null) {
                bad = true;
                continue;
            }
            boolean on = false;
            String rhs = bits[1].toLowerCase();
            if (rhs.equals("on")) {
                on = true;
            } else if (!rhs.equals("off")) {
                bad = true;
            }
            if (bad) continue;
            mode = on ? (mode |= this_mode.longValue()) : (mode &= this_mode ^ 0xFFFFFFFFFFFFFFFFL);
            AERunStateHandler.setResourceMode(mode);
        }
        if (bad) {
            ci.out.println("> Command 'runstate': invalid parameters (example: dui=On, all=off)");
        } else {
            for (int i = 0; i < AERunStateHandler.RS_MODES.length; ++i) {
                String mode_name = AERunStateHandler.RS_MODE_NAMES[i];
                long mode_value = AERunStateHandler.RS_MODES[i];
                ci.out.println("\t" + mode_name + "=" + ((mode & mode_value) == 0L ? "Off" : "On"));
            }
        }
    }
}

