/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.multiuser.persist;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.gudy.azureus2.ui.console.UserProfile;
import org.gudy.azureus2.ui.console.multiuser.UserManager;
import org.gudy.azureus2.ui.console.multiuser.UserManagerPersister;

public class UserManagerXMLPersist
implements UserManagerPersister {
    public void doSave(OutputStream out, Map usersMap) {
        UserManager.UserManagerConfig config = new UserManager.UserManagerConfig();
        ArrayList users = new ArrayList(usersMap.values());
        config.setUsers(users);
        XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(out));
        encoder.writeObject(config);
        encoder.close();
    }

    public void doLoad(InputStream in, Map usersMap) {
        XMLDecoder decoder = new XMLDecoder(in);
        UserManager.UserManagerConfig managerConfig = (UserManager.UserManagerConfig)decoder.readObject();
        for (UserProfile user : managerConfig.getUsers()) {
            usersMap.put(user.getUsername().toLowerCase(), user);
        }
        System.out.println("UserManager: registered " + usersMap.size() + " users");
        decoder.close();
    }
}

