/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.launcher.Launcher;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.StartServer;
import org.gudy.azureus2.ui.swt.StartSocket;

public class Main {
    private static final LogIDs LOGID = LogIDs.GUI;
    public static final String PR_MULTI_INSTANCE = "MULTI_INSTANCE";
    StartServer startServer;
    public static long startTime = System.currentTimeMillis();

    public Main(String[] args) {
        try {
            if (Launcher.checkAndLaunch(Main.class, args)) {
                return;
            }
            COConfigurationManager.preInitialise();
            Constructor<?> constructor = null;
            try {
                Class<?> az3Class = Class.forName("com.aelitis.azureus.ui.swt.Initializer");
                constructor = az3Class.getConstructor(AzureusCore.class, StartServer.class, String[].class);
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println(cnfe.toString() + "\nDid you include the azureus3 module?");
                return;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
            String mi_str = System.getProperty(PR_MULTI_INSTANCE);
            boolean mi = mi_str != null && mi_str.equalsIgnoreCase("true");
            this.startServer = new StartServer();
            boolean debugGUI = Boolean.getBoolean("debug");
            if (mi || debugGUI) {
                AzureusCore core = AzureusCoreFactory.create();
                constructor.newInstance(core, this.startServer, args);
                return;
            }
            if (Main.processParams(args, this.startServer)) {
                AzureusCore core = AzureusCoreFactory.create();
                this.startServer.pollForConnections(core);
                constructor.newInstance(core, this.startServer, args);
            }
        }
        catch (AzureusCoreException e) {
            Logger.log(new LogEvent(LOGID, "Start failed", e));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static boolean processParams(String[] args, StartServer startServer) {
        StartSocket ss;
        boolean another_instance;
        boolean closedown = false;
        boolean bl = another_instance = startServer.getState() != 1;
        if (another_instance) {
            System.setProperty("transitory.startup", "1");
        }
        for (int i = 0; i < args.length; ++i) {
            byte[] hash;
            String arg = args[i];
            if (arg.equalsIgnoreCase("--closedown") || arg.equalsIgnoreCase("--shutdown") || arg.equalsIgnoreCase("--restart")) {
                closedown = true;
                break;
            }
            if (arg.equalsIgnoreCase("--open")) continue;
            String filename = arg;
            if (filename.length() == 40) {
                hash = null;
                try {
                    hash = ByteFormatter.decodeString(filename);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (hash != null && hash.length == 20) {
                    filename = "magnet:?xt=urn:btih:" + Base32.encode(hash);
                }
            }
            if (filename.length() == 32) {
                hash = null;
                try {
                    hash = Base32.decode(filename);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (hash != null && hash.length == 20) {
                    filename = "magnet:?xt=urn:btih:" + filename;
                }
            }
            if (filename.toUpperCase().startsWith("HTTP:") || filename.toUpperCase().startsWith("HTTPS:") || filename.toUpperCase().startsWith("MAGNET:") || filename.toUpperCase().startsWith("MAGGOT:") || filename.toUpperCase().startsWith("BC:") || filename.toUpperCase().startsWith("BCTP:") || filename.toUpperCase().startsWith("DHT:")) {
                if (another_instance) continue;
                Logger.log(new LogEvent(LOGID, "Main::main: args[" + i + "] handling as a URI: " + filename));
                continue;
            }
            try {
                File file = new File(filename);
                if (!file.exists()) {
                    throw new Exception("File '" + file + "' not found");
                }
                args[i] = file.getCanonicalPath();
                if (another_instance || !Logger.isEnabled()) continue;
                Logger.log(new LogEvent(LOGID, "Main::main: args[" + i + "] exists = " + new File(filename).exists()));
                continue;
            }
            catch (Throwable e) {
                if (another_instance) {
                    e.printStackTrace();
                    continue;
                }
                Logger.log(new LogAlert(true, 3, "Failed to access torrent file '" + filename + "'. Ensure sufficient temporary " + "file space available (check browser cache usage)."));
            }
        }
        if (another_instance && !(ss = new StartSocket(args = Main.CocoaMagic(args))).sendArgs()) {
            another_instance = false;
            String msg = "There appears to be another program process already listening on socket [127.0.0.1: " + Constants.INSTANCE_PORT + "].\nLoading of torrents via command line parameter will fail until this is fixed.";
            System.out.println(msg);
            Logger.log(new LogAlert(true, 1, msg));
        }
        if (!another_instance) {
            return !closedown;
        }
        return false;
    }

    private static String[] CocoaMagic(String[] args) {
        if (!Constants.isOSX) {
            return args;
        }
        try {
            System.setProperty("osxaccess.light", "1");
            Class<?> claOSXAccess = Class.forName("org.gudy.azureus2.platform.macosx.access.jnilib.OSXAccess");
            if (claOSXAccess != null) {
                Method method = claOSXAccess.getMethod("runLight", String[].class);
                Object invoke = method.invoke(null, new Object[]{args});
                return (String[])invoke;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return args;
    }

    public static void main(String[] args) {
        if (Launcher.checkAndLaunch(Main.class, args)) {
            return;
        }
        if (System.getProperty("ui.temp") == null) {
            System.setProperty("ui.temp", "az2");
        }
        new Main(args);
    }
}

