/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.ui.swt.UISwitcherListener;

public class UISwitcherUtil {
    private static final long UPTIME_NEWUSER = 3600L;
    private static ArrayList listeners = new ArrayList();
    private static String switchedToUI = null;

    public static void addListener(UISwitcherListener l) {
        listeners.add(l);
        if (switchedToUI != null) {
            UISwitcherUtil.triggerListeners(switchedToUI);
        }
    }

    public static void removeListener(UISwitcherListener l) {
        listeners.remove(l);
    }

    public static void openSwitcherWindow() {
        UISwitcherUtil._openSwitcherWindow();
    }

    public static void triggerListeners(String ui) {
        Object[] array = listeners.toArray();
        for (int i = 0; i < array.length; ++i) {
            UISwitcherListener l = (UISwitcherListener)array[i];
            l.uiSwitched(ui);
        }
    }

    public static String calcUIMode() {
        if ("1".equals(System.getProperty("azureus.safemode"))) {
            return "az2";
        }
        String lastUI = COConfigurationManager.getStringParameter("ui", "az2");
        COConfigurationManager.setParameter("lastUI", lastUI);
        String forceUI = System.getProperty("force.ui");
        if (forceUI != null) {
            COConfigurationManager.setParameter("ui", forceUI);
            return forceUI;
        }
        boolean installLogExists = FileUtil.getApplicationFile("installer.log").exists();
        boolean alreadySwitched = COConfigurationManager.getBooleanParameter("installer.ui.alreadySwitched", false);
        if (!alreadySwitched && installLogExists) {
            COConfigurationManager.setParameter("installer.ui.alreadySwitched", true);
            COConfigurationManager.setParameter("ui", "az3");
            COConfigurationManager.setParameter("az3.virgin.switch", true);
            return "az3";
        }
        boolean asked = COConfigurationManager.getBooleanParameter("ui.asked", false);
        if (asked || COConfigurationManager.hasParameter("ui", true)) {
            return COConfigurationManager.getStringParameter("ui", "az3");
        }
        String sFirstVersion = COConfigurationManager.getStringParameter("First Recorded Version");
        if (Constants.compareVersions(sFirstVersion, "3.0.0.0") >= 0) {
            COConfigurationManager.setParameter("ui", "az3");
            return "az3";
        }
        try {
            Map overallMap;
            Map map = FileUtil.readResilientConfigFile("azureus.statistics");
            if (map != null && (overallMap = (Map)map.get("all")) != null) {
                long uptime = 0L;
                Object uptimeObject = overallMap.get("uptime");
                if (uptimeObject instanceof Number) {
                    uptime = ((Number)uptimeObject).longValue();
                }
                if (uptime < 3600L && uptime >= 0L) {
                    COConfigurationManager.setParameter("ui", "az3");
                    COConfigurationManager.setParameter("az3.virgin.switch", true);
                    COConfigurationManager.setParameter("az3.switch.immediate", true);
                    return "az3";
                }
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        COConfigurationManager.setParameter("ui", "az2");
        return "az2";
    }

    public static void _openSwitcherWindow() {
        Class<?> uiswClass = null;
        try {
            uiswClass = Class.forName("com.aelitis.azureus.ui.swt.shells.uiswitcher.UISwitcherWindow");
        }
        catch (ClassNotFoundException e1) {
            // empty catch block
        }
        if (uiswClass == null) {
            return;
        }
        try {
            Constructor<?> constructor = uiswClass.getConstructor(new Class[0]);
            Object object = constructor.newInstance(new Object[0]);
            Method method = uiswClass.getMethod("open", new Class[0]);
            method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }
}

