/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import com.aelitis.azureus.ui.swt.utils.ColorCache2;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;
import org.gudy.azureus2.ui.swt.components.InPaintInfo;
import org.gudy.azureus2.ui.swt.views.table.TableOrTreeSWT;

public abstract class BufferedTableItemImpl
implements BufferedTableItem {
    protected BufferedTableRow row;
    private int position;
    private ColorCache2.CachedColor ourFGColor_cache = null;
    private String text = "";
    private Image icon = null;
    private AERunnable runnableDirtyCell;
    private boolean isDirty;

    public BufferedTableItemImpl(BufferedTableRow row, int position) {
        this.row = row;
        this.position = position;
    }

    public String getText() {
        return this.text;
    }

    public boolean setText(String text) {
        if (this.text.equals(text)) {
            return false;
        }
        this.text = text == null ? "" : text;
        this.redraw();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redraw() {
        BufferedTableItemImpl bufferedTableItemImpl = this;
        synchronized (bufferedTableItemImpl) {
            if (this.isDirty) {
                return;
            }
        }
        if (!this.row.isVisibleNoSWT()) {
            return;
        }
        if (this.runnableDirtyCell == null) {
            bufferedTableItemImpl = this;
            synchronized (bufferedTableItemImpl) {
                if (this.runnableDirtyCell == null) {
                    this.runnableDirtyCell = new AERunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void runSupport() {
                            TableOrTreeSWT table;
                            Rectangle dirty;
                            BufferedTableItemImpl bufferedTableItemImpl = BufferedTableItemImpl.this;
                            synchronized (bufferedTableItemImpl) {
                                BufferedTableItemImpl.this.isDirty = false;
                            }
                            if (BufferedTableItemImpl.this.isInPaintItem() && BufferedTableItemImpl.this.row.getTable().getData("fullPaint") == Boolean.TRUE) {
                                return;
                            }
                            Rectangle bounds = BufferedTableItemImpl.this.getBoundsRaw();
                            if (bounds != null && !(dirty = (table = BufferedTableItemImpl.this.row.getTable()).getClientArea().intersection(bounds)).isEmpty()) {
                                BufferedTableItemImpl.this.quickRedrawCell(table, dirty, bounds);
                            }
                        }
                    };
                }
            }
        }
        bufferedTableItemImpl = this;
        synchronized (bufferedTableItemImpl) {
            this.isDirty = true;
        }
        Utils.execSWTThread(this.runnableDirtyCell);
    }

    protected void quickRedrawCell(TableOrTreeSWT table, Rectangle dirty, Rectangle cellBounds) {
        table.redraw(dirty.x, dirty.y, dirty.width, dirty.height, false);
    }

    public void setIcon(Image img) {
        if (this.position != -1) {
            this.row.setImage(this.position, img);
            this.icon = img;
        }
    }

    public Image getIcon() {
        if (this.position != -1) {
            Image image = this.row.getImage(this.position);
            return image != null ? image : this.icon;
        }
        return null;
    }

    public void setRowForeground(Color color) {
        this.row.setForeground(color);
    }

    public boolean setForeground(Color color) {
        if (this.position == -1) {
            return false;
        }
        boolean ok = this.row.setForeground(this.position, color);
        if (ok && this.ourFGColor_cache != null) {
            if (!this.ourFGColor_cache.isDisposed()) {
                this.ourFGColor_cache.dispose();
            }
            this.ourFGColor_cache = null;
        }
        return ok;
    }

    public Color getForeground() {
        if (this.position == -1) {
            return null;
        }
        return this.row.getForeground(this.position);
    }

    public boolean setForeground(final int red, final int green, final int blue) {
        if (this.position == -1) {
            return false;
        }
        Color oldColor = this.row.getForeground(this.position);
        if (oldColor != null) {
            RGB newRGB = new RGB(red, green, blue);
            if (oldColor.getRGB().equals((Object)newRGB)) {
                return false;
            }
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                BufferedTableItemImpl.this.swt_setForeground(red, green, blue);
            }
        });
        return true;
    }

    private boolean swt_setForeground(int red, int green, int blue) {
        if (red == -1 && green == -1 && blue == -1) {
            return this.setForeground(null);
        }
        Color oldColor = this.row.getForeground(this.position);
        RGB newRGB = new RGB(red, green, blue);
        if (oldColor != null && oldColor.getRGB().equals((Object)newRGB)) {
            return false;
        }
        ColorCache2.CachedColor newColor = ColorCache2.getColor((Device)this.row.getTable().getDisplay(), newRGB);
        boolean ok = this.row.setForeground(this.position, newColor.getColor());
        if (ok) {
            if (this.ourFGColor_cache != null && !this.ourFGColor_cache.isDisposed()) {
                this.ourFGColor_cache.dispose();
            }
            this.ourFGColor_cache = newColor;
        } else if (!newColor.isDisposed()) {
            newColor.dispose();
        }
        return ok;
    }

    public Color getBackground() {
        return this.row.getBackground();
    }

    public Rectangle getBounds() {
        if (this.position == -1) {
            return null;
        }
        if (this.isInPaintItem()) {
            InPaintInfo data = (InPaintInfo)this.row.getTable().getData("inPaintInfo");
            return new Rectangle(data.curCellBounds.x, data.curCellBounds.y, data.curCellBounds.width, data.curCellBounds.height);
        }
        return this.row.getBounds(this.position);
    }

    public Rectangle getBoundsRaw() {
        return this.getBounds();
    }

    public TableOrTreeSWT getTable() {
        return this.row.getTable();
    }

    public void dispose() {
        if (this.ourFGColor_cache != null && !this.ourFGColor_cache.isDisposed()) {
            this.ourFGColor_cache.dispose();
        }
    }

    public boolean isShown() {
        return true;
    }

    public boolean needsPainting() {
        return false;
    }

    public void locationChanged() {
    }

    public int getPosition() {
        return this.position;
    }

    public Image getBackgroundImage() {
        TableOrTreeSWT table = this.row.getTable();
        Rectangle bounds = this.getBounds();
        if (bounds.isEmpty()) {
            return null;
        }
        Image image = new Image((Device)table.getDisplay(), bounds.width, bounds.height);
        GC gc = new GC((Drawable)image);
        gc.setForeground(this.getBackground());
        gc.setBackground(this.getBackground());
        gc.fillRectangle(0, 0, bounds.width, bounds.height);
        gc.dispose();
        return image;
    }

    public int getMaxLines() {
        return 1;
    }

    public void setCursor(final int cursorID) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (BufferedTableItemImpl.this.row == null) {
                    return;
                }
                TableOrTreeSWT table = BufferedTableItemImpl.this.row.getTable();
                if (table == null || table.isDisposed()) {
                    return;
                }
                table.setCursor(table.getDisplay().getSystemCursor(cursorID));
            }
        });
    }

    public boolean isMouseOver() {
        TableOrTreeSWT table = this.row.getTable();
        if (table == null || table.isDisposed()) {
            return false;
        }
        Point pt = table.getDisplay().getCursorLocation();
        pt = table.toControl(pt);
        Rectangle bounds = this.getBounds();
        return bounds == null ? false : bounds.contains(pt);
    }

    public boolean isInPaintItem() {
        if (this.row.inPaintItem()) {
            InPaintInfo data = (InPaintInfo)this.row.getTable().getData("inPaintInfo");
            return data.curCellIndex == this.position;
        }
        return false;
    }

    public int getHeight() {
        return this.row.getHeight();
    }
}

