/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import com.aelitis.azureus.ui.swt.utils.ColorCache2;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.InPaintInfo;
import org.gudy.azureus2.ui.swt.views.table.TableItemOrTreeItem;
import org.gudy.azureus2.ui.swt.views.table.TableOrTreeSWT;

public class BufferedTableRow {
    private static final int VALUE_SIZE_INC = 8;
    public static final int REQUIRE_TABLEITEM = 0;
    public static final int REQUIRE_TABLEITEM_INITIALIZED = 1;
    public static final int REQUIRE_VISIBILITY = 2;
    protected TableOrTreeSWT table;
    protected TableItemOrTreeItem item;
    protected Image[] image_values = new Image[0];
    protected Color[] foreground_colors = new Color[0];
    protected ColorCache2.CachedColor foreground_cache;
    protected ColorCache2.CachedColor ourForeground_cache;
    private Point ptIconSize = null;
    private Image imageBG;
    private int numSubItems;
    private boolean expanded;
    private boolean isVirtual;

    public BufferedTableRow(TableOrTreeSWT _table) {
        this.table = _table;
        this.item = null;
    }

    public void dispose() {
        if (this.table != null && !this.table.isDisposed() && Utils.isThisThreadSWT()) {
            boolean itemNeedsDisposal;
            if (!this.checkWidget(0)) {
                TableItemOrTreeItem[] items = this.table.getItems();
                for (int i = items.length - 1; i >= 0; --i) {
                    Object itemRow;
                    TableItemOrTreeItem item = items[i];
                    if (item.isDisposed() || (itemRow = item.getData("TableRow")) != null && itemRow != this) continue;
                    this.item = item;
                    break;
                }
            }
            boolean bl = itemNeedsDisposal = this.item != null && !this.item.isDisposed();
            if (this.ourForeground_cache != null && !this.ourForeground_cache.isDisposed()) {
                if (itemNeedsDisposal) {
                    this.item.setForeground(null);
                }
                this.ourForeground_cache.dispose();
            }
            if (itemNeedsDisposal) {
                this.item.dispose();
            } else if (this.table.getItemCount() > 0) {
                System.err.println("No table row was found to dispose");
            }
        } else if (!Utils.isThisThreadSWT()) {
            System.err.println("Calling BufferedTableRow.dispose on non-SWT thread!");
            System.err.println(Debug.getStackTrace(false, false));
        }
        this.item = null;
    }

    public void setImage(int index, Image new_image) {
        Image image;
        if (!this.checkWidget(1)) {
            return;
        }
        if (index >= this.image_values.length) {
            int new_size = Math.max(index + 1, this.image_values.length + 8);
            Image[] new_images = new Image[new_size];
            System.arraycopy(this.image_values, 0, new_images, 0, this.image_values.length);
            this.image_values = new_images;
        }
        if (new_image == (image = this.image_values[index])) {
            return;
        }
        this.image_values[index] = new_image;
        this.item.setImage(index, new_image);
    }

    public Image getImage(int index) {
        if (!this.checkWidget(1)) {
            return null;
        }
        return this.item.getImage(index);
    }

    public boolean checkWidget(int checkFlags) {
        boolean bCheckInitialized;
        boolean bWidgetOk = this.item != null && !this.item.isDisposed() && this.item.getData("TableRow") == this;
        boolean bCheckVisibility = (checkFlags & 2) > 0;
        boolean bl = bCheckInitialized = (checkFlags & 1) > 0;
        if (bWidgetOk && bCheckInitialized) {
            boolean bl2 = bWidgetOk = !this.isVirtual || this.item.getData("SD") != null;
        }
        if (bWidgetOk && bCheckVisibility) {
            if (this._isVisible()) {
                if (!bCheckInitialized && this.isVirtual && this.item.getData("SD") == null) {
                    try {
                        this.item.setData("SD", "1");
                    }
                    catch (NullPointerException badSWT) {
                        // empty catch block
                    }
                    this.setIconSize(this.ptIconSize);
                    this.invalidate();
                }
            } else {
                bWidgetOk = false;
            }
        }
        return bWidgetOk;
    }

    private boolean _isVisible() {
        if (this.inPaintItem()) {
            return true;
        }
        if (!this.table.isVisible()) {
            return false;
        }
        Rectangle bounds = this.getBounds(0);
        if (bounds == null) {
            return false;
        }
        return this.table.getClientArea().contains(bounds.x, bounds.y);
    }

    public Color getForeground() {
        if (this.foreground_cache != null) {
            return this.foreground_cache.getColor();
        }
        if (!Utils.isSWTThread()) {
            return null;
        }
        if (this.foreground_cache == null && this.isSelected()) {
            return this.table.getDisplay().getSystemColor(27);
        }
        if (!this.checkWidget(0)) {
            return null;
        }
        return this.item.getForeground();
    }

    public boolean setForeground(Color c) {
        Color existing;
        if (this.foreground_cache == null && c == null) {
            return false;
        }
        if (this.foreground_cache != null && (existing = this.foreground_cache.getColor()) != null && existing.equals((Object)c)) {
            return false;
        }
        this.foreground_cache = ColorCache2.getColor(c);
        if (this.ourForeground_cache != null) {
            if (!this.ourForeground_cache.isDisposed()) {
                this.ourForeground_cache.dispose();
            }
            this.ourForeground_cache = null;
        }
        if (!this.checkWidget(1)) {
            return false;
        }
        this.item.setForeground(c);
        return true;
    }

    public void setForeground(final int red, final int green, final int blue) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                BufferedTableRow.this.swt_setForeground(red, green, blue);
            }
        });
    }

    public void swt_setForeground(int red, int green, int blue) {
        Color c;
        if (red == -1 && green == -1 && blue == -1) {
            this.setForeground(null);
            return;
        }
        RGB newRGB = new RGB(red, green, blue);
        if (this.foreground_cache != null && (c = this.foreground_cache.getColor()) != null && c.getRGB().equals((Object)newRGB)) {
            return;
        }
        ColorCache2.CachedColor newColor = ColorCache2.getColor((Device)this.getTable().getDisplay(), newRGB);
        if (this.checkWidget(1)) {
            this.item.setForeground(newColor.getColor());
        }
        if (this.ourForeground_cache != null && !this.ourForeground_cache.isDisposed()) {
            this.ourForeground_cache.dispose();
        }
        this.foreground_cache = newColor;
        this.ourForeground_cache = newColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setForeground(final int index, final Color new_color) {
        BufferedTableRow bufferedTableRow = this;
        synchronized (bufferedTableRow) {
            Color value;
            if (index >= this.foreground_colors.length) {
                int new_size = Math.max(index + 1, this.foreground_colors.length + 8);
                Color[] new_colors = new Color[new_size];
                System.arraycopy(this.foreground_colors, 0, new_colors, 0, this.foreground_colors.length);
                this.foreground_colors = new_colors;
            }
            if (new_color == (value = this.foreground_colors[index])) {
                return false;
            }
            if (new_color != null && value != null && new_color.equals((Object)value)) {
                return false;
            }
            this.foreground_colors[index] = new_color;
        }
        if (!this.checkWidget(1)) {
            return true;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (!BufferedTableRow.this.item.isDisposed()) {
                    BufferedTableRow.this.item.setForeground(index, new_color);
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getForeground(int index) {
        BufferedTableRow bufferedTableRow = this;
        synchronized (bufferedTableRow) {
            if (index >= this.foreground_colors.length) {
                return this.getForeground();
            }
            if (this.foreground_colors[index] == null) {
                if (this.isSelected()) {
                    if (!Utils.isSWTThread()) {
                        return null;
                    }
                    Color systemColor = this.table.getDisplay().getSystemColor(this.table.isFocusControl() ? 27 : 21);
                    return systemColor;
                }
                return this.getForeground();
            }
            return this.foreground_colors[index];
        }
    }

    protected String getText(int index) {
        if (!this.checkWidget(1)) {
            return "";
        }
        return this.item.getText(index);
    }

    public boolean setText(int index, String new_value) {
        if (!this.checkWidget(1)) {
            return false;
        }
        if (index < 0 || index >= this.table.getColumnCount()) {
            return false;
        }
        if (new_value == null) {
            new_value = "";
        }
        if (this.item.getText(index).equals(new_value)) {
            return false;
        }
        this.item.setText(index, new_value);
        return true;
    }

    public Rectangle getBounds(int index) {
        if (!this.checkWidget(1)) {
            return null;
        }
        Rectangle r = this.item.getBounds(index);
        if (r == null || r.width == 0 || r.height == 0) {
            return null;
        }
        return r;
    }

    protected TableOrTreeSWT getTable() {
        return this.table;
    }

    public Color getBackground() {
        if (!this.checkWidget(1)) {
            return null;
        }
        if (this.isSelected()) {
            return this.table.getDisplay().getSystemColor(this.table.isFocusControl() ? 26 : 22);
        }
        return this.item.getBackground();
    }

    public int getIndex() {
        if (!this.checkWidget(0)) {
            return -1;
        }
        return this.table.indexOf(this.item);
    }

    public boolean isSelected() {
        if (!this.checkWidget(0)) {
            return false;
        }
        return this.table.isSelected(this.item);
    }

    public void setSelected(final boolean bSelected) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                BufferedTableRow.this.swt_setSelected(bSelected);
            }
        });
    }

    private void swt_setSelected(boolean bSelected) {
        if (!this.checkWidget(0)) {
            return;
        }
        if (bSelected) {
            this.table.select(this.item);
        } else {
            this.table.deselect(this.item);
        }
    }

    public boolean setTableItem(int newIndex, boolean isVisible) {
        TableItemOrTreeItem newRow;
        try {
            newRow = this.table.getItem(newIndex);
        }
        catch (IllegalArgumentException er) {
            if (this.item == null || this.item.isDisposed()) {
                return false;
            }
            this.item = null;
            return true;
        }
        catch (Throwable e) {
            System.out.println("setTableItem(" + newIndex + ", " + isVisible + ")");
            e.printStackTrace();
            return false;
        }
        return this.setTableItem(newRow, isVisible);
    }

    public boolean setTableItem(TableItemOrTreeItem newRow, boolean isVisible) {
        boolean lastItemExisted;
        block12: {
            if (this.item == null) {
                boolean bl = this.isVirtual = (this.table.getStyle() & 0x10000000) != 0;
                if (this.ptIconSize == null) {
                    this.ptIconSize = new Point(1, this.table.getItemHeight());
                }
            }
            if (newRow.isDisposed()) {
                Debug.out("newRow disposed from " + Debug.getCompressedStackTrace());
                return false;
            }
            if (newRow.equals(this.item) && newRow.getData("TableRow") == this) {
                return false;
            }
            boolean bl = lastItemExisted = this.item != null && !this.item.isDisposed();
            if (newRow.getData("SD") == null) {
                newRow.setData("SD", "1");
                this.setIconSize(this.ptIconSize);
            }
            newRow.setForeground(this.foreground_cache == null ? null : this.foreground_cache.getColor());
            int numColumns = this.table.getColumnCount();
            for (int i = 0; i < numColumns; ++i) {
                try {
                    newRow.setForeground(i, i < this.foreground_colors.length ? this.foreground_colors[i] : null);
                    continue;
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
            }
            try {
                newRow.setData("TableRow", this);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Disposed? " + newRow.isDisposed());
                if (newRow.isDisposed()) break block12;
                System.out.println("TR? " + newRow.getData("TableRow"));
                System.out.println("SD? " + newRow.getData("SD"));
            }
        }
        this.image_values = new Image[0];
        if (lastItemExisted && this.item.getData("TableRow") == this && !newRow.equals(this.item)) {
            this.item.setData("TableRow", null);
            this.table.deselect(this.item);
        }
        this.item = newRow;
        this.setSubItemCount(this.numSubItems);
        this.item.setExpanded(this.expanded);
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                if (BufferedTableRow.this.table.isDisposed() || BufferedTableRow.this.item == null) {
                    return;
                }
                if (BufferedTableRow.this.item.isDisposed() || BufferedTableRow.this.item.getData("TableRow") != BufferedTableRow.this) {
                    return;
                }
                if (BufferedTableRow.this.isSelected()) {
                    BufferedTableRow.this.table.select(BufferedTableRow.this.item);
                } else {
                    BufferedTableRow.this.table.deselect(BufferedTableRow.this.item);
                }
            }
        });
        if (isVisible && !this.inPaintItem()) {
            Rectangle r = this.item.getBounds(0);
            this.table.redraw(0, r.y, this.table.getClientArea().width, r.height, true);
        }
        return true;
    }

    public boolean setHeight(int iHeight) {
        return this.setIconSize(new Point(1, iHeight));
    }

    public int getHeight() {
        return this.ptIconSize == null ? 0 : this.ptIconSize.y;
    }

    public boolean setIconSize(Point pt) {
        this.ptIconSize = pt;
        if (pt == null || this.item == null) {
            return false;
        }
        if (!this.checkWidget(1)) {
            return false;
        }
        Image oldImage = this.item.getImage(0);
        if (oldImage != null) {
            Rectangle r = oldImage.getBounds();
            if (r.width == pt.x && r.height == pt.y) {
                return false;
            }
        }
        Image image = new Image((Device)this.item.getDisplay(), pt.x, pt.y);
        this.item.setImage(0, image);
        this.item.setImage(0, null);
        image.dispose();
        return true;
    }

    public boolean isVisible() {
        return this.checkWidget(2);
    }

    public void invalidate() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (!BufferedTableRow.this.checkWidget(3)) {
                    return;
                }
                Rectangle r = BufferedTableRow.this.item.getBounds(0);
                BufferedTableRow.this.table.redraw(0, r.y, BufferedTableRow.this.table.getClientArea().width, r.height, true);
            }
        });
    }

    public void setBackgroundImage(Image image) {
        if (this.imageBG != null && !this.imageBG.isDisposed()) {
            this.imageBG.dispose();
        }
        this.imageBG = image;
    }

    public Image getBackgroundImage() {
        return this.imageBG;
    }

    public void setSubItemCount(int i) {
        this.numSubItems = i;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (BufferedTableRow.this.item != null && !BufferedTableRow.this.item.isDisposed()) {
                    BufferedTableRow.this.item.setItemCount(BufferedTableRow.this.numSubItems == 0 ? 0 : 1);
                }
            }
        });
    }

    public int getSubItemCount() {
        return this.numSubItems;
    }

    public TableItemOrTreeItem[] getSubItems() {
        return this.table.getItems();
    }

    public void setExpanded(boolean b) {
        this.expanded = b;
        if (this.item != null && !this.item.isDisposed()) {
            TableItemOrTreeItem[] items;
            if (this.item.getItemCount() != this.numSubItems) {
                this.item.setItemCount(this.numSubItems);
                Rectangle r = this.item.getBounds(0);
                if (r != null) {
                    this.table.redraw(0, r.y, this.table.getClientArea().width, r.height, true);
                }
            }
            for (TableItemOrTreeItem subItem : items = this.item.getItems()) {
                subItem.setData("TableRow", null);
            }
            this.item.setExpanded(b);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean inPaintItem() {
        InPaintInfo info;
        return this.item != null && !this.item.isDisposed() && (info = (InPaintInfo)this.table.getData("inPaintInfo")) != null && this.item.getItem().equals(info.item);
    }

    public boolean isVisibleNoSWT() {
        return true;
    }

    public TableItemOrTreeItem getItem() {
        return this.item;
    }
}

