/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.graphics;

import java.util.HashSet;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.graphics.Scale;
import org.gudy.azureus2.ui.swt.components.graphics.ScaledGraphic;
import org.gudy.azureus2.ui.swt.components.graphics.ValueFormater;
import org.gudy.azureus2.ui.swt.components.graphics.ValueSource;

public class MultiPlotGraphic
extends ScaledGraphic
implements ParameterListener {
    private static final int DEFAULT_ENTRIES = 2000;
    private ValueSource[] value_sources;
    private int internalLoop;
    private int graphicsUpdate;
    private Point oldSize;
    private Image bufferImage;
    private int nbValues = 0;
    private int maxEntries = 2000;
    private int[][] all_values;
    private int currentPosition = 0;
    private boolean update_outstanding = false;
    private TimerEventPeriodic update_event;

    public static MultiPlotGraphic getInstance(ValueSource[] sources, ValueFormater formatter) {
        return new MultiPlotGraphic(new Scale(), sources, formatter);
    }

    private MultiPlotGraphic(Scale scale, ValueSource[] sources, ValueFormater formater) {
        super(scale, formater);
        this.value_sources = sources;
        this.init(null);
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Graphics Update", "Stats Graph Dividers"}, this);
    }

    private void init(int[][] history) {
        this.nbValues = 0;
        this.maxEntries = 2000;
        this.all_values = new int[this.value_sources.length][this.maxEntries];
        this.currentPosition = 0;
        if (history != null) {
            if (history.length != this.value_sources.length) {
                Debug.out("Incompatible history records, ignored");
            } else {
                if (history.length > 0) {
                    int offset;
                    int history_entries = history[0].length;
                    for (int i = offset = Math.max(history_entries - this.maxEntries, 0); i < history_entries; ++i) {
                        for (int j = 0; j < history.length; ++j) {
                            this.all_values[j][this.nbValues] = history[j][i];
                        }
                        ++this.nbValues;
                    }
                }
                this.currentPosition = this.nbValues;
            }
        }
        this.update_outstanding = true;
    }

    public void initialize(Canvas canvas) {
        this.initialize(canvas, true);
    }

    public void initialize(Canvas canvas, boolean is_active) {
        super.initialize(canvas);
        this.drawCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (MultiPlotGraphic.this.bufferImage != null && !MultiPlotGraphic.this.bufferImage.isDisposed()) {
                    Rectangle bounds = MultiPlotGraphic.this.bufferImage.getBounds();
                    if (bounds.width >= e.width && bounds.height >= e.height) {
                        e.gc.drawImage(MultiPlotGraphic.this.bufferImage, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
                    }
                }
            }
        });
        this.drawCanvas.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                MultiPlotGraphic.this.drawChart(true);
            }
        });
        this.setActive(is_active);
    }

    public void setActive(boolean active) {
        if (active) {
            if (this.update_event != null) {
                return;
            }
            this.update_event = SimpleTimer.addPeriodicEvent("MPG:updater", 1000L, new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    if (MultiPlotGraphic.this.drawCanvas.isDisposed()) {
                        if (MultiPlotGraphic.this.update_event != null) {
                            MultiPlotGraphic.this.update_event.cancel();
                            MultiPlotGraphic.this.update_event = null;
                        }
                    } else {
                        int[] new_values = new int[MultiPlotGraphic.this.value_sources.length];
                        for (int i = 0; i < new_values.length; ++i) {
                            new_values[i] = MultiPlotGraphic.this.value_sources[i].getValue();
                        }
                        MultiPlotGraphic.this.addIntsValue(new_values);
                    }
                }
            });
        } else if (this.update_event != null) {
            this.update_event.cancel();
            this.update_event = null;
        }
    }

    public void reset(int[][] history) {
        this.init(history);
        Utils.execSWTThread(new Runnable(){

            public void run() {
                MultiPlotGraphic.this.refresh(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIntsValue(int[] new_values) {
        try {
            this.this_mon.enter();
            if (this.all_values.length < new_values.length) {
                int i;
                int[][] new_all_values = new int[new_values.length][];
                for (i = 0; i < this.all_values.length; ++i) {
                    new_all_values[i] = this.all_values[i];
                }
                for (i = this.all_values.length; i < new_all_values.length; ++i) {
                    new_all_values[i] = new int[this.maxEntries];
                }
                this.all_values = new_all_values;
            }
            for (int i = 0; i < new_values.length; ++i) {
                this.all_values[i][this.currentPosition] = new_values[i];
            }
            ++this.currentPosition;
            if (this.nbValues < this.maxEntries) {
                ++this.nbValues;
            }
            this.currentPosition %= this.maxEntries;
            Object var5_5 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
        if (this.update_outstanding) {
            this.update_outstanding = false;
            Utils.execSWTThread(new Runnable(){

                public void run() {
                    MultiPlotGraphic.this.refresh(true);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean force) {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed()) {
            return;
        }
        Rectangle bounds = this.drawCanvas.getClientArea();
        if (bounds.height < 30 || bounds.width < 100 || bounds.width > 10000 || bounds.height > 10000) {
            return;
        }
        if (bounds.width > this.maxEntries) {
            try {
                this.this_mon.enter();
                while (this.maxEntries < bounds.width) {
                    this.maxEntries += 1000;
                }
                for (int i = 0; i < this.all_values.length; ++i) {
                    int[] newValues = new int[this.maxEntries];
                    System.arraycopy(this.all_values[i], 0, newValues, 0, this.all_values[i].length);
                    this.all_values[i] = newValues;
                }
                Object var6_5 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        boolean sizeChanged = this.oldSize == null || this.oldSize.x != bounds.width || this.oldSize.y != bounds.height;
        this.oldSize = new Point(bounds.width, bounds.height);
        ++this.internalLoop;
        if (this.internalLoop > this.graphicsUpdate) {
            this.internalLoop = 0;
        }
        if (this.internalLoop == 0 || sizeChanged || force) {
            this.drawChart(sizeChanged);
            if (force) {
                this.drawChart(true);
            }
        }
        this.drawCanvas.redraw();
        this.drawCanvas.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void drawChart(boolean sizeChanged) {
        GC gcImage;
        block45: {
            block44: {
                block42: {
                    block43: {
                        if (this.drawCanvas == null) return;
                        if (this.drawCanvas.isDisposed()) return;
                        if (!this.drawCanvas.isVisible()) {
                            return;
                        }
                        gcImage = null;
                        try {
                            try {
                                block47: {
                                    block46: {
                                        this.this_mon.enter();
                                        this.drawScale(sizeChanged);
                                        if (this.bufferScale == null) break block46;
                                        if (!this.bufferScale.isDisposed()) break block47;
                                    }
                                    Object var31_3 = null;
                                    if (gcImage == null) break block42;
                                    break block43;
                                }
                                Rectangle bounds = this.drawCanvas.getClientArea();
                                if (bounds.isEmpty()) {
                                    break block44;
                                }
                                if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
                                    this.bufferImage.dispose();
                                }
                                this.bufferImage = new Image((Device)this.drawCanvas.getDisplay(), bounds);
                                gcImage = new GC((Drawable)this.bufferImage);
                                gcImage.drawImage(this.bufferScale, 0, 0);
                                gcImage.setAntialias(1);
                                gcImage.setTextAntialias(1);
                                HashSet<ValueSource> invisible_sources = new HashSet<ValueSource>();
                                for (int i = 0; i < this.value_sources.length; ++i) {
                                    ValueSource source = this.value_sources[i];
                                    if ((source.getStyle() & 0x10) == 0) continue;
                                    invisible_sources.add(source);
                                }
                                int[] oldTargetValues = new int[this.all_values.length];
                                int[] maxs = new int[this.all_values.length];
                                for (int x = 0; x < bounds.width - 71; ++x) {
                                    int position = this.currentPosition - x - 1;
                                    if (position < 0 && (position += this.maxEntries) < 0) {
                                        position = 0;
                                    }
                                    for (int chartIdx = 0; chartIdx < this.all_values.length; ++chartIdx) {
                                        int value;
                                        ValueSource source = this.value_sources[chartIdx];
                                        if (invisible_sources.contains(source) || (value = this.all_values[chartIdx][position]) <= maxs[chartIdx]) continue;
                                        maxs[chartIdx] = value;
                                    }
                                }
                                HashSet<ValueSource> bold_sources = new HashSet<ValueSource>();
                                HashSet<ValueSource> dotted_sources = new HashSet<ValueSource>();
                                int max = 0;
                                for (int i = 0; i < maxs.length; ++i) {
                                    ValueSource source = this.value_sources[i];
                                    if (invisible_sources.contains(source)) continue;
                                    if ((source.getStyle() & 8) != 0) {
                                        bold_sources.add(source);
                                    }
                                    if ((source.getStyle() & 0x20) != 0) {
                                        dotted_sources.add(source);
                                    }
                                    if (source.isTrimmable()) continue;
                                    max = Math.max(max, maxs[i]);
                                }
                                int max_primary = max;
                                for (int i = 0; i < maxs.length; ++i) {
                                    int m;
                                    ValueSource source = this.value_sources[i];
                                    if (invisible_sources.contains(source) || !source.isTrimmable() || max >= (m = maxs[i])) continue;
                                    if (m <= 2 * max_primary) {
                                        max = m;
                                        continue;
                                    }
                                    max = 2 * max_primary;
                                    break;
                                }
                                if (max > 5120) {
                                    max = (max + 1023) / 1024 * 1024;
                                }
                                this.scale.setMax(max);
                                int[] prev_x = new int[this.value_sources.length];
                                int[] prev_y = new int[this.value_sources.length];
                                int bounds_width_adj = bounds.width - 71;
                                int cycles = bold_sources.size() == 0 ? 2 : 3;
                                for (int x = 0; x < bounds_width_adj; ++x) {
                                    int position = this.currentPosition - x - 1;
                                    if (position < 0 && (position += this.maxEntries) < 0) {
                                        position = 0;
                                    }
                                    int xDraw = bounds_width_adj - x;
                                    for (int order = 0; order < cycles; ++order) {
                                        for (int chartIdx = 0; chartIdx < this.all_values.length; ++chartIdx) {
                                            boolean is_bold;
                                            ValueSource source = this.value_sources[chartIdx];
                                            if (invisible_sources.contains(source) || (is_bold = bold_sources.contains(source)) && order != 2) continue;
                                            boolean is_dotted = dotted_sources.contains(source);
                                            if ((source.isTrimmable() != (order == 0) || order >= 2) && (!is_bold || order != 2)) continue;
                                            Color line_color = source.getLineColor();
                                            int targetValue = this.all_values[chartIdx][position];
                                            int oldTargetValue = oldTargetValues[chartIdx];
                                            if (x > 0) {
                                                int trimmed;
                                                if (is_dotted) {
                                                    trimmed = 2;
                                                } else {
                                                    trimmed = 0;
                                                    if (targetValue > max) {
                                                        targetValue = max;
                                                        ++trimmed;
                                                    }
                                                    if (oldTargetValue > max) {
                                                        oldTargetValue = max;
                                                        ++trimmed;
                                                    }
                                                }
                                                boolean force_draw = trimmed == 2 && position % 4 == 0 || xDraw == 1;
                                                int h1 = bounds.height - this.scale.getScaledValue(targetValue) - 2;
                                                if (x == 1) {
                                                    int h2 = bounds.height - this.scale.getScaledValue(oldTargetValue) - 2;
                                                    prev_x[chartIdx] = xDraw + 1;
                                                    prev_y[chartIdx] = h2;
                                                }
                                                if (trimmed < 2 || force_draw) {
                                                    if (h1 != prev_y[chartIdx] || force_draw) {
                                                        gcImage.setAlpha(source.getAlpha());
                                                        gcImage.setLineWidth(trimmed == 2 ? 3 : (is_bold ? 4 : 2));
                                                        gcImage.setForeground(line_color);
                                                        gcImage.drawLine(xDraw + 1, prev_y[chartIdx], prev_x[chartIdx], prev_y[chartIdx]);
                                                        gcImage.drawLine(xDraw, h1, xDraw + 1, prev_y[chartIdx]);
                                                        prev_x[chartIdx] = xDraw;
                                                        prev_y[chartIdx] = h1;
                                                    }
                                                } else {
                                                    prev_x[chartIdx] = xDraw;
                                                    prev_y[chartIdx] = h1;
                                                }
                                            }
                                            oldTargetValues[chartIdx] = this.all_values[chartIdx][position];
                                        }
                                    }
                                }
                                if (this.nbValues > 0) {
                                    for (int order = 0; order < cycles; ++order) {
                                        for (int chartIdx = 0; chartIdx < this.all_values.length; ++chartIdx) {
                                            int y;
                                            int x;
                                            int style;
                                            boolean is_bold;
                                            ValueSource source = this.value_sources[chartIdx];
                                            if (invisible_sources.contains(source) || (is_bold = bold_sources.contains(source)) && order != 2 || (source.isTrimmable() != (order == 0) || order >= 2) && (!is_bold || order != 2) || ((style = source.getStyle()) & 0x40) != 0) continue;
                                            int average_val = this.computeAverage(chartIdx, this.currentPosition - 6);
                                            int average_mod = average_val;
                                            if (average_mod > max) {
                                                average_mod = max;
                                            }
                                            int height = bounds.height - this.scale.getScaledValue(average_mod) - 2;
                                            gcImage.setAlpha(255);
                                            gcImage.setForeground(source.getLineColor());
                                            gcImage.drawText(this.formater.format(average_val), bounds.width - 65, height - 12, false);
                                            Color bg = gcImage.getBackground();
                                            if ((style & 2) != 0) {
                                                x = bounds.width - 72;
                                                y = height - 12;
                                                gcImage.setBackground(source.getLineColor());
                                                gcImage.fillPolygon(new int[]{x, y, x + 7, y, x + 3, y + 7});
                                                gcImage.setBackground(bg);
                                                continue;
                                            }
                                            if ((style & 1) == 0) continue;
                                            x = bounds.width - 72;
                                            y = height - 12;
                                            gcImage.setBackground(source.getLineColor());
                                            gcImage.fillPolygon(new int[]{x, y + 7, x + 7, y + 7, x + 3, y});
                                            gcImage.setBackground(bg);
                                        }
                                    }
                                }
                                break block45;
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                                Object var31_6 = null;
                                if (gcImage != null) {
                                    gcImage.dispose();
                                }
                                this.this_mon.exit();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var31_7 = null;
                            if (gcImage != null) {
                                gcImage.dispose();
                            }
                            this.this_mon.exit();
                            throw throwable;
                        }
                    }
                    gcImage.dispose();
                }
                this.this_mon.exit();
                return;
            }
            Object var31_4 = null;
            if (gcImage != null) {
                gcImage.dispose();
            }
            this.this_mon.exit();
            return;
        }
        Object var31_5 = null;
        if (gcImage != null) {
            gcImage.dispose();
        }
        this.this_mon.exit();
    }

    private int computeAverage(int line_index, int position) {
        long sum = 0L;
        for (int i = -5; i < 6; ++i) {
            int pos = position + i;
            if ((pos %= this.maxEntries) < 0) {
                pos += this.maxEntries;
            }
            sum += (long)this.all_values[line_index][pos];
        }
        return (int)(sum / 11L);
    }

    public void parameterChanged(String parameter) {
        this.graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
        boolean update_dividers = COConfigurationManager.getBooleanParameter("Stats Graph Dividers");
        int update_divider_width = update_dividers ? 60 : 0;
        this.setUpdateDividerWidth(update_divider_width);
    }

    public void dispose() {
        super.dispose();
        if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
            this.bufferImage.dispose();
        }
        if (this.update_event != null) {
            this.update_event.cancel();
            this.update_event = null;
        }
        COConfigurationManager.removeParameterListener("Graphics Update", this);
        COConfigurationManager.removeParameterListener("Stats Graph Dividers", this);
    }
}

