/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.ui.swt.config.IAdditionalActionPerformer;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeListener;

public class RadioParameter
extends Parameter {
    boolean saveInConfigFile;
    Button radioButton;
    List performers = new ArrayList();

    public RadioParameter(Composite composite, String sConfigName, int iButtonValue) {
        this(composite, sConfigName, iButtonValue, null);
    }

    public RadioParameter(Composite composite, boolean saveInConfigFile, String sConfigName, int iButtonValue) {
        this(composite, saveInConfigFile, sConfigName, iButtonValue, null);
    }

    public RadioParameter(Composite composite, String sConfigName, int iButtonValue, IAdditionalActionPerformer actionPerformer) {
        this(composite, true, sConfigName, iButtonValue, actionPerformer);
    }

    public RadioParameter(Composite composite, boolean saveInConfigFile, final String sConfigName, final int iButtonValue, IAdditionalActionPerformer actionPerformer) {
        super(sConfigName);
        this.saveInConfigFile = saveInConfigFile;
        if (actionPerformer != null) {
            this.performers.add(actionPerformer);
        }
        int iDefaultValue = COConfigurationManager.getIntParameter(sConfigName);
        this.radioButton = new Button(composite, 16);
        this.radioButton.setSelection(iDefaultValue == iButtonValue);
        this.radioButton.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                boolean selected = RadioParameter.this.radioButton.getSelection();
                if (selected && RadioParameter.this.getSaveInConfigFile()) {
                    COConfigurationManager.setParameter(sConfigName, iButtonValue);
                }
                if (RadioParameter.this.performers.size() > 0) {
                    for (int i = 0; i < RadioParameter.this.performers.size(); ++i) {
                        IAdditionalActionPerformer performer = (IAdditionalActionPerformer)RadioParameter.this.performers.get(i);
                        performer.setSelected(selected);
                        performer.performAction();
                    }
                }
            }
        });
    }

    public void setLayoutData(Object layoutData) {
        this.radioButton.setLayoutData(layoutData);
    }

    public void setAdditionalActionPerformer(IAdditionalActionPerformer actionPerformer) {
        this.performers.add(actionPerformer);
        boolean selected = this.radioButton.getSelection();
        actionPerformer.setSelected(selected);
        actionPerformer.performAction();
    }

    public Control getControl() {
        return this.radioButton;
    }

    public boolean isSelected() {
        return this.radioButton.getSelection();
    }

    public void setValue(Object value) {
        System.err.println("NOT IMPLEMENTED");
    }

    public void setSelected(boolean selected) {
        if (selected != this.radioButton.getSelection()) {
            int i;
            this.radioButton.setSelection(selected);
            if (this.performers.size() > 0) {
                for (i = 0; i < this.performers.size(); ++i) {
                    IAdditionalActionPerformer performer = (IAdditionalActionPerformer)this.performers.get(i);
                    performer.setSelected(selected);
                    performer.performAction();
                }
            }
            if (this.change_listeners != null) {
                for (i = 0; i < this.change_listeners.size(); ++i) {
                    ((ParameterChangeListener)this.change_listeners.get(i)).parameterChanged(this, false);
                }
            }
        }
    }

    public boolean getSaveInConfigFile() {
        return this.saveInConfigFile;
    }
}

