/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.help;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;
import org.gudy.azureus2.update.CorePatchLevel;
import shu.utils.ShuUtils;

public class SplashPreview {
    static Image image;
    static AEMonitor class_mon;
    private static Shell instance;
    private static Image imgSrc;
    private static int paintColorTo;

    public static void show() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SplashPreview._show();
            }
        });
    }

    private static void _show() {
        if (instance != null) {
            instance.open();
            return;
        }
        paintColorTo = 0;
        final Shell window = ShellFactory.createMainShell(Constants.isOSX ? 2144 : 67680);
        Utils.setShellIcon(window);
        final Display display = window.getDisplay();
        window.setText(MessageText.getString("MainWindow.about.title") + " " + Constants.AZUREUS_VERSION);
        window.setLayout((Layout)new GridLayout(3, false));
        ImageLoader imageLoader = ImageLoader.getInstance();
        imgSrc = imageLoader.getImage(ShuUtils.getSplash());
        if (imgSrc != null) {
            int w;
            int ow = w = SplashPreview.imgSrc.getBounds().width;
            int h = SplashPreview.imgSrc.getBounds().height;
            Image imgGray = new Image((Device)display, imageLoader.getImage(ShuUtils.getSplash()), 2);
            imageLoader.releaseImage(ShuUtils.getSplash());
            GC gc = new GC((Drawable)imgGray);
            if (Constants.isOSX) {
                gc.drawImage(imgGray, (w - ow) / 2, 0);
            } else {
                gc.copyArea(0, 0, ow, h, (w - ow) / 2, 0);
            }
            gc.dispose();
            Image image2 = new Image((Device)display, w, h);
            gc = new GC((Drawable)image2);
            gc.setBackground(window.getBackground());
            gc.fillRectangle(image2.getBounds());
            gc.dispose();
            image = Utils.renderTransparency(display, image2, imgGray, new Point(0, 0), 180);
            image2.dispose();
            imgGray.dispose();
        }
        Group gDevelopers = new Group((Composite)window, 0);
        gDevelopers.setLayout((Layout)new GridLayout());
        gDevelopers.setText("Developers");
        GridData gridData = new GridData(272);
        gDevelopers.setLayoutData((Object)gridData);
        Label label = new Label((Composite)gDevelopers, 16384);
        label.setText("DigitalDJ\nghostfucker\nShu");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        final Canvas labelImage = new Canvas((Composite)window, 0x20000000);
        gridData = new GridData(272);
        Rectangle imgBounds = image.getBounds();
        gridData.widthHint = SplashPreview.image.getBounds().width;
        labelImage.setLayoutData((Object)gridData);
        labelImage.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle boundsColor = imgSrc.getBounds();
                int ofs = (labelImage.getSize().x - boundsColor.width) / 2;
                if (paintColorTo > 0) {
                    e.gc.drawImage(imgSrc, 0, 0, paintColorTo, boundsColor.height, ofs, 20, paintColorTo, boundsColor.height);
                }
                Rectangle imgBounds = image.getBounds();
                if (imgBounds.width - paintColorTo - 1 > 0) {
                    e.gc.drawImage(image, paintColorTo + 1, 0, imgBounds.width - paintColorTo - 1, imgBounds.height, paintColorTo + 1 + ofs, 20, imgBounds.width - paintColorTo - 1, imgBounds.height);
                }
            }
        });
        Group gTranslators = new Group((Composite)window, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 2;
        gl.marginWidth = 0;
        gTranslators.setLayout((Layout)gl);
        gTranslators.setText("Thanks");
        gridData = new GridData(272);
        gTranslators.setLayoutData((Object)gridData);
        Text txtTrans = new Text((Composite)gTranslators, 524362);
        txtTrans.setText("SB-Innovation:\nButcho\nRebound\nhitman\nManas\neudora\nanon\nInstab\n\nShu Community:\nMatt\nHenning\nLovewich\nlix\ncarllfo\nfraggy\nVilon\nzoplex\nmasterchief\nBeta testers\nTranslators\nAnd many others");
        gridData = new GridData(1808);
        gridData.heightHint = txtTrans.computeSize((int)-1, (int)-1).y + 10;
        txtTrans.setLayoutData((Object)gridData);
        txtTrans.setBackground(display.getSystemColor(22));
        Group gInternet = new Group((Composite)window, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gInternet.setLayout((Layout)gridLayout);
        Messages.setLanguageText((Widget)gInternet, "MainWindow.about.section.internet");
        gridData = new GridData(272);
        gridData.horizontalSpan = 2;
        gInternet.setLayoutData((Object)gridData);
        Group gSys = new Group((Composite)window, 0);
        gSys.setLayout((Layout)new GridLayout());
        Messages.setLanguageText((Widget)gSys, "MainWindow.about.section.system");
        gridData = new GridData(272);
        gridData.verticalSpan = 1;
        gSys.setLayoutData((Object)gridData);
        Text txtSysInfo = new Text((Composite)gSys, 74);
        txtSysInfo.setBackground(display.getSystemColor(22));
        txtSysInfo.setText("Java " + System.getProperty("java.version") + "\n " + System.getProperty("java.vendor") + "\n" + "SWT v" + SWT.getVersion() + ", " + SWT.getPlatform() + "\n" + System.getProperty("os.name") + " v" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + "\n" + Constants.APP_NAME.charAt(0) + Constants.AZUREUS_VERSION + ("".length() == 0 ? "" : "-") + "/" + CorePatchLevel.getCurrentPatchLevel() + " " + COConfigurationManager.getStringParameter("ui"));
        gridData = new GridData(1808);
        txtSysInfo.setLayoutData((Object)gridData);
        if (window.getCaret() != null) {
            window.getCaret().setVisible(false);
        }
        String[][] link = new String[][]{{"sbinnovation", "digitaldj", "shumod"}, {"http://www.sb-innovation.de/", "http://digitaldj.net/", "http://www.le-shu.net/"}};
        for (int i = 0; i < link[0].length; ++i) {
            CLabel linkLabel = new CLabel((Composite)gInternet, 0);
            linkLabel.setText(MessageText.getString("MainWindow.about.internet." + link[0][i]));
            linkLabel.setData((Object)link[1][i]);
            linkLabel.setCursor(display.getSystemCursor(21));
            linkLabel.setForeground(Colors.blue);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            linkLabel.setLayoutData((Object)gridData);
            linkLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    Utils.launch((String)((CLabel)arg0.widget).getData());
                }

                public void mouseDown(MouseEvent arg0) {
                    Utils.launch((String)((CLabel)arg0.widget).getData());
                }
            });
        }
        Listener keyListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    window.dispose();
                }
            }
        };
        window.addListener(2, keyListener);
        window.pack();
        txtSysInfo.setFocus();
        Utils.centreWindow(window);
        window.open();
        instance = window;
        window.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event2) {
                instance = null;
                SplashPreview.disposeImage();
            }
        });
        AEThread2 updater = new AEThread2("Splash Screen Updater", true){

            public void run() {
                if (image == null || image.isDisposed()) {
                    return;
                }
                int maxX = SplashPreview.image.getBounds().width;
                final int maxY = SplashPreview.image.getBounds().height;
                while (paintColorTo < maxX) {
                    if (image == null || image.isDisposed()) {
                        paintColorTo = maxX;
                        break;
                    }
                    if (display.isDisposed()) {
                        paintColorTo = maxX;
                        break;
                    }
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (labelImage.isDisposed()) {
                                return;
                            }
                            paintColorTo++;
                            Rectangle boundsColor = imgSrc.getBounds();
                            int ofs = (labelImage.getSize().x - boundsColor.width) / 2;
                            labelImage.redraw(paintColorTo - 1 + ofs, 20, 2, maxY, true);
                        }
                    });
                    try {
                        Thread.sleep(30L);
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        };
        updater.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeImage() {
        try {
            class_mon.enter();
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
            ImageLoader imageLoader = ImageLoader.getInstance();
            imageLoader.releaseImage(ShuUtils.getSplash());
            image = null;
            imgSrc = null;
            Object var2_1 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public static void main(String[] args) {
        try {
            Display display = new Display();
            Colors.getInstance();
            SWTThread.createInstance(null);
            SplashPreview.show();
            while (!display.isDisposed() && instance != null && !instance.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            if (!display.isDisposed()) {
                display.dispose();
            }
        }
        catch (SWTThreadAlreadyInstanciatedException e) {
            e.printStackTrace();
        }
    }

    static {
        class_mon = new AEMonitor("AboutWindow");
        paintColorTo = 0;
    }
}

